@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NatGateway].
 */
@PulumiTagMarker
public class NatGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NatGatewayArgs = NatGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NatGatewayArgsBuilder.() -> Unit) {
        val builder = NatGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NatGateway {
        val builtJavaResource = com.pulumi.alicloud.vpc.NatGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NatGateway(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Nat gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/natGateway:NatGateway example <id>
 * ```
 */
public class NatGateway internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.NatGateway,
) : KotlinCustomResource(javaResource, NatGatewayMapper) {
    /**
     * Whether enable the deletion protection or not. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    public val deletionProtection: Output<Boolean>
        get() = javaResource.deletionProtection().applyValue({ args0 -> args0 })

    /**
     * Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to only precheck this request. Default value: `false`.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
     * - `MULTI_BINDED`: Multi EIP network card visible mode.
     * - `NAT`: EIP normal mode, compatible with IPv4 gateway.
     */
    public val eipBindMode: Output<String>
        get() = javaResource.eipBindMode().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to forcefully delete the NAT gateway.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The nat gateway will auto create a forward item.
     */
    public val forwardTableIds: Output<String>
        get() = javaResource.forwardTableIds().applyValue({ args0 -> args0 })

    /**
     * Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * The internet charge type. Valid values `PayByLcu` and `PayBySpec`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From 1.137.0+, The `PayBySpec` has been deprecated.
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
     */
    public val natGatewayName: Output<String>
        get() = javaResource.natGatewayName().applyValue({ args0 -> args0 })

    /**
     * The type of NAT gateway. Valid values: `Normal` and `Enhanced`. **NOTE:** From 1.137.0+,  The `Normal` has been deprecated.
     */
    public val natType: Output<String>
        get() = javaResource.natType().applyValue({ args0 -> args0 })

    /**
     * Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The billing method of the NAT gateway. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The nat gateway will auto create a snat item.
     */
    public val snatTableIds: Output<String>
        get() = javaResource.snatTableIds().applyValue({ args0 -> args0 })

    /**
     * The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
     */
    public val specification: Output<String>
        get() = javaResource.specification().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.121.0) The status of NAT gateway.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of NAT gateway.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The VPC ID.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The id of VSwitch.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NatGatewayMapper : ResourceMapper<NatGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.NatGateway::class == javaResource::class

    override fun map(javaResource: Resource): NatGateway = NatGateway(
        javaResource as
            com.pulumi.alicloud.vpc.NatGateway,
    )
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NatGateway].
 */
public suspend fun natGateway(name: String, block: suspend NatGatewayResourceBuilder.() -> Unit): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun natGateway(name: String): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
