@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.NatGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Nat gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/natGateway:NatGateway example <id>
 * ```
 * @property deletionProtection Whether enable the deletion protection or not. Default value: `false`.
 * - true: Enable deletion protection.
 * - false: Disable deletion protection.
 * @property description Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
 * @property dryRun Specifies whether to only precheck this request. Default value: `false`.
 * @property eipBindMode The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
 * - `MULTI_BINDED`: Multi EIP network card visible mode.
 * - `NAT`: EIP normal mode, compatible with IPv4 gateway.
 * @property force Specifies whether to forcefully delete the NAT gateway.
 * @property instanceChargeType Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
 * @property internetChargeType The internet charge type. Valid values `PayByLcu` and `PayBySpec`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From 1.137.0+, The `PayBySpec` has been deprecated.
 * @property name Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
 * @property natGatewayName Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
 * @property natType The type of NAT gateway. Valid values: `Normal` and `Enhanced`. **NOTE:** From 1.137.0+,  The `Normal` has been deprecated.
 * @property networkType Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
 * @property paymentType The billing method of the NAT gateway. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
 * @property period The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property specification The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
 * @property tags The tags of NAT gateway.
 * @property vpcId The VPC ID.
 * @property vswitchId The id of VSwitch.
 */
public data class NatGatewayArgs(
    public val deletionProtection: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val eipBindMode: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val natGatewayName: Output<String>? = null,
    public val natType: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val specification: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.NatGatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.NatGatewayArgs =
        com.pulumi.alicloud.vpc.NatGatewayArgs.builder()
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .eipBindMode(eipBindMode?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .natGatewayName(natGatewayName?.applyValue({ args0 -> args0 }))
            .natType(natType?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NatGatewayArgs].
 */
@PulumiTagMarker
public class NatGatewayArgsBuilder internal constructor() {
    private var deletionProtection: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var eipBindMode: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var instanceChargeType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var name: Output<String>? = null

    private var natGatewayName: Output<String>? = null

    private var natType: Output<String>? = null

    private var networkType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var specification: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Whether enable the deletion protection or not. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("bpwfpfkxtuxqmxmt")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
     */
    @JvmName("oajcqpldfjbhyovo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to only precheck this request. Default value: `false`.
     */
    @JvmName("jwenjrucsytpcxhe")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
     * - `MULTI_BINDED`: Multi EIP network card visible mode.
     * - `NAT`: EIP normal mode, compatible with IPv4 gateway.
     */
    @JvmName("gfgylmpqbtblrspx")
    public suspend fun eipBindMode(`value`: Output<String>) {
        this.eipBindMode = value
    }

    /**
     * @param value Specifies whether to forcefully delete the NAT gateway.
     */
    @JvmName("sffeabvotctcdtoh")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
     */
    @JvmName("pryrultsvgveckqj")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The internet charge type. Valid values `PayByLcu` and `PayBySpec`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From 1.137.0+, The `PayBySpec` has been deprecated.
     */
    @JvmName("gplwgslcjnjiuook")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
     */
    @JvmName("cnvdjybdikxpjcpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
     */
    @JvmName("fniimhgeedmaenmi")
    public suspend fun natGatewayName(`value`: Output<String>) {
        this.natGatewayName = value
    }

    /**
     * @param value The type of NAT gateway. Valid values: `Normal` and `Enhanced`. **NOTE:** From 1.137.0+,  The `Normal` has been deprecated.
     */
    @JvmName("walpxsutqdfvobep")
    public suspend fun natType(`value`: Output<String>) {
        this.natType = value
    }

    /**
     * @param value Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
     */
    @JvmName("qavjuhfcnlrdrncf")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The billing method of the NAT gateway. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("cnnhcetwxygpbjpn")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("iafyuywroklojoge")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
     */
    @JvmName("nafpjatuyavhcjsh")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The tags of NAT gateway.
     */
    @JvmName("vhjafbfpfmjhekhb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("sqfdxeinjexvccub")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The id of VSwitch.
     */
    @JvmName("hyerhnhwvdtocqsg")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Whether enable the deletion protection or not. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("cgujeflurrrhbmqs")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
     */
    @JvmName("ioqltobmfrbjkoem")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to only precheck this request. Default value: `false`.
     */
    @JvmName("fychjcpodnfyemlj")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
     * - `MULTI_BINDED`: Multi EIP network card visible mode.
     * - `NAT`: EIP normal mode, compatible with IPv4 gateway.
     */
    @JvmName("ptemqkboxacafhuu")
    public suspend fun eipBindMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipBindMode = mapped
    }

    /**
     * @param value Specifies whether to forcefully delete the NAT gateway.
     */
    @JvmName("xwufktmgyffkytro")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
     */
    @JvmName("waliswgwqitdmssq")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The internet charge type. Valid values `PayByLcu` and `PayBySpec`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From 1.137.0+, The `PayBySpec` has been deprecated.
     */
    @JvmName("mrxmjmpieepctqca")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
     */
    @JvmName("cwsbrrpshkedguvy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
     */
    @JvmName("ihvpifqxvtbffvnj")
    public suspend fun natGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayName = mapped
    }

    /**
     * @param value The type of NAT gateway. Valid values: `Normal` and `Enhanced`. **NOTE:** From 1.137.0+,  The `Normal` has been deprecated.
     */
    @JvmName("iapodiqrfmtbotqe")
    public suspend fun natType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natType = mapped
    }

    /**
     * @param value Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
     */
    @JvmName("skwciwvjiragrljr")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The billing method of the NAT gateway. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("bkmwqwoksywqpfmc")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("bxjuluqdxsjkkwyr")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
     */
    @JvmName("qaqingdkrnbdghws")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The tags of NAT gateway.
     */
    @JvmName("ywojmhqugtequajh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of NAT gateway.
     */
    @JvmName("tkcdrarefrcoqlna")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("sfrshadjpolysvpe")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The id of VSwitch.
     */
    @JvmName("urimxccsvuojapql")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): NatGatewayArgs = NatGatewayArgs(
        deletionProtection = deletionProtection,
        description = description,
        dryRun = dryRun,
        eipBindMode = eipBindMode,
        force = force,
        instanceChargeType = instanceChargeType,
        internetChargeType = internetChargeType,
        name = name,
        natGatewayName = natGatewayName,
        natType = natType,
        networkType = networkType,
        paymentType = paymentType,
        period = period,
        specification = specification,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
