@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkIpv6CidrBlock
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkIpv6CidrBlock.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Network].
 */
@PulumiTagMarker
public class NetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkArgs = NetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkArgsBuilder.() -> Unit) {
        val builder = NetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Network {
        val builtJavaResource = com.pulumi.alicloud.vpc.Network(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Network(builtJavaResource)
    }
}

/**
 * Provides a VPC Vpc resource.
 * A VPC instance creates a VPC. You can fully control your own VPC, such as selecting IP address ranges, configuring routing tables, and gateways. You can use Alibaba cloud resources such as cloud servers, apsaradb for RDS, and load balancer in your own VPC.
 * > **NOTE:** This resource will auto build a router and a route table while it uses `alicloud.vpc.Network` to build a vpc resource.
 * > **NOTE:** Available since v1.0.0.
 * ## Module Support
 * You can use the existing vpc module
 * to create a VPC and several VSwitches one-click.
 * For information about VPC Vpc and how to use it, see [What is Vpc](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/what-is-a-vpc).
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpc.Network("default", {
 *     ipv6Isp: "BGP",
 *     description: "test",
 *     cidrBlock: "10.0.0.0/8",
 *     vpcName: name,
 *     enableIpv6: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.Network("default",
 *     ipv6_isp="BGP",
 *     description="test",
 *     cidr_block="10.0.0.0/8",
 *     vpc_name=name,
 *     enable_ipv6=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpc.Network("default", new()
 *     {
 *         Ipv6Isp = "BGP",
 *         Description = "test",
 *         CidrBlock = "10.0.0.0/8",
 *         VpcName = name,
 *         EnableIpv6 = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			Ipv6Isp:     pulumi.String("BGP"),
 * 			Description: pulumi.String("test"),
 * 			CidrBlock:   pulumi.String("10.0.0.0/8"),
 * 			VpcName:     pulumi.String(name),
 * 			EnableIpv6:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .ipv6Isp("BGP")
 *             .description("test")
 *             .cidrBlock("10.0.0.0/8")
 *             .vpcName(name)
 *             .enableIpv6(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpc:Network
 *     properties:
 *       ipv6Isp: BGP
 *       description: test
 *       cidrBlock: 10.0.0.0/8
 *       vpcName: ${name}
 *       enableIpv6: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Vpc can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/network:Network example <id>
 * ```
 */
public class Network internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Network,
) : KotlinCustomResource(javaResource, NetworkMapper) {
    /**
     * The CIDR block of the VPC.
     * - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
     * - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * The status of ClassicLink function.
     */
    public val classicLinkEnabled: Output<Boolean>?
        get() = javaResource.classicLinkEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creation time of the VPC.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The new description of the VPC. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to perform a dry run. Valid values:
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     */
    public val enableIpv6: Output<Boolean>?
        get() = javaResource.enableIpv6().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
     */
    public val ipv4IpamPoolId: Output<String>?
        get() = javaResource.ipv4IpamPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv6 CIDR block of the default VPC.
     * > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
     */
    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    /**
     * The IPv6 CIDR block information of the VPC.
     */
    public val ipv6CidrBlocks: Output<List<NetworkIpv6CidrBlock>>
        get() = javaResource.ipv6CidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The IPv6 address segment type of the VPC. Value:
     * - `BGP` (default): Alibaba Cloud BGP IPv6.
     * - `ChinaMobile`: China Mobile (single line).
     * - `ChinaUnicom`: China Unicom (single line).
     * - `ChinaTelecom`: China Telecom (single line).
     * > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
     */
    public val ipv6Isp: Output<String>?
        get() = javaResource.ipv6Isp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to create the default VPC in the specified region. Valid values:
     */
    public val isDefault: Output<Boolean>?
        get() = javaResource.isDefault().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the route table that you want to query.
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * The region ID of the VPC to which the route table belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/doc-detail/36063.html) operation to query the most recent region list.
     */
    public val routerId: Output<String>
        get() = javaResource.routerId().applyValue({ args0 -> args0 })

    /**
     * . Field 'router_table_id' has been deprecated from provider version 1.227.1. New field 'route_table_id' instead.
     */
    @Deprecated(
        message = """
  Field 'router_table_id' has been deprecated since provider version 1.221.0. New field
      'route_table_id' instead.
  """,
    )
    public val routerTableId: Output<String>
        get() = javaResource.routerTableId().applyValue({ args0 -> args0 })

    /**
     * Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at the same time.
     */
    @Deprecated(
        message = """
  Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field
      'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be
      removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'.
      `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at
      the same time.
  """,
    )
    public val secondaryCidrBlocks: Output<List<String>>
        get() = javaResource.secondaryCidrBlocks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The status of the VPC.   `Pending`: The VPC is being configured. `Available`: The VPC is available.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The description of the route table. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
     */
    public val systemRouteTableDescription: Output<String>?
        get() = javaResource.systemRouteTableDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the route table. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     */
    public val systemRouteTableName: Output<String>?
        get() = javaResource.systemRouteTableName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags of Vpc.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A list of user CIDRs.
     */
    public val userCidrs: Output<List<String>>
        get() = javaResource.userCidrs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The new name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vpcName: Output<String>
        get() = javaResource.vpcName().applyValue({ args0 -> args0 })
}

public object NetworkMapper : ResourceMapper<Network> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Network::class == javaResource::class

    override fun map(javaResource: Resource): Network = Network(
        javaResource as
            com.pulumi.alicloud.vpc.Network,
    )
}

/**
 * @see [Network].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Network].
 */
public suspend fun network(name: String, block: suspend NetworkResourceBuilder.() -> Unit): Network {
    val builder = NetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Network].
 * @param name The _unique_ name of the resulting resource.
 */
public fun network(name: String): Network {
    val builder = NetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
