@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclEgressAclEntry
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclIngressAclEntry
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclEgressAclEntry.Companion.toKotlin as networkAclEgressAclEntryToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclIngressAclEntry.Companion.toKotlin as networkAclIngressAclEntryToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclResource.Companion.toKotlin as networkAclResourceToKotlin

/**
 * Builder for [NetworkAcl].
 */
@PulumiTagMarker
public class NetworkAclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAclArgs = NetworkAclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAclArgsBuilder.() -> Unit) {
        val builder = NetworkAclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkAcl {
        val builtJavaResource = com.pulumi.alicloud.vpc.NetworkAcl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkAcl(builtJavaResource)
    }
}

/**
 * Provides a VPC Network Acl resource. Network Access Control List (ACL) is a Network Access Control function in VPC. You can customize the network ACL rules and bind the network ACL to the switch to control the traffic of ECS instances in the switch.
 * For information about VPC Network Acl and how to use it, see [What is Network Acl](https://www.alibabacloud.com/help/en/ens/latest/createnetworkacl).
 * > **NOTE:** Available since v1.43.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: example.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const exampleNetworkAcl = new alicloud.vpc.NetworkAcl("example", {
 *     vpcId: example.id,
 *     networkAclName: name,
 *     description: name,
 *     ingressAclEntries: [{
 *         description: `${name}-ingress`,
 *         networkAclEntryName: `${name}-ingress`,
 *         sourceCidrIp: "10.0.0.0/24",
 *         policy: "accept",
 *         port: "20/80",
 *         protocol: "tcp",
 *     }],
 *     egressAclEntries: [{
 *         description: `${name}-egress`,
 *         networkAclEntryName: `${name}-egress`,
 *         destinationCidrIp: "10.0.0.0/24",
 *         policy: "accept",
 *         port: "20/80",
 *         protocol: "tcp",
 *     }],
 *     resources: [{
 *         resourceId: exampleSwitch.id,
 *         resourceType: "VSwitch",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=example.id,
 *     zone_id=default.zones[0].id)
 * example_network_acl = alicloud.vpc.NetworkAcl("example",
 *     vpc_id=example.id,
 *     network_acl_name=name,
 *     description=name,
 *     ingress_acl_entries=[{
 *         "description": f"{name}-ingress",
 *         "network_acl_entry_name": f"{name}-ingress",
 *         "source_cidr_ip": "10.0.0.0/24",
 *         "policy": "accept",
 *         "port": "20/80",
 *         "protocol": "tcp",
 *     }],
 *     egress_acl_entries=[{
 *         "description": f"{name}-egress",
 *         "network_acl_entry_name": f"{name}-egress",
 *         "destination_cidr_ip": "10.0.0.0/24",
 *         "policy": "accept",
 *         "port": "20/80",
 *         "protocol": "tcp",
 *     }],
 *     resources=[{
 *         "resource_id": example_switch.id,
 *         "resource_type": "VSwitch",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = example.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var exampleNetworkAcl = new AliCloud.Vpc.NetworkAcl("example", new()
 *     {
 *         VpcId = example.Id,
 *         NetworkAclName = name,
 *         Description = name,
 *         IngressAclEntries = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclIngressAclEntryArgs
 *             {
 *                 Description = $"{name}-ingress",
 *                 NetworkAclEntryName = $"{name}-ingress",
 *                 SourceCidrIp = "10.0.0.0/24",
 *                 Policy = "accept",
 *                 Port = "20/80",
 *                 Protocol = "tcp",
 *             },
 *         },
 *         EgressAclEntries = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclEgressAclEntryArgs
 *             {
 *                 Description = $"{name}-egress",
 *                 NetworkAclEntryName = $"{name}-egress",
 *                 DestinationCidrIp = "10.0.0.0/24",
 *                 Policy = "accept",
 *                 Port = "20/80",
 *                 Protocol = "tcp",
 *             },
 *         },
 *         Resources = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclResourceArgs
 *             {
 *                 ResourceId = exampleSwitch.Id,
 *                 ResourceType = "VSwitch",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkAcl(ctx, "example", &vpc.NetworkAclArgs{
 * 			VpcId:          example.ID(),
 * 			NetworkAclName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			IngressAclEntries: vpc.NetworkAclIngressAclEntryArray{
 * 				&vpc.NetworkAclIngressAclEntryArgs{
 * 					Description:         pulumi.Sprintf("%v-ingress", name),
 * 					NetworkAclEntryName: pulumi.Sprintf("%v-ingress", name),
 * 					SourceCidrIp:        pulumi.String("10.0.0.0/24"),
 * 					Policy:              pulumi.String("accept"),
 * 					Port:                pulumi.String("20/80"),
 * 					Protocol:            pulumi.String("tcp"),
 * 				},
 * 			},
 * 			EgressAclEntries: vpc.NetworkAclEgressAclEntryArray{
 * 				&vpc.NetworkAclEgressAclEntryArgs{
 * 					Description:         pulumi.Sprintf("%v-egress", name),
 * 					NetworkAclEntryName: pulumi.Sprintf("%v-egress", name),
 * 					DestinationCidrIp:   pulumi.String("10.0.0.0/24"),
 * 					Policy:              pulumi.String("accept"),
 * 					Port:                pulumi.String("20/80"),
 * 					Protocol:            pulumi.String("tcp"),
 * 				},
 * 			},
 * 			Resources: vpc.NetworkAclResourceArray{
 * 				&vpc.NetworkAclResourceArgs{
 * 					ResourceId:   exampleSwitch.ID(),
 * 					ResourceType: pulumi.String("VSwitch"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NetworkAcl;
 * import com.pulumi.alicloud.vpc.NetworkAclArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclIngressAclEntryArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclEgressAclEntryArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(example.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var exampleNetworkAcl = new NetworkAcl("exampleNetworkAcl", NetworkAclArgs.builder()
 *             .vpcId(example.id())
 *             .networkAclName(name)
 *             .description(name)
 *             .ingressAclEntries(NetworkAclIngressAclEntryArgs.builder()
 *                 .description(String.format("%s-ingress", name))
 *                 .networkAclEntryName(String.format("%s-ingress", name))
 *                 .sourceCidrIp("10.0.0.0/24")
 *                 .policy("accept")
 *                 .port("20/80")
 *                 .protocol("tcp")
 *                 .build())
 *             .egressAclEntries(NetworkAclEgressAclEntryArgs.builder()
 *                 .description(String.format("%s-egress", name))
 *                 .networkAclEntryName(String.format("%s-egress", name))
 *                 .destinationCidrIp("10.0.0.0/24")
 *                 .policy("accept")
 *                 .port("20/80")
 *                 .protocol("tcp")
 *                 .build())
 *             .resources(NetworkAclResourceArgs.builder()
 *                 .resourceId(exampleSwitch.id())
 *                 .resourceType("VSwitch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${default.zones[0].id}
 *   exampleNetworkAcl:
 *     type: alicloud:vpc:NetworkAcl
 *     name: example
 *     properties:
 *       vpcId: ${example.id}
 *       networkAclName: ${name}
 *       description: ${name}
 *       ingressAclEntries:
 *         - description: ${name}-ingress
 *           networkAclEntryName: ${name}-ingress
 *           sourceCidrIp: 10.0.0.0/24
 *           policy: accept
 *           port: 20/80
 *           protocol: tcp
 *       egressAclEntries:
 *         - description: ${name}-egress
 *           networkAclEntryName: ${name}-egress
 *           destinationCidrIp: 10.0.0.0/24
 *           policy: accept
 *           port: 20/80
 *           protocol: tcp
 *       resources:
 *         - resourceId: ${exampleSwitch.id}
 *           resourceType: VSwitch
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Network Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/networkAcl:NetworkAcl example <id>
 * ```
 */
public class NetworkAcl internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.NetworkAcl,
) : KotlinCustomResource(javaResource, NetworkAclMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the network ACL.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Out direction rule information. See `egress_acl_entries` below.
     */
    public val egressAclEntries: Output<List<NetworkAclEgressAclEntry>>
        get() = javaResource.egressAclEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkAclEgressAclEntryToKotlin(args0) })
            })
        })

    /**
     * Inward direction rule information. See `ingress_acl_entries` below.
     */
    public val ingressAclEntries: Output<List<NetworkAclIngressAclEntry>>
        get() = javaResource.ingressAclEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkAclIngressAclEntryToKotlin(args0) })
            })
        })

    /**
     * . Field 'name' has been deprecated from provider version 1.122.0. New field 'network_acl_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.122.0. New field 'network_acl_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the network ACL.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    public val networkAclName: Output<String>
        get() = javaResource.networkAclName().applyValue({ args0 -> args0 })

    /**
     * The associated resource. See `resources` below.
     */
    public val resources: Output<List<NetworkAclResource>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkAclResourceToKotlin(args0)
                })
            })
        })

    /**
     * SOURCE NetworkAcl specified by CopyNetworkAclEntries.
     */
    public val sourceNetworkAclId: Output<String>?
        get() = javaResource.sourceNetworkAclId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the network ACL.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of this resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the associated VPC.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object NetworkAclMapper : ResourceMapper<NetworkAcl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.NetworkAcl::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAcl = NetworkAcl(
        javaResource as
            com.pulumi.alicloud.vpc.NetworkAcl,
    )
}

/**
 * @see [NetworkAcl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAcl].
 */
public suspend fun networkAcl(name: String, block: suspend NetworkAclResourceBuilder.() -> Unit): NetworkAcl {
    val builder = NetworkAclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAcl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAcl(name: String): NetworkAcl {
    val builder = NetworkAclResourceBuilder()
    builder.name(name)
    return builder.build()
}
