@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.NetworkAclArgs.builder
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclEgressAclEntryArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclEgressAclEntryArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclIngressAclEntryArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclIngressAclEntryArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclResourceArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Network Acl resource. Network Access Control List (ACL) is a Network Access Control function in VPC. You can customize the network ACL rules and bind the network ACL to the switch to control the traffic of ECS instances in the switch.
 * For information about VPC Network Acl and how to use it, see [What is Network Acl](https://www.alibabacloud.com/help/en/ens/latest/createnetworkacl).
 * > **NOTE:** Available since v1.43.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: example.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const exampleNetworkAcl = new alicloud.vpc.NetworkAcl("example", {
 *     vpcId: example.id,
 *     networkAclName: name,
 *     description: name,
 *     ingressAclEntries: [{
 *         description: `${name}-ingress`,
 *         networkAclEntryName: `${name}-ingress`,
 *         sourceCidrIp: "10.0.0.0/24",
 *         policy: "accept",
 *         port: "20/80",
 *         protocol: "tcp",
 *     }],
 *     egressAclEntries: [{
 *         description: `${name}-egress`,
 *         networkAclEntryName: `${name}-egress`,
 *         destinationCidrIp: "10.0.0.0/24",
 *         policy: "accept",
 *         port: "20/80",
 *         protocol: "tcp",
 *     }],
 *     resources: [{
 *         resourceId: exampleSwitch.id,
 *         resourceType: "VSwitch",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=example.id,
 *     zone_id=default.zones[0].id)
 * example_network_acl = alicloud.vpc.NetworkAcl("example",
 *     vpc_id=example.id,
 *     network_acl_name=name,
 *     description=name,
 *     ingress_acl_entries=[{
 *         "description": f"{name}-ingress",
 *         "network_acl_entry_name": f"{name}-ingress",
 *         "source_cidr_ip": "10.0.0.0/24",
 *         "policy": "accept",
 *         "port": "20/80",
 *         "protocol": "tcp",
 *     }],
 *     egress_acl_entries=[{
 *         "description": f"{name}-egress",
 *         "network_acl_entry_name": f"{name}-egress",
 *         "destination_cidr_ip": "10.0.0.0/24",
 *         "policy": "accept",
 *         "port": "20/80",
 *         "protocol": "tcp",
 *     }],
 *     resources=[{
 *         "resource_id": example_switch.id,
 *         "resource_type": "VSwitch",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = example.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var exampleNetworkAcl = new AliCloud.Vpc.NetworkAcl("example", new()
 *     {
 *         VpcId = example.Id,
 *         NetworkAclName = name,
 *         Description = name,
 *         IngressAclEntries = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclIngressAclEntryArgs
 *             {
 *                 Description = $"{name}-ingress",
 *                 NetworkAclEntryName = $"{name}-ingress",
 *                 SourceCidrIp = "10.0.0.0/24",
 *                 Policy = "accept",
 *                 Port = "20/80",
 *                 Protocol = "tcp",
 *             },
 *         },
 *         EgressAclEntries = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclEgressAclEntryArgs
 *             {
 *                 Description = $"{name}-egress",
 *                 NetworkAclEntryName = $"{name}-egress",
 *                 DestinationCidrIp = "10.0.0.0/24",
 *                 Policy = "accept",
 *                 Port = "20/80",
 *                 Protocol = "tcp",
 *             },
 *         },
 *         Resources = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclResourceArgs
 *             {
 *                 ResourceId = exampleSwitch.Id,
 *                 ResourceType = "VSwitch",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkAcl(ctx, "example", &vpc.NetworkAclArgs{
 * 			VpcId:          example.ID(),
 * 			NetworkAclName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			IngressAclEntries: vpc.NetworkAclIngressAclEntryArray{
 * 				&vpc.NetworkAclIngressAclEntryArgs{
 * 					Description:         pulumi.Sprintf("%v-ingress", name),
 * 					NetworkAclEntryName: pulumi.Sprintf("%v-ingress", name),
 * 					SourceCidrIp:        pulumi.String("10.0.0.0/24"),
 * 					Policy:              pulumi.String("accept"),
 * 					Port:                pulumi.String("20/80"),
 * 					Protocol:            pulumi.String("tcp"),
 * 				},
 * 			},
 * 			EgressAclEntries: vpc.NetworkAclEgressAclEntryArray{
 * 				&vpc.NetworkAclEgressAclEntryArgs{
 * 					Description:         pulumi.Sprintf("%v-egress", name),
 * 					NetworkAclEntryName: pulumi.Sprintf("%v-egress", name),
 * 					DestinationCidrIp:   pulumi.String("10.0.0.0/24"),
 * 					Policy:              pulumi.String("accept"),
 * 					Port:                pulumi.String("20/80"),
 * 					Protocol:            pulumi.String("tcp"),
 * 				},
 * 			},
 * 			Resources: vpc.NetworkAclResourceArray{
 * 				&vpc.NetworkAclResourceArgs{
 * 					ResourceId:   exampleSwitch.ID(),
 * 					ResourceType: pulumi.String("VSwitch"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NetworkAcl;
 * import com.pulumi.alicloud.vpc.NetworkAclArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclIngressAclEntryArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclEgressAclEntryArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(example.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var exampleNetworkAcl = new NetworkAcl("exampleNetworkAcl", NetworkAclArgs.builder()
 *             .vpcId(example.id())
 *             .networkAclName(name)
 *             .description(name)
 *             .ingressAclEntries(NetworkAclIngressAclEntryArgs.builder()
 *                 .description(String.format("%s-ingress", name))
 *                 .networkAclEntryName(String.format("%s-ingress", name))
 *                 .sourceCidrIp("10.0.0.0/24")
 *                 .policy("accept")
 *                 .port("20/80")
 *                 .protocol("tcp")
 *                 .build())
 *             .egressAclEntries(NetworkAclEgressAclEntryArgs.builder()
 *                 .description(String.format("%s-egress", name))
 *                 .networkAclEntryName(String.format("%s-egress", name))
 *                 .destinationCidrIp("10.0.0.0/24")
 *                 .policy("accept")
 *                 .port("20/80")
 *                 .protocol("tcp")
 *                 .build())
 *             .resources(NetworkAclResourceArgs.builder()
 *                 .resourceId(exampleSwitch.id())
 *                 .resourceType("VSwitch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${default.zones[0].id}
 *   exampleNetworkAcl:
 *     type: alicloud:vpc:NetworkAcl
 *     name: example
 *     properties:
 *       vpcId: ${example.id}
 *       networkAclName: ${name}
 *       description: ${name}
 *       ingressAclEntries:
 *         - description: ${name}-ingress
 *           networkAclEntryName: ${name}-ingress
 *           sourceCidrIp: 10.0.0.0/24
 *           policy: accept
 *           port: 20/80
 *           protocol: tcp
 *       egressAclEntries:
 *         - description: ${name}-egress
 *           networkAclEntryName: ${name}-egress
 *           destinationCidrIp: 10.0.0.0/24
 *           policy: accept
 *           port: 20/80
 *           protocol: tcp
 *       resources:
 *         - resourceId: ${exampleSwitch.id}
 *           resourceType: VSwitch
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Network Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/networkAcl:NetworkAcl example <id>
 * ```
 * @property description The description of the network ACL.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
 * @property egressAclEntries Out direction rule information. See `egress_acl_entries` below.
 * @property ingressAclEntries Inward direction rule information. See `ingress_acl_entries` below.
 * @property name . Field 'name' has been deprecated from provider version 1.122.0. New field 'network_acl_name' instead.
 * @property networkAclName The name of the network ACL.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
 * @property resources The associated resource. See `resources` below.
 * @property sourceNetworkAclId SOURCE NetworkAcl specified by CopyNetworkAclEntries.
 * @property tags The tags of this resource.
 * @property vpcId The ID of the associated VPC.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class NetworkAclArgs(
    public val description: Output<String>? = null,
    public val egressAclEntries: Output<List<NetworkAclEgressAclEntryArgs>>? = null,
    public val ingressAclEntries: Output<List<NetworkAclIngressAclEntryArgs>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.122.0. New field 'network_acl_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val networkAclName: Output<String>? = null,
    public val resources: Output<List<NetworkAclResourceArgs>>? = null,
    public val sourceNetworkAclId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.NetworkAclArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.NetworkAclArgs =
        com.pulumi.alicloud.vpc.NetworkAclArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .egressAclEntries(
                egressAclEntries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingressAclEntries(
                ingressAclEntries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .networkAclName(networkAclName?.applyValue({ args0 -> args0 }))
            .resources(
                resources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceNetworkAclId(sourceNetworkAclId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclArgs].
 */
@PulumiTagMarker
public class NetworkAclArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var egressAclEntries: Output<List<NetworkAclEgressAclEntryArgs>>? = null

    private var ingressAclEntries: Output<List<NetworkAclIngressAclEntryArgs>>? = null

    private var name: Output<String>? = null

    private var networkAclName: Output<String>? = null

    private var resources: Output<List<NetworkAclResourceArgs>>? = null

    private var sourceNetworkAclId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The description of the network ACL.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    @JvmName("nbffpkcdnsnxjwwm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("lxxijadcvoftegia")
    public suspend fun egressAclEntries(`value`: Output<List<NetworkAclEgressAclEntryArgs>>) {
        this.egressAclEntries = value
    }

    @JvmName("mcbdncyoavgrinan")
    public suspend fun egressAclEntries(vararg values: Output<NetworkAclEgressAclEntryArgs>) {
        this.egressAclEntries = Output.all(values.asList())
    }

    /**
     * @param values Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("hgbjoededmhmhhuh")
    public suspend fun egressAclEntries(values: List<Output<NetworkAclEgressAclEntryArgs>>) {
        this.egressAclEntries = Output.all(values)
    }

    /**
     * @param value Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("apbfoormdijnehfg")
    public suspend fun ingressAclEntries(`value`: Output<List<NetworkAclIngressAclEntryArgs>>) {
        this.ingressAclEntries = value
    }

    @JvmName("rjityyihaiyguvts")
    public suspend fun ingressAclEntries(vararg values: Output<NetworkAclIngressAclEntryArgs>) {
        this.ingressAclEntries = Output.all(values.asList())
    }

    /**
     * @param values Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("ssyqlmxttxgqwbwh")
    public suspend fun ingressAclEntries(values: List<Output<NetworkAclIngressAclEntryArgs>>) {
        this.ingressAclEntries = Output.all(values)
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.122.0. New field 'network_acl_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.122.0. New field 'network_acl_name'
      instead.
  """,
    )
    @JvmName("nnygjdjogiebbcds")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network ACL.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    @JvmName("mlnryaxnxihlhxub")
    public suspend fun networkAclName(`value`: Output<String>) {
        this.networkAclName = value
    }

    /**
     * @param value The associated resource. See `resources` below.
     */
    @JvmName("crwsaesecynuyxra")
    public suspend fun resources(`value`: Output<List<NetworkAclResourceArgs>>) {
        this.resources = value
    }

    @JvmName("rjrxjjpvqiejsnod")
    public suspend fun resources(vararg values: Output<NetworkAclResourceArgs>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values The associated resource. See `resources` below.
     */
    @JvmName("bgbkpfiytgadqeyh")
    public suspend fun resources(values: List<Output<NetworkAclResourceArgs>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value SOURCE NetworkAcl specified by CopyNetworkAclEntries.
     */
    @JvmName("bqadptnafekecrmg")
    public suspend fun sourceNetworkAclId(`value`: Output<String>) {
        this.sourceNetworkAclId = value
    }

    /**
     * @param value The tags of this resource.
     */
    @JvmName("wnqobxqfepdmtkvt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the associated VPC.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("kyrqbnkeuihjwioh")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The description of the network ACL.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    @JvmName("phhhtajmmtakjjdu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("okgrxjchnhavxhis")
    public suspend fun egressAclEntries(`value`: List<NetworkAclEgressAclEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressAclEntries = mapped
    }

    /**
     * @param argument Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("wytlpideqdbgwlqj")
    public suspend fun egressAclEntries(argument: List<suspend NetworkAclEgressAclEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclEgressAclEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egressAclEntries = mapped
    }

    /**
     * @param argument Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("bjoutjsgxtxlvkbd")
    public suspend fun egressAclEntries(vararg argument: suspend NetworkAclEgressAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclEgressAclEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egressAclEntries = mapped
    }

    /**
     * @param argument Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("wsqfctdiwdfcaqon")
    public suspend fun egressAclEntries(argument: suspend NetworkAclEgressAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkAclEgressAclEntryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.egressAclEntries = mapped
    }

    /**
     * @param values Out direction rule information. See `egress_acl_entries` below.
     */
    @JvmName("akauyiydbjahitpn")
    public suspend fun egressAclEntries(vararg values: NetworkAclEgressAclEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressAclEntries = mapped
    }

    /**
     * @param value Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("ucavcexvwjfqxaed")
    public suspend fun ingressAclEntries(`value`: List<NetworkAclIngressAclEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressAclEntries = mapped
    }

    /**
     * @param argument Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("ivbahnuqprdinrsc")
    public suspend fun ingressAclEntries(argument: List<suspend NetworkAclIngressAclEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclIngressAclEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingressAclEntries = mapped
    }

    /**
     * @param argument Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("clppelpqieckuygw")
    public suspend fun ingressAclEntries(vararg argument: suspend NetworkAclIngressAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclIngressAclEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingressAclEntries = mapped
    }

    /**
     * @param argument Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("ndlcecjycibttyrq")
    public suspend fun ingressAclEntries(argument: suspend NetworkAclIngressAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkAclIngressAclEntryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ingressAclEntries = mapped
    }

    /**
     * @param values Inward direction rule information. See `ingress_acl_entries` below.
     */
    @JvmName("jyfwsawdxdrkeuiu")
    public suspend fun ingressAclEntries(vararg values: NetworkAclIngressAclEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingressAclEntries = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.122.0. New field 'network_acl_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.122.0. New field 'network_acl_name'
      instead.
  """,
    )
    @JvmName("yiqypuequlbqkxuj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network ACL.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    @JvmName("qlmdgayyymrdvicp")
    public suspend fun networkAclName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclName = mapped
    }

    /**
     * @param value The associated resource. See `resources` below.
     */
    @JvmName("knbgqspatgpdghxm")
    public suspend fun resources(`value`: List<NetworkAclResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument The associated resource. See `resources` below.
     */
    @JvmName("vhyymhuwqfbnjttc")
    public suspend fun resources(argument: List<suspend NetworkAclResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument The associated resource. See `resources` below.
     */
    @JvmName("lxjamdoqhqqjkwtu")
    public suspend fun resources(vararg argument: suspend NetworkAclResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument The associated resource. See `resources` below.
     */
    @JvmName("jbkoqatygvslhijv")
    public suspend fun resources(argument: suspend NetworkAclResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkAclResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param values The associated resource. See `resources` below.
     */
    @JvmName("uravxraklpmjeigu")
    public suspend fun resources(vararg values: NetworkAclResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value SOURCE NetworkAcl specified by CopyNetworkAclEntries.
     */
    @JvmName("ivonwidenkcxihhn")
    public suspend fun sourceNetworkAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceNetworkAclId = mapped
    }

    /**
     * @param value The tags of this resource.
     */
    @JvmName("etwqoanjtqkqgujj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of this resource.
     */
    @JvmName("utwmjacycwllpgao")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the associated VPC.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("quvhsunlgllfnyye")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): NetworkAclArgs = NetworkAclArgs(
        description = description,
        egressAclEntries = egressAclEntries,
        ingressAclEntries = ingressAclEntries,
        name = name,
        networkAclName = networkAclName,
        resources = resources,
        sourceNetworkAclId = sourceNetworkAclId,
        tags = tags,
        vpcId = vpcId,
    )
}
