@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclAttachmentResource
import com.pulumi.alicloud.vpc.kotlin.outputs.NetworkAclAttachmentResource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [NetworkAclAttachment].
 */
@PulumiTagMarker
public class NetworkAclAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAclAttachmentArgs = NetworkAclAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAclAttachmentArgsBuilder.() -> Unit) {
        val builder = NetworkAclAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkAclAttachment {
        val builtJavaResource = com.pulumi.alicloud.vpc.NetworkAclAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkAclAttachment(builtJavaResource)
    }
}

/**
 * Provides a network acl attachment resource to associate network acls to vswitches.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.124.0`. Replace by `resources` with the resource alicloud_network_acl.
 * Note that because this resource conflicts with the `resources` attribute of `alicloud.vpc.NetworkAcl`, this resource can no be used.
 * > **NOTE:** Available in 1.44.0+. Currently, the resource are only available in Hongkong(cn-hongkong), and Indonesia(ap-southeast-1) regions.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "NatGatewayConfigSpec";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultNetworkAcl = new alicloud.vpc.NetworkAcl("default", {
 *     vpcId: defaultNetwork.id,
 *     networkAclName: name,
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultNetworkAclAttachment = new alicloud.vpc.NetworkAclAttachment("default", {
 *     networkAclId: defaultNetworkAcl.id,
 *     resources: [{
 *         resourceId: defaultSwitch.id,
 *         resourceType: "VSwitch",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "NatGatewayConfigSpec"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * default_network_acl = alicloud.vpc.NetworkAcl("default",
 *     vpc_id=default_network.id,
 *     network_acl_name=name)
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_network_acl_attachment = alicloud.vpc.NetworkAclAttachment("default",
 *     network_acl_id=default_network_acl.id,
 *     resources=[{
 *         "resource_id": default_switch.id,
 *         "resource_type": "VSwitch",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "NatGatewayConfigSpec";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultNetworkAcl = new AliCloud.Vpc.NetworkAcl("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         NetworkAclName = name,
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultNetworkAclAttachment = new AliCloud.Vpc.NetworkAclAttachment("default", new()
 *     {
 *         NetworkAclId = defaultNetworkAcl.Id,
 *         Resources = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclAttachmentResourceArgs
 *             {
 *                 ResourceId = defaultSwitch.Id,
 *                 ResourceType = "VSwitch",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "NatGatewayConfigSpec"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetworkAcl, err := vpc.NewNetworkAcl(ctx, "default", &vpc.NetworkAclArgs{
 * 			VpcId:          defaultNetwork.ID(),
 * 			NetworkAclName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkAclAttachment(ctx, "default", &vpc.NetworkAclAttachmentArgs{
 * 			NetworkAclId: defaultNetworkAcl.ID(),
 * 			Resources: vpc.NetworkAclAttachmentResourceArray{
 * 				&vpc.NetworkAclAttachmentResourceArgs{
 * 					ResourceId:   defaultSwitch.ID(),
 * 					ResourceType: pulumi.String("VSwitch"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.NetworkAcl;
 * import com.pulumi.alicloud.vpc.NetworkAclArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NetworkAclAttachment;
 * import com.pulumi.alicloud.vpc.NetworkAclAttachmentArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclAttachmentResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("NatGatewayConfigSpec");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultNetworkAcl = new NetworkAcl("defaultNetworkAcl", NetworkAclArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .networkAclName(name)
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultNetworkAclAttachment = new NetworkAclAttachment("defaultNetworkAclAttachment", NetworkAclAttachmentArgs.builder()
 *             .networkAclId(defaultNetworkAcl.id())
 *             .resources(NetworkAclAttachmentResourceArgs.builder()
 *                 .resourceId(defaultSwitch.id())
 *                 .resourceType("VSwitch")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: NatGatewayConfigSpec
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultNetworkAcl:
 *     type: alicloud:vpc:NetworkAcl
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       networkAclName: ${name}
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultNetworkAclAttachment:
 *     type: alicloud:vpc:NetworkAclAttachment
 *     name: default
 *     properties:
 *       networkAclId: ${defaultNetworkAcl.id}
 *       resources:
 *         - resourceId: ${defaultSwitch.id}
 *           resourceType: VSwitch
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class NetworkAclAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.NetworkAclAttachment,
) : KotlinCustomResource(javaResource, NetworkAclAttachmentMapper) {
    /**
     * The id of the network acl, the field can't be changed.
     */
    public val networkAclId: Output<String>
        get() = javaResource.networkAclId().applyValue({ args0 -> args0 })

    /**
     * List of the resources associated with the network acl. The details see Block Resources.
     */
    public val resources: Output<List<NetworkAclAttachmentResource>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object NetworkAclAttachmentMapper : ResourceMapper<NetworkAclAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.NetworkAclAttachment::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAclAttachment = NetworkAclAttachment(
        javaResource
            as com.pulumi.alicloud.vpc.NetworkAclAttachment,
    )
}

/**
 * @see [NetworkAclAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAclAttachment].
 */
public suspend fun networkAclAttachment(
    name: String,
    block: suspend NetworkAclAttachmentResourceBuilder.() -> Unit,
): NetworkAclAttachment {
    val builder = NetworkAclAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAclAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAclAttachment(name: String): NetworkAclAttachment {
    val builder = NetworkAclAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
