@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.NetworkAclEntriesArgs.builder
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclEntriesEgressArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclEntriesEgressArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclEntriesIngressArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.NetworkAclEntriesIngressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a network acl entries resource to create ingress and egress entries.
 * > **NOTE:** Available in 1.45.0+. Currently, the resource are only available in Hongkong(cn-hongkong), and Indonesia(ap-southeast-1) regions.
 * > **NOTE:** It doesn't support concurrency and the order of the ingress and egress entries determines the priority.
 * > **NOTE:** Using this resource need to open a whitelist.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.122.0`. Replace by `ingress_acl_entries` and `egress_acl_entries` with the resource alicloud_network_acl.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "NetworkAclEntries";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     name: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultNetworkAcl = new alicloud.vpc.NetworkAcl("default", {
 *     vpcId: defaultNetwork.id,
 *     name: name,
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     name: name,
 * });
 * const defaultNetworkAclAttachment = new alicloud.vpc.NetworkAclAttachment("default", {
 *     networkAclId: defaultNetworkAcl.id,
 *     resources: [{
 *         resourceId: defaultSwitch.id,
 *         resourceType: "VSwitch",
 *     }],
 * });
 * const defaultNetworkAclEntries = new alicloud.vpc.NetworkAclEntries("default", {
 *     networkAclId: defaultNetworkAcl.id,
 *     ingresses: [{
 *         protocol: "all",
 *         port: "-1/-1",
 *         sourceCidrIp: "0.0.0.0/32",
 *         name: name,
 *         entryType: "custom",
 *         policy: "accept",
 *         description: name,
 *     }],
 *     egresses: [{
 *         protocol: "all",
 *         port: "-1/-1",
 *         destinationCidrIp: "0.0.0.0/32",
 *         name: name,
 *         entryType: "custom",
 *         policy: "accept",
 *         description: name,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "NetworkAclEntries"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     name=name,
 *     cidr_block="172.16.0.0/12")
 * default_network_acl = alicloud.vpc.NetworkAcl("default",
 *     vpc_id=default_network.id,
 *     name=name)
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default.zones[0].id,
 *     name=name)
 * default_network_acl_attachment = alicloud.vpc.NetworkAclAttachment("default",
 *     network_acl_id=default_network_acl.id,
 *     resources=[{
 *         "resource_id": default_switch.id,
 *         "resource_type": "VSwitch",
 *     }])
 * default_network_acl_entries = alicloud.vpc.NetworkAclEntries("default",
 *     network_acl_id=default_network_acl.id,
 *     ingresses=[{
 *         "protocol": "all",
 *         "port": "-1/-1",
 *         "source_cidr_ip": "0.0.0.0/32",
 *         "name": name,
 *         "entry_type": "custom",
 *         "policy": "accept",
 *         "description": name,
 *     }],
 *     egresses=[{
 *         "protocol": "all",
 *         "port": "-1/-1",
 *         "destination_cidr_ip": "0.0.0.0/32",
 *         "name": name,
 *         "entry_type": "custom",
 *         "policy": "accept",
 *         "description": name,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "NetworkAclEntries";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         Name = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultNetworkAcl = new AliCloud.Vpc.NetworkAcl("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         Name = name,
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         Name = name,
 *     });
 *     var defaultNetworkAclAttachment = new AliCloud.Vpc.NetworkAclAttachment("default", new()
 *     {
 *         NetworkAclId = defaultNetworkAcl.Id,
 *         Resources = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclAttachmentResourceArgs
 *             {
 *                 ResourceId = defaultSwitch.Id,
 *                 ResourceType = "VSwitch",
 *             },
 *         },
 *     });
 *     var defaultNetworkAclEntries = new AliCloud.Vpc.NetworkAclEntries("default", new()
 *     {
 *         NetworkAclId = defaultNetworkAcl.Id,
 *         Ingresses = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclEntriesIngressArgs
 *             {
 *                 Protocol = "all",
 *                 Port = "-1/-1",
 *                 SourceCidrIp = "0.0.0.0/32",
 *                 Name = name,
 *                 EntryType = "custom",
 *                 Policy = "accept",
 *                 Description = name,
 *             },
 *         },
 *         Egresses = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.NetworkAclEntriesEgressArgs
 *             {
 *                 Protocol = "all",
 *                 Port = "-1/-1",
 *                 DestinationCidrIp = "0.0.0.0/32",
 *                 Name = name,
 *                 EntryType = "custom",
 *                 Policy = "accept",
 *                 Description = name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "NetworkAclEntries"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			Name:      pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetworkAcl, err := vpc.NewNetworkAcl(ctx, "default", &vpc.NetworkAclArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 			Name:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:     defaultNetwork.ID(),
 * 			CidrBlock: pulumi.String("172.16.0.0/21"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			Name:      pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkAclAttachment(ctx, "default", &vpc.NetworkAclAttachmentArgs{
 * 			NetworkAclId: defaultNetworkAcl.ID(),
 * 			Resources: vpc.NetworkAclAttachmentResourceArray{
 * 				&vpc.NetworkAclAttachmentResourceArgs{
 * 					ResourceId:   defaultSwitch.ID(),
 * 					ResourceType: pulumi.String("VSwitch"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkAclEntries(ctx, "default", &vpc.NetworkAclEntriesArgs{
 * 			NetworkAclId: defaultNetworkAcl.ID(),
 * 			Ingresses: vpc.NetworkAclEntriesIngressArray{
 * 				&vpc.NetworkAclEntriesIngressArgs{
 * 					Protocol:     pulumi.String("all"),
 * 					Port:         pulumi.String("-1/-1"),
 * 					SourceCidrIp: pulumi.String("0.0.0.0/32"),
 * 					Name:         pulumi.String(name),
 * 					EntryType:    pulumi.String("custom"),
 * 					Policy:       pulumi.String("accept"),
 * 					Description:  pulumi.String(name),
 * 				},
 * 			},
 * 			Egresses: vpc.NetworkAclEntriesEgressArray{
 * 				&vpc.NetworkAclEntriesEgressArgs{
 * 					Protocol:          pulumi.String("all"),
 * 					Port:              pulumi.String("-1/-1"),
 * 					DestinationCidrIp: pulumi.String("0.0.0.0/32"),
 * 					Name:              pulumi.String(name),
 * 					EntryType:         pulumi.String("custom"),
 * 					Policy:            pulumi.String("accept"),
 * 					Description:       pulumi.String(name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.NetworkAcl;
 * import com.pulumi.alicloud.vpc.NetworkAclArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NetworkAclAttachment;
 * import com.pulumi.alicloud.vpc.NetworkAclAttachmentArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclAttachmentResourceArgs;
 * import com.pulumi.alicloud.vpc.NetworkAclEntries;
 * import com.pulumi.alicloud.vpc.NetworkAclEntriesArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesIngressArgs;
 * import com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesEgressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("NetworkAclEntries");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .name(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultNetworkAcl = new NetworkAcl("defaultNetworkAcl", NetworkAclArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .name(name)
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(default_.zones()[0].id())
 *             .name(name)
 *             .build());
 *         var defaultNetworkAclAttachment = new NetworkAclAttachment("defaultNetworkAclAttachment", NetworkAclAttachmentArgs.builder()
 *             .networkAclId(defaultNetworkAcl.id())
 *             .resources(NetworkAclAttachmentResourceArgs.builder()
 *                 .resourceId(defaultSwitch.id())
 *                 .resourceType("VSwitch")
 *                 .build())
 *             .build());
 *         var defaultNetworkAclEntries = new NetworkAclEntries("defaultNetworkAclEntries", NetworkAclEntriesArgs.builder()
 *             .networkAclId(defaultNetworkAcl.id())
 *             .ingresses(NetworkAclEntriesIngressArgs.builder()
 *                 .protocol("all")
 *                 .port("-1/-1")
 *                 .sourceCidrIp("0.0.0.0/32")
 *                 .name(name)
 *                 .entryType("custom")
 *                 .policy("accept")
 *                 .description(name)
 *                 .build())
 *             .egresses(NetworkAclEntriesEgressArgs.builder()
 *                 .protocol("all")
 *                 .port("-1/-1")
 *                 .destinationCidrIp("0.0.0.0/32")
 *                 .name(name)
 *                 .entryType("custom")
 *                 .policy("accept")
 *                 .description(name)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: NetworkAclEntries
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       name: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultNetworkAcl:
 *     type: alicloud:vpc:NetworkAcl
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       name: ${name}
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${default.zones[0].id}
 *       name: ${name}
 *   defaultNetworkAclAttachment:
 *     type: alicloud:vpc:NetworkAclAttachment
 *     name: default
 *     properties:
 *       networkAclId: ${defaultNetworkAcl.id}
 *       resources:
 *         - resourceId: ${defaultSwitch.id}
 *           resourceType: VSwitch
 *   defaultNetworkAclEntries:
 *     type: alicloud:vpc:NetworkAclEntries
 *     name: default
 *     properties:
 *       networkAclId: ${defaultNetworkAcl.id}
 *       ingresses:
 *         - protocol: all
 *           port: -1/-1
 *           sourceCidrIp: 0.0.0.0/32
 *           name: ${name}
 *           entryType: custom
 *           policy: accept
 *           description: ${name}
 *       egresses:
 *         - protocol: all
 *           port: -1/-1
 *           destinationCidrIp: 0.0.0.0/32
 *           name: ${name}
 *           entryType: custom
 *           policy: accept
 *           description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * @property egresses List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
 * @property ingresses List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
 * @property networkAclId The id of the network acl, the field can't be changed.
 */
public data class NetworkAclEntriesArgs(
    public val egresses: Output<List<NetworkAclEntriesEgressArgs>>? = null,
    public val ingresses: Output<List<NetworkAclEntriesIngressArgs>>? = null,
    public val networkAclId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.NetworkAclEntriesArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.NetworkAclEntriesArgs =
        com.pulumi.alicloud.vpc.NetworkAclEntriesArgs.builder()
            .egresses(
                egresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingresses(
                ingresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .networkAclId(networkAclId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclEntriesArgs].
 */
@PulumiTagMarker
public class NetworkAclEntriesArgsBuilder internal constructor() {
    private var egresses: Output<List<NetworkAclEntriesEgressArgs>>? = null

    private var ingresses: Output<List<NetworkAclEntriesIngressArgs>>? = null

    private var networkAclId: Output<String>? = null

    /**
     * @param value List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("pvplddrmdjwaneuk")
    public suspend fun egresses(`value`: Output<List<NetworkAclEntriesEgressArgs>>) {
        this.egresses = value
    }

    @JvmName("olcespcnetfbytsj")
    public suspend fun egresses(vararg values: Output<NetworkAclEntriesEgressArgs>) {
        this.egresses = Output.all(values.asList())
    }

    /**
     * @param values List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("dlrguuxfngqoapkr")
    public suspend fun egresses(values: List<Output<NetworkAclEntriesEgressArgs>>) {
        this.egresses = Output.all(values)
    }

    /**
     * @param value List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("rxviftrrjkxppacy")
    public suspend fun ingresses(`value`: Output<List<NetworkAclEntriesIngressArgs>>) {
        this.ingresses = value
    }

    @JvmName("elckxwaljvukwkqr")
    public suspend fun ingresses(vararg values: Output<NetworkAclEntriesIngressArgs>) {
        this.ingresses = Output.all(values.asList())
    }

    /**
     * @param values List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("adpiftjvkbmyjxbu")
    public suspend fun ingresses(values: List<Output<NetworkAclEntriesIngressArgs>>) {
        this.ingresses = Output.all(values)
    }

    /**
     * @param value The id of the network acl, the field can't be changed.
     */
    @JvmName("rdqelamvjophestb")
    public suspend fun networkAclId(`value`: Output<String>) {
        this.networkAclId = value
    }

    /**
     * @param value List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("euviqdkyfpdjgyys")
    public suspend fun egresses(`value`: List<NetworkAclEntriesEgressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egresses = mapped
    }

    /**
     * @param argument List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("xurhinyfcojnrcdb")
    public suspend fun egresses(argument: List<suspend NetworkAclEntriesEgressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclEntriesEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egresses = mapped
    }

    /**
     * @param argument List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("bunxenyucetneunk")
    public suspend fun egresses(vararg argument: suspend NetworkAclEntriesEgressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclEntriesEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egresses = mapped
    }

    /**
     * @param argument List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("qyocwdsndsfpaydm")
    public suspend fun egresses(argument: suspend NetworkAclEntriesEgressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkAclEntriesEgressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.egresses = mapped
    }

    /**
     * @param values List of the egress entries of the network acl. The order of the egress entries determines the priority. The details see Block Egress.
     */
    @JvmName("aqsdgvhulvctuenr")
    public suspend fun egresses(vararg values: NetworkAclEntriesEgressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egresses = mapped
    }

    /**
     * @param value List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("xoxonwbiedqgvbxl")
    public suspend fun ingresses(`value`: List<NetworkAclEntriesIngressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingresses = mapped
    }

    /**
     * @param argument List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("oxagvhpgfpijqgaa")
    public suspend fun ingresses(argument: List<suspend NetworkAclEntriesIngressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclEntriesIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingresses = mapped
    }

    /**
     * @param argument List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("cgukmhjrkvadyojy")
    public suspend fun ingresses(vararg argument: suspend NetworkAclEntriesIngressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclEntriesIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingresses = mapped
    }

    /**
     * @param argument List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("kwwneosesculnhmp")
    public suspend fun ingresses(argument: suspend NetworkAclEntriesIngressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkAclEntriesIngressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ingresses = mapped
    }

    /**
     * @param values List of the ingress entries of the network acl. The order of the ingress entries determines the priority. The details see Block Ingress.
     */
    @JvmName("hhjvawsodcmmtwpf")
    public suspend fun ingresses(vararg values: NetworkAclEntriesIngressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingresses = mapped
    }

    /**
     * @param value The id of the network acl, the field can't be changed.
     */
    @JvmName("qucgobijyddsdkym")
    public suspend fun networkAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclId = mapped
    }

    internal fun build(): NetworkAclEntriesArgs = NetworkAclEntriesArgs(
        egresses = egresses,
        ingresses = ingresses,
        networkAclId = networkAclId,
    )
}
