@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.NetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Vpc resource.
 * A VPC instance creates a VPC. You can fully control your own VPC, such as selecting IP address ranges, configuring routing tables, and gateways. You can use Alibaba cloud resources such as cloud servers, apsaradb for RDS, and load balancer in your own VPC.
 * > **NOTE:** This resource will auto build a router and a route table while it uses `alicloud.vpc.Network` to build a vpc resource.
 * > **NOTE:** Available since v1.0.0.
 * ## Module Support
 * You can use the existing vpc module
 * to create a VPC and several VSwitches one-click.
 * For information about VPC Vpc and how to use it, see [What is Vpc](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/what-is-a-vpc).
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpc.Network("default", {
 *     ipv6Isp: "BGP",
 *     description: "test",
 *     cidrBlock: "10.0.0.0/8",
 *     vpcName: name,
 *     enableIpv6: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.Network("default",
 *     ipv6_isp="BGP",
 *     description="test",
 *     cidr_block="10.0.0.0/8",
 *     vpc_name=name,
 *     enable_ipv6=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpc.Network("default", new()
 *     {
 *         Ipv6Isp = "BGP",
 *         Description = "test",
 *         CidrBlock = "10.0.0.0/8",
 *         VpcName = name,
 *         EnableIpv6 = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			Ipv6Isp:     pulumi.String("BGP"),
 * 			Description: pulumi.String("test"),
 * 			CidrBlock:   pulumi.String("10.0.0.0/8"),
 * 			VpcName:     pulumi.String(name),
 * 			EnableIpv6:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .ipv6Isp("BGP")
 *             .description("test")
 *             .cidrBlock("10.0.0.0/8")
 *             .vpcName(name)
 *             .enableIpv6(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpc:Network
 *     properties:
 *       ipv6Isp: BGP
 *       description: test
 *       cidrBlock: 10.0.0.0/8
 *       vpcName: ${name}
 *       enableIpv6: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Vpc can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/network:Network example <id>
 * ```
 * @property cidrBlock The CIDR block of the VPC.
 * - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
 * - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
 * @property classicLinkEnabled The status of ClassicLink function.
 * @property description The new description of the VPC. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
 * @property dryRun Specifies whether to perform a dry run. Valid values:
 * @property enableIpv6 The name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
 * @property ipv4IpamPoolId The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
 * @property ipv6CidrBlock The IPv6 CIDR block of the default VPC.
 * > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
 * @property ipv6Isp The IPv6 address segment type of the VPC. Value:
 * - `BGP` (default): Alibaba Cloud BGP IPv6.
 * - `ChinaMobile`: China Mobile (single line).
 * - `ChinaUnicom`: China Unicom (single line).
 * - `ChinaTelecom`: China Telecom (single line).
 * > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
 * @property isDefault Specifies whether to create the default VPC in the specified region. Valid values:
 * @property name . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
 * @property resourceGroupId The ID of the resource group to which you want to move the resource.
 * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
 * @property secondaryCidrBlocks Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at the same time.
 * @property systemRouteTableDescription The description of the route table. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
 * @property systemRouteTableName The name of the route table. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
 * @property tags The tags of Vpc.
 * @property userCidrs A list of user CIDRs.
 * @property vpcName The new name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class NetworkArgs(
    public val cidrBlock: Output<String>? = null,
    public val classicLinkEnabled: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val enableIpv6: Output<Boolean>? = null,
    public val ipv4IpamPoolId: Output<String>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6Isp: Output<String>? = null,
    public val isDefault: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field
      'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be
      removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'.
      `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at
      the same time.
  """,
    )
    public val secondaryCidrBlocks: Output<List<String>>? = null,
    public val systemRouteTableDescription: Output<String>? = null,
    public val systemRouteTableName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userCidrs: Output<List<String>>? = null,
    public val vpcName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.NetworkArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.NetworkArgs =
        com.pulumi.alicloud.vpc.NetworkArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .classicLinkEnabled(classicLinkEnabled?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .enableIpv6(enableIpv6?.applyValue({ args0 -> args0 }))
            .ipv4IpamPoolId(ipv4IpamPoolId?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .ipv6Isp(ipv6Isp?.applyValue({ args0 -> args0 }))
            .isDefault(isDefault?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .secondaryCidrBlocks(secondaryCidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .systemRouteTableDescription(systemRouteTableDescription?.applyValue({ args0 -> args0 }))
            .systemRouteTableName(systemRouteTableName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userCidrs(userCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcName(vpcName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkArgs].
 */
@PulumiTagMarker
public class NetworkArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var classicLinkEnabled: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var enableIpv6: Output<Boolean>? = null

    private var ipv4IpamPoolId: Output<String>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6Isp: Output<String>? = null

    private var isDefault: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var secondaryCidrBlocks: Output<List<String>>? = null

    private var systemRouteTableDescription: Output<String>? = null

    private var systemRouteTableName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userCidrs: Output<List<String>>? = null

    private var vpcName: Output<String>? = null

    /**
     * @param value The CIDR block of the VPC.
     * - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
     * - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
     */
    @JvmName("ormkwcxsfkapcxwv")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The status of ClassicLink function.
     */
    @JvmName("fumnepwtrutxrrxg")
    public suspend fun classicLinkEnabled(`value`: Output<Boolean>) {
        this.classicLinkEnabled = value
    }

    /**
     * @param value The new description of the VPC. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
     */
    @JvmName("yedevbotwpoqfatw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to perform a dry run. Valid values:
     */
    @JvmName("ydthdgudcvxpplrq")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("iasqgipnabjyxhnw")
    public suspend fun enableIpv6(`value`: Output<Boolean>) {
        this.enableIpv6 = value
    }

    /**
     * @param value The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
     */
    @JvmName("bxloxdrbqgpelbmw")
    public suspend fun ipv4IpamPoolId(`value`: Output<String>) {
        this.ipv4IpamPoolId = value
    }

    /**
     * @param value The IPv6 CIDR block of the default VPC.
     * > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
     */
    @JvmName("fvwwyvpuippirvpv")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value The IPv6 address segment type of the VPC. Value:
     * - `BGP` (default): Alibaba Cloud BGP IPv6.
     * - `ChinaMobile`: China Mobile (single line).
     * - `ChinaUnicom`: China Unicom (single line).
     * - `ChinaTelecom`: China Telecom (single line).
     * > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
     */
    @JvmName("jxgkmnswlmffnbfr")
    public suspend fun ipv6Isp(`value`: Output<String>) {
        this.ipv6Isp = value
    }

    /**
     * @param value Specifies whether to create the default VPC in the specified region. Valid values:
     */
    @JvmName("xljjlbghcktcrgdh")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.
  """,
    )
    @JvmName("txyravaeacsfsrve")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    @JvmName("vjccejtwnadrmumo")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at the same time.
     */
    @Deprecated(
        message = """
  Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field
      'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be
      removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'.
      `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at
      the same time.
  """,
    )
    @JvmName("rddqsiqfybdypanm")
    public suspend fun secondaryCidrBlocks(`value`: Output<List<String>>) {
        this.secondaryCidrBlocks = value
    }

    @JvmName("weltwhejoouwklys")
    public suspend fun secondaryCidrBlocks(vararg values: Output<String>) {
        this.secondaryCidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at the same time.
     */
    @Deprecated(
        message = """
  Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field
      'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be
      removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'.
      `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at
      the same time.
  """,
    )
    @JvmName("pxulshofylllxsjd")
    public suspend fun secondaryCidrBlocks(values: List<Output<String>>) {
        this.secondaryCidrBlocks = Output.all(values)
    }

    /**
     * @param value The description of the route table. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
     */
    @JvmName("ettbwgphmiwhujpo")
    public suspend fun systemRouteTableDescription(`value`: Output<String>) {
        this.systemRouteTableDescription = value
    }

    /**
     * @param value The name of the route table. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("kweytydfsoaifocc")
    public suspend fun systemRouteTableName(`value`: Output<String>) {
        this.systemRouteTableName = value
    }

    /**
     * @param value The tags of Vpc.
     */
    @JvmName("qmwxrgsdkubucvyv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of user CIDRs.
     */
    @JvmName("kcnaqwvpipxjpmpu")
    public suspend fun userCidrs(`value`: Output<List<String>>) {
        this.userCidrs = value
    }

    @JvmName("vwjxhrwiiwjmrplh")
    public suspend fun userCidrs(vararg values: Output<String>) {
        this.userCidrs = Output.all(values.asList())
    }

    /**
     * @param values A list of user CIDRs.
     */
    @JvmName("tsamlaoallywitwy")
    public suspend fun userCidrs(values: List<Output<String>>) {
        this.userCidrs = Output.all(values)
    }

    /**
     * @param value The new name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("txhovmkliogpmskt")
    public suspend fun vpcName(`value`: Output<String>) {
        this.vpcName = value
    }

    /**
     * @param value The CIDR block of the VPC.
     * - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
     * - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
     */
    @JvmName("utpcbhdilqtxxfcy")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The status of ClassicLink function.
     */
    @JvmName("mdukrerywmauviji")
    public suspend fun classicLinkEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classicLinkEnabled = mapped
    }

    /**
     * @param value The new description of the VPC. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
     */
    @JvmName("ctfssqmaonyynlnx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to perform a dry run. Valid values:
     */
    @JvmName("udalynhtmgdghrcl")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("aarbfwemoumjctvb")
    public suspend fun enableIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpv6 = mapped
    }

    /**
     * @param value The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
     */
    @JvmName("joqynbqdadpfmmhj")
    public suspend fun ipv4IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4IpamPoolId = mapped
    }

    /**
     * @param value The IPv6 CIDR block of the default VPC.
     * > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
     */
    @JvmName("dhfevwtayexdqgeh")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value The IPv6 address segment type of the VPC. Value:
     * - `BGP` (default): Alibaba Cloud BGP IPv6.
     * - `ChinaMobile`: China Mobile (single line).
     * - `ChinaUnicom`: China Unicom (single line).
     * - `ChinaTelecom`: China Telecom (single line).
     * > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
     */
    @JvmName("ewubngaoxvybedqw")
    public suspend fun ipv6Isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Isp = mapped
    }

    /**
     * @param value Specifies whether to create the default VPC in the specified region. Valid values:
     */
    @JvmName("nqlsgurwenhxltoe")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.
  """,
    )
    @JvmName("bseyoqvwfymfksre")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    @JvmName("qxydwqtktkcppywe")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at the same time.
     */
    @Deprecated(
        message = """
  Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field
      'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be
      removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'.
      `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at
      the same time.
  """,
    )
    @JvmName("lfyndaalfjrqjrpf")
    public suspend fun secondaryCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryCidrBlocks = mapped
    }

    /**
     * @param values Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at the same time.
     */
    @Deprecated(
        message = """
  Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field
      'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be
      removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'.
      `secondary_cidr_blocks` attributes and `alicloud.vpc.Ipv4CidrBlock` resource cannot be used at
      the same time.
  """,
    )
    @JvmName("utyctacohnpuivhd")
    public suspend fun secondaryCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryCidrBlocks = mapped
    }

    /**
     * @param value The description of the route table. The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
     */
    @JvmName("exgckwhrrruxibtd")
    public suspend fun systemRouteTableDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemRouteTableDescription = mapped
    }

    /**
     * @param value The name of the route table. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("jkwahiyvqplraoka")
    public suspend fun systemRouteTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemRouteTableName = mapped
    }

    /**
     * @param value The tags of Vpc.
     */
    @JvmName("ahtnuowthskppcnl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of Vpc.
     */
    @JvmName("mpbepfimekklmhad")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of user CIDRs.
     */
    @JvmName("pnowqpsvuyluktuf")
    public suspend fun userCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userCidrs = mapped
    }

    /**
     * @param values A list of user CIDRs.
     */
    @JvmName("ckgnocgpqwyfsaow")
    public suspend fun userCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userCidrs = mapped
    }

    /**
     * @param value The new name of the VPC. The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("cqikcipusbjlcxlc")
    public suspend fun vpcName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcName = mapped
    }

    internal fun build(): NetworkArgs = NetworkArgs(
        cidrBlock = cidrBlock,
        classicLinkEnabled = classicLinkEnabled,
        description = description,
        dryRun = dryRun,
        enableIpv6 = enableIpv6,
        ipv4IpamPoolId = ipv4IpamPoolId,
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6Isp = ipv6Isp,
        isDefault = isDefault,
        name = name,
        resourceGroupId = resourceGroupId,
        secondaryCidrBlocks = secondaryCidrBlocks,
        systemRouteTableDescription = systemRouteTableDescription,
        systemRouteTableName = systemRouteTableName,
        tags = tags,
        userCidrs = userCidrs,
        vpcName = vpcName,
    )
}
