@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NetworkInterface].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceArgs = NetworkInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkInterface {
        val builtJavaResource = com.pulumi.alicloud.vpc.NetworkInterface(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkInterface(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsNetworkInterface from version 1.123.1.
 * Provides an ECS Elastic Network Interface resource.
 * For information about Elastic Network Interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html).
 * > **NOTE** Only one of private_ips or private_ips_count can be specified when assign private IPs.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "networkInterfaceName";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/24",
 * });
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const vswitch = new alicloud.vpc.Switch("vswitch", {
 *     name: name,
 *     cidrBlock: "192.168.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vpcId: vpc.id,
 * });
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: name,
 *     vpcId: vpc.id,
 * });
 * const defaultNetworkInterface = new alicloud.vpc.NetworkInterface("default", {
 *     networkInterfaceName: name,
 *     vswitchId: vswitch.id,
 *     securityGroupIds: [group&#46;id],
 *     privateIp: "192.168.0.2",
 *     privateIpsCount: 3,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "networkInterfaceName"
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/24")
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * vswitch = alicloud.vpc.Switch("vswitch",
 *     name=name,
 *     cidr_block="192.168.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vpc_id=vpc.id)
 * group = alicloud.ecs.SecurityGroup("group",
 *     name=name,
 *     vpc_id=vpc.id)
 * default_network_interface = alicloud.vpc.NetworkInterface("default",
 *     network_interface_name=name,
 *     vswitch_id=vswitch.id,
 *     security_group_ids=[group&#46;id],
 *     private_ip="192.168.0.2",
 *     private_ips_count=3)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "networkInterfaceName";
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/24",
 *     });
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var vswitch = new AliCloud.Vpc.Switch("vswitch", new()
 *     {
 *         Name = name,
 *         CidrBlock = "192.168.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VpcId = vpc.Id,
 *     });
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = name,
 *         VpcId = vpc.Id,
 *     });
 *     var defaultNetworkInterface = new AliCloud.Vpc.NetworkInterface("default", new()
 *     {
 *         NetworkInterfaceName = name,
 *         VswitchId = vswitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             @group.Id,
 *         },
 *         PrivateIp = "192.168.0.2",
 *         PrivateIpsCount = 3,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "networkInterfaceName"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitch, err := vpc.NewSwitch(ctx, "vswitch", &vpc.SwitchArgs{
 * 			Name:      pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/24"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			VpcId:     vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		group, err := ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkInterface(ctx, "default", &vpc.NetworkInterfaceArgs{
 * 			NetworkInterfaceName: pulumi.String(name),
 * 			VswitchId:            vswitch.ID(),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				group.ID(),
 * 			},
 * 			PrivateIp:       pulumi.String("192.168.0.2"),
 * 			PrivateIpsCount: pulumi.Int(3),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.vpc.NetworkInterface;
 * import com.pulumi.alicloud.vpc.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("networkInterfaceName");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .build());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
 *             .name(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vpcId(vpc.id())
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(vpc.id())
 *             .build());
 *         var defaultNetworkInterface = new NetworkInterface("defaultNetworkInterface", NetworkInterfaceArgs.builder()
 *             .networkInterfaceName(name)
 *             .vswitchId(vswitch.id())
 *             .securityGroupIds(group.id())
 *             .privateIp("192.168.0.2")
 *             .privateIpsCount(3)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: networkInterfaceName
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/24
 *   vswitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       name: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vpcId: ${vpc.id}
 *   group:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: ${name}
 *       vpcId: ${vpc.id}
 *   defaultNetworkInterface:
 *     type: alicloud:vpc:NetworkInterface
 *     name: default
 *     properties:
 *       networkInterfaceName: ${name}
 *       vswitchId: ${vswitch.id}
 *       securityGroupIds:
 *         - ${group.id}
 *       privateIp: 192.168.0.2
 *       privateIpsCount: 3
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENI can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/networkInterface:NetworkInterface eni eni-abc1234567890000
 * ```
 */
public class NetworkInterface internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.NetworkInterface,
) : KotlinCustomResource(javaResource, NetworkInterfaceMapper) {
    /**
     * Description of the ENI. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    public val ipv4PrefixCount: Output<Int>
        get() = javaResource.ipv4PrefixCount().applyValue({ args0 -> args0 })

    public val ipv4Prefixes: Output<List<String>>
        get() = javaResource.ipv4Prefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val ipv6AddressCount: Output<Int>
        get() = javaResource.ipv6AddressCount().applyValue({ args0 -> args0 })

    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * (Available in 1.54.0+) The MAC address of an ENI.
     */
    public val mac: Output<String>
        get() = javaResource.mac().applyValue({ args0 -> args0 })

    /**
     * Name of the ENI. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-", ".", "_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val networkInterfaceName: Output<String>
        get() = javaResource.networkInterfaceName().applyValue({ args0 -> args0 })

    public val networkInterfaceTrafficMode: Output<String>
        get() = javaResource.networkInterfaceTrafficMode().applyValue({ args0 -> args0 })

    public val primaryIpAddress: Output<String>
        get() = javaResource.primaryIpAddress().applyValue({ args0 -> args0 })

    /**
     * The primary private IP of the ENI.
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    public val privateIpAddresses: Output<List<String>>
        get() = javaResource.privateIpAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    public val privateIps: Output<List<String>>
        get() = javaResource.privateIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Number of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    public val privateIpsCount: Output<Int>
        get() = javaResource.privateIpsCount().applyValue({ args0 -> args0 })

    public val queueNumber: Output<Int>
        get() = javaResource.queueNumber().applyValue({ args0 -> args0 })

    /**
     * The Id of resource group which the network interface belongs.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val secondaryPrivateIpAddressCount: Output<Int>
        get() = javaResource.secondaryPrivateIpAddressCount().applyValue({ args0 -> args0 })

    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of security group ids to associate with.
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The VSwitch to create the ENI in.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object NetworkInterfaceMapper : ResourceMapper<NetworkInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.NetworkInterface::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterface = NetworkInterface(
        javaResource as
            com.pulumi.alicloud.vpc.NetworkInterface,
    )
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterface].
 */
public suspend fun networkInterface(
    name: String,
    block: suspend NetworkInterfaceResourceBuilder.() -> Unit,
): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterface(name: String): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
