@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.NetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsNetworkInterface from version 1.123.1.
 * Provides an ECS Elastic Network Interface resource.
 * For information about Elastic Network Interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html).
 * > **NOTE** Only one of private_ips or private_ips_count can be specified when assign private IPs.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "networkInterfaceName";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/24",
 * });
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const vswitch = new alicloud.vpc.Switch("vswitch", {
 *     name: name,
 *     cidrBlock: "192.168.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vpcId: vpc.id,
 * });
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: name,
 *     vpcId: vpc.id,
 * });
 * const defaultNetworkInterface = new alicloud.vpc.NetworkInterface("default", {
 *     networkInterfaceName: name,
 *     vswitchId: vswitch.id,
 *     securityGroupIds: [group&#46;id],
 *     privateIp: "192.168.0.2",
 *     privateIpsCount: 3,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "networkInterfaceName"
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/24")
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * vswitch = alicloud.vpc.Switch("vswitch",
 *     name=name,
 *     cidr_block="192.168.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vpc_id=vpc.id)
 * group = alicloud.ecs.SecurityGroup("group",
 *     name=name,
 *     vpc_id=vpc.id)
 * default_network_interface = alicloud.vpc.NetworkInterface("default",
 *     network_interface_name=name,
 *     vswitch_id=vswitch.id,
 *     security_group_ids=[group&#46;id],
 *     private_ip="192.168.0.2",
 *     private_ips_count=3)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "networkInterfaceName";
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/24",
 *     });
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var vswitch = new AliCloud.Vpc.Switch("vswitch", new()
 *     {
 *         Name = name,
 *         CidrBlock = "192.168.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VpcId = vpc.Id,
 *     });
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = name,
 *         VpcId = vpc.Id,
 *     });
 *     var defaultNetworkInterface = new AliCloud.Vpc.NetworkInterface("default", new()
 *     {
 *         NetworkInterfaceName = name,
 *         VswitchId = vswitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             @group.Id,
 *         },
 *         PrivateIp = "192.168.0.2",
 *         PrivateIpsCount = 3,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "networkInterfaceName"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitch, err := vpc.NewSwitch(ctx, "vswitch", &vpc.SwitchArgs{
 * 			Name:      pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/24"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			VpcId:     vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		group, err := ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewNetworkInterface(ctx, "default", &vpc.NetworkInterfaceArgs{
 * 			NetworkInterfaceName: pulumi.String(name),
 * 			VswitchId:            vswitch.ID(),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				group.ID(),
 * 			},
 * 			PrivateIp:       pulumi.String("192.168.0.2"),
 * 			PrivateIpsCount: pulumi.Int(3),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.vpc.NetworkInterface;
 * import com.pulumi.alicloud.vpc.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("networkInterfaceName");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .build());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
 *             .name(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vpcId(vpc.id())
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(vpc.id())
 *             .build());
 *         var defaultNetworkInterface = new NetworkInterface("defaultNetworkInterface", NetworkInterfaceArgs.builder()
 *             .networkInterfaceName(name)
 *             .vswitchId(vswitch.id())
 *             .securityGroupIds(group.id())
 *             .privateIp("192.168.0.2")
 *             .privateIpsCount(3)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: networkInterfaceName
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/24
 *   vswitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       name: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vpcId: ${vpc.id}
 *   group:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: ${name}
 *       vpcId: ${vpc.id}
 *   defaultNetworkInterface:
 *     type: alicloud:vpc:NetworkInterface
 *     name: default
 *     properties:
 *       networkInterfaceName: ${name}
 *       vswitchId: ${vswitch.id}
 *       securityGroupIds:
 *         - ${group.id}
 *       privateIp: 192.168.0.2
 *       privateIpsCount: 3
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENI can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/networkInterface:NetworkInterface eni eni-abc1234567890000
 * ```
 * @property description Description of the ENI. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
 * @property instanceType
 * @property ipv4PrefixCount
 * @property ipv4Prefixes
 * @property ipv6AddressCount
 * @property ipv6Addresses
 * @property name Name of the ENI. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-", ".", "_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
 * @property networkInterfaceName
 * @property networkInterfaceTrafficMode
 * @property primaryIpAddress
 * @property privateIp The primary private IP of the ENI.
 * @property privateIpAddresses
 * @property privateIps List of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
 * @property privateIpsCount Number of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
 * @property queueNumber
 * @property resourceGroupId The Id of resource group which the network interface belongs.
 * @property secondaryPrivateIpAddressCount
 * @property securityGroupIds
 * @property securityGroups A list of security group ids to associate with.
 * @property tags A mapping of tags to assign to the resource.
 * @property vswitchId The VSwitch to create the ENI in.
 */
public data class NetworkInterfaceArgs(
    public val description: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val ipv4PrefixCount: Output<Int>? = null,
    public val ipv4Prefixes: Output<List<String>>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    public val name: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val networkInterfaceTrafficMode: Output<String>? = null,
    public val primaryIpAddress: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    public val privateIp: Output<String>? = null,
    public val privateIpAddresses: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    public val privateIps: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    public val privateIpsCount: Output<Int>? = null,
    public val queueNumber: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val secondaryPrivateIpAddressCount: Output<Int>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    public val securityGroups: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.NetworkInterfaceArgs =
        com.pulumi.alicloud.vpc.NetworkInterfaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .ipv4PrefixCount(ipv4PrefixCount?.applyValue({ args0 -> args0 }))
            .ipv4Prefixes(ipv4Prefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .networkInterfaceTrafficMode(networkInterfaceTrafficMode?.applyValue({ args0 -> args0 }))
            .primaryIpAddress(primaryIpAddress?.applyValue({ args0 -> args0 }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .privateIpAddresses(privateIpAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIps(privateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIpsCount(privateIpsCount?.applyValue({ args0 -> args0 }))
            .queueNumber(queueNumber?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var ipv4PrefixCount: Output<Int>? = null

    private var ipv4Prefixes: Output<List<String>>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var networkInterfaceTrafficMode: Output<String>? = null

    private var primaryIpAddress: Output<String>? = null

    private var privateIp: Output<String>? = null

    private var privateIpAddresses: Output<List<String>>? = null

    private var privateIps: Output<List<String>>? = null

    private var privateIpsCount: Output<Int>? = null

    private var queueNumber: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var secondaryPrivateIpAddressCount: Output<Int>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var securityGroups: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Description of the ENI. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("smkedgcfdupjimnf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("laoxqgdetfuqwysi")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value
     */
    @JvmName("lsxcoinqrhfqkjba")
    public suspend fun ipv4PrefixCount(`value`: Output<Int>) {
        this.ipv4PrefixCount = value
    }

    /**
     * @param value
     */
    @JvmName("rrxihlsebtqrlsep")
    public suspend fun ipv4Prefixes(`value`: Output<List<String>>) {
        this.ipv4Prefixes = value
    }

    @JvmName("qomolmmidpijchfw")
    public suspend fun ipv4Prefixes(vararg values: Output<String>) {
        this.ipv4Prefixes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bxfyvaivtuakksna")
    public suspend fun ipv4Prefixes(values: List<Output<String>>) {
        this.ipv4Prefixes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("yfyadibmavxjxmjh")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value
     */
    @JvmName("moeqdlwkjfvfebai")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("sbvfhiykpxjvwasu")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gnxcncwdywuifoyk")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Name of the ENI. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-", ".", "_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    @JvmName("tycngccjooyfsokc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("iqfhncyndhwwbxnm")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value
     */
    @JvmName("biswhkyfvdsyhvqu")
    public suspend fun networkInterfaceTrafficMode(`value`: Output<String>) {
        this.networkInterfaceTrafficMode = value
    }

    /**
     * @param value
     */
    @JvmName("blbojfjredgpdeal")
    public suspend fun primaryIpAddress(`value`: Output<String>) {
        this.primaryIpAddress = value
    }

    /**
     * @param value The primary private IP of the ENI.
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    @JvmName("ssuaemyfvxagpbgk")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value
     */
    @JvmName("vbnbpghhbmexawfp")
    public suspend fun privateIpAddresses(`value`: Output<List<String>>) {
        this.privateIpAddresses = value
    }

    @JvmName("eggiftydaijumqtv")
    public suspend fun privateIpAddresses(vararg values: Output<String>) {
        this.privateIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("voigrniyfuonylln")
    public suspend fun privateIpAddresses(values: List<Output<String>>) {
        this.privateIpAddresses = Output.all(values)
    }

    /**
     * @param value List of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("gginwglyoqlbjlpt")
    public suspend fun privateIps(`value`: Output<List<String>>) {
        this.privateIps = value
    }

    @JvmName("vyqeltgotojrilqp")
    public suspend fun privateIps(vararg values: Output<String>) {
        this.privateIps = Output.all(values.asList())
    }

    /**
     * @param values List of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("nljbngtaqknypwkk")
    public suspend fun privateIps(values: List<Output<String>>) {
        this.privateIps = Output.all(values)
    }

    /**
     * @param value Number of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    @JvmName("bngfwvmbmdnuqprq")
    public suspend fun privateIpsCount(`value`: Output<Int>) {
        this.privateIpsCount = value
    }

    /**
     * @param value
     */
    @JvmName("rfervaypuunlxqgs")
    public suspend fun queueNumber(`value`: Output<Int>) {
        this.queueNumber = value
    }

    /**
     * @param value The Id of resource group which the network interface belongs.
     */
    @JvmName("lpnuaojvvyrwrllq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("nvdltidhwamtqcon")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Output<Int>) {
        this.secondaryPrivateIpAddressCount = value
    }

    /**
     * @param value
     */
    @JvmName("dqhfuvklddhsaasb")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("ivmxmlxhwpjihoth")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bwpukvofupvruwqa")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of security group ids to associate with.
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("kcjmarebslkjmewq")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("mxsmfhnkhrtvayrx")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group ids to associate with.
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("berblqqfaskfawht")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("asnnhtwyasncgfwl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VSwitch to create the ENI in.
     */
    @JvmName("jrbkbpjnyvyxamnh")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Description of the ENI. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("vmtjpjqunnoywgvt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("hvfmnkanjaqqqeuk")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("kgqtbolvfrlruiwa")
    public suspend fun ipv4PrefixCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4PrefixCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvtwisxojnoacxri")
    public suspend fun ipv4Prefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param values
     */
    @JvmName("cxnluhcifmstwxjd")
    public suspend fun ipv4Prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param value
     */
    @JvmName("rxbarrdgncnvebqh")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("knycxvxqjstuadjx")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values
     */
    @JvmName("lvirqvsywwridfsy")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value Name of the ENI. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-", ".", "_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    @JvmName("rmsgegnjnkkflehg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewgirbxlnnnwlhlb")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("otdkjggftwoobhyr")
    public suspend fun networkInterfaceTrafficMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceTrafficMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("hfspeqakmvisdlon")
    public suspend fun primaryIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpAddress = mapped
    }

    /**
     * @param value The primary private IP of the ENI.
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    @JvmName("phnkrosqqpycqisx")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvoeurhschdipixb")
    public suspend fun privateIpAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddresses = mapped
    }

    /**
     * @param values
     */
    @JvmName("qjjsvrletnomfpcn")
    public suspend fun privateIpAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIpAddresses = mapped
    }

    /**
     * @param value List of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("wvhmhgfpqbpbxewk")
    public suspend fun privateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIps = mapped
    }

    /**
     * @param values List of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("ujvelecxsidethbj")
    public suspend fun privateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIps = mapped
    }

    /**
     * @param value Number of secondary private IPs to assign to the ENI. Don't use both private_ips and private_ips_count in the same ENI resource block.
     */
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    @JvmName("vsflbptsdxiejrev")
    public suspend fun privateIpsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpsCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvdgfxahkkdwosep")
    public suspend fun queueNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueNumber = mapped
    }

    /**
     * @param value The Id of resource group which the network interface belongs.
     */
    @JvmName("brhqtxifheutnsyn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("yctklirwybcnaqlx")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddressCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("yjcumfepivwpuvil")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("guoohaulurdcdvhi")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of security group ids to associate with.
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("mnwhibyneytfkjge")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group ids to associate with.
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("pxhalvoliqkxvodn")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("proyqkbuvqovyrmr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("yyytodwxuridfhde")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VSwitch to create the ENI in.
     */
    @JvmName("vjtfyiorkqeiruvq")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        description = description,
        instanceType = instanceType,
        ipv4PrefixCount = ipv4PrefixCount,
        ipv4Prefixes = ipv4Prefixes,
        ipv6AddressCount = ipv6AddressCount,
        ipv6Addresses = ipv6Addresses,
        name = name,
        networkInterfaceName = networkInterfaceName,
        networkInterfaceTrafficMode = networkInterfaceTrafficMode,
        primaryIpAddress = primaryIpAddress,
        privateIp = privateIp,
        privateIpAddresses = privateIpAddresses,
        privateIps = privateIps,
        privateIpsCount = privateIpsCount,
        queueNumber = queueNumber,
        resourceGroupId = resourceGroupId,
        secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount,
        securityGroupIds = securityGroupIds,
        securityGroups = securityGroups,
        tags = tags,
        vswitchId = vswitchId,
    )
}
