@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkInterfaceAttachment].
 */
@PulumiTagMarker
public class NetworkInterfaceAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceAttachmentArgs = NetworkInterfaceAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceAttachmentArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkInterfaceAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.vpc.NetworkInterfaceAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkInterfaceAttachment(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsNetworkInterfaceAttachment from version 1.123.1.
 * Provides an Alicloud ECS Elastic Network Interface Attachment as a resource to attach ENI to or detach ENI from ECS Instances.
 * For information about Elastic Network Interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html).
 * ## Import
 * Network Interfaces Attachment resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/networkInterfaceAttachment:NetworkInterfaceAttachment eni eni-abc123456789000:i-abc123456789000
 * ```
 */
public class NetworkInterfaceAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.NetworkInterfaceAttachment,
) : KotlinCustomResource(javaResource, NetworkInterfaceAttachmentMapper) {
    /**
     * The instance ID to attach.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    public val networkCardIndex: Output<Int>?
        get() = javaResource.networkCardIndex().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ENI ID to attach.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    public val trunkNetworkInstanceId: Output<String>?
        get() = javaResource.trunkNetworkInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val waitForNetworkConfigurationReady: Output<Boolean>?
        get() = javaResource.waitForNetworkConfigurationReady().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NetworkInterfaceAttachmentMapper : ResourceMapper<NetworkInterfaceAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.NetworkInterfaceAttachment::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterfaceAttachment =
        NetworkInterfaceAttachment(javaResource as com.pulumi.alicloud.vpc.NetworkInterfaceAttachment)
}

/**
 * @see [NetworkInterfaceAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterfaceAttachment].
 */
public suspend fun networkInterfaceAttachment(
    name: String,
    block: suspend NetworkInterfaceAttachmentResourceBuilder.() -> Unit,
): NetworkInterfaceAttachment {
    val builder = NetworkInterfaceAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterfaceAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterfaceAttachment(name: String): NetworkInterfaceAttachment {
    val builder = NetworkInterfaceAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
