@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.NetworkInterfaceAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsNetworkInterfaceAttachment from version 1.123.1.
 * Provides an Alicloud ECS Elastic Network Interface Attachment as a resource to attach ENI to or detach ENI from ECS Instances.
 * For information about Elastic Network Interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html).
 * ## Import
 * Network Interfaces Attachment resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/networkInterfaceAttachment:NetworkInterfaceAttachment eni eni-abc123456789000:i-abc123456789000
 * ```
 * @property instanceId The instance ID to attach.
 * @property networkCardIndex
 * @property networkInterfaceId The ENI ID to attach.
 * @property trunkNetworkInstanceId
 * @property waitForNetworkConfigurationReady
 */
public data class NetworkInterfaceAttachmentArgs(
    public val instanceId: Output<String>? = null,
    public val networkCardIndex: Output<Int>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val trunkNetworkInstanceId: Output<String>? = null,
    public val waitForNetworkConfigurationReady: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.NetworkInterfaceAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.NetworkInterfaceAttachmentArgs =
        com.pulumi.alicloud.vpc.NetworkInterfaceAttachmentArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .networkCardIndex(networkCardIndex?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .trunkNetworkInstanceId(trunkNetworkInstanceId?.applyValue({ args0 -> args0 }))
            .waitForNetworkConfigurationReady(
                waitForNetworkConfigurationReady?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceAttachmentArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceAttachmentArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var networkCardIndex: Output<Int>? = null

    private var networkInterfaceId: Output<String>? = null

    private var trunkNetworkInstanceId: Output<String>? = null

    private var waitForNetworkConfigurationReady: Output<Boolean>? = null

    /**
     * @param value The instance ID to attach.
     */
    @JvmName("cvmogxkanumdgjwl")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value
     */
    @JvmName("bhkfkfvdsamkmewi")
    public suspend fun networkCardIndex(`value`: Output<Int>) {
        this.networkCardIndex = value
    }

    /**
     * @param value The ENI ID to attach.
     */
    @JvmName("fvmtcxxemidtteav")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value
     */
    @JvmName("psmdsudshwqoiblf")
    public suspend fun trunkNetworkInstanceId(`value`: Output<String>) {
        this.trunkNetworkInstanceId = value
    }

    /**
     * @param value
     */
    @JvmName("ehogdmmijtqmggnq")
    public suspend fun waitForNetworkConfigurationReady(`value`: Output<Boolean>) {
        this.waitForNetworkConfigurationReady = value
    }

    /**
     * @param value The instance ID to attach.
     */
    @JvmName("ymxxbpukcwffqjnx")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("pjeujlepytohyxpt")
    public suspend fun networkCardIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCardIndex = mapped
    }

    /**
     * @param value The ENI ID to attach.
     */
    @JvmName("mgqaakfsyxrpohbp")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("rcuksgpieuwxkehm")
    public suspend fun trunkNetworkInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trunkNetworkInstanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ugsrpvquejxqdrej")
    public suspend fun waitForNetworkConfigurationReady(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForNetworkConfigurationReady = mapped
    }

    internal fun build(): NetworkInterfaceAttachmentArgs = NetworkInterfaceAttachmentArgs(
        instanceId = instanceId,
        networkCardIndex = networkCardIndex,
        networkInterfaceId = networkInterfaceId,
        trunkNetworkInstanceId = trunkNetworkInstanceId,
        waitForNetworkConfigurationReady = waitForNetworkConfigurationReady,
    )
}
