@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PeerConnection].
 */
@PulumiTagMarker
public class PeerConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeerConnectionArgs = PeerConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeerConnectionArgsBuilder.() -> Unit) {
        val builder = PeerConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PeerConnection {
        val builtJavaResource = com.pulumi.alicloud.vpc.PeerConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PeerConnection(builtJavaResource)
    }
}

/**
 * Provides a VPC Peer Connection resource.
 * For information about VPC Peer Connection and how to use it, see [What is Peer Connection](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createvpcpeer).
 * > **NOTE:** Available since v1.186.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getAccount({});
 * const config = new pulumi.Config();
 * const acceptingRegion = config.get("acceptingRegion") || "cn-beijing";
 * const localVpc = new alicloud.vpc.Network("local_vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const acceptingVpc = new alicloud.vpc.Network("accepting_vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultPeerConnection = new alicloud.vpc.PeerConnection("default", {
 *     peerConnectionName: "terraform-example",
 *     vpcId: localVpc.id,
 *     acceptingAliUid: _default.then(_default => _default.id),
 *     acceptingRegionId: acceptingRegion,
 *     acceptingVpcId: acceptingVpc.id,
 *     description: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_account()
 * config = pulumi.Config()
 * accepting_region = config.get("acceptingRegion")
 * if accepting_region is None:
 *     accepting_region = "cn-beijing"
 * local_vpc = alicloud.vpc.Network("local_vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * accepting_vpc = alicloud.vpc.Network("accepting_vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_peer_connection = alicloud.vpc.PeerConnection("default",
 *     peer_connection_name="terraform-example",
 *     vpc_id=local_vpc.id,
 *     accepting_ali_uid=default.id,
 *     accepting_region_id=accepting_region,
 *     accepting_vpc_id=accepting_vpc.id,
 *     description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var config = new Config();
 *     var acceptingRegion = config.Get("acceptingRegion") ?? "cn-beijing";
 *     var localVpc = new AliCloud.Vpc.Network("local_vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var acceptingVpc = new AliCloud.Vpc.Network("accepting_vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultPeerConnection = new AliCloud.Vpc.PeerConnection("default", new()
 *     {
 *         PeerConnectionName = "terraform-example",
 *         VpcId = localVpc.Id,
 *         AcceptingAliUid = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         AcceptingRegionId = acceptingRegion,
 *         AcceptingVpcId = acceptingVpc.Id,
 *         Description = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		acceptingRegion := "cn-beijing"
 * 		if param := cfg.Get("acceptingRegion"); param != "" {
 * 			acceptingRegion = param
 * 		}
 * 		localVpc, err := vpc.NewNetwork(ctx, "local_vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		acceptingVpc, err := vpc.NewNetwork(ctx, "accepting_vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPeerConnection(ctx, "default", &vpc.PeerConnectionArgs{
 * 			PeerConnectionName: pulumi.String("terraform-example"),
 * 			VpcId:              localVpc.ID(),
 * 			AcceptingAliUid:    pulumi.String(_default.Id),
 * 			AcceptingRegionId:  pulumi.String(acceptingRegion),
 * 			AcceptingVpcId:     acceptingVpc.ID(),
 * 			Description:        pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.PeerConnection;
 * import com.pulumi.alicloud.vpc.PeerConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getAccount();
 *         final var acceptingRegion = config.get("acceptingRegion").orElse("cn-beijing");
 *         var localVpc = new Network("localVpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var acceptingVpc = new Network("acceptingVpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultPeerConnection = new PeerConnection("defaultPeerConnection", PeerConnectionArgs.builder()
 *             .peerConnectionName("terraform-example")
 *             .vpcId(localVpc.id())
 *             .acceptingAliUid(default_.id())
 *             .acceptingRegionId(acceptingRegion)
 *             .acceptingVpcId(acceptingVpc.id())
 *             .description("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   acceptingRegion:
 *     type: string
 *     default: cn-beijing
 * resources:
 *   localVpc:
 *     type: alicloud:vpc:Network
 *     name: local_vpc
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   acceptingVpc:
 *     type: alicloud:vpc:Network
 *     name: accepting_vpc
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultPeerConnection:
 *     type: alicloud:vpc:PeerConnection
 *     name: default
 *     properties:
 *       peerConnectionName: terraform-example
 *       vpcId: ${localVpc.id}
 *       acceptingAliUid: ${default.id}
 *       acceptingRegionId: ${acceptingRegion}
 *       acceptingVpcId: ${acceptingVpc.id}
 *       description: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Peer Connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/peerConnection:PeerConnection example <id>
 * ```
 */
public class PeerConnection internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.PeerConnection,
) : KotlinCustomResource(javaResource, PeerConnectionMapper) {
    /**
     * The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
     * - Enter the ID of your Alibaba Cloud account to create a peer-to-peer connection to the VPC account.
     * - Enter the ID of another Alibaba Cloud account to create a cross-account VPC peer-to-peer connection.
     * > **NOTE:**  If the recipient account is a RAM user (sub-account), enter the ID of the Alibaba Cloud account corresponding to the RAM user.
     */
    public val acceptingAliUid: Output<Int>?
        get() = javaResource.acceptingAliUid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region ID of the recipient of the VPC peering connection to be created.
     * - When creating a VPC peer-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.
     * - When creating a cross-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
     */
    public val acceptingRegionId: Output<String>
        get() = javaResource.acceptingRegionId().applyValue({ args0 -> args0 })

    /**
     * The VPC ID of the receiving end of the VPC peer connection.
     */
    public val acceptingVpcId: Output<String>
        get() = javaResource.acceptingVpcId().applyValue({ args0 -> args0 })

    /**
     * The bandwidth of the VPC peering connection to be modified. Unit: Mbps. The value range is an integer greater than 0.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The creation time of the VPC peer connection. Use UTC time in the format `YYYY-MM-DDThh:mm:ssZ`.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the VPC peer connection to be created.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to PreCheck only this request. Default value: `false`. Valid values:
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the VPC peer connection. The name of the resource. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    public val peerConnectionName: Output<String>?
        get() = javaResource.peerConnectionName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the VPC peer connection.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the requester VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object PeerConnectionMapper : ResourceMapper<PeerConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.PeerConnection::class == javaResource::class

    override fun map(javaResource: Resource): PeerConnection = PeerConnection(
        javaResource as
            com.pulumi.alicloud.vpc.PeerConnection,
    )
}

/**
 * @see [PeerConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeerConnection].
 */
public suspend fun peerConnection(
    name: String,
    block: suspend PeerConnectionResourceBuilder.() -> Unit,
): PeerConnection {
    val builder = PeerConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeerConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun peerConnection(name: String): PeerConnection {
    val builder = PeerConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
