@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.PeerConnectionAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Vpc Peer Connection Accepter resource.
 * For information about Vpc Peer Connection Accepter and how to use it, see [What is Peer Connection Accepter](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpcpeer-2022-01-01-acceptvpcpeerconnection).
 * > **NOTE:** Available since v1.196.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const acceptingRegion = config.get("acceptingRegion") || "cn-beijing";
 * const anotherUid = config.get("anotherUid") || "xxxx";
 * const local = new alicloud.vpc.Network("local", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const acceptingNetwork = new alicloud.vpc.Network("accepting", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const accepting = alicloud.getAccount({});
 * const _default = new alicloud.vpc.PeerConnection("default", {
 *     peerConnectionName: name,
 *     vpcId: local.id,
 *     acceptingAliUid: accepting.then(accepting => accepting.id),
 *     acceptingRegionId: acceptingRegion,
 *     acceptingVpcId: acceptingNetwork.id,
 *     description: name,
 * });
 * const defaultPeerConnectionAccepter = new alicloud.vpc.PeerConnectionAccepter("default", {instanceId: _default.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * accepting_region = config.get("acceptingRegion")
 * if accepting_region is None:
 *     accepting_region = "cn-beijing"
 * another_uid = config.get("anotherUid")
 * if another_uid is None:
 *     another_uid = "xxxx"
 * local = alicloud.vpc.Network("local",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * accepting_network = alicloud.vpc.Network("accepting",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * accepting = alicloud.get_account()
 * default = alicloud.vpc.PeerConnection("default",
 *     peer_connection_name=name,
 *     vpc_id=local.id,
 *     accepting_ali_uid=accepting.id,
 *     accepting_region_id=accepting_region,
 *     accepting_vpc_id=accepting_network.id,
 *     description=name)
 * default_peer_connection_accepter = alicloud.vpc.PeerConnectionAccepter("default", instance_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var acceptingRegion = config.Get("acceptingRegion") ?? "cn-beijing";
 *     var anotherUid = config.Get("anotherUid") ?? "xxxx";
 *     var local = new AliCloud.Vpc.Network("local", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var acceptingNetwork = new AliCloud.Vpc.Network("accepting", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var accepting = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.Vpc.PeerConnection("default", new()
 *     {
 *         PeerConnectionName = name,
 *         VpcId = local.Id,
 *         AcceptingAliUid = accepting.Apply(getAccountResult => getAccountResult.Id),
 *         AcceptingRegionId = acceptingRegion,
 *         AcceptingVpcId = acceptingNetwork.Id,
 *         Description = name,
 *     });
 *     var defaultPeerConnectionAccepter = new AliCloud.Vpc.PeerConnectionAccepter("default", new()
 *     {
 *         InstanceId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		acceptingRegion := "cn-beijing"
 * 		if param := cfg.Get("acceptingRegion"); param != "" {
 * 			acceptingRegion = param
 * 		}
 * 		anotherUid := "xxxx"
 * 		if param := cfg.Get("anotherUid"); param != "" {
 * 			anotherUid = param
 * 		}
 * 		local, err := vpc.NewNetwork(ctx, "local", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		acceptingNetwork, err := vpc.NewNetwork(ctx, "accepting", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		accepting, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPeerConnection(ctx, "default", &vpc.PeerConnectionArgs{
 * 			PeerConnectionName: pulumi.String(name),
 * 			VpcId:              local.ID(),
 * 			AcceptingAliUid:    pulumi.String(accepting.Id),
 * 			AcceptingRegionId:  pulumi.String(acceptingRegion),
 * 			AcceptingVpcId:     acceptingNetwork.ID(),
 * 			Description:        pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPeerConnectionAccepter(ctx, "default", &vpc.PeerConnectionAccepterArgs{
 * 			InstanceId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.vpc.PeerConnection;
 * import com.pulumi.alicloud.vpc.PeerConnectionArgs;
 * import com.pulumi.alicloud.vpc.PeerConnectionAccepter;
 * import com.pulumi.alicloud.vpc.PeerConnectionAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var acceptingRegion = config.get("acceptingRegion").orElse("cn-beijing");
 *         final var anotherUid = config.get("anotherUid").orElse("xxxx");
 *         var local = new Network("local", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var acceptingNetwork = new Network("acceptingNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         final var accepting = AlicloudFunctions.getAccount();
 *         var default_ = new PeerConnection("default", PeerConnectionArgs.builder()
 *             .peerConnectionName(name)
 *             .vpcId(local.id())
 *             .acceptingAliUid(accepting.applyValue(getAccountResult -> getAccountResult.id()))
 *             .acceptingRegionId(acceptingRegion)
 *             .acceptingVpcId(acceptingNetwork.id())
 *             .description(name)
 *             .build());
 *         var defaultPeerConnectionAccepter = new PeerConnectionAccepter("defaultPeerConnectionAccepter", PeerConnectionAccepterArgs.builder()
 *             .instanceId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   acceptingRegion:
 *     type: string
 *     default: cn-beijing
 *   anotherUid:
 *     type: string
 *     default: xxxx
 * resources:
 *   local:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   acceptingNetwork:
 *     type: alicloud:vpc:Network
 *     name: accepting
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   default:
 *     type: alicloud:vpc:PeerConnection
 *     properties:
 *       peerConnectionName: ${name}
 *       vpcId: ${local.id}
 *       acceptingAliUid: ${accepting.id}
 *       acceptingRegionId: ${acceptingRegion}
 *       acceptingVpcId: ${acceptingNetwork.id}
 *       description: ${name}
 *   defaultPeerConnectionAccepter:
 *     type: alicloud:vpc:PeerConnectionAccepter
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 * variables:
 *   accepting:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Peer Connection Accepter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/peerConnectionAccepter:PeerConnectionAccepter example <id>
 * ```
 * @property dryRun The dry run.
 * @property instanceId The ID of the instance of the created VPC peer connection.
 */
public data class PeerConnectionAccepterArgs(
    public val dryRun: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.PeerConnectionAccepterArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.PeerConnectionAccepterArgs =
        com.pulumi.alicloud.vpc.PeerConnectionAccepterArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeerConnectionAccepterArgs].
 */
@PulumiTagMarker
public class PeerConnectionAccepterArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value The dry run.
     */
    @JvmName("lrvwjlssohicerbs")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the instance of the created VPC peer connection.
     */
    @JvmName("hlfepygmqeswnqea")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("fbxrabcissdipdcs")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the instance of the created VPC peer connection.
     */
    @JvmName("xcnjdohpqwfipeal")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): PeerConnectionAccepterArgs = PeerConnectionAccepterArgs(
        dryRun = dryRun,
        instanceId = instanceId,
    )
}
