@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.PeerConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Peer Connection resource.
 * For information about VPC Peer Connection and how to use it, see [What is Peer Connection](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createvpcpeer).
 * > **NOTE:** Available since v1.186.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getAccount({});
 * const config = new pulumi.Config();
 * const acceptingRegion = config.get("acceptingRegion") || "cn-beijing";
 * const localVpc = new alicloud.vpc.Network("local_vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const acceptingVpc = new alicloud.vpc.Network("accepting_vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultPeerConnection = new alicloud.vpc.PeerConnection("default", {
 *     peerConnectionName: "terraform-example",
 *     vpcId: localVpc.id,
 *     acceptingAliUid: _default.then(_default => _default.id),
 *     acceptingRegionId: acceptingRegion,
 *     acceptingVpcId: acceptingVpc.id,
 *     description: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_account()
 * config = pulumi.Config()
 * accepting_region = config.get("acceptingRegion")
 * if accepting_region is None:
 *     accepting_region = "cn-beijing"
 * local_vpc = alicloud.vpc.Network("local_vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * accepting_vpc = alicloud.vpc.Network("accepting_vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_peer_connection = alicloud.vpc.PeerConnection("default",
 *     peer_connection_name="terraform-example",
 *     vpc_id=local_vpc.id,
 *     accepting_ali_uid=default.id,
 *     accepting_region_id=accepting_region,
 *     accepting_vpc_id=accepting_vpc.id,
 *     description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var config = new Config();
 *     var acceptingRegion = config.Get("acceptingRegion") ?? "cn-beijing";
 *     var localVpc = new AliCloud.Vpc.Network("local_vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var acceptingVpc = new AliCloud.Vpc.Network("accepting_vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultPeerConnection = new AliCloud.Vpc.PeerConnection("default", new()
 *     {
 *         PeerConnectionName = "terraform-example",
 *         VpcId = localVpc.Id,
 *         AcceptingAliUid = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         AcceptingRegionId = acceptingRegion,
 *         AcceptingVpcId = acceptingVpc.Id,
 *         Description = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		acceptingRegion := "cn-beijing"
 * 		if param := cfg.Get("acceptingRegion"); param != "" {
 * 			acceptingRegion = param
 * 		}
 * 		localVpc, err := vpc.NewNetwork(ctx, "local_vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		acceptingVpc, err := vpc.NewNetwork(ctx, "accepting_vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPeerConnection(ctx, "default", &vpc.PeerConnectionArgs{
 * 			PeerConnectionName: pulumi.String("terraform-example"),
 * 			VpcId:              localVpc.ID(),
 * 			AcceptingAliUid:    pulumi.String(_default.Id),
 * 			AcceptingRegionId:  pulumi.String(acceptingRegion),
 * 			AcceptingVpcId:     acceptingVpc.ID(),
 * 			Description:        pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.PeerConnection;
 * import com.pulumi.alicloud.vpc.PeerConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getAccount();
 *         final var acceptingRegion = config.get("acceptingRegion").orElse("cn-beijing");
 *         var localVpc = new Network("localVpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var acceptingVpc = new Network("acceptingVpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultPeerConnection = new PeerConnection("defaultPeerConnection", PeerConnectionArgs.builder()
 *             .peerConnectionName("terraform-example")
 *             .vpcId(localVpc.id())
 *             .acceptingAliUid(default_.id())
 *             .acceptingRegionId(acceptingRegion)
 *             .acceptingVpcId(acceptingVpc.id())
 *             .description("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   acceptingRegion:
 *     type: string
 *     default: cn-beijing
 * resources:
 *   localVpc:
 *     type: alicloud:vpc:Network
 *     name: local_vpc
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   acceptingVpc:
 *     type: alicloud:vpc:Network
 *     name: accepting_vpc
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultPeerConnection:
 *     type: alicloud:vpc:PeerConnection
 *     name: default
 *     properties:
 *       peerConnectionName: terraform-example
 *       vpcId: ${localVpc.id}
 *       acceptingAliUid: ${default.id}
 *       acceptingRegionId: ${acceptingRegion}
 *       acceptingVpcId: ${acceptingVpc.id}
 *       description: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Peer Connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/peerConnection:PeerConnection example <id>
 * ```
 * @property acceptingAliUid The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
 * - Enter the ID of your Alibaba Cloud account to create a peer-to-peer connection to the VPC account.
 * - Enter the ID of another Alibaba Cloud account to create a cross-account VPC peer-to-peer connection.
 * > **NOTE:**  If the recipient account is a RAM user (sub-account), enter the ID of the Alibaba Cloud account corresponding to the RAM user.
 * @property acceptingRegionId The region ID of the recipient of the VPC peering connection to be created.
 * - When creating a VPC peer-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.
 * - When creating a cross-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
 * @property acceptingVpcId The VPC ID of the receiving end of the VPC peer connection.
 * @property bandwidth The bandwidth of the VPC peering connection to be modified. Unit: Mbps. The value range is an integer greater than 0.
 * @property description The description of the VPC peer connection to be created.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
 * @property dryRun Whether to PreCheck only this request. Default value: `false`. Valid values:
 * @property peerConnectionName The name of the VPC peer connection. The name of the resource. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the VPC peer connection.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the requester VPC.
 */
public data class PeerConnectionArgs(
    public val acceptingAliUid: Output<Int>? = null,
    public val acceptingRegionId: Output<String>? = null,
    public val acceptingVpcId: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val peerConnectionName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.PeerConnectionArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.PeerConnectionArgs =
        com.pulumi.alicloud.vpc.PeerConnectionArgs.builder()
            .acceptingAliUid(acceptingAliUid?.applyValue({ args0 -> args0 }))
            .acceptingRegionId(acceptingRegionId?.applyValue({ args0 -> args0 }))
            .acceptingVpcId(acceptingVpcId?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .peerConnectionName(peerConnectionName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeerConnectionArgs].
 */
@PulumiTagMarker
public class PeerConnectionArgsBuilder internal constructor() {
    private var acceptingAliUid: Output<Int>? = null

    private var acceptingRegionId: Output<String>? = null

    private var acceptingVpcId: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var peerConnectionName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
     * - Enter the ID of your Alibaba Cloud account to create a peer-to-peer connection to the VPC account.
     * - Enter the ID of another Alibaba Cloud account to create a cross-account VPC peer-to-peer connection.
     * > **NOTE:**  If the recipient account is a RAM user (sub-account), enter the ID of the Alibaba Cloud account corresponding to the RAM user.
     */
    @JvmName("qhyqepqjbcxxwlnn")
    public suspend fun acceptingAliUid(`value`: Output<Int>) {
        this.acceptingAliUid = value
    }

    /**
     * @param value The region ID of the recipient of the VPC peering connection to be created.
     * - When creating a VPC peer-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.
     * - When creating a cross-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
     */
    @JvmName("mrxicicgfgdtyvgt")
    public suspend fun acceptingRegionId(`value`: Output<String>) {
        this.acceptingRegionId = value
    }

    /**
     * @param value The VPC ID of the receiving end of the VPC peer connection.
     */
    @JvmName("jimxqjgbwkjhkgbb")
    public suspend fun acceptingVpcId(`value`: Output<String>) {
        this.acceptingVpcId = value
    }

    /**
     * @param value The bandwidth of the VPC peering connection to be modified. Unit: Mbps. The value range is an integer greater than 0.
     */
    @JvmName("bwuafdhnqmphgdyp")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The description of the VPC peer connection to be created.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("jrregailrnfcxcin")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to PreCheck only this request. Default value: `false`. Valid values:
     */
    @JvmName("jasnsfhgxymufhdb")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The name of the VPC peer connection. The name of the resource. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    @JvmName("oeqcaoqojsliglap")
    public suspend fun peerConnectionName(`value`: Output<String>) {
        this.peerConnectionName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("jkhfdqlyeqnuvsea")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The status of the VPC peer connection.
     */
    @JvmName("xvaoxstbugammxma")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("qrfxtbsrcfokikrp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the requester VPC.
     */
    @JvmName("dfdvxbuptfmyxxgr")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
     * - Enter the ID of your Alibaba Cloud account to create a peer-to-peer connection to the VPC account.
     * - Enter the ID of another Alibaba Cloud account to create a cross-account VPC peer-to-peer connection.
     * > **NOTE:**  If the recipient account is a RAM user (sub-account), enter the ID of the Alibaba Cloud account corresponding to the RAM user.
     */
    @JvmName("clmwedhmhmbxydbn")
    public suspend fun acceptingAliUid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptingAliUid = mapped
    }

    /**
     * @param value The region ID of the recipient of the VPC peering connection to be created.
     * - When creating a VPC peer-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.
     * - When creating a cross-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
     */
    @JvmName("avdpdwtiknkjhuwa")
    public suspend fun acceptingRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptingRegionId = mapped
    }

    /**
     * @param value The VPC ID of the receiving end of the VPC peer connection.
     */
    @JvmName("xnrwmgbilpvpqfgl")
    public suspend fun acceptingVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptingVpcId = mapped
    }

    /**
     * @param value The bandwidth of the VPC peering connection to be modified. Unit: Mbps. The value range is an integer greater than 0.
     */
    @JvmName("idfjnhfebhxfxuun")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The description of the VPC peer connection to be created.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("smrailjxgbujfnrv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to PreCheck only this request. Default value: `false`. Valid values:
     */
    @JvmName("hmsaimqpxjdajrls")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The name of the VPC peer connection. The name of the resource. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    @JvmName("dfxuaxqoxejpuphu")
    public suspend fun peerConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerConnectionName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("pyuwkfpkderhxtdg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the VPC peer connection.
     */
    @JvmName("didwgrudcjpvtevc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jyvnyackxjmwkvih")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("kjwswdpswwqcgjng")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the requester VPC.
     */
    @JvmName("apaapsolhxxdjgum")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): PeerConnectionArgs = PeerConnectionArgs(
        acceptingAliUid = acceptingAliUid,
        acceptingRegionId = acceptingRegionId,
        acceptingVpcId = acceptingVpcId,
        bandwidth = bandwidth,
        description = description,
        dryRun = dryRun,
        peerConnectionName = peerConnectionName,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        vpcId = vpcId,
    )
}
