@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.kotlin.outputs.PrefixListEntry
import com.pulumi.alicloud.vpc.kotlin.outputs.PrefixListPrefixListAssociation
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.vpc.kotlin.outputs.PrefixListEntry.Companion.toKotlin as prefixListEntryToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.PrefixListPrefixListAssociation.Companion.toKotlin as prefixListPrefixListAssociationToKotlin

/**
 * Builder for [PrefixList].
 */
@PulumiTagMarker
public class PrefixListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrefixListArgs = PrefixListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrefixListArgsBuilder.() -> Unit) {
        val builder = PrefixListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrefixList {
        val builtJavaResource = com.pulumi.alicloud.vpc.PrefixList(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrefixList(builtJavaResource)
    }
}

/**
 * Provides a Vpc Prefix List resource. This resource is used to create a prefix list.
 * For information about Vpc Prefix List and how to use it, see [What is Prefix List](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/creatvpcprefixlist).
 * > **NOTE:** Available in v1.182.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-testacc-chenyi",
 *     resourceGroupName: name,
 * });
 * const changeRg = new alicloud.resourcemanager.ResourceGroup("changeRg", {
 *     displayName: "tf-testacc-chenyi-change",
 *     resourceGroupName: `${name}1`,
 * });
 * const _default = new alicloud.vpc.PrefixList("default", {
 *     maxEntries: 50,
 *     resourceGroupId: defaultRg.id,
 *     prefixListDescription: "test",
 *     ipVersion: "IPV4",
 *     prefixListName: name,
 *     entrys: [{
 *         cidr: "192.168.0.0/16",
 *         description: "test",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-testacc-chenyi",
 *     resource_group_name=name)
 * change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
 *     display_name="tf-testacc-chenyi-change",
 *     resource_group_name=f"{name}1")
 * default = alicloud.vpc.PrefixList("default",
 *     max_entries=50,
 *     resource_group_id=default_rg.id,
 *     prefix_list_description="test",
 *     ip_version="IPV4",
 *     prefix_list_name=name,
 *     entrys=[{
 *         "cidr": "192.168.0.0/16",
 *         "description": "test",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-testacc-chenyi",
 *         ResourceGroupName = name,
 *     });
 *     var changeRg = new AliCloud.ResourceManager.ResourceGroup("changeRg", new()
 *     {
 *         DisplayName = "tf-testacc-chenyi-change",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var @default = new AliCloud.Vpc.PrefixList("default", new()
 *     {
 *         MaxEntries = 50,
 *         ResourceGroupId = defaultRg.Id,
 *         PrefixListDescription = "test",
 *         IpVersion = "IPV4",
 *         PrefixListName = name,
 *         Entrys = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.PrefixListEntryArgs
 *             {
 *                 Cidr = "192.168.0.0/16",
 *                 Description = "test",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-chenyi"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "changeRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-chenyi-change"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPrefixList(ctx, "default", &vpc.PrefixListArgs{
 * 			MaxEntries:            pulumi.Int(50),
 * 			ResourceGroupId:       defaultRg.ID(),
 * 			PrefixListDescription: pulumi.String("test"),
 * 			IpVersion:             pulumi.String("IPV4"),
 * 			PrefixListName:        pulumi.String(name),
 * 			Entrys: vpc.PrefixListEntryArray{
 * 				&vpc.PrefixListEntryArgs{
 * 					Cidr:        pulumi.String("192.168.0.0/16"),
 * 					Description: pulumi.String("test"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.PrefixList;
 * import com.pulumi.alicloud.vpc.PrefixListArgs;
 * import com.pulumi.alicloud.vpc.inputs.PrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-chenyi")
 *             .resourceGroupName(name)
 *             .build());
 *         var changeRg = new ResourceGroup("changeRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-chenyi-change")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var default_ = new PrefixList("default", PrefixListArgs.builder()
 *             .maxEntries(50)
 *             .resourceGroupId(defaultRg.id())
 *             .prefixListDescription("test")
 *             .ipVersion("IPV4")
 *             .prefixListName(name)
 *             .entrys(PrefixListEntryArgs.builder()
 *                 .cidr("192.168.0.0/16")
 *                 .description("test")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-chenyi
 *       resourceGroupName: ${name}
 *   changeRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-chenyi-change
 *       resourceGroupName: ${name}1
 *   default:
 *     type: alicloud:vpc:PrefixList
 *     properties:
 *       maxEntries: 50
 *       resourceGroupId: ${defaultRg.id}
 *       prefixListDescription: test
 *       ipVersion: IPV4
 *       prefixListName: ${name}
 *       entrys:
 *         - cidr: 192.168.0.0/16
 *           description: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Prefix List can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/prefixList:PrefixList example <id>
 * ```
 */
public class PrefixList internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.PrefixList,
) : KotlinCustomResource(javaResource, PrefixListMapper) {
    /**
     * The time when the prefix list was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    public val entrys: Output<List<PrefixListEntry>>?
        get() = javaResource.entrys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> prefixListEntryToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The IP version of the prefix list. Value:-**IPV4**:IPv4 version.-**IPV6**:IPv6 version.
     */
    public val ipVersion: Output<String>
        get() = javaResource.ipVersion().applyValue({ args0 -> args0 })

    /**
     * The maximum number of entries for CIDR address blocks in the prefix list.
     */
    public val maxEntries: Output<Int>
        get() = javaResource.maxEntries().applyValue({ args0 -> args0 })

    /**
     * The association list information of the prefix list.
     */
    public val prefixListAssociations: Output<List<PrefixListPrefixListAssociation>>
        get() = javaResource.prefixListAssociations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> prefixListPrefixListAssociationToKotlin(args0) })
            })
        })

    /**
     * The description of the prefix list.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    public val prefixListDescription: Output<String>?
        get() = javaResource.prefixListDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the query Prefix List.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })

    /**
     * The name of the prefix list. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
     */
    public val prefixListName: Output<String>?
        get() = javaResource.prefixListName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which the PrefixList belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The share type of the prefix list. Value:-**Shared**: indicates that the prefix list is a Shared prefix list.-Null: indicates that the prefix list is not a shared prefix list.
     */
    public val shareType: Output<String>
        get() = javaResource.shareType().applyValue({ args0 -> args0 })

    /**
     * Resource attribute fields that represent the status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of PrefixList.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object PrefixListMapper : ResourceMapper<PrefixList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.PrefixList::class == javaResource::class

    override fun map(javaResource: Resource): PrefixList = PrefixList(
        javaResource as
            com.pulumi.alicloud.vpc.PrefixList,
    )
}

/**
 * @see [PrefixList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrefixList].
 */
public suspend fun prefixList(name: String, block: suspend PrefixListResourceBuilder.() -> Unit): PrefixList {
    val builder = PrefixListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrefixList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prefixList(name: String): PrefixList {
    val builder = PrefixListResourceBuilder()
    builder.name(name)
    return builder.build()
}
