@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.PrefixListArgs.builder
import com.pulumi.alicloud.vpc.kotlin.inputs.PrefixListEntryArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.PrefixListEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Vpc Prefix List resource. This resource is used to create a prefix list.
 * For information about Vpc Prefix List and how to use it, see [What is Prefix List](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/creatvpcprefixlist).
 * > **NOTE:** Available in v1.182.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-testacc-chenyi",
 *     resourceGroupName: name,
 * });
 * const changeRg = new alicloud.resourcemanager.ResourceGroup("changeRg", {
 *     displayName: "tf-testacc-chenyi-change",
 *     resourceGroupName: `${name}1`,
 * });
 * const _default = new alicloud.vpc.PrefixList("default", {
 *     maxEntries: 50,
 *     resourceGroupId: defaultRg.id,
 *     prefixListDescription: "test",
 *     ipVersion: "IPV4",
 *     prefixListName: name,
 *     entrys: [{
 *         cidr: "192.168.0.0/16",
 *         description: "test",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-testacc-chenyi",
 *     resource_group_name=name)
 * change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
 *     display_name="tf-testacc-chenyi-change",
 *     resource_group_name=f"{name}1")
 * default = alicloud.vpc.PrefixList("default",
 *     max_entries=50,
 *     resource_group_id=default_rg.id,
 *     prefix_list_description="test",
 *     ip_version="IPV4",
 *     prefix_list_name=name,
 *     entrys=[{
 *         "cidr": "192.168.0.0/16",
 *         "description": "test",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-testacc-chenyi",
 *         ResourceGroupName = name,
 *     });
 *     var changeRg = new AliCloud.ResourceManager.ResourceGroup("changeRg", new()
 *     {
 *         DisplayName = "tf-testacc-chenyi-change",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var @default = new AliCloud.Vpc.PrefixList("default", new()
 *     {
 *         MaxEntries = 50,
 *         ResourceGroupId = defaultRg.Id,
 *         PrefixListDescription = "test",
 *         IpVersion = "IPV4",
 *         PrefixListName = name,
 *         Entrys = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.PrefixListEntryArgs
 *             {
 *                 Cidr = "192.168.0.0/16",
 *                 Description = "test",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-chenyi"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "changeRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-chenyi-change"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPrefixList(ctx, "default", &vpc.PrefixListArgs{
 * 			MaxEntries:            pulumi.Int(50),
 * 			ResourceGroupId:       defaultRg.ID(),
 * 			PrefixListDescription: pulumi.String("test"),
 * 			IpVersion:             pulumi.String("IPV4"),
 * 			PrefixListName:        pulumi.String(name),
 * 			Entrys: vpc.PrefixListEntryArray{
 * 				&vpc.PrefixListEntryArgs{
 * 					Cidr:        pulumi.String("192.168.0.0/16"),
 * 					Description: pulumi.String("test"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.PrefixList;
 * import com.pulumi.alicloud.vpc.PrefixListArgs;
 * import com.pulumi.alicloud.vpc.inputs.PrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-chenyi")
 *             .resourceGroupName(name)
 *             .build());
 *         var changeRg = new ResourceGroup("changeRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-chenyi-change")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var default_ = new PrefixList("default", PrefixListArgs.builder()
 *             .maxEntries(50)
 *             .resourceGroupId(defaultRg.id())
 *             .prefixListDescription("test")
 *             .ipVersion("IPV4")
 *             .prefixListName(name)
 *             .entrys(PrefixListEntryArgs.builder()
 *                 .cidr("192.168.0.0/16")
 *                 .description("test")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-chenyi
 *       resourceGroupName: ${name}
 *   changeRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-chenyi-change
 *       resourceGroupName: ${name}1
 *   default:
 *     type: alicloud:vpc:PrefixList
 *     properties:
 *       maxEntries: 50
 *       resourceGroupId: ${defaultRg.id}
 *       prefixListDescription: test
 *       ipVersion: IPV4
 *       prefixListName: ${name}
 *       entrys:
 *         - cidr: 192.168.0.0/16
 *           description: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Prefix List can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/prefixList:PrefixList example <id>
 * ```
 * @property entrys The CIDR address block list of the prefix list.See the following `Block Entrys`.
 * @property ipVersion The IP version of the prefix list. Value:-**IPV4**:IPv4 version.-**IPV6**:IPv6 version.
 * @property maxEntries The maximum number of entries for CIDR address blocks in the prefix list.
 * @property prefixListDescription The description of the prefix list.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
 * @property prefixListName The name of the prefix list. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
 * @property resourceGroupId The ID of the resource group to which the PrefixList belongs.
 * @property tags The tags of PrefixList.
 */
public data class PrefixListArgs(
    public val entrys: Output<List<PrefixListEntryArgs>>? = null,
    public val ipVersion: Output<String>? = null,
    public val maxEntries: Output<Int>? = null,
    public val prefixListDescription: Output<String>? = null,
    public val prefixListName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.PrefixListArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.PrefixListArgs =
        com.pulumi.alicloud.vpc.PrefixListArgs.builder()
            .entrys(entrys?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
            .maxEntries(maxEntries?.applyValue({ args0 -> args0 }))
            .prefixListDescription(prefixListDescription?.applyValue({ args0 -> args0 }))
            .prefixListName(prefixListName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrefixListArgs].
 */
@PulumiTagMarker
public class PrefixListArgsBuilder internal constructor() {
    private var entrys: Output<List<PrefixListEntryArgs>>? = null

    private var ipVersion: Output<String>? = null

    private var maxEntries: Output<Int>? = null

    private var prefixListDescription: Output<String>? = null

    private var prefixListName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("wlribeyrepwjgxxh")
    public suspend fun entrys(`value`: Output<List<PrefixListEntryArgs>>) {
        this.entrys = value
    }

    @JvmName("odkhpcafsljolniy")
    public suspend fun entrys(vararg values: Output<PrefixListEntryArgs>) {
        this.entrys = Output.all(values.asList())
    }

    /**
     * @param values The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("hpsckfqeclosnufi")
    public suspend fun entrys(values: List<Output<PrefixListEntryArgs>>) {
        this.entrys = Output.all(values)
    }

    /**
     * @param value The IP version of the prefix list. Value:-**IPV4**:IPv4 version.-**IPV6**:IPv6 version.
     */
    @JvmName("titnfkievqnumubh")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value The maximum number of entries for CIDR address blocks in the prefix list.
     */
    @JvmName("kddtwvxxxgtuhnmj")
    public suspend fun maxEntries(`value`: Output<Int>) {
        this.maxEntries = value
    }

    /**
     * @param value The description of the prefix list.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("pyiglauchpbbykwl")
    public suspend fun prefixListDescription(`value`: Output<String>) {
        this.prefixListDescription = value
    }

    /**
     * @param value The name of the prefix list. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("cxyepndsatvaymkl")
    public suspend fun prefixListName(`value`: Output<String>) {
        this.prefixListName = value
    }

    /**
     * @param value The ID of the resource group to which the PrefixList belongs.
     */
    @JvmName("wshrbmadjjvrbwtl")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tags of PrefixList.
     */
    @JvmName("qstoekaxdnsqwwov")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("ysutepteixypnhfy")
    public suspend fun entrys(`value`: List<PrefixListEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entrys = mapped
    }

    /**
     * @param argument The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("xbcjmbxvycwboasr")
    public suspend fun entrys(argument: List<suspend PrefixListEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrefixListEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.entrys = mapped
    }

    /**
     * @param argument The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("crnbgognckrhddof")
    public suspend fun entrys(vararg argument: suspend PrefixListEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrefixListEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.entrys = mapped
    }

    /**
     * @param argument The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("vvynqlvbsarolljf")
    public suspend fun entrys(argument: suspend PrefixListEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrefixListEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.entrys = mapped
    }

    /**
     * @param values The CIDR address block list of the prefix list.See the following `Block Entrys`.
     */
    @JvmName("edummtfamuwirwdi")
    public suspend fun entrys(vararg values: PrefixListEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entrys = mapped
    }

    /**
     * @param value The IP version of the prefix list. Value:-**IPV4**:IPv4 version.-**IPV6**:IPv6 version.
     */
    @JvmName("nopuglyyptuxxtqx")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value The maximum number of entries for CIDR address blocks in the prefix list.
     */
    @JvmName("fsjhmyxmoixpbsfo")
    public suspend fun maxEntries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEntries = mapped
    }

    /**
     * @param value The description of the prefix list.It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("gcsehoycbejsmapg")
    public suspend fun prefixListDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListDescription = mapped
    }

    /**
     * @param value The name of the prefix list. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("fqkmhqihdlslwwcd")
    public suspend fun prefixListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListName = mapped
    }

    /**
     * @param value The ID of the resource group to which the PrefixList belongs.
     */
    @JvmName("hogofkdjmcjontyg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tags of PrefixList.
     */
    @JvmName("dyrthdojxnjfdjak")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of PrefixList.
     */
    @JvmName("ydeexhabdqkrsnsn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrefixListArgs = PrefixListArgs(
        entrys = entrys,
        ipVersion = ipVersion,
        maxEntries = maxEntries,
        prefixListDescription = prefixListDescription,
        prefixListName = prefixListName,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
