@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PublicIpAddressPool].
 */
@PulumiTagMarker
public class PublicIpAddressPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublicIpAddressPoolArgs = PublicIpAddressPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublicIpAddressPoolArgsBuilder.() -> Unit) {
        val builder = PublicIpAddressPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PublicIpAddressPool {
        val builtJavaResource = com.pulumi.alicloud.vpc.PublicIpAddressPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PublicIpAddressPool(builtJavaResource)
    }
}

/**
 * Provides a VPC Public Ip Address Pool resource.
 * For information about VPC Public Ip Address Pool and how to use it, see [What is Public Ip Address Pool](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createpublicipaddresspool).
 * > **NOTE:** Available since v1.186.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultPublicIpAddressPool = new alicloud.vpc.PublicIpAddressPool("default", {
 *     description: name,
 *     publicIpAddressPoolName: name,
 *     isp: "BGP",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("default",
 *     description=name,
 *     public_ip_address_pool_name=name,
 *     isp="BGP",
 *     resource_group_id=default.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultPublicIpAddressPool = new AliCloud.Vpc.PublicIpAddressPool("default", new()
 *     {
 *         Description = name,
 *         PublicIpAddressPoolName = name,
 *         Isp = "BGP",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPublicIpAddressPool(ctx, "default", &vpc.PublicIpAddressPoolArgs{
 * 			Description:             pulumi.String(name),
 * 			PublicIpAddressPoolName: pulumi.String(name),
 * 			Isp:                     pulumi.String("BGP"),
 * 			ResourceGroupId:         pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPool;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultPublicIpAddressPool = new PublicIpAddressPool("defaultPublicIpAddressPool", PublicIpAddressPoolArgs.builder()
 *             .description(name)
 *             .publicIpAddressPoolName(name)
 *             .isp("BGP")
 *             .resourceGroupId(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultPublicIpAddressPool:
 *     type: alicloud:vpc:PublicIpAddressPool
 *     name: default
 *     properties:
 *       description: ${name}
 *       publicIpAddressPoolName: ${name}
 *       isp: BGP
 *       resourceGroupId: ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Public Ip Address Pool can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/publicIpAddressPool:PublicIpAddressPool example <id>
 * ```
 */
public class PublicIpAddressPool internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.PublicIpAddressPool,
) : KotlinCustomResource(javaResource, PublicIpAddressPoolMapper) {
    /**
     * The name of the VPC Public IP address pool.
     */
    public val bizType: Output<String>
        get() = javaResource.bizType().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether there is a free IP address.
     */
    public val ipAddressRemaining: Output<Boolean>
        get() = javaResource.ipAddressRemaining().applyValue({ args0 -> args0 })

    /**
     * The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
     */
    public val isp: Output<String>
        get() = javaResource.isp().applyValue({ args0 -> args0 })

    public val publicIpAddressPoolId: Output<String>
        get() = javaResource.publicIpAddressPoolId().applyValue({ args0 -> args0 })

    /**
     * The name of the VPC Public IP address pool.
     */
    public val publicIpAddressPoolName: Output<String>?
        get() = javaResource.publicIpAddressPoolName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource group ID of the VPC Public IP address pool.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Security protection level.
     * - If the configuration is empty, the default value is DDoS protection (Basic edition).
     * - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
     */
    public val securityProtectionTypes: Output<List<String>>?
        get() = javaResource.securityProtectionTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The status of the VPC Public IP address pool.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of PrefixList.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The total number of public IP address pools.
     */
    public val totalIpNum: Output<Int>
        get() = javaResource.totalIpNum().applyValue({ args0 -> args0 })

    /**
     * The number of used IP addresses in the public IP address pool.
     */
    public val usedIpNum: Output<Int>
        get() = javaResource.usedIpNum().applyValue({ args0 -> args0 })
}

public object PublicIpAddressPoolMapper : ResourceMapper<PublicIpAddressPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.PublicIpAddressPool::class == javaResource::class

    override fun map(javaResource: Resource): PublicIpAddressPool = PublicIpAddressPool(
        javaResource
            as com.pulumi.alicloud.vpc.PublicIpAddressPool,
    )
}

/**
 * @see [PublicIpAddressPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublicIpAddressPool].
 */
public suspend fun publicIpAddressPool(
    name: String,
    block: suspend PublicIpAddressPoolResourceBuilder.() -> Unit,
): PublicIpAddressPool {
    val builder = PublicIpAddressPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublicIpAddressPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publicIpAddressPool(name: String): PublicIpAddressPool {
    val builder = PublicIpAddressPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
