@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Public Ip Address Pool resource.
 * For information about VPC Public Ip Address Pool and how to use it, see [What is Public Ip Address Pool](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createpublicipaddresspool).
 * > **NOTE:** Available since v1.186.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultPublicIpAddressPool = new alicloud.vpc.PublicIpAddressPool("default", {
 *     description: name,
 *     publicIpAddressPoolName: name,
 *     isp: "BGP",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("default",
 *     description=name,
 *     public_ip_address_pool_name=name,
 *     isp="BGP",
 *     resource_group_id=default.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultPublicIpAddressPool = new AliCloud.Vpc.PublicIpAddressPool("default", new()
 *     {
 *         Description = name,
 *         PublicIpAddressPoolName = name,
 *         Isp = "BGP",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPublicIpAddressPool(ctx, "default", &vpc.PublicIpAddressPoolArgs{
 * 			Description:             pulumi.String(name),
 * 			PublicIpAddressPoolName: pulumi.String(name),
 * 			Isp:                     pulumi.String("BGP"),
 * 			ResourceGroupId:         pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPool;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultPublicIpAddressPool = new PublicIpAddressPool("defaultPublicIpAddressPool", PublicIpAddressPoolArgs.builder()
 *             .description(name)
 *             .publicIpAddressPoolName(name)
 *             .isp("BGP")
 *             .resourceGroupId(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultPublicIpAddressPool:
 *     type: alicloud:vpc:PublicIpAddressPool
 *     name: default
 *     properties:
 *       description: ${name}
 *       publicIpAddressPoolName: ${name}
 *       isp: BGP
 *       resourceGroupId: ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Public Ip Address Pool can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/publicIpAddressPool:PublicIpAddressPool example <id>
 * ```
 * @property bizType The name of the VPC Public IP address pool.
 * @property description Description.
 * @property isp The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
 * @property publicIpAddressPoolName The name of the VPC Public IP address pool.
 * @property resourceGroupId The resource group ID of the VPC Public IP address pool.
 * @property securityProtectionTypes Security protection level.
 * - If the configuration is empty, the default value is DDoS protection (Basic edition).
 * - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
 * @property tags The tags of PrefixList.
 */
public data class PublicIpAddressPoolArgs(
    public val bizType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val isp: Output<String>? = null,
    public val publicIpAddressPoolName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityProtectionTypes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs =
        com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs.builder()
            .bizType(bizType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isp(isp?.applyValue({ args0 -> args0 }))
            .publicIpAddressPoolName(publicIpAddressPoolName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityProtectionTypes(
                securityProtectionTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PublicIpAddressPoolArgs].
 */
@PulumiTagMarker
public class PublicIpAddressPoolArgsBuilder internal constructor() {
    private var bizType: Output<String>? = null

    private var description: Output<String>? = null

    private var isp: Output<String>? = null

    private var publicIpAddressPoolName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityProtectionTypes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the VPC Public IP address pool.
     */
    @JvmName("akwuhugvkrpjgook")
    public suspend fun bizType(`value`: Output<String>) {
        this.bizType = value
    }

    /**
     * @param value Description.
     */
    @JvmName("dwgkihlbdjthqitp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
     */
    @JvmName("sqqrjrxceyfgmicq")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value The name of the VPC Public IP address pool.
     */
    @JvmName("pvpejvsljrcqcxud")
    public suspend fun publicIpAddressPoolName(`value`: Output<String>) {
        this.publicIpAddressPoolName = value
    }

    /**
     * @param value The resource group ID of the VPC Public IP address pool.
     */
    @JvmName("gxkoffntfcwfswaq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Security protection level.
     * - If the configuration is empty, the default value is DDoS protection (Basic edition).
     * - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
     */
    @JvmName("devtgasxfojjatbk")
    public suspend fun securityProtectionTypes(`value`: Output<List<String>>) {
        this.securityProtectionTypes = value
    }

    @JvmName("isweuumvvvuadhdn")
    public suspend fun securityProtectionTypes(vararg values: Output<String>) {
        this.securityProtectionTypes = Output.all(values.asList())
    }

    /**
     * @param values Security protection level.
     * - If the configuration is empty, the default value is DDoS protection (Basic edition).
     * - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
     */
    @JvmName("skfenpvlnuiialxx")
    public suspend fun securityProtectionTypes(values: List<Output<String>>) {
        this.securityProtectionTypes = Output.all(values)
    }

    /**
     * @param value The tags of PrefixList.
     */
    @JvmName("tbwulorsdudpajuv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the VPC Public IP address pool.
     */
    @JvmName("vrsolaosuhnummxp")
    public suspend fun bizType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizType = mapped
    }

    /**
     * @param value Description.
     */
    @JvmName("decbellciogffiai")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
     */
    @JvmName("rupsxhbiucvavbid")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    /**
     * @param value The name of the VPC Public IP address pool.
     */
    @JvmName("mqmoogxvenrmfraf")
    public suspend fun publicIpAddressPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressPoolName = mapped
    }

    /**
     * @param value The resource group ID of the VPC Public IP address pool.
     */
    @JvmName("ussoojxlfhwgcwde")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Security protection level.
     * - If the configuration is empty, the default value is DDoS protection (Basic edition).
     * - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
     */
    @JvmName("aroqjbngiejclrag")
    public suspend fun securityProtectionTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param values Security protection level.
     * - If the configuration is empty, the default value is DDoS protection (Basic edition).
     * - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
     */
    @JvmName("xcidlclmkgyjqpls")
    public suspend fun securityProtectionTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param value The tags of PrefixList.
     */
    @JvmName("yeiyxfsufcjufeor")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of PrefixList.
     */
    @JvmName("hneivwsrqkbfxlwr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PublicIpAddressPoolArgs = PublicIpAddressPoolArgs(
        bizType = bizType,
        description = description,
        isp = isp,
        publicIpAddressPoolName = publicIpAddressPoolName,
        resourceGroupId = resourceGroupId,
        securityProtectionTypes = securityProtectionTypes,
        tags = tags,
    )
}
