@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.PublicIpAddressPoolCidrBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Public Ip Address Pool Cidr Block resource.
 * > **NOTE:** Only users who have the required permissions can use the IP address pool feature of Elastic IP Address (EIP). To apply for the required permissions, [submit a ticket](https://smartservice.console.aliyun.com/service/create-ticket).
 * For information about VPC Public Ip Address Pool Cidr Block and how to use it, see [What is Public Ip Address Pool Cidr Block](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/429100).
 * > **NOTE:** Available since v1.189.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultPublicIpAddressPool = new alicloud.vpc.PublicIpAddressPool("default", {
 *     description: name,
 *     publicIpAddressPoolName: name,
 *     isp: "BGP",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 * });
 * const defaultPublicIpAddressPoolCidrBlock = new alicloud.vpc.PublicIpAddressPoolCidrBlock("default", {
 *     publicIpAddressPoolId: defaultPublicIpAddressPool.id,
 *     cidrBlock: "47.118.126.0/25",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("default",
 *     description=name,
 *     public_ip_address_pool_name=name,
 *     isp="BGP",
 *     resource_group_id=default.ids[0])
 * default_public_ip_address_pool_cidr_block = alicloud.vpc.PublicIpAddressPoolCidrBlock("default",
 *     public_ip_address_pool_id=default_public_ip_address_pool.id,
 *     cidr_block="47.118.126.0/25")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultPublicIpAddressPool = new AliCloud.Vpc.PublicIpAddressPool("default", new()
 *     {
 *         Description = name,
 *         PublicIpAddressPoolName = name,
 *         Isp = "BGP",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *     });
 *     var defaultPublicIpAddressPoolCidrBlock = new AliCloud.Vpc.PublicIpAddressPoolCidrBlock("default", new()
 *     {
 *         PublicIpAddressPoolId = defaultPublicIpAddressPool.Id,
 *         CidrBlock = "47.118.126.0/25",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultPublicIpAddressPool, err := vpc.NewPublicIpAddressPool(ctx, "default", &vpc.PublicIpAddressPoolArgs{
 * 			Description:             pulumi.String(name),
 * 			PublicIpAddressPoolName: pulumi.String(name),
 * 			Isp:                     pulumi.String("BGP"),
 * 			ResourceGroupId:         pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewPublicIpAddressPoolCidrBlock(ctx, "default", &vpc.PublicIpAddressPoolCidrBlockArgs{
 * 			PublicIpAddressPoolId: defaultPublicIpAddressPool.ID(),
 * 			CidrBlock:             pulumi.String("47.118.126.0/25"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPool;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPoolArgs;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPoolCidrBlock;
 * import com.pulumi.alicloud.vpc.PublicIpAddressPoolCidrBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultPublicIpAddressPool = new PublicIpAddressPool("defaultPublicIpAddressPool", PublicIpAddressPoolArgs.builder()
 *             .description(name)
 *             .publicIpAddressPoolName(name)
 *             .isp("BGP")
 *             .resourceGroupId(default_.ids()[0])
 *             .build());
 *         var defaultPublicIpAddressPoolCidrBlock = new PublicIpAddressPoolCidrBlock("defaultPublicIpAddressPoolCidrBlock", PublicIpAddressPoolCidrBlockArgs.builder()
 *             .publicIpAddressPoolId(defaultPublicIpAddressPool.id())
 *             .cidrBlock("47.118.126.0/25")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultPublicIpAddressPool:
 *     type: alicloud:vpc:PublicIpAddressPool
 *     name: default
 *     properties:
 *       description: ${name}
 *       publicIpAddressPoolName: ${name}
 *       isp: BGP
 *       resourceGroupId: ${default.ids[0]}
 *   defaultPublicIpAddressPoolCidrBlock:
 *     type: alicloud:vpc:PublicIpAddressPoolCidrBlock
 *     name: default
 *     properties:
 *       publicIpAddressPoolId: ${defaultPublicIpAddressPool.id}
 *       cidrBlock: 47.118.126.0/25
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Public Ip Address Pool Cidr Block can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/publicIpAddressPoolCidrBlock:PublicIpAddressPoolCidrBlock example <public_ip_address_pool_id>:<cidr_block>
 * ```
 * @property cidrBlock The CIDR block.
 * @property cidrMask IP address and network segment mask. After you enter the mask, the system automatically allocates the IP address network segment. Value range: **24** to **28**.
 * > **NOTE:**  **CidrBlock** and **CidrMask** cannot be configured at the same time. Select one of them to configure.
 * @property publicIpAddressPoolId The ID of the VPC Public IP address pool.
 */
public data class PublicIpAddressPoolCidrBlockArgs(
    public val cidrBlock: Output<String>? = null,
    public val cidrMask: Output<Int>? = null,
    public val publicIpAddressPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.PublicIpAddressPoolCidrBlockArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.PublicIpAddressPoolCidrBlockArgs =
        com.pulumi.alicloud.vpc.PublicIpAddressPoolCidrBlockArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .cidrMask(cidrMask?.applyValue({ args0 -> args0 }))
            .publicIpAddressPoolId(publicIpAddressPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublicIpAddressPoolCidrBlockArgs].
 */
@PulumiTagMarker
public class PublicIpAddressPoolCidrBlockArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var cidrMask: Output<Int>? = null

    private var publicIpAddressPoolId: Output<String>? = null

    /**
     * @param value The CIDR block.
     */
    @JvmName("wgjhkqxcifnwmonp")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value IP address and network segment mask. After you enter the mask, the system automatically allocates the IP address network segment. Value range: **24** to **28**.
     * > **NOTE:**  **CidrBlock** and **CidrMask** cannot be configured at the same time. Select one of them to configure.
     */
    @JvmName("ahijhvruoxitfsie")
    public suspend fun cidrMask(`value`: Output<Int>) {
        this.cidrMask = value
    }

    /**
     * @param value The ID of the VPC Public IP address pool.
     */
    @JvmName("leslmjpsmpjnvtoj")
    public suspend fun publicIpAddressPoolId(`value`: Output<String>) {
        this.publicIpAddressPoolId = value
    }

    /**
     * @param value The CIDR block.
     */
    @JvmName("vxgicnkwhcmwrsfu")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value IP address and network segment mask. After you enter the mask, the system automatically allocates the IP address network segment. Value range: **24** to **28**.
     * > **NOTE:**  **CidrBlock** and **CidrMask** cannot be configured at the same time. Select one of them to configure.
     */
    @JvmName("xgjgixvmurbveylm")
    public suspend fun cidrMask(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrMask = mapped
    }

    /**
     * @param value The ID of the VPC Public IP address pool.
     */
    @JvmName("ypsbwjhtynspxpcp")
    public suspend fun publicIpAddressPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressPoolId = mapped
    }

    internal fun build(): PublicIpAddressPoolCidrBlockArgs = PublicIpAddressPoolCidrBlockArgs(
        cidrBlock = cidrBlock,
        cidrMask = cidrMask,
        publicIpAddressPoolId = publicIpAddressPoolId,
    )
}
