@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouteEntry].
 */
@PulumiTagMarker
public class RouteEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteEntryArgs = RouteEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteEntryArgsBuilder.() -> Unit) {
        val builder = RouteEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteEntry {
        val builtJavaResource = com.pulumi.alicloud.vpc.RouteEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteEntry(builtJavaResource)
    }
}

/**
 * Provides a route entry resource. A route entry represents a route item of one VPC route table.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const config = new pulumi.Config();
 * const name = config.get("name") || "RouteEntryConfig";
 * const foo = new alicloud.vpc.Network("foo", {
 *     vpcName: name,
 *     cidrBlock: "10.1.0.0/21",
 * });
 * const fooSwitch = new alicloud.vpc.Switch("foo", {
 *     vpcId: foo.id,
 *     cidrBlock: "10.1.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const tfTestFoo = new alicloud.ecs.SecurityGroup("tf_test_foo", {
 *     name: name,
 *     description: "foo",
 *     vpcId: foo.id,
 * });
 * const ingress = new alicloud.ecs.SecurityGroupRule("ingress", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: tfTestFoo.id,
 *     cidrIp: "0.0.0.0/0",
 * });
 * const fooInstance = new alicloud.ecs.Instance("foo", {
 *     securityGroups: [tfTestFoo&#46;id],
 *     vswitchId: fooSwitch.id,
 *     instanceChargeType: "PostPaid",
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     internetChargeType: "PayByTraffic",
 *     internetMaxBandwidthOut: 5,
 *     systemDiskCategory: "cloud_efficiency",
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceName: name,
 * });
 * const fooRouteEntry = new alicloud.vpc.RouteEntry("foo", {
 *     routeTableId: foo.routeTableId,
 *     destinationCidrblock: "172.11.1.1/32",
 *     nexthopType: "Instance",
 *     nexthopId: fooInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "RouteEntryConfig"
 * foo = alicloud.vpc.Network("foo",
 *     vpc_name=name,
 *     cidr_block="10.1.0.0/21")
 * foo_switch = alicloud.vpc.Switch("foo",
 *     vpc_id=foo.id,
 *     cidr_block="10.1.1.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * tf_test_foo = alicloud.ecs.SecurityGroup("tf_test_foo",
 *     name=name,
 *     description="foo",
 *     vpc_id=foo.id)
 * ingress = alicloud.ecs.SecurityGroupRule("ingress",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=tf_test_foo.id,
 *     cidr_ip="0.0.0.0/0")
 * foo_instance = alicloud.ecs.Instance("foo",
 *     security_groups=[tf_test_foo&#46;id],
 *     vswitch_id=foo_switch.id,
 *     instance_charge_type="PostPaid",
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     internet_charge_type="PayByTraffic",
 *     internet_max_bandwidth_out=5,
 *     system_disk_category="cloud_efficiency",
 *     image_id=default_get_images.images[0].id,
 *     instance_name=name)
 * foo_route_entry = alicloud.vpc.RouteEntry("foo",
 *     route_table_id=foo.route_table_id,
 *     destination_cidrblock="172.11.1.1/32",
 *     nexthop_type="Instance",
 *     nexthop_id=foo_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var config = new Config();
 *     var name = config.Get("name") ?? "RouteEntryConfig";
 *     var foo = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.1.0.0/21",
 *     });
 *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
 *     {
 *         VpcId = foo.Id,
 *         CidrBlock = "10.1.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var tfTestFoo = new AliCloud.Ecs.SecurityGroup("tf_test_foo", new()
 *     {
 *         Name = name,
 *         Description = "foo",
 *         VpcId = foo.Id,
 *     });
 *     var ingress = new AliCloud.Ecs.SecurityGroupRule("ingress", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = tfTestFoo.Id,
 *         CidrIp = "0.0.0.0/0",
 *     });
 *     var fooInstance = new AliCloud.Ecs.Instance("foo", new()
 *     {
 *         SecurityGroups = new[]
 *         {
 *             tfTestFoo.Id,
 *         },
 *         VswitchId = fooSwitch.Id,
 *         InstanceChargeType = "PostPaid",
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         InternetChargeType = "PayByTraffic",
 *         InternetMaxBandwidthOut = 5,
 *         SystemDiskCategory = "cloud_efficiency",
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceName = name,
 *     });
 *     var fooRouteEntry = new AliCloud.Vpc.RouteEntry("foo", new()
 *     {
 *         RouteTableId = foo.RouteTableId,
 *         DestinationCidrblock = "172.11.1.1/32",
 *         NexthopType = "Instance",
 *         NexthopId = fooInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(1),
 * 			MemorySize:       pulumi.Float64Ref(2),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		name := "RouteEntryConfig"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		foo, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.1.0.0/21"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooSwitch, err := vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
 * 			VpcId:       foo.ID(),
 * 			CidrBlock:   pulumi.String("10.1.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tfTestFoo, err := ecs.NewSecurityGroup(ctx, "tf_test_foo", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String("foo"),
 * 			VpcId:       foo.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "ingress", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: tfTestFoo.ID(),
 * 			CidrIp:          pulumi.String("0.0.0.0/0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooInstance, err := ecs.NewInstance(ctx, "foo", &ecs.InstanceArgs{
 * 			SecurityGroups: pulumi.StringArray{
 * 				tfTestFoo.ID(),
 * 			},
 * 			VswitchId:               fooSwitch.ID(),
 * 			InstanceChargeType:      pulumi.String("PostPaid"),
 * 			InstanceType:            pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			InternetChargeType:      pulumi.String("PayByTraffic"),
 * 			InternetMaxBandwidthOut: pulumi.Int(5),
 * 			SystemDiskCategory:      pulumi.String("cloud_efficiency"),
 * 			ImageId:                 pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceName:            pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewRouteEntry(ctx, "foo", &vpc.RouteEntryArgs{
 * 			RouteTableId:         foo.RouteTableId,
 * 			DestinationCidrblock: pulumi.String("172.11.1.1/32"),
 * 			NexthopType:          pulumi.String("Instance"),
 * 			NexthopId:            fooInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.vpc.RouteEntry;
 * import com.pulumi.alicloud.vpc.RouteEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         final var name = config.get("name").orElse("RouteEntryConfig");
 *         var foo = new Network("foo", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
 *             .vpcId(foo.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var tfTestFoo = new SecurityGroup("tfTestFoo", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description("foo")
 *             .vpcId(foo.id())
 *             .build());
 *         var ingress = new SecurityGroupRule("ingress", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(tfTestFoo.id())
 *             .cidrIp("0.0.0.0/0")
 *             .build());
 *         var fooInstance = new Instance("fooInstance", InstanceArgs.builder()
 *             .securityGroups(tfTestFoo.id())
 *             .vswitchId(fooSwitch.id())
 *             .instanceChargeType("PostPaid")
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .internetChargeType("PayByTraffic")
 *             .internetMaxBandwidthOut(5)
 *             .systemDiskCategory("cloud_efficiency")
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceName(name)
 *             .build());
 *         var fooRouteEntry = new RouteEntry("fooRouteEntry", RouteEntryArgs.builder()
 *             .routeTableId(foo.routeTableId())
 *             .destinationCidrblock("172.11.1.1/32")
 *             .nexthopType("Instance")
 *             .nexthopId(fooInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: RouteEntryConfig
 * resources:
 *   foo:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.1.0.0/21
 *   fooSwitch:
 *     type: alicloud:vpc:Switch
 *     name: foo
 *     properties:
 *       vpcId: ${foo.id}
 *       cidrBlock: 10.1.1.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   tfTestFoo:
 *     type: alicloud:ecs:SecurityGroup
 *     name: tf_test_foo
 *     properties:
 *       name: ${name}
 *       description: foo
 *       vpcId: ${foo.id}
 *   ingress:
 *     type: alicloud:ecs:SecurityGroupRule
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${tfTestFoo.id}
 *       cidrIp: 0.0.0.0/0
 *   fooInstance:
 *     type: alicloud:ecs:Instance
 *     name: foo
 *     properties:
 *       securityGroups:
 *         - ${tfTestFoo.id}
 *       vswitchId: ${fooSwitch.id}
 *       instanceChargeType: PostPaid
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       internetChargeType: PayByTraffic
 *       internetMaxBandwidthOut: 5
 *       systemDiskCategory: cloud_efficiency
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceName: ${name}
 *   fooRouteEntry:
 *     type: alicloud:vpc:RouteEntry
 *     name: foo
 *     properties:
 *       routeTableId: ${foo.routeTableId}
 *       destinationCidrblock: 172.11.1.1/32
 *       nexthopType: Instance
 *       nexthopId: ${fooInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 1
 *         memorySize: 2
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing vpc module
 * to create a VPC, several VSwitches and add several route entries one-click.
 * ## Import
 * Router entry can be imported using the id, e.g (formatted as<route_table_id:router_id:destination_cidrblock:nexthop_type:nexthop_id>).
 * ```sh
 * $ pulumi import alicloud:vpc/routeEntry:RouteEntry example vtb-123456:vrt-123456:0.0.0.0/0:NatGateway:ngw-123456
 * ```
 */
public class RouteEntry internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.RouteEntry,
) : KotlinCustomResource(javaResource, RouteEntryMapper) {
    /**
     * The RouteEntry's target network segment.
     */
    public val destinationCidrblock: Output<String>?
        get() = javaResource.destinationCidrblock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the route entry. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The route entry's next hop. ECS instance ID or VPC router interface ID.
     */
    public val nexthopId: Output<String>?
        get() = javaResource.nexthopId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The next hop type. Available values:
     * - `Instance` (Default): an Elastic Compute Service (ECS) instance. This is the default value.
     * - `RouterInterface`: a router interface.
     * - `VpnGateway`: a VPN Gateway.
     * - `HaVip`: a high-availability virtual IP address (HAVIP).
     * - `NetworkInterface`: an elastic network interface (ENI).
     * - `NatGateway`: a Nat Gateway.
     * - `IPv6Gateway`: an IPv6 gateway.
     * - `Attachment`: a transit router.
     * - `VpcPeer`: a VPC Peering Connection.
     * - `Ipv4Gateway`  (Available in 1.193.0+): an IPv4 gateway.
     */
    public val nexthopType: Output<String>?
        get() = javaResource.nexthopType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the route table.
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * This argument has been deprecated. Please use other arguments to launch a custom route entry.
     */
    @Deprecated(
        message = """
  Attribute router_id has been deprecated and suggest removing it from your template.
  """,
    )
    public val routerId: Output<String>
        get() = javaResource.routerId().applyValue({ args0 -> args0 })
}

public object RouteEntryMapper : ResourceMapper<RouteEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.RouteEntry::class == javaResource::class

    override fun map(javaResource: Resource): RouteEntry = RouteEntry(
        javaResource as
            com.pulumi.alicloud.vpc.RouteEntry,
    )
}

/**
 * @see [RouteEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteEntry].
 */
public suspend fun routeEntry(name: String, block: suspend RouteEntryResourceBuilder.() -> Unit): RouteEntry {
    val builder = RouteEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeEntry(name: String): RouteEntry {
    val builder = RouteEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
