@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RouteTable].
 */
@PulumiTagMarker
public class RouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteTableArgs = RouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteTableArgsBuilder.() -> Unit) {
        val builder = RouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteTable {
        val builtJavaResource = com.pulumi.alicloud.vpc.RouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteTable(builtJavaResource)
    }
}

/**
 * Provides a VPC Route Table resource. Currently, customized route tables are available in most regions apart from China (Beijing), China (Hangzhou), and China (Shenzhen) regions.
 * For information about VPC Route Table and how to use it, see [What is Route Table](https://www.alibabacloud.com/help/doc-detail/87057.htm).
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {vpcName: name});
 * const _default = new alicloud.vpc.RouteTable("default", {
 *     description: "test-description",
 *     vpcId: defaultVpc.id,
 *     routeTableName: name,
 *     associateType: "VSwitch",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_vpc = alicloud.vpc.Network("defaultVpc", vpc_name=name)
 * default = alicloud.vpc.RouteTable("default",
 *     description="test-description",
 *     vpc_id=default_vpc.id,
 *     route_table_name=name,
 *     associate_type="VSwitch")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         VpcName = name,
 *     });
 *     var @default = new AliCloud.Vpc.RouteTable("default", new()
 *     {
 *         Description = "test-description",
 *         VpcId = defaultVpc.Id,
 *         RouteTableName = name,
 *         AssociateType = "VSwitch",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			VpcName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewRouteTable(ctx, "default", &vpc.RouteTableArgs{
 * 			Description:    pulumi.String("test-description"),
 * 			VpcId:          defaultVpc.ID(),
 * 			RouteTableName: pulumi.String(name),
 * 			AssociateType:  pulumi.String("VSwitch"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.RouteTable;
 * import com.pulumi.alicloud.vpc.RouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .build());
 *         var default_ = new RouteTable("default", RouteTableArgs.builder()
 *             .description("test-description")
 *             .vpcId(defaultVpc.id())
 *             .routeTableName(name)
 *             .associateType("VSwitch")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *   default:
 *     type: alicloud:vpc:RouteTable
 *     properties:
 *       description: test-description
 *       vpcId: ${defaultVpc.id}
 *       routeTableName: ${name}
 *       associateType: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Route Table can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/routeTable:RouteTable example <id>
 * ```
 */
public class RouteTable internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.RouteTable,
) : KotlinCustomResource(javaResource, RouteTableMapper) {
    /**
     * The type of cloud resource that is bound to the routing table. Value:
     * - **VSwitch**: switch.
     * - **Gateway**:IPv4 Gateway.
     */
    public val associateType: Output<String>
        get() = javaResource.associateType().applyValue({ args0 -> args0 })

    /**
     * The creation time of the routing table.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of the routing table.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource group ID.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the routing table.
     */
    public val routeTableName: Output<String>
        get() = javaResource.routeTableName().applyValue({ args0 -> args0 })

    /**
     * Routing table state.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of VPC.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object RouteTableMapper : ResourceMapper<RouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.RouteTable::class == javaResource::class

    override fun map(javaResource: Resource): RouteTable = RouteTable(
        javaResource as
            com.pulumi.alicloud.vpc.RouteTable,
    )
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteTable].
 */
public suspend fun routeTable(name: String, block: suspend RouteTableResourceBuilder.() -> Unit): RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeTable(name: String): RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
