@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.RouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Route Table resource. Currently, customized route tables are available in most regions apart from China (Beijing), China (Hangzhou), and China (Shenzhen) regions.
 * For information about VPC Route Table and how to use it, see [What is Route Table](https://www.alibabacloud.com/help/doc-detail/87057.htm).
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {vpcName: name});
 * const _default = new alicloud.vpc.RouteTable("default", {
 *     description: "test-description",
 *     vpcId: defaultVpc.id,
 *     routeTableName: name,
 *     associateType: "VSwitch",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_vpc = alicloud.vpc.Network("defaultVpc", vpc_name=name)
 * default = alicloud.vpc.RouteTable("default",
 *     description="test-description",
 *     vpc_id=default_vpc.id,
 *     route_table_name=name,
 *     associate_type="VSwitch")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         VpcName = name,
 *     });
 *     var @default = new AliCloud.Vpc.RouteTable("default", new()
 *     {
 *         Description = "test-description",
 *         VpcId = defaultVpc.Id,
 *         RouteTableName = name,
 *         AssociateType = "VSwitch",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			VpcName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewRouteTable(ctx, "default", &vpc.RouteTableArgs{
 * 			Description:    pulumi.String("test-description"),
 * 			VpcId:          defaultVpc.ID(),
 * 			RouteTableName: pulumi.String(name),
 * 			AssociateType:  pulumi.String("VSwitch"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.RouteTable;
 * import com.pulumi.alicloud.vpc.RouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .build());
 *         var default_ = new RouteTable("default", RouteTableArgs.builder()
 *             .description("test-description")
 *             .vpcId(defaultVpc.id())
 *             .routeTableName(name)
 *             .associateType("VSwitch")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *   default:
 *     type: alicloud:vpc:RouteTable
 *     properties:
 *       description: test-description
 *       vpcId: ${defaultVpc.id}
 *       routeTableName: ${name}
 *       associateType: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Route Table can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/routeTable:RouteTable example <id>
 * ```
 * @property associateType The type of cloud resource that is bound to the routing table. Value:
 * - **VSwitch**: switch.
 * - **Gateway**:IPv4 Gateway.
 * @property description Description of the routing table.
 * @property name Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
 * @property routeTableName The name of the routing table.
 * @property tags The tag.
 * @property vpcId The ID of VPC.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class RouteTableArgs(
    public val associateType: Output<String>? = null,
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val routeTableName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.RouteTableArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.RouteTableArgs =
        com.pulumi.alicloud.vpc.RouteTableArgs.builder()
            .associateType(associateType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routeTableName(routeTableName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTableArgs].
 */
@PulumiTagMarker
public class RouteTableArgsBuilder internal constructor() {
    private var associateType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var routeTableName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The type of cloud resource that is bound to the routing table. Value:
     * - **VSwitch**: switch.
     * - **Gateway**:IPv4 Gateway.
     */
    @JvmName("genaomvjjabcmyji")
    public suspend fun associateType(`value`: Output<String>) {
        this.associateType = value
    }

    /**
     * @param value Description of the routing table.
     */
    @JvmName("ynjkwpeyacwkcjov")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name'
      instead.
  """,
    )
    @JvmName("ptdypviufgurgdpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the routing table.
     */
    @JvmName("hhgnrtgeeoqqmdvy")
    public suspend fun routeTableName(`value`: Output<String>) {
        this.routeTableName = value
    }

    /**
     * @param value The tag.
     */
    @JvmName("acjuwtidgyboyfnj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of VPC.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("gnhdetnavisymnyl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The type of cloud resource that is bound to the routing table. Value:
     * - **VSwitch**: switch.
     * - **Gateway**:IPv4 Gateway.
     */
    @JvmName("usixwqqkoycnbpom")
    public suspend fun associateType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associateType = mapped
    }

    /**
     * @param value Description of the routing table.
     */
    @JvmName("tckthdftcdriqdvv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name'
      instead.
  """,
    )
    @JvmName("srmkmjluygedmiwb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the routing table.
     */
    @JvmName("pkancyajvwryaexu")
    public suspend fun routeTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableName = mapped
    }

    /**
     * @param value The tag.
     */
    @JvmName("qorgswhgjqwkmiay")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag.
     */
    @JvmName("tvgyfccfiijdhmug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of VPC.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("ivnkgrpklakknjyi")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): RouteTableArgs = RouteTableArgs(
        associateType = associateType,
        description = description,
        name = name,
        routeTableName = routeTableName,
        tags = tags,
        vpcId = vpcId,
    )
}
