@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouterInterface].
 */
@PulumiTagMarker
public class RouterInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouterInterfaceArgs = RouterInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouterInterfaceArgsBuilder.() -> Unit) {
        val builder = RouterInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouterInterface {
        val builtJavaResource = com.pulumi.alicloud.vpc.RouterInterface(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouterInterface(builtJavaResource)
    }
}

/**
 * Provides a VPC router interface resource aim to build a connection between two VPCs.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.
 * > **NOTE:** Only one pair of connected router interfaces can exist between two routers. Up to 5 router interfaces can be created for each router and each account.
 * > **NOTE:** The router interface is not connected when it is created. It can be connected by means of resource alicloud_router_interface_connection.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.vpc.Network("foo", {
 *     vpcName: "tf_test_foo12345",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const _interface = new alicloud.vpc.RouterInterface("interface", {
 *     oppositeRegion: "cn-beijing",
 *     routerType: "VRouter",
 *     routerId: foo.routerId,
 *     role: "InitiatingSide",
 *     specification: "Large.2",
 *     name: "test1",
 *     description: "test1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.vpc.Network("foo",
 *     vpc_name="tf_test_foo12345",
 *     cidr_block="172.16.0.0/12")
 * interface = alicloud.vpc.RouterInterface("interface",
 *     opposite_region="cn-beijing",
 *     router_type="VRouter",
 *     router_id=foo.router_id,
 *     role="InitiatingSide",
 *     specification="Large.2",
 *     name="test1",
 *     description="test1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = "tf_test_foo12345",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var @interface = new AliCloud.Vpc.RouterInterface("interface", new()
 *     {
 *         OppositeRegion = "cn-beijing",
 *         RouterType = "VRouter",
 *         RouterId = foo.RouterId,
 *         Role = "InitiatingSide",
 *         Specification = "Large.2",
 *         Name = "test1",
 *         Description = "test1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_test_foo12345"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewRouterInterface(ctx, "interface", &vpc.RouterInterfaceArgs{
 * 			OppositeRegion: pulumi.String("cn-beijing"),
 * 			RouterType:     pulumi.String("VRouter"),
 * 			RouterId:       foo.RouterId,
 * 			Role:           pulumi.String("InitiatingSide"),
 * 			Specification:  pulumi.String("Large.2"),
 * 			Name:           pulumi.String("test1"),
 * 			Description:    pulumi.String("test1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.RouterInterface;
 * import com.pulumi.alicloud.vpc.RouterInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Network("foo", NetworkArgs.builder()
 *             .vpcName("tf_test_foo12345")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var interface_ = new RouterInterface("interface", RouterInterfaceArgs.builder()
 *             .oppositeRegion("cn-beijing")
 *             .routerType("VRouter")
 *             .routerId(foo.routerId())
 *             .role("InitiatingSide")
 *             .specification("Large.2")
 *             .name("test1")
 *             .description("test1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_test_foo12345
 *       cidrBlock: 172.16.0.0/12
 *   interface:
 *     type: alicloud:vpc:RouterInterface
 *     properties:
 *       oppositeRegion: cn-beijing
 *       routerType: VRouter
 *       routerId: ${foo.routerId}
 *       role: InitiatingSide
 *       specification: Large.2
 *       name: test1
 *       description: test1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The router interface can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/routerInterface:RouterInterface interface ri-abc123456
 * ```
 */
public class RouterInterface internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.RouterInterface,
) : KotlinCustomResource(javaResource, RouterInterfaceMapper) {
    /**
     * It has been deprecated from version 1.11.0.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.
  """,
    )
    public val accessPointId: Output<String>
        get() = javaResource.accessPointId().applyValue({ args0 -> args0 })

    /**
     * Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
     */
    public val healthCheckSourceIp: Output<String>?
        get() = javaResource.healthCheckSourceIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
     */
    public val healthCheckTargetIp: Output<String>?
        get() = javaResource.healthCheckTargetIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
     * If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.11.0.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.
  """,
    )
    public val oppositeAccessPointId: Output<String>?
        get() = javaResource.oppositeAccessPointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_interface_id' has been deprecated from version 1.11.0. Use resource
      alicloud_router_interface_connection's 'opposite_interface_id' instead.
  """,
    )
    public val oppositeInterfaceId: Output<String>
        get() = javaResource.oppositeInterfaceId().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_interface_owner_id' has been deprecated from version 1.11.0. Use resource
      alicloud_router_interface_connection's 'opposite_interface_owner_id' instead.
  """,
    )
    public val oppositeInterfaceOwnerId: Output<String>
        get() = javaResource.oppositeInterfaceOwnerId().applyValue({ args0 -> args0 })

    /**
     * The Region of peer side.
     */
    public val oppositeRegion: Output<String>
        get() = javaResource.oppositeRegion().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_router_id' has been deprecated from version 1.11.0. Use resource
      alicloud_router_interface_connection's 'opposite_router_id' instead.
  """,
    )
    public val oppositeRouterId: Output<String>
        get() = javaResource.oppositeRouterId().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.11.0. resource alicloud_router_interface_connection's 'opposite_router_type' instead.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_router_type' has been deprecated from version 1.11.0. Use resource
      alicloud_router_interface_connection's 'opposite_router_type' instead.
  """,
    )
    public val oppositeRouterType: Output<String>
        get() = javaResource.oppositeRouterType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The Router ID.
     */
    public val routerId: Output<String>
        get() = javaResource.routerId().applyValue({ args0 -> args0 })

    /**
     * Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
     */
    public val routerType: Output<String>
        get() = javaResource.routerType().applyValue({ args0 -> args0 })

    /**
     * Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
     */
    public val specification: Output<String>?
        get() = javaResource.specification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RouterInterfaceMapper : ResourceMapper<RouterInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.RouterInterface::class == javaResource::class

    override fun map(javaResource: Resource): RouterInterface = RouterInterface(
        javaResource as
            com.pulumi.alicloud.vpc.RouterInterface,
    )
}

/**
 * @see [RouterInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouterInterface].
 */
public suspend fun routerInterface(
    name: String,
    block: suspend RouterInterfaceResourceBuilder.() -> Unit,
): RouterInterface {
    val builder = RouterInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouterInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routerInterface(name: String): RouterInterface {
    val builder = RouterInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
