@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.RouterInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC router interface resource aim to build a connection between two VPCs.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.
 * > **NOTE:** Only one pair of connected router interfaces can exist between two routers. Up to 5 router interfaces can be created for each router and each account.
 * > **NOTE:** The router interface is not connected when it is created. It can be connected by means of resource alicloud_router_interface_connection.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.vpc.Network("foo", {
 *     vpcName: "tf_test_foo12345",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const _interface = new alicloud.vpc.RouterInterface("interface", {
 *     oppositeRegion: "cn-beijing",
 *     routerType: "VRouter",
 *     routerId: foo.routerId,
 *     role: "InitiatingSide",
 *     specification: "Large.2",
 *     name: "test1",
 *     description: "test1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.vpc.Network("foo",
 *     vpc_name="tf_test_foo12345",
 *     cidr_block="172.16.0.0/12")
 * interface = alicloud.vpc.RouterInterface("interface",
 *     opposite_region="cn-beijing",
 *     router_type="VRouter",
 *     router_id=foo.router_id,
 *     role="InitiatingSide",
 *     specification="Large.2",
 *     name="test1",
 *     description="test1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = "tf_test_foo12345",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var @interface = new AliCloud.Vpc.RouterInterface("interface", new()
 *     {
 *         OppositeRegion = "cn-beijing",
 *         RouterType = "VRouter",
 *         RouterId = foo.RouterId,
 *         Role = "InitiatingSide",
 *         Specification = "Large.2",
 *         Name = "test1",
 *         Description = "test1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_test_foo12345"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewRouterInterface(ctx, "interface", &vpc.RouterInterfaceArgs{
 * 			OppositeRegion: pulumi.String("cn-beijing"),
 * 			RouterType:     pulumi.String("VRouter"),
 * 			RouterId:       foo.RouterId,
 * 			Role:           pulumi.String("InitiatingSide"),
 * 			Specification:  pulumi.String("Large.2"),
 * 			Name:           pulumi.String("test1"),
 * 			Description:    pulumi.String("test1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.RouterInterface;
 * import com.pulumi.alicloud.vpc.RouterInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Network("foo", NetworkArgs.builder()
 *             .vpcName("tf_test_foo12345")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var interface_ = new RouterInterface("interface", RouterInterfaceArgs.builder()
 *             .oppositeRegion("cn-beijing")
 *             .routerType("VRouter")
 *             .routerId(foo.routerId())
 *             .role("InitiatingSide")
 *             .specification("Large.2")
 *             .name("test1")
 *             .description("test1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_test_foo12345
 *       cidrBlock: 172.16.0.0/12
 *   interface:
 *     type: alicloud:vpc:RouterInterface
 *     properties:
 *       oppositeRegion: cn-beijing
 *       routerType: VRouter
 *       routerId: ${foo.routerId}
 *       role: InitiatingSide
 *       specification: Large.2
 *       name: test1
 *       description: test1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The router interface can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/routerInterface:RouterInterface interface ri-abc123456
 * ```
 * @property description Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
 * @property healthCheckSourceIp Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
 * @property healthCheckTargetIp Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
 * @property instanceChargeType The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
 * @property name Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
 * If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
 * @property oppositeAccessPointId It has been deprecated from version 1.11.0.
 * @property oppositeRegion The Region of peer side.
 * @property period The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property role The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
 * @property routerId The Router ID.
 * @property routerType Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
 * @property specification Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
 */
public data class RouterInterfaceArgs(
    public val description: Output<String>? = null,
    public val healthCheckSourceIp: Output<String>? = null,
    public val healthCheckTargetIp: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.
  """,
    )
    public val oppositeAccessPointId: Output<String>? = null,
    public val oppositeRegion: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val role: Output<String>? = null,
    public val routerId: Output<String>? = null,
    public val routerType: Output<String>? = null,
    public val specification: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.RouterInterfaceArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.RouterInterfaceArgs =
        com.pulumi.alicloud.vpc.RouterInterfaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .healthCheckSourceIp(healthCheckSourceIp?.applyValue({ args0 -> args0 }))
            .healthCheckTargetIp(healthCheckTargetIp?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .oppositeAccessPointId(oppositeAccessPointId?.applyValue({ args0 -> args0 }))
            .oppositeRegion(oppositeRegion?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .routerId(routerId?.applyValue({ args0 -> args0 }))
            .routerType(routerType?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouterInterfaceArgs].
 */
@PulumiTagMarker
public class RouterInterfaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var healthCheckSourceIp: Output<String>? = null

    private var healthCheckTargetIp: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var name: Output<String>? = null

    private var oppositeAccessPointId: Output<String>? = null

    private var oppositeRegion: Output<String>? = null

    private var period: Output<Int>? = null

    private var role: Output<String>? = null

    private var routerId: Output<String>? = null

    private var routerType: Output<String>? = null

    private var specification: Output<String>? = null

    /**
     * @param value Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
     */
    @JvmName("medkhyyrwjmpvcdk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
     */
    @JvmName("ikplxlxlynjuvgtw")
    public suspend fun healthCheckSourceIp(`value`: Output<String>) {
        this.healthCheckSourceIp = value
    }

    /**
     * @param value Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
     */
    @JvmName("dryetbhaywltyqwn")
    public suspend fun healthCheckTargetIp(`value`: Output<String>) {
        this.healthCheckTargetIp = value
    }

    /**
     * @param value The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
     */
    @JvmName("bxvydcwpewrxdbhn")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
     * If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
     */
    @JvmName("rcevnvgguknstpom")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value It has been deprecated from version 1.11.0.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.
  """,
    )
    @JvmName("fesucrsscxdqvtcp")
    public suspend fun oppositeAccessPointId(`value`: Output<String>) {
        this.oppositeAccessPointId = value
    }

    /**
     * @param value The Region of peer side.
     */
    @JvmName("loraqiyufrqximep")
    public suspend fun oppositeRegion(`value`: Output<String>) {
        this.oppositeRegion = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("cmjsebgjgrampfvt")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
     */
    @JvmName("pltretekoqhbwbiy")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The Router ID.
     */
    @JvmName("lsiqlbbnuavljdca")
    public suspend fun routerId(`value`: Output<String>) {
        this.routerId = value
    }

    /**
     * @param value Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
     */
    @JvmName("klrfbfbprewmwxqt")
    public suspend fun routerType(`value`: Output<String>) {
        this.routerType = value
    }

    /**
     * @param value Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
     */
    @JvmName("rvsnxydeoixmtdyn")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
     */
    @JvmName("gxadxcnlxxofmhan")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
     */
    @JvmName("pqtjrglhakrbbmdr")
    public suspend fun healthCheckSourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckSourceIp = mapped
    }

    /**
     * @param value Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
     */
    @JvmName("ojgdooykkcnahwnk")
    public suspend fun healthCheckTargetIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTargetIp = mapped
    }

    /**
     * @param value The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
     */
    @JvmName("csdsvboajwhdcwrt")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
     * If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
     */
    @JvmName("qgkmadipbrglkkqf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value It has been deprecated from version 1.11.0.
     */
    @Deprecated(
        message = """
  Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.
  """,
    )
    @JvmName("oyxtsgtrsgebvmjg")
    public suspend fun oppositeAccessPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeAccessPointId = mapped
    }

    /**
     * @param value The Region of peer side.
     */
    @JvmName("ijiuyycsdxljkkee")
    public suspend fun oppositeRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeRegion = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("dvxihpspqixsappq")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
     */
    @JvmName("punvorpqcsffdbhf")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The Router ID.
     */
    @JvmName("ipnmenadtccxlvor")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerId = mapped
    }

    /**
     * @param value Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
     */
    @JvmName("mkpviagsxnkkmuqv")
    public suspend fun routerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerType = mapped
    }

    /**
     * @param value Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
     */
    @JvmName("kjbejmepbkxusops")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    internal fun build(): RouterInterfaceArgs = RouterInterfaceArgs(
        description = description,
        healthCheckSourceIp = healthCheckSourceIp,
        healthCheckTargetIp = healthCheckTargetIp,
        instanceChargeType = instanceChargeType,
        name = name,
        oppositeAccessPointId = oppositeAccessPointId,
        oppositeRegion = oppositeRegion,
        period = period,
        role = role,
        routerId = routerId,
        routerType = routerType,
        specification = specification,
    )
}
