@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouterInterfaceConnection].
 */
@PulumiTagMarker
public class RouterInterfaceConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouterInterfaceConnectionArgs = RouterInterfaceConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouterInterfaceConnectionArgsBuilder.() -> Unit) {
        val builder = RouterInterfaceConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouterInterfaceConnection {
        val builtJavaResource =
            com.pulumi.alicloud.vpc.RouterInterfaceConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RouterInterfaceConnection(builtJavaResource)
    }
}

/**
 * Provides a VPC router interface connection resource to connect two router interfaces which are in two different VPCs.
 * After that, all of the two router interfaces will be active.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.
 * > **NOTE:** At present, Router interface does not support changing opposite router interface, the connection delete action is only deactivating it to inactive, not modifying the connection to empty.
 * > **NOTE:** If you want to changing opposite router interface, you can delete router interface and re-build them.
 * > **NOTE:** A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 * > **NOTE:** Please remember to add a `depends_on` clause in the router interface connection from the InitiatingSide to the AcceptingSide, because the connection from the AcceptingSide to the InitiatingSide must be done first.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const name = config.get("name") || "alicloudRouterInterfaceConnectionBasic";
 * const foo = new alicloud.vpc.Network("foo", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const bar = new alicloud.vpc.Network("bar", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const initiate = new alicloud.vpc.RouterInterface("initiate", {
 *     oppositeRegion: region,
 *     routerType: "VRouter",
 *     routerId: foo.routerId,
 *     role: "InitiatingSide",
 *     specification: "Large.2",
 *     name: name,
 *     description: name,
 *     instanceChargeType: "PostPaid",
 * });
 * const opposite = new alicloud.vpc.RouterInterface("opposite", {
 *     oppositeRegion: region,
 *     routerType: "VRouter",
 *     routerId: bar.routerId,
 *     role: "AcceptingSide",
 *     specification: "Large.1",
 *     name: `${name}-opposite`,
 *     description: `${name}-opposite`,
 * });
 * const barRouterInterfaceConnection = new alicloud.vpc.RouterInterfaceConnection("bar", {
 *     interfaceId: opposite.id,
 *     oppositeInterfaceId: initiate.id,
 * });
 * // A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 * const fooRouterInterfaceConnection = new alicloud.vpc.RouterInterfaceConnection("foo", {
 *     interfaceId: initiate.id,
 *     oppositeInterfaceId: opposite.id,
 * }, {
 *     dependsOn: [barRouterInterfaceConnection],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * name = config.get("name")
 * if name is None:
 *     name = "alicloudRouterInterfaceConnectionBasic"
 * foo = alicloud.vpc.Network("foo",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * bar = alicloud.vpc.Network("bar",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * initiate = alicloud.vpc.RouterInterface("initiate",
 *     opposite_region=region,
 *     router_type="VRouter",
 *     router_id=foo.router_id,
 *     role="InitiatingSide",
 *     specification="Large.2",
 *     name=name,
 *     description=name,
 *     instance_charge_type="PostPaid")
 * opposite = alicloud.vpc.RouterInterface("opposite",
 *     opposite_region=region,
 *     router_type="VRouter",
 *     router_id=bar.router_id,
 *     role="AcceptingSide",
 *     specification="Large.1",
 *     name=f"{name}-opposite",
 *     description=f"{name}-opposite")
 * bar_router_interface_connection = alicloud.vpc.RouterInterfaceConnection("bar",
 *     interface_id=opposite.id,
 *     opposite_interface_id=initiate.id)
 * # A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 * foo_router_interface_connection = alicloud.vpc.RouterInterfaceConnection("foo",
 *     interface_id=initiate.id,
 *     opposite_interface_id=opposite.id,
 *     opts = pulumi.ResourceOptions(depends_on=[bar_router_interface_connection]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var name = config.Get("name") ?? "alicloudRouterInterfaceConnectionBasic";
 *     var foo = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var bar = new AliCloud.Vpc.Network("bar", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var initiate = new AliCloud.Vpc.RouterInterface("initiate", new()
 *     {
 *         OppositeRegion = region,
 *         RouterType = "VRouter",
 *         RouterId = foo.RouterId,
 *         Role = "InitiatingSide",
 *         Specification = "Large.2",
 *         Name = name,
 *         Description = name,
 *         InstanceChargeType = "PostPaid",
 *     });
 *     var opposite = new AliCloud.Vpc.RouterInterface("opposite", new()
 *     {
 *         OppositeRegion = region,
 *         RouterType = "VRouter",
 *         RouterId = bar.RouterId,
 *         Role = "AcceptingSide",
 *         Specification = "Large.1",
 *         Name = $"{name}-opposite",
 *         Description = $"{name}-opposite",
 *     });
 *     var barRouterInterfaceConnection = new AliCloud.Vpc.RouterInterfaceConnection("bar", new()
 *     {
 *         InterfaceId = opposite.Id,
 *         OppositeInterfaceId = initiate.Id,
 *     });
 *     // A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 *     var fooRouterInterfaceConnection = new AliCloud.Vpc.RouterInterfaceConnection("foo", new()
 *     {
 *         InterfaceId = initiate.Id,
 *         OppositeInterfaceId = opposite.Id,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             barRouterInterfaceConnection,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "alicloudRouterInterfaceConnectionBasic"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		foo, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := vpc.NewNetwork(ctx, "bar", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		initiate, err := vpc.NewRouterInterface(ctx, "initiate", &vpc.RouterInterfaceArgs{
 * 			OppositeRegion:     pulumi.String(region),
 * 			RouterType:         pulumi.String("VRouter"),
 * 			RouterId:           foo.RouterId,
 * 			Role:               pulumi.String("InitiatingSide"),
 * 			Specification:      pulumi.String("Large.2"),
 * 			Name:               pulumi.String(name),
 * 			Description:        pulumi.String(name),
 * 			InstanceChargeType: pulumi.String("PostPaid"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		opposite, err := vpc.NewRouterInterface(ctx, "opposite", &vpc.RouterInterfaceArgs{
 * 			OppositeRegion: pulumi.String(region),
 * 			RouterType:     pulumi.String("VRouter"),
 * 			RouterId:       bar.RouterId,
 * 			Role:           pulumi.String("AcceptingSide"),
 * 			Specification:  pulumi.String("Large.1"),
 * 			Name:           pulumi.Sprintf("%v-opposite", name),
 * 			Description:    pulumi.Sprintf("%v-opposite", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		barRouterInterfaceConnection, err := vpc.NewRouterInterfaceConnection(ctx, "bar", &vpc.RouterInterfaceConnectionArgs{
 * 			InterfaceId:         opposite.ID(),
 * 			OppositeInterfaceId: initiate.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 * 		_, err = vpc.NewRouterInterfaceConnection(ctx, "foo", &vpc.RouterInterfaceConnectionArgs{
 * 			InterfaceId:         initiate.ID(),
 * 			OppositeInterfaceId: opposite.ID(),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			barRouterInterfaceConnection,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.RouterInterface;
 * import com.pulumi.alicloud.vpc.RouterInterfaceArgs;
 * import com.pulumi.alicloud.vpc.RouterInterfaceConnection;
 * import com.pulumi.alicloud.vpc.RouterInterfaceConnectionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var name = config.get("name").orElse("alicloudRouterInterfaceConnectionBasic");
 *         var foo = new Network("foo", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var bar = new Network("bar", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var initiate = new RouterInterface("initiate", RouterInterfaceArgs.builder()
 *             .oppositeRegion(region)
 *             .routerType("VRouter")
 *             .routerId(foo.routerId())
 *             .role("InitiatingSide")
 *             .specification("Large.2")
 *             .name(name)
 *             .description(name)
 *             .instanceChargeType("PostPaid")
 *             .build());
 *         var opposite = new RouterInterface("opposite", RouterInterfaceArgs.builder()
 *             .oppositeRegion(region)
 *             .routerType("VRouter")
 *             .routerId(bar.routerId())
 *             .role("AcceptingSide")
 *             .specification("Large.1")
 *             .name(String.format("%s-opposite", name))
 *             .description(String.format("%s-opposite", name))
 *             .build());
 *         var barRouterInterfaceConnection = new RouterInterfaceConnection("barRouterInterfaceConnection", RouterInterfaceConnectionArgs.builder()
 *             .interfaceId(opposite.id())
 *             .oppositeInterfaceId(initiate.id())
 *             .build());
 *         // A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 *         var fooRouterInterfaceConnection = new RouterInterfaceConnection("fooRouterInterfaceConnection", RouterInterfaceConnectionArgs.builder()
 *             .interfaceId(initiate.id())
 *             .oppositeInterfaceId(opposite.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(barRouterInterfaceConnection)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   name:
 *     type: string
 *     default: alicloudRouterInterfaceConnectionBasic
 * resources:
 *   foo:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   bar:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   initiate:
 *     type: alicloud:vpc:RouterInterface
 *     properties:
 *       oppositeRegion: ${region}
 *       routerType: VRouter
 *       routerId: ${foo.routerId}
 *       role: InitiatingSide
 *       specification: Large.2
 *       name: ${name}
 *       description: ${name}
 *       instanceChargeType: PostPaid
 *   opposite:
 *     type: alicloud:vpc:RouterInterface
 *     properties:
 *       oppositeRegion: ${region}
 *       routerType: VRouter
 *       routerId: ${bar.routerId}
 *       role: AcceptingSide
 *       specification: Large.1
 *       name: ${name}-opposite
 *       description: ${name}-opposite
 *   # A integrated router interface connection tunnel requires both InitiatingSide and AcceptingSide configuring opposite router interface.
 *   fooRouterInterfaceConnection:
 *     type: alicloud:vpc:RouterInterfaceConnection
 *     name: foo
 *     properties:
 *       interfaceId: ${initiate.id}
 *       oppositeInterfaceId: ${opposite.id}
 *     options:
 *       dependson:
 *         - ${barRouterInterfaceConnection}
 *   barRouterInterfaceConnection:
 *     type: alicloud:vpc:RouterInterfaceConnection
 *     name: bar
 *     properties:
 *       interfaceId: ${opposite.id}
 *       oppositeInterfaceId: ${initiate.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The router interface connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/routerInterfaceConnection:RouterInterfaceConnection foo ri-abc123456
 * ```
 */
public class RouterInterfaceConnection internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.RouterInterfaceConnection,
) : KotlinCustomResource(javaResource, RouterInterfaceConnectionMapper) {
    /**
     * One side router interface ID.
     */
    public val interfaceId: Output<String>
        get() = javaResource.interfaceId().applyValue({ args0 -> args0 })

    /**
     * Another side router interface ID. It must belong the specified "opposite_interface_owner_id" account.
     */
    public val oppositeInterfaceId: Output<String>
        get() = javaResource.oppositeInterfaceId().applyValue({ args0 -> args0 })

    /**
     * Another side router interface account ID. Log on to the Alibaba Cloud console, select User Info > Account Management to check the account ID. Default to Provider account_id.
     */
    public val oppositeInterfaceOwnerId: Output<String>
        get() = javaResource.oppositeInterfaceOwnerId().applyValue({ args0 -> args0 })

    /**
     * Another side router ID. It must belong the specified "opposite_interface_owner_id" account. It is valid when field "opposite_interface_owner_id" is specified.
     */
    public val oppositeRouterId: Output<String>
        get() = javaResource.oppositeRouterId().applyValue({ args0 -> args0 })

    /**
     * Another side router Type. Optional value: VRouter, VBR. It is valid when field "opposite_interface_owner_id" is specified.
     * > **NOTE:** The value of "opposite_interface_owner_id" or "account_id" must be main account and not be sub account.
     */
    public val oppositeRouterType: Output<String>?
        get() = javaResource.oppositeRouterType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RouterInterfaceConnectionMapper : ResourceMapper<RouterInterfaceConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.RouterInterfaceConnection::class == javaResource::class

    override fun map(javaResource: Resource): RouterInterfaceConnection =
        RouterInterfaceConnection(javaResource as com.pulumi.alicloud.vpc.RouterInterfaceConnection)
}

/**
 * @see [RouterInterfaceConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouterInterfaceConnection].
 */
public suspend fun routerInterfaceConnection(
    name: String,
    block: suspend RouterInterfaceConnectionResourceBuilder.() -> Unit,
): RouterInterfaceConnection {
    val builder = RouterInterfaceConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouterInterfaceConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routerInterfaceConnection(name: String): RouterInterfaceConnection {
    val builder = RouterInterfaceConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
