@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SnatEntry].
 */
@PulumiTagMarker
public class SnatEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnatEntryArgs = SnatEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnatEntryArgsBuilder.() -> Unit) {
        val builder = SnatEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnatEntry {
        val builtJavaResource = com.pulumi.alicloud.vpc.SnatEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnatEntry(builtJavaResource)
    }
}

/**
 * Provides a snat resource.
 * > **NOTE:** Available since v1.119.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultNatGateway = new alicloud.vpc.NatGateway("default", {
 *     vpcId: defaultNetwork.id,
 *     natGatewayName: name,
 *     paymentType: "PayAsYouGo",
 *     vswitchId: defaultSwitch.id,
 *     natType: "Enhanced",
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {addressName: name});
 * const defaultEipAssociation = new alicloud.ecs.EipAssociation("default", {
 *     allocationId: defaultEipAddress.id,
 *     instanceId: defaultNatGateway.id,
 * });
 * const defaultSnatEntry = new alicloud.vpc.SnatEntry("default", {
 *     snatTableId: defaultNatGateway.snatTableIds,
 *     sourceVswitchId: defaultSwitch.id,
 *     snatIp: defaultEipAddress.ipAddress,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_nat_gateway = alicloud.vpc.NatGateway("default",
 *     vpc_id=default_network.id,
 *     nat_gateway_name=name,
 *     payment_type="PayAsYouGo",
 *     vswitch_id=default_switch.id,
 *     nat_type="Enhanced")
 * default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
 * default_eip_association = alicloud.ecs.EipAssociation("default",
 *     allocation_id=default_eip_address.id,
 *     instance_id=default_nat_gateway.id)
 * default_snat_entry = alicloud.vpc.SnatEntry("default",
 *     snat_table_id=default_nat_gateway.snat_table_ids,
 *     source_vswitch_id=default_switch.id,
 *     snat_ip=default_eip_address.ip_address)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultNatGateway = new AliCloud.Vpc.NatGateway("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         NatGatewayName = name,
 *         PaymentType = "PayAsYouGo",
 *         VswitchId = defaultSwitch.Id,
 *         NatType = "Enhanced",
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *     });
 *     var defaultEipAssociation = new AliCloud.Ecs.EipAssociation("default", new()
 *     {
 *         AllocationId = defaultEipAddress.Id,
 *         InstanceId = defaultNatGateway.Id,
 *     });
 *     var defaultSnatEntry = new AliCloud.Vpc.SnatEntry("default", new()
 *     {
 *         SnatTableId = defaultNatGateway.SnatTableIds,
 *         SourceVswitchId = defaultSwitch.Id,
 *         SnatIp = defaultEipAddress.IpAddress,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNatGateway, err := vpc.NewNatGateway(ctx, "default", &vpc.NatGatewayArgs{
 * 			VpcId:          defaultNetwork.ID(),
 * 			NatGatewayName: pulumi.String(name),
 * 			PaymentType:    pulumi.String("PayAsYouGo"),
 * 			VswitchId:      defaultSwitch.ID(),
 * 			NatType:        pulumi.String("Enhanced"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEipAssociation(ctx, "default", &ecs.EipAssociationArgs{
 * 			AllocationId: defaultEipAddress.ID(),
 * 			InstanceId:   defaultNatGateway.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSnatEntry(ctx, "default", &vpc.SnatEntryArgs{
 * 			SnatTableId:     defaultNatGateway.SnatTableIds,
 * 			SourceVswitchId: defaultSwitch.ID(),
 * 			SnatIp:          defaultEipAddress.IpAddress,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NatGateway;
 * import com.pulumi.alicloud.vpc.NatGatewayArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ecs.EipAssociation;
 * import com.pulumi.alicloud.ecs.EipAssociationArgs;
 * import com.pulumi.alicloud.vpc.SnatEntry;
 * import com.pulumi.alicloud.vpc.SnatEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultNatGateway = new NatGateway("defaultNatGateway", NatGatewayArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .natGatewayName(name)
 *             .paymentType("PayAsYouGo")
 *             .vswitchId(defaultSwitch.id())
 *             .natType("Enhanced")
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .addressName(name)
 *             .build());
 *         var defaultEipAssociation = new EipAssociation("defaultEipAssociation", EipAssociationArgs.builder()
 *             .allocationId(defaultEipAddress.id())
 *             .instanceId(defaultNatGateway.id())
 *             .build());
 *         var defaultSnatEntry = new SnatEntry("defaultSnatEntry", SnatEntryArgs.builder()
 *             .snatTableId(defaultNatGateway.snatTableIds())
 *             .sourceVswitchId(defaultSwitch.id())
 *             .snatIp(defaultEipAddress.ipAddress())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultNatGateway:
 *     type: alicloud:vpc:NatGateway
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       natGatewayName: ${name}
 *       paymentType: PayAsYouGo
 *       vswitchId: ${defaultSwitch.id}
 *       natType: Enhanced
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       addressName: ${name}
 *   defaultEipAssociation:
 *     type: alicloud:ecs:EipAssociation
 *     name: default
 *     properties:
 *       allocationId: ${defaultEipAddress.id}
 *       instanceId: ${defaultNatGateway.id}
 *   defaultSnatEntry:
 *     type: alicloud:vpc:SnatEntry
 *     name: default
 *     properties:
 *       snatTableId: ${defaultNatGateway.snatTableIds}
 *       sourceVswitchId: ${defaultSwitch.id}
 *       snatIp: ${defaultEipAddress.ipAddress}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Snat Entry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/snatEntry:SnatEntry foo stb-1aece3:snat-232ce2
 * ```
 */
public class SnatEntry internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.SnatEntry,
) : KotlinCustomResource(javaResource, SnatEntryMapper) {
    /**
     * The id of the snat entry on the server.
     */
    public val snatEntryId: Output<String>
        get() = javaResource.snatEntryId().applyValue({ args0 -> args0 })

    /**
     * The name of snat entry.
     */
    public val snatEntryName: Output<String>?
        get() = javaResource.snatEntryName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SNAT ip address, the ip must along bandwidth package public ip which `alicloud.vpc.NatGateway` argument `bandwidth_packages`.
     */
    public val snatIp: Output<String>
        get() = javaResource.snatIp().applyValue({ args0 -> args0 })

    /**
     * The value can get from `alicloud.vpc.NatGateway` Attributes "snat_table_ids".
     */
    public val snatTableId: Output<String>
        get() = javaResource.snatTableId().applyValue({ args0 -> args0 })

    /**
     * The private network segment of Ecs. This parameter and the `source_vswitch_id` parameter are mutually exclusive and cannot appear at the same time.
     */
    public val sourceCidr: Output<String>
        get() = javaResource.sourceCidr().applyValue({ args0 -> args0 })

    /**
     * The vswitch ID.
     */
    public val sourceVswitchId: Output<String>
        get() = javaResource.sourceVswitchId().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.119.1) The status of snat entry.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SnatEntryMapper : ResourceMapper<SnatEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.SnatEntry::class == javaResource::class

    override fun map(javaResource: Resource): SnatEntry = SnatEntry(
        javaResource as
            com.pulumi.alicloud.vpc.SnatEntry,
    )
}

/**
 * @see [SnatEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnatEntry].
 */
public suspend fun snatEntry(name: String, block: suspend SnatEntryResourceBuilder.() -> Unit): SnatEntry {
    val builder = SnatEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnatEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snatEntry(name: String): SnatEntry {
    val builder = SnatEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
