@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.SnatEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a snat resource.
 * > **NOTE:** Available since v1.119.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultNatGateway = new alicloud.vpc.NatGateway("default", {
 *     vpcId: defaultNetwork.id,
 *     natGatewayName: name,
 *     paymentType: "PayAsYouGo",
 *     vswitchId: defaultSwitch.id,
 *     natType: "Enhanced",
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {addressName: name});
 * const defaultEipAssociation = new alicloud.ecs.EipAssociation("default", {
 *     allocationId: defaultEipAddress.id,
 *     instanceId: defaultNatGateway.id,
 * });
 * const defaultSnatEntry = new alicloud.vpc.SnatEntry("default", {
 *     snatTableId: defaultNatGateway.snatTableIds,
 *     sourceVswitchId: defaultSwitch.id,
 *     snatIp: defaultEipAddress.ipAddress,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_nat_gateway = alicloud.vpc.NatGateway("default",
 *     vpc_id=default_network.id,
 *     nat_gateway_name=name,
 *     payment_type="PayAsYouGo",
 *     vswitch_id=default_switch.id,
 *     nat_type="Enhanced")
 * default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
 * default_eip_association = alicloud.ecs.EipAssociation("default",
 *     allocation_id=default_eip_address.id,
 *     instance_id=default_nat_gateway.id)
 * default_snat_entry = alicloud.vpc.SnatEntry("default",
 *     snat_table_id=default_nat_gateway.snat_table_ids,
 *     source_vswitch_id=default_switch.id,
 *     snat_ip=default_eip_address.ip_address)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultNatGateway = new AliCloud.Vpc.NatGateway("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         NatGatewayName = name,
 *         PaymentType = "PayAsYouGo",
 *         VswitchId = defaultSwitch.Id,
 *         NatType = "Enhanced",
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *     });
 *     var defaultEipAssociation = new AliCloud.Ecs.EipAssociation("default", new()
 *     {
 *         AllocationId = defaultEipAddress.Id,
 *         InstanceId = defaultNatGateway.Id,
 *     });
 *     var defaultSnatEntry = new AliCloud.Vpc.SnatEntry("default", new()
 *     {
 *         SnatTableId = defaultNatGateway.SnatTableIds,
 *         SourceVswitchId = defaultSwitch.Id,
 *         SnatIp = defaultEipAddress.IpAddress,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNatGateway, err := vpc.NewNatGateway(ctx, "default", &vpc.NatGatewayArgs{
 * 			VpcId:          defaultNetwork.ID(),
 * 			NatGatewayName: pulumi.String(name),
 * 			PaymentType:    pulumi.String("PayAsYouGo"),
 * 			VswitchId:      defaultSwitch.ID(),
 * 			NatType:        pulumi.String("Enhanced"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEipAssociation(ctx, "default", &ecs.EipAssociationArgs{
 * 			AllocationId: defaultEipAddress.ID(),
 * 			InstanceId:   defaultNatGateway.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSnatEntry(ctx, "default", &vpc.SnatEntryArgs{
 * 			SnatTableId:     defaultNatGateway.SnatTableIds,
 * 			SourceVswitchId: defaultSwitch.ID(),
 * 			SnatIp:          defaultEipAddress.IpAddress,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NatGateway;
 * import com.pulumi.alicloud.vpc.NatGatewayArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ecs.EipAssociation;
 * import com.pulumi.alicloud.ecs.EipAssociationArgs;
 * import com.pulumi.alicloud.vpc.SnatEntry;
 * import com.pulumi.alicloud.vpc.SnatEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultNatGateway = new NatGateway("defaultNatGateway", NatGatewayArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .natGatewayName(name)
 *             .paymentType("PayAsYouGo")
 *             .vswitchId(defaultSwitch.id())
 *             .natType("Enhanced")
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .addressName(name)
 *             .build());
 *         var defaultEipAssociation = new EipAssociation("defaultEipAssociation", EipAssociationArgs.builder()
 *             .allocationId(defaultEipAddress.id())
 *             .instanceId(defaultNatGateway.id())
 *             .build());
 *         var defaultSnatEntry = new SnatEntry("defaultSnatEntry", SnatEntryArgs.builder()
 *             .snatTableId(defaultNatGateway.snatTableIds())
 *             .sourceVswitchId(defaultSwitch.id())
 *             .snatIp(defaultEipAddress.ipAddress())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultNatGateway:
 *     type: alicloud:vpc:NatGateway
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       natGatewayName: ${name}
 *       paymentType: PayAsYouGo
 *       vswitchId: ${defaultSwitch.id}
 *       natType: Enhanced
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       addressName: ${name}
 *   defaultEipAssociation:
 *     type: alicloud:ecs:EipAssociation
 *     name: default
 *     properties:
 *       allocationId: ${defaultEipAddress.id}
 *       instanceId: ${defaultNatGateway.id}
 *   defaultSnatEntry:
 *     type: alicloud:vpc:SnatEntry
 *     name: default
 *     properties:
 *       snatTableId: ${defaultNatGateway.snatTableIds}
 *       sourceVswitchId: ${defaultSwitch.id}
 *       snatIp: ${defaultEipAddress.ipAddress}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Snat Entry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/snatEntry:SnatEntry foo stb-1aece3:snat-232ce2
 * ```
 * @property snatEntryName The name of snat entry.
 * @property snatIp The SNAT ip address, the ip must along bandwidth package public ip which `alicloud.vpc.NatGateway` argument `bandwidth_packages`.
 * @property snatTableId The value can get from `alicloud.vpc.NatGateway` Attributes "snat_table_ids".
 * @property sourceCidr The private network segment of Ecs. This parameter and the `source_vswitch_id` parameter are mutually exclusive and cannot appear at the same time.
 * @property sourceVswitchId The vswitch ID.
 */
public data class SnatEntryArgs(
    public val snatEntryName: Output<String>? = null,
    public val snatIp: Output<String>? = null,
    public val snatTableId: Output<String>? = null,
    public val sourceCidr: Output<String>? = null,
    public val sourceVswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.SnatEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.SnatEntryArgs =
        com.pulumi.alicloud.vpc.SnatEntryArgs.builder()
            .snatEntryName(snatEntryName?.applyValue({ args0 -> args0 }))
            .snatIp(snatIp?.applyValue({ args0 -> args0 }))
            .snatTableId(snatTableId?.applyValue({ args0 -> args0 }))
            .sourceCidr(sourceCidr?.applyValue({ args0 -> args0 }))
            .sourceVswitchId(sourceVswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnatEntryArgs].
 */
@PulumiTagMarker
public class SnatEntryArgsBuilder internal constructor() {
    private var snatEntryName: Output<String>? = null

    private var snatIp: Output<String>? = null

    private var snatTableId: Output<String>? = null

    private var sourceCidr: Output<String>? = null

    private var sourceVswitchId: Output<String>? = null

    /**
     * @param value The name of snat entry.
     */
    @JvmName("yhttmegfyvhqykfe")
    public suspend fun snatEntryName(`value`: Output<String>) {
        this.snatEntryName = value
    }

    /**
     * @param value The SNAT ip address, the ip must along bandwidth package public ip which `alicloud.vpc.NatGateway` argument `bandwidth_packages`.
     */
    @JvmName("swbtkopjcoecvyil")
    public suspend fun snatIp(`value`: Output<String>) {
        this.snatIp = value
    }

    /**
     * @param value The value can get from `alicloud.vpc.NatGateway` Attributes "snat_table_ids".
     */
    @JvmName("ymcswrcfnhysxbsj")
    public suspend fun snatTableId(`value`: Output<String>) {
        this.snatTableId = value
    }

    /**
     * @param value The private network segment of Ecs. This parameter and the `source_vswitch_id` parameter are mutually exclusive and cannot appear at the same time.
     */
    @JvmName("gqrrsevhooynjmfe")
    public suspend fun sourceCidr(`value`: Output<String>) {
        this.sourceCidr = value
    }

    /**
     * @param value The vswitch ID.
     */
    @JvmName("oqbfyibxlpvngitq")
    public suspend fun sourceVswitchId(`value`: Output<String>) {
        this.sourceVswitchId = value
    }

    /**
     * @param value The name of snat entry.
     */
    @JvmName("gijkceckqjjejqkk")
    public suspend fun snatEntryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snatEntryName = mapped
    }

    /**
     * @param value The SNAT ip address, the ip must along bandwidth package public ip which `alicloud.vpc.NatGateway` argument `bandwidth_packages`.
     */
    @JvmName("uhksehwlwgmxcoup")
    public suspend fun snatIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snatIp = mapped
    }

    /**
     * @param value The value can get from `alicloud.vpc.NatGateway` Attributes "snat_table_ids".
     */
    @JvmName("roaoiqiqkuajlfbm")
    public suspend fun snatTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snatTableId = mapped
    }

    /**
     * @param value The private network segment of Ecs. This parameter and the `source_vswitch_id` parameter are mutually exclusive and cannot appear at the same time.
     */
    @JvmName("xnhephsxjofcpysb")
    public suspend fun sourceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidr = mapped
    }

    /**
     * @param value The vswitch ID.
     */
    @JvmName("qpvxmegmwehjvlym")
    public suspend fun sourceVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVswitchId = mapped
    }

    internal fun build(): SnatEntryArgs = SnatEntryArgs(
        snatEntryName = snatEntryName,
        snatIp = snatIp,
        snatTableId = snatTableId,
        sourceCidr = sourceCidr,
        sourceVswitchId = sourceVswitchId,
    )
}
