@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Subnet].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated and replaced by the Switch resource.
""",
)
public class SubnetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetArgs = SubnetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetArgsBuilder.() -> Unit) {
        val builder = SubnetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Subnet {
        val builtJavaResource = com.pulumi.alicloud.vpc.Subnet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subnet(builtJavaResource)
    }
}

@Deprecated(
    message = """
This resource has been deprecated and replaced by the Switch resource.
""",
)
public class Subnet internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Subnet,
) : KotlinCustomResource(javaResource, SubnetMapper) {
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableIpv6: Output<Boolean>?
        get() = javaResource.enableIpv6().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    public val ipv6CidrBlockMask: Output<Int>
        get() = javaResource.ipv6CidrBlockMask().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    public val vswitchName: Output<String>
        get() = javaResource.vswitchName().applyValue({ args0 -> args0 })

    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object SubnetMapper : ResourceMapper<Subnet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Subnet::class == javaResource::class

    override fun map(javaResource: Resource): Subnet = Subnet(
        javaResource as
            com.pulumi.alicloud.vpc.Subnet,
    )
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subnet].
 */
@Deprecated(
    message = """
This resource has been deprecated and replaced by the Switch resource.
""",
)
public suspend fun subnet(name: String, block: suspend SubnetResourceBuilder.() -> Unit): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 */
@Deprecated(
    message = """
This resource has been deprecated and replaced by the Switch resource.
""",
)
public fun subnet(name: String): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    return builder.build()
}
