@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.SubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZone
 * @property cidrBlock
 * @property description
 * @property enableIpv6
 * @property ipv6CidrBlockMask
 * @property name
 * @property tags
 * @property vpcId
 * @property vswitchName
 * @property zoneId
 */
public data class SubnetArgs
@Deprecated(
    message = """
This resource has been deprecated and replaced by the Switch resource.
""",
)
constructor(
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    public val availabilityZone: Output<String>? = null,
    public val cidrBlock: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableIpv6: Output<Boolean>? = null,
    public val ipv6CidrBlockMask: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchName: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.SubnetArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.SubnetArgs =
        com.pulumi.alicloud.vpc.SubnetArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableIpv6(enableIpv6?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlockMask(ipv6CidrBlockMask?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchName(vswitchName?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated and replaced by the Switch resource.
""",
)
public class SubnetArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var cidrBlock: Output<String>? = null

    private var description: Output<String>? = null

    private var enableIpv6: Output<Boolean>? = null

    private var ipv6CidrBlockMask: Output<Int>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchName: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    @JvmName("wjmhgwwafxoevyqb")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value
     */
    @JvmName("oxklyaaxxebojylu")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("kvqikvnrvsgxoapl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("ltxbrwaqbjlysblx")
    public suspend fun enableIpv6(`value`: Output<Boolean>) {
        this.enableIpv6 = value
    }

    /**
     * @param value
     */
    @JvmName("kqygxjkleiaestsi")
    public suspend fun ipv6CidrBlockMask(`value`: Output<Int>) {
        this.ipv6CidrBlockMask = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    @JvmName("mvatkbylaftdmsbv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("qoxjiivucdbcjhce")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("octrpkgifogoybvu")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value
     */
    @JvmName("qmvjmkbexyobwrkg")
    public suspend fun vswitchName(`value`: Output<String>) {
        this.vswitchName = value
    }

    /**
     * @param value
     */
    @JvmName("tadxormalkxvsbql")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    @JvmName("fgswrserfwrqjflb")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value
     */
    @JvmName("dyvqtocdrbgtwgwm")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("slrgrftagdxcnyup")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("exkncfbrevuwsmpb")
    public suspend fun enableIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpv6 = mapped
    }

    /**
     * @param value
     */
    @JvmName("nladidbqsfgnknny")
    public suspend fun ipv6CidrBlockMask(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlockMask = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    @JvmName("xujtjskgpiuucsru")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("bwsbcvptkooodouw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("cguwdrjgywttkndm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("afwgfbjofxtjjsdl")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ensdmrfakattjagm")
    public suspend fun vswitchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchName = mapped
    }

    /**
     * @param value
     */
    @JvmName("xrxjhsvdfnlgxxdv")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        availabilityZone = availabilityZone,
        cidrBlock = cidrBlock,
        description = description,
        enableIpv6 = enableIpv6,
        ipv6CidrBlockMask = ipv6CidrBlockMask,
        name = name,
        tags = tags,
        vpcId = vpcId,
        vswitchName = vswitchName,
        zoneId = zoneId,
    )
}
