@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Switch].
 */
@PulumiTagMarker
public class SwitchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SwitchArgs = SwitchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SwitchArgsBuilder.() -> Unit) {
        val builder = SwitchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Switch {
        val builtJavaResource = com.pulumi.alicloud.vpc.Switch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Switch(builtJavaResource)
    }
}

/**
 * Provides a VPC Vswitch resource. ## Module Support
 * You can use to the existing vpc module  to create a VPC and several VSwitches one-click.
 * For information about VPC Vswitch and how to use it, see [What is Vswitch](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/work-with-vswitches).
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const fooNetwork = new alicloud.vpc.Network("foo", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const fooSwitch = new alicloud.vpc.Switch("foo", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.16.0.0/21",
 *     vpcId: fooNetwork.id,
 *     zoneId: foo.then(foo => foo.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.get_zones(available_resource_creation="VSwitch")
 * foo_network = alicloud.vpc.Network("foo",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/12")
 * foo_switch = alicloud.vpc.Switch("foo",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.16.0.0/21",
 *     vpc_id=foo_network.id,
 *     zone_id=foo.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.16.0.0/21",
 *         VpcId = fooNetwork.Id,
 *         ZoneId = foo.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			VpcId:       fooNetwork.ID(),
 * 			ZoneId:      pulumi.String(foo.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var foo = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.16.0.0/21")
 *             .vpcId(fooNetwork.id())
 *             .zoneId(foo.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fooNetwork:
 *     type: alicloud:vpc:Network
 *     name: foo
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/12
 *   fooSwitch:
 *     type: alicloud:vpc:Switch
 *     name: foo
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.16.0.0/21
 *       vpcId: ${fooNetwork.id}
 *       zoneId: ${foo.zones[0].id}
 * variables:
 *   foo:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const cidrBlocks = new alicloud.vpc.Ipv4CidrBlock("cidr_blocks", {
 *     vpcId: vpc.id,
 *     secondaryCidrBlock: "192.163.0.0/16",
 * });
 * const island_nat = new alicloud.vpc.Switch("island-nat", {
 *     vpcId: cidrBlocks.vpcId,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: foo.then(foo => foo.zones?.[0]?.id),
 *     vswitchName: "terraform-example",
 *     tags: {
 *         BuiltBy: "example_value",
 *         cnm_version: "example_value",
 *         Environment: "example_value",
 *         ManagedBy: "example_value",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.get_zones(available_resource_creation="VSwitch")
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/12")
 * cidr_blocks = alicloud.vpc.Ipv4CidrBlock("cidr_blocks",
 *     vpc_id=vpc.id,
 *     secondary_cidr_block="192.163.0.0/16")
 * island_nat = alicloud.vpc.Switch("island-nat",
 *     vpc_id=cidr_blocks.vpc_id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=foo.zones[0].id,
 *     vswitch_name="terraform-example",
 *     tags={
 *         "BuiltBy": "example_value",
 *         "cnm_version": "example_value",
 *         "Environment": "example_value",
 *         "ManagedBy": "example_value",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var cidrBlocks = new AliCloud.Vpc.Ipv4CidrBlock("cidr_blocks", new()
 *     {
 *         VpcId = vpc.Id,
 *         SecondaryCidrBlock = "192.163.0.0/16",
 *     });
 *     var island_nat = new AliCloud.Vpc.Switch("island-nat", new()
 *     {
 *         VpcId = cidrBlocks.VpcId,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = foo.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = "terraform-example",
 *         Tags =
 *         {
 *             { "BuiltBy", "example_value" },
 *             { "cnm_version", "example_value" },
 *             { "Environment", "example_value" },
 *             { "ManagedBy", "example_value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cidrBlocks, err := vpc.NewIpv4CidrBlock(ctx, "cidr_blocks", &vpc.Ipv4CidrBlockArgs{
 * 			VpcId:              vpc.ID(),
 * 			SecondaryCidrBlock: pulumi.String("192.163.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSwitch(ctx, "island-nat", &vpc.SwitchArgs{
 * 			VpcId:       cidrBlocks.VpcId,
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(foo.Zones[0].Id),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"BuiltBy":     pulumi.String("example_value"),
 * 				"cnm_version": pulumi.String("example_value"),
 * 				"Environment": pulumi.String("example_value"),
 * 				"ManagedBy":   pulumi.String("example_value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlock;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlockArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var foo = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var cidrBlocks = new Ipv4CidrBlock("cidrBlocks", Ipv4CidrBlockArgs.builder()
 *             .vpcId(vpc.id())
 *             .secondaryCidrBlock("192.163.0.0/16")
 *             .build());
 *         var island_nat = new Switch("island-nat", SwitchArgs.builder()
 *             .vpcId(cidrBlocks.vpcId())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(foo.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("BuiltBy", "example_value"),
 *                 Map.entry("cnm_version", "example_value"),
 *                 Map.entry("Environment", "example_value"),
 *                 Map.entry("ManagedBy", "example_value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/12
 *   cidrBlocks:
 *     type: alicloud:vpc:Ipv4CidrBlock
 *     name: cidr_blocks
 *     properties:
 *       vpcId: ${vpc.id}
 *       secondaryCidrBlock: 192.163.0.0/16
 *   island-nat:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${cidrBlocks.vpcId}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${foo.zones[0].id}
 *       vswitchName: terraform-example
 *       tags:
 *         BuiltBy: example_value
 *         cnm_version: example_value
 *         Environment: example_value
 *         ManagedBy: example_value
 * variables:
 *   foo:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a switch associated with the additional network segment
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const fooNetwork = new alicloud.vpc.Network("foo", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const fooIpv4CidrBlock = new alicloud.vpc.Ipv4CidrBlock("foo", {
 *     vpcId: fooNetwork.id,
 *     secondaryCidrBlock: "192.163.0.0/16",
 * });
 * const fooSwitch = new alicloud.vpc.Switch("foo", {
 *     vpcId: fooIpv4CidrBlock.vpcId,
 *     cidrBlock: "192.163.0.0/24",
 *     zoneId: foo.then(foo => foo.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.get_zones(available_resource_creation="VSwitch")
 * foo_network = alicloud.vpc.Network("foo",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/12")
 * foo_ipv4_cidr_block = alicloud.vpc.Ipv4CidrBlock("foo",
 *     vpc_id=foo_network.id,
 *     secondary_cidr_block="192.163.0.0/16")
 * foo_switch = alicloud.vpc.Switch("foo",
 *     vpc_id=foo_ipv4_cidr_block.vpc_id,
 *     cidr_block="192.163.0.0/24",
 *     zone_id=foo.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var fooIpv4CidrBlock = new AliCloud.Vpc.Ipv4CidrBlock("foo", new()
 *     {
 *         VpcId = fooNetwork.Id,
 *         SecondaryCidrBlock = "192.163.0.0/16",
 *     });
 *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
 *     {
 *         VpcId = fooIpv4CidrBlock.VpcId,
 *         CidrBlock = "192.163.0.0/24",
 *         ZoneId = foo.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooIpv4CidrBlock, err := vpc.NewIpv4CidrBlock(ctx, "foo", &vpc.Ipv4CidrBlockArgs{
 * 			VpcId:              fooNetwork.ID(),
 * 			SecondaryCidrBlock: pulumi.String("192.163.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
 * 			VpcId:     fooIpv4CidrBlock.VpcId,
 * 			CidrBlock: pulumi.String("192.163.0.0/24"),
 * 			ZoneId:    pulumi.String(foo.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlock;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlockArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var foo = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var fooIpv4CidrBlock = new Ipv4CidrBlock("fooIpv4CidrBlock", Ipv4CidrBlockArgs.builder()
 *             .vpcId(fooNetwork.id())
 *             .secondaryCidrBlock("192.163.0.0/16")
 *             .build());
 *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
 *             .vpcId(fooIpv4CidrBlock.vpcId())
 *             .cidrBlock("192.163.0.0/24")
 *             .zoneId(foo.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fooNetwork:
 *     type: alicloud:vpc:Network
 *     name: foo
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/12
 *   fooIpv4CidrBlock:
 *     type: alicloud:vpc:Ipv4CidrBlock
 *     name: foo
 *     properties:
 *       vpcId: ${fooNetwork.id}
 *       secondaryCidrBlock: 192.163.0.0/16
 *   fooSwitch:
 *     type: alicloud:vpc:Switch
 *     name: foo
 *     properties:
 *       vpcId: ${fooIpv4CidrBlock.vpcId}
 *       cidrBlock: 192.163.0.0/24
 *       zoneId: ${foo.zones[0].id}
 * variables:
 *   foo:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Vswitch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/switch:Switch example <id>
 * ```
 */
public class Switch internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Switch,
) : KotlinCustomResource(javaResource, SwitchMapper) {
    /**
     * Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id' instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR block of the VSwitch.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * The creation time of the VSwitch.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of VSwitch.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the IPv6 function is enabled in the switch. Value:
     * - **true**: enables IPv6.
     * - **false** (default): IPv6 is not enabled.
     */
    public val enableIpv6: Output<Boolean>?
        get() = javaResource.enableIpv6().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv6 CIDR block of the VSwitch.
     */
    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    /**
     * The IPv6 CIDR block of the VSwitch.
     */
    public val ipv6CidrBlockMask: Output<Int>
        get() = javaResource.ipv6CidrBlockMask().applyValue({ args0 -> args0 })

    /**
     * Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of VSwitch.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The VPC ID.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The name of the VSwitch.
     */
    public val vswitchName: Output<String>
        get() = javaResource.vswitchName().applyValue({ args0 -> args0 })

    /**
     * The AZ for the VSwitch. **Note:** Required for a VPC VSwitch.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object SwitchMapper : ResourceMapper<Switch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Switch::class == javaResource::class

    override fun map(javaResource: Resource): Switch = Switch(
        javaResource as
            com.pulumi.alicloud.vpc.Switch,
    )
}

/**
 * @see [Switch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Switch].
 */
public suspend fun switch(name: String, block: suspend SwitchResourceBuilder.() -> Unit): Switch {
    val builder = SwitchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Switch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun switch(name: String): Switch {
    val builder = SwitchResourceBuilder()
    builder.name(name)
    return builder.build()
}
