@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.SwitchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Vswitch resource. ## Module Support
 * You can use to the existing vpc module  to create a VPC and several VSwitches one-click.
 * For information about VPC Vswitch and how to use it, see [What is Vswitch](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/work-with-vswitches).
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const fooNetwork = new alicloud.vpc.Network("foo", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const fooSwitch = new alicloud.vpc.Switch("foo", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.16.0.0/21",
 *     vpcId: fooNetwork.id,
 *     zoneId: foo.then(foo => foo.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.get_zones(available_resource_creation="VSwitch")
 * foo_network = alicloud.vpc.Network("foo",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/12")
 * foo_switch = alicloud.vpc.Switch("foo",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.16.0.0/21",
 *     vpc_id=foo_network.id,
 *     zone_id=foo.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.16.0.0/21",
 *         VpcId = fooNetwork.Id,
 *         ZoneId = foo.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			VpcId:       fooNetwork.ID(),
 * 			ZoneId:      pulumi.String(foo.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var foo = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.16.0.0/21")
 *             .vpcId(fooNetwork.id())
 *             .zoneId(foo.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fooNetwork:
 *     type: alicloud:vpc:Network
 *     name: foo
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/12
 *   fooSwitch:
 *     type: alicloud:vpc:Switch
 *     name: foo
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.16.0.0/21
 *       vpcId: ${fooNetwork.id}
 *       zoneId: ${foo.zones[0].id}
 * variables:
 *   foo:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const cidrBlocks = new alicloud.vpc.Ipv4CidrBlock("cidr_blocks", {
 *     vpcId: vpc.id,
 *     secondaryCidrBlock: "192.163.0.0/16",
 * });
 * const island_nat = new alicloud.vpc.Switch("island-nat", {
 *     vpcId: cidrBlocks.vpcId,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: foo.then(foo => foo.zones?.[0]?.id),
 *     vswitchName: "terraform-example",
 *     tags: {
 *         BuiltBy: "example_value",
 *         cnm_version: "example_value",
 *         Environment: "example_value",
 *         ManagedBy: "example_value",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.get_zones(available_resource_creation="VSwitch")
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/12")
 * cidr_blocks = alicloud.vpc.Ipv4CidrBlock("cidr_blocks",
 *     vpc_id=vpc.id,
 *     secondary_cidr_block="192.163.0.0/16")
 * island_nat = alicloud.vpc.Switch("island-nat",
 *     vpc_id=cidr_blocks.vpc_id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=foo.zones[0].id,
 *     vswitch_name="terraform-example",
 *     tags={
 *         "BuiltBy": "example_value",
 *         "cnm_version": "example_value",
 *         "Environment": "example_value",
 *         "ManagedBy": "example_value",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var cidrBlocks = new AliCloud.Vpc.Ipv4CidrBlock("cidr_blocks", new()
 *     {
 *         VpcId = vpc.Id,
 *         SecondaryCidrBlock = "192.163.0.0/16",
 *     });
 *     var island_nat = new AliCloud.Vpc.Switch("island-nat", new()
 *     {
 *         VpcId = cidrBlocks.VpcId,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = foo.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = "terraform-example",
 *         Tags =
 *         {
 *             { "BuiltBy", "example_value" },
 *             { "cnm_version", "example_value" },
 *             { "Environment", "example_value" },
 *             { "ManagedBy", "example_value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cidrBlocks, err := vpc.NewIpv4CidrBlock(ctx, "cidr_blocks", &vpc.Ipv4CidrBlockArgs{
 * 			VpcId:              vpc.ID(),
 * 			SecondaryCidrBlock: pulumi.String("192.163.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSwitch(ctx, "island-nat", &vpc.SwitchArgs{
 * 			VpcId:       cidrBlocks.VpcId,
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(foo.Zones[0].Id),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"BuiltBy":     pulumi.String("example_value"),
 * 				"cnm_version": pulumi.String("example_value"),
 * 				"Environment": pulumi.String("example_value"),
 * 				"ManagedBy":   pulumi.String("example_value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlock;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlockArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var foo = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var cidrBlocks = new Ipv4CidrBlock("cidrBlocks", Ipv4CidrBlockArgs.builder()
 *             .vpcId(vpc.id())
 *             .secondaryCidrBlock("192.163.0.0/16")
 *             .build());
 *         var island_nat = new Switch("island-nat", SwitchArgs.builder()
 *             .vpcId(cidrBlocks.vpcId())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(foo.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("BuiltBy", "example_value"),
 *                 Map.entry("cnm_version", "example_value"),
 *                 Map.entry("Environment", "example_value"),
 *                 Map.entry("ManagedBy", "example_value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/12
 *   cidrBlocks:
 *     type: alicloud:vpc:Ipv4CidrBlock
 *     name: cidr_blocks
 *     properties:
 *       vpcId: ${vpc.id}
 *       secondaryCidrBlock: 192.163.0.0/16
 *   island-nat:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${cidrBlocks.vpcId}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${foo.zones[0].id}
 *       vswitchName: terraform-example
 *       tags:
 *         BuiltBy: example_value
 *         cnm_version: example_value
 *         Environment: example_value
 *         ManagedBy: example_value
 * variables:
 *   foo:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a switch associated with the additional network segment
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const fooNetwork = new alicloud.vpc.Network("foo", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const fooIpv4CidrBlock = new alicloud.vpc.Ipv4CidrBlock("foo", {
 *     vpcId: fooNetwork.id,
 *     secondaryCidrBlock: "192.163.0.0/16",
 * });
 * const fooSwitch = new alicloud.vpc.Switch("foo", {
 *     vpcId: fooIpv4CidrBlock.vpcId,
 *     cidrBlock: "192.163.0.0/24",
 *     zoneId: foo.then(foo => foo.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.get_zones(available_resource_creation="VSwitch")
 * foo_network = alicloud.vpc.Network("foo",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/12")
 * foo_ipv4_cidr_block = alicloud.vpc.Ipv4CidrBlock("foo",
 *     vpc_id=foo_network.id,
 *     secondary_cidr_block="192.163.0.0/16")
 * foo_switch = alicloud.vpc.Switch("foo",
 *     vpc_id=foo_ipv4_cidr_block.vpc_id,
 *     cidr_block="192.163.0.0/24",
 *     zone_id=foo.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var fooIpv4CidrBlock = new AliCloud.Vpc.Ipv4CidrBlock("foo", new()
 *     {
 *         VpcId = fooNetwork.Id,
 *         SecondaryCidrBlock = "192.163.0.0/16",
 *     });
 *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
 *     {
 *         VpcId = fooIpv4CidrBlock.VpcId,
 *         CidrBlock = "192.163.0.0/24",
 *         ZoneId = foo.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooIpv4CidrBlock, err := vpc.NewIpv4CidrBlock(ctx, "foo", &vpc.Ipv4CidrBlockArgs{
 * 			VpcId:              fooNetwork.ID(),
 * 			SecondaryCidrBlock: pulumi.String("192.163.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
 * 			VpcId:     fooIpv4CidrBlock.VpcId,
 * 			CidrBlock: pulumi.String("192.163.0.0/24"),
 * 			ZoneId:    pulumi.String(foo.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlock;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlockArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var foo = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var fooIpv4CidrBlock = new Ipv4CidrBlock("fooIpv4CidrBlock", Ipv4CidrBlockArgs.builder()
 *             .vpcId(fooNetwork.id())
 *             .secondaryCidrBlock("192.163.0.0/16")
 *             .build());
 *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
 *             .vpcId(fooIpv4CidrBlock.vpcId())
 *             .cidrBlock("192.163.0.0/24")
 *             .zoneId(foo.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fooNetwork:
 *     type: alicloud:vpc:Network
 *     name: foo
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/12
 *   fooIpv4CidrBlock:
 *     type: alicloud:vpc:Ipv4CidrBlock
 *     name: foo
 *     properties:
 *       vpcId: ${fooNetwork.id}
 *       secondaryCidrBlock: 192.163.0.0/16
 *   fooSwitch:
 *     type: alicloud:vpc:Switch
 *     name: foo
 *     properties:
 *       vpcId: ${fooIpv4CidrBlock.vpcId}
 *       cidrBlock: 192.163.0.0/24
 *       zoneId: ${foo.zones[0].id}
 * variables:
 *   foo:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Vswitch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/switch:Switch example <id>
 * ```
 * @property availabilityZone Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id' instead.
 * @property cidrBlock The IPv4 CIDR block of the VSwitch.
 * @property description The description of VSwitch.
 * @property enableIpv6 Whether the IPv6 function is enabled in the switch. Value:
 * - **true**: enables IPv6.
 * - **false** (default): IPv6 is not enabled.
 * @property ipv6CidrBlockMask The IPv6 CIDR block of the VSwitch.
 * @property name Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
 * @property tags The tags of VSwitch.
 * @property vpcId The VPC ID.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 * @property vswitchName The name of the VSwitch.
 * @property zoneId The AZ for the VSwitch. **Note:** Required for a VPC VSwitch.
 */
public data class SwitchArgs(
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    public val availabilityZone: Output<String>? = null,
    public val cidrBlock: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableIpv6: Output<Boolean>? = null,
    public val ipv6CidrBlockMask: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchName: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.SwitchArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.SwitchArgs =
        com.pulumi.alicloud.vpc.SwitchArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableIpv6(enableIpv6?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlockMask(ipv6CidrBlockMask?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchName(vswitchName?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SwitchArgs].
 */
@PulumiTagMarker
public class SwitchArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var cidrBlock: Output<String>? = null

    private var description: Output<String>? = null

    private var enableIpv6: Output<Boolean>? = null

    private var ipv6CidrBlockMask: Output<Int>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchName: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id' instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    @JvmName("icidfgxohlbgtjvr")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The IPv4 CIDR block of the VSwitch.
     */
    @JvmName("jokhnckoowxybwsn")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The description of VSwitch.
     */
    @JvmName("iwqxxcghoalgclqf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the IPv6 function is enabled in the switch. Value:
     * - **true**: enables IPv6.
     * - **false** (default): IPv6 is not enabled.
     */
    @JvmName("vvabyaihxpubqpnx")
    public suspend fun enableIpv6(`value`: Output<Boolean>) {
        this.enableIpv6 = value
    }

    /**
     * @param value The IPv6 CIDR block of the VSwitch.
     */
    @JvmName("kqydtwjspsibdhyx")
    public suspend fun ipv6CidrBlockMask(`value`: Output<Int>) {
        this.ipv6CidrBlockMask = value
    }

    /**
     * @param value Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    @JvmName("vrcwtecgiosygnkw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tags of VSwitch.
     */
    @JvmName("sedtfvperpltmlni")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC ID.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("wrxladmxscduvlle")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The name of the VSwitch.
     */
    @JvmName("wotqjqohkdaugrtx")
    public suspend fun vswitchName(`value`: Output<String>) {
        this.vswitchName = value
    }

    /**
     * @param value The AZ for the VSwitch. **Note:** Required for a VPC VSwitch.
     */
    @JvmName("eepwtcxukbcaxdpv")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id' instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.119.0. New field 'zone_id'
      instead.
  """,
    )
    @JvmName("fiwiyixbfyjvbjof")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The IPv4 CIDR block of the VSwitch.
     */
    @JvmName("vdeedsjvphmdsunl")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The description of VSwitch.
     */
    @JvmName("ivxnvgtetooahoey")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the IPv6 function is enabled in the switch. Value:
     * - **true**: enables IPv6.
     * - **false** (default): IPv6 is not enabled.
     */
    @JvmName("edkwnswkvtccyofv")
    public suspend fun enableIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpv6 = mapped
    }

    /**
     * @param value The IPv6 CIDR block of the VSwitch.
     */
    @JvmName("qeicppetnjvtsiqw")
    public suspend fun ipv6CidrBlockMask(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlockMask = mapped
    }

    /**
     * @param value Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.0. New field 'vswitch_name' instead.
  """,
    )
    @JvmName("gbjtwuehpesxcjnb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tags of VSwitch.
     */
    @JvmName("hpschxaakibirqrd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of VSwitch.
     */
    @JvmName("gtateqybbpaansfw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC ID.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("yawagmjefkbjdxvf")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The name of the VSwitch.
     */
    @JvmName("qjjexukfqqilqwyb")
    public suspend fun vswitchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchName = mapped
    }

    /**
     * @param value The AZ for the VSwitch. **Note:** Required for a VPC VSwitch.
     */
    @JvmName("edgclmekuprnxcxj")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): SwitchArgs = SwitchArgs(
        availabilityZone = availabilityZone,
        cidrBlock = cidrBlock,
        description = description,
        enableIpv6 = enableIpv6,
        ipv6CidrBlockMask = ipv6CidrBlockMask,
        name = name,
        tags = tags,
        vpcId = vpcId,
        vswitchName = vswitchName,
        zoneId = zoneId,
    )
}
