@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.kotlin.outputs.TrafficMirrorFilterEgressRule
import com.pulumi.alicloud.vpc.kotlin.outputs.TrafficMirrorFilterIngressRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.vpc.kotlin.outputs.TrafficMirrorFilterEgressRule.Companion.toKotlin as trafficMirrorFilterEgressRuleToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.TrafficMirrorFilterIngressRule.Companion.toKotlin as trafficMirrorFilterIngressRuleToKotlin

/**
 * Builder for [TrafficMirrorFilter].
 */
@PulumiTagMarker
public class TrafficMirrorFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMirrorFilterArgs = TrafficMirrorFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMirrorFilterArgsBuilder.() -> Unit) {
        val builder = TrafficMirrorFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficMirrorFilter {
        val builtJavaResource = com.pulumi.alicloud.vpc.TrafficMirrorFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficMirrorFilter(builtJavaResource)
    }
}

/**
 * Provides a VPC Traffic Mirror Filter resource. Traffic mirror filter criteria.
 * For information about VPC Traffic Mirror Filter and how to use it, see [What is Traffic Mirror Filter](https://www.alibabacloud.com/help/doc-detail/207513.htm).
 * > **NOTE:** Available in v1.140.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default3iXhoa = new alicloud.resourcemanager.ResourceGroup("default3iXhoa", {
 *     displayName: "testname03",
 *     resourceGroupName: name,
 * });
 * const defaultdNz2qk = new alicloud.resourcemanager.ResourceGroup("defaultdNz2qk", {
 *     displayName: "testname04",
 *     resourceGroupName: `${name}1`,
 * });
 * const _default = new alicloud.vpc.TrafficMirrorFilter("default", {
 *     trafficMirrorFilterDescription: "test",
 *     trafficMirrorFilterName: name,
 *     resourceGroupId: default3iXhoa.id,
 *     egressRules: [{
 *         priority: 1,
 *         protocol: "TCP",
 *         action: "accept",
 *         destinationCidrBlock: "32.0.0.0/4",
 *         destinationPortRange: "80/80",
 *         sourceCidrBlock: "16.0.0.0/4",
 *         sourcePortRange: "80/80",
 *     }],
 *     ingressRules: [{
 *         priority: 1,
 *         protocol: "TCP",
 *         action: "accept",
 *         destinationCidrBlock: "10.64.0.0/10",
 *         destinationPortRange: "80/80",
 *         sourceCidrBlock: "10.0.0.0/8",
 *         sourcePortRange: "80/80",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default3i_xhoa = alicloud.resourcemanager.ResourceGroup("default3iXhoa",
 *     display_name="testname03",
 *     resource_group_name=name)
 * defaultd_nz2qk = alicloud.resourcemanager.ResourceGroup("defaultdNz2qk",
 *     display_name="testname04",
 *     resource_group_name=f"{name}1")
 * default = alicloud.vpc.TrafficMirrorFilter("default",
 *     traffic_mirror_filter_description="test",
 *     traffic_mirror_filter_name=name,
 *     resource_group_id=default3i_xhoa.id,
 *     egress_rules=[{
 *         "priority": 1,
 *         "protocol": "TCP",
 *         "action": "accept",
 *         "destination_cidr_block": "32.0.0.0/4",
 *         "destination_port_range": "80/80",
 *         "source_cidr_block": "16.0.0.0/4",
 *         "source_port_range": "80/80",
 *     }],
 *     ingress_rules=[{
 *         "priority": 1,
 *         "protocol": "TCP",
 *         "action": "accept",
 *         "destination_cidr_block": "10.64.0.0/10",
 *         "destination_port_range": "80/80",
 *         "source_cidr_block": "10.0.0.0/8",
 *         "source_port_range": "80/80",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var default3iXhoa = new AliCloud.ResourceManager.ResourceGroup("default3iXhoa", new()
 *     {
 *         DisplayName = "testname03",
 *         ResourceGroupName = name,
 *     });
 *     var defaultdNz2qk = new AliCloud.ResourceManager.ResourceGroup("defaultdNz2qk", new()
 *     {
 *         DisplayName = "testname04",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var @default = new AliCloud.Vpc.TrafficMirrorFilter("default", new()
 *     {
 *         TrafficMirrorFilterDescription = "test",
 *         TrafficMirrorFilterName = name,
 *         ResourceGroupId = default3iXhoa.Id,
 *         EgressRules = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.TrafficMirrorFilterEgressRuleArgs
 *             {
 *                 Priority = 1,
 *                 Protocol = "TCP",
 *                 Action = "accept",
 *                 DestinationCidrBlock = "32.0.0.0/4",
 *                 DestinationPortRange = "80/80",
 *                 SourceCidrBlock = "16.0.0.0/4",
 *                 SourcePortRange = "80/80",
 *             },
 *         },
 *         IngressRules = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.TrafficMirrorFilterIngressRuleArgs
 *             {
 *                 Priority = 1,
 *                 Protocol = "TCP",
 *                 Action = "accept",
 *                 DestinationCidrBlock = "10.64.0.0/10",
 *                 DestinationPortRange = "80/80",
 *                 SourceCidrBlock = "10.0.0.0/8",
 *                 SourcePortRange = "80/80",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		default3iXhoa, err := resourcemanager.NewResourceGroup(ctx, "default3iXhoa", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("testname03"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "defaultdNz2qk", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("testname04"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewTrafficMirrorFilter(ctx, "default", &vpc.TrafficMirrorFilterArgs{
 * 			TrafficMirrorFilterDescription: pulumi.String("test"),
 * 			TrafficMirrorFilterName:        pulumi.String(name),
 * 			ResourceGroupId:                default3iXhoa.ID(),
 * 			EgressRules: vpc.TrafficMirrorFilterEgressRuleTypeArray{
 * 				&vpc.TrafficMirrorFilterEgressRuleTypeArgs{
 * 					Priority:             pulumi.Int(1),
 * 					Protocol:             pulumi.String("TCP"),
 * 					Action:               pulumi.String("accept"),
 * 					DestinationCidrBlock: pulumi.String("32.0.0.0/4"),
 * 					DestinationPortRange: pulumi.String("80/80"),
 * 					SourceCidrBlock:      pulumi.String("16.0.0.0/4"),
 * 					SourcePortRange:      pulumi.String("80/80"),
 * 				},
 * 			},
 * 			IngressRules: vpc.TrafficMirrorFilterIngressRuleTypeArray{
 * 				&vpc.TrafficMirrorFilterIngressRuleTypeArgs{
 * 					Priority:             pulumi.Int(1),
 * 					Protocol:             pulumi.String("TCP"),
 * 					Action:               pulumi.String("accept"),
 * 					DestinationCidrBlock: pulumi.String("10.64.0.0/10"),
 * 					DestinationPortRange: pulumi.String("80/80"),
 * 					SourceCidrBlock:      pulumi.String("10.0.0.0/8"),
 * 					SourcePortRange:      pulumi.String("80/80"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilter;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs;
 * import com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterEgressRuleArgs;
 * import com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default3iXhoa = new ResourceGroup("default3iXhoa", ResourceGroupArgs.builder()
 *             .displayName("testname03")
 *             .resourceGroupName(name)
 *             .build());
 *         var defaultdNz2qk = new ResourceGroup("defaultdNz2qk", ResourceGroupArgs.builder()
 *             .displayName("testname04")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var default_ = new TrafficMirrorFilter("default", TrafficMirrorFilterArgs.builder()
 *             .trafficMirrorFilterDescription("test")
 *             .trafficMirrorFilterName(name)
 *             .resourceGroupId(default3iXhoa.id())
 *             .egressRules(TrafficMirrorFilterEgressRuleArgs.builder()
 *                 .priority(1)
 *                 .protocol("TCP")
 *                 .action("accept")
 *                 .destinationCidrBlock("32.0.0.0/4")
 *                 .destinationPortRange("80/80")
 *                 .sourceCidrBlock("16.0.0.0/4")
 *                 .sourcePortRange("80/80")
 *                 .build())
 *             .ingressRules(TrafficMirrorFilterIngressRuleArgs.builder()
 *                 .priority(1)
 *                 .protocol("TCP")
 *                 .action("accept")
 *                 .destinationCidrBlock("10.64.0.0/10")
 *                 .destinationPortRange("80/80")
 *                 .sourceCidrBlock("10.0.0.0/8")
 *                 .sourcePortRange("80/80")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default3iXhoa:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: testname03
 *       resourceGroupName: ${name}
 *   defaultdNz2qk:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: testname04
 *       resourceGroupName: ${name}1
 *   default:
 *     type: alicloud:vpc:TrafficMirrorFilter
 *     properties:
 *       trafficMirrorFilterDescription: test
 *       trafficMirrorFilterName: ${name}
 *       resourceGroupId: ${default3iXhoa.id}
 *       egressRules:
 *         - priority: 1
 *           protocol: TCP
 *           action: accept
 *           destinationCidrBlock: 32.0.0.0/4
 *           destinationPortRange: 80/80
 *           sourceCidrBlock: 16.0.0.0/4
 *           sourcePortRange: 80/80
 *       ingressRules:
 *         - priority: 1
 *           protocol: TCP
 *           action: accept
 *           destinationCidrBlock: 10.64.0.0/10
 *           destinationPortRange: 80/80
 *           sourceCidrBlock: 10.0.0.0/8
 *           sourcePortRange: 80/80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Traffic Mirror Filter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/trafficMirrorFilter:TrafficMirrorFilter example <id>
 * ```
 */
public class TrafficMirrorFilter internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.TrafficMirrorFilter,
) : KotlinCustomResource(javaResource, TrafficMirrorFilterMapper) {
    /**
     * Whether to PreCheck only this request. Value:
     * - **true**: The check request is sent without creating traffic Image filter conditions. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request, returns a 2xx HTTP status code after passing the check, and directly creates a filter condition.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information about the outbound rule. See the following `Block EgressRules`.
     */
    public val egressRules: Output<List<TrafficMirrorFilterEgressRule>>
        get() = javaResource.egressRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    trafficMirrorFilterEgressRuleToKotlin(args0)
                })
            })
        })

    /**
     * Inward direction rule information. See the following `Block IngressRules`.
     */
    public val ingressRules: Output<List<TrafficMirrorFilterIngressRule>>
        get() = javaResource.ingressRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    trafficMirrorFilterIngressRuleToKotlin(args0)
                })
            })
        })

    /**
     * The ID of the resource group to which the VPC belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of this resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The description of the TrafficMirrorFilter.
     */
    public val trafficMirrorFilterDescription: Output<String>?
        get() = javaResource.trafficMirrorFilterDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the TrafficMirrorFilter.
     */
    public val trafficMirrorFilterName: Output<String>?
        get() = javaResource.trafficMirrorFilterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TrafficMirrorFilterMapper : ResourceMapper<TrafficMirrorFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.TrafficMirrorFilter::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMirrorFilter = TrafficMirrorFilter(
        javaResource
            as com.pulumi.alicloud.vpc.TrafficMirrorFilter,
    )
}

/**
 * @see [TrafficMirrorFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMirrorFilter].
 */
public suspend fun trafficMirrorFilter(
    name: String,
    block: suspend TrafficMirrorFilterResourceBuilder.() -> Unit,
): TrafficMirrorFilter {
    val builder = TrafficMirrorFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMirrorFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMirrorFilter(name: String): TrafficMirrorFilter {
    val builder = TrafficMirrorFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
