@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs.builder
import com.pulumi.alicloud.vpc.kotlin.inputs.TrafficMirrorFilterEgressRuleArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.TrafficMirrorFilterEgressRuleArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.TrafficMirrorFilterIngressRuleArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.TrafficMirrorFilterIngressRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Traffic Mirror Filter resource. Traffic mirror filter criteria.
 * For information about VPC Traffic Mirror Filter and how to use it, see [What is Traffic Mirror Filter](https://www.alibabacloud.com/help/doc-detail/207513.htm).
 * > **NOTE:** Available in v1.140.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default3iXhoa = new alicloud.resourcemanager.ResourceGroup("default3iXhoa", {
 *     displayName: "testname03",
 *     resourceGroupName: name,
 * });
 * const defaultdNz2qk = new alicloud.resourcemanager.ResourceGroup("defaultdNz2qk", {
 *     displayName: "testname04",
 *     resourceGroupName: `${name}1`,
 * });
 * const _default = new alicloud.vpc.TrafficMirrorFilter("default", {
 *     trafficMirrorFilterDescription: "test",
 *     trafficMirrorFilterName: name,
 *     resourceGroupId: default3iXhoa.id,
 *     egressRules: [{
 *         priority: 1,
 *         protocol: "TCP",
 *         action: "accept",
 *         destinationCidrBlock: "32.0.0.0/4",
 *         destinationPortRange: "80/80",
 *         sourceCidrBlock: "16.0.0.0/4",
 *         sourcePortRange: "80/80",
 *     }],
 *     ingressRules: [{
 *         priority: 1,
 *         protocol: "TCP",
 *         action: "accept",
 *         destinationCidrBlock: "10.64.0.0/10",
 *         destinationPortRange: "80/80",
 *         sourceCidrBlock: "10.0.0.0/8",
 *         sourcePortRange: "80/80",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default3i_xhoa = alicloud.resourcemanager.ResourceGroup("default3iXhoa",
 *     display_name="testname03",
 *     resource_group_name=name)
 * defaultd_nz2qk = alicloud.resourcemanager.ResourceGroup("defaultdNz2qk",
 *     display_name="testname04",
 *     resource_group_name=f"{name}1")
 * default = alicloud.vpc.TrafficMirrorFilter("default",
 *     traffic_mirror_filter_description="test",
 *     traffic_mirror_filter_name=name,
 *     resource_group_id=default3i_xhoa.id,
 *     egress_rules=[{
 *         "priority": 1,
 *         "protocol": "TCP",
 *         "action": "accept",
 *         "destination_cidr_block": "32.0.0.0/4",
 *         "destination_port_range": "80/80",
 *         "source_cidr_block": "16.0.0.0/4",
 *         "source_port_range": "80/80",
 *     }],
 *     ingress_rules=[{
 *         "priority": 1,
 *         "protocol": "TCP",
 *         "action": "accept",
 *         "destination_cidr_block": "10.64.0.0/10",
 *         "destination_port_range": "80/80",
 *         "source_cidr_block": "10.0.0.0/8",
 *         "source_port_range": "80/80",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var default3iXhoa = new AliCloud.ResourceManager.ResourceGroup("default3iXhoa", new()
 *     {
 *         DisplayName = "testname03",
 *         ResourceGroupName = name,
 *     });
 *     var defaultdNz2qk = new AliCloud.ResourceManager.ResourceGroup("defaultdNz2qk", new()
 *     {
 *         DisplayName = "testname04",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var @default = new AliCloud.Vpc.TrafficMirrorFilter("default", new()
 *     {
 *         TrafficMirrorFilterDescription = "test",
 *         TrafficMirrorFilterName = name,
 *         ResourceGroupId = default3iXhoa.Id,
 *         EgressRules = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.TrafficMirrorFilterEgressRuleArgs
 *             {
 *                 Priority = 1,
 *                 Protocol = "TCP",
 *                 Action = "accept",
 *                 DestinationCidrBlock = "32.0.0.0/4",
 *                 DestinationPortRange = "80/80",
 *                 SourceCidrBlock = "16.0.0.0/4",
 *                 SourcePortRange = "80/80",
 *             },
 *         },
 *         IngressRules = new[]
 *         {
 *             new AliCloud.Vpc.Inputs.TrafficMirrorFilterIngressRuleArgs
 *             {
 *                 Priority = 1,
 *                 Protocol = "TCP",
 *                 Action = "accept",
 *                 DestinationCidrBlock = "10.64.0.0/10",
 *                 DestinationPortRange = "80/80",
 *                 SourceCidrBlock = "10.0.0.0/8",
 *                 SourcePortRange = "80/80",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		default3iXhoa, err := resourcemanager.NewResourceGroup(ctx, "default3iXhoa", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("testname03"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "defaultdNz2qk", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("testname04"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewTrafficMirrorFilter(ctx, "default", &vpc.TrafficMirrorFilterArgs{
 * 			TrafficMirrorFilterDescription: pulumi.String("test"),
 * 			TrafficMirrorFilterName:        pulumi.String(name),
 * 			ResourceGroupId:                default3iXhoa.ID(),
 * 			EgressRules: vpc.TrafficMirrorFilterEgressRuleTypeArray{
 * 				&vpc.TrafficMirrorFilterEgressRuleTypeArgs{
 * 					Priority:             pulumi.Int(1),
 * 					Protocol:             pulumi.String("TCP"),
 * 					Action:               pulumi.String("accept"),
 * 					DestinationCidrBlock: pulumi.String("32.0.0.0/4"),
 * 					DestinationPortRange: pulumi.String("80/80"),
 * 					SourceCidrBlock:      pulumi.String("16.0.0.0/4"),
 * 					SourcePortRange:      pulumi.String("80/80"),
 * 				},
 * 			},
 * 			IngressRules: vpc.TrafficMirrorFilterIngressRuleTypeArray{
 * 				&vpc.TrafficMirrorFilterIngressRuleTypeArgs{
 * 					Priority:             pulumi.Int(1),
 * 					Protocol:             pulumi.String("TCP"),
 * 					Action:               pulumi.String("accept"),
 * 					DestinationCidrBlock: pulumi.String("10.64.0.0/10"),
 * 					DestinationPortRange: pulumi.String("80/80"),
 * 					SourceCidrBlock:      pulumi.String("10.0.0.0/8"),
 * 					SourcePortRange:      pulumi.String("80/80"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilter;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs;
 * import com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterEgressRuleArgs;
 * import com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default3iXhoa = new ResourceGroup("default3iXhoa", ResourceGroupArgs.builder()
 *             .displayName("testname03")
 *             .resourceGroupName(name)
 *             .build());
 *         var defaultdNz2qk = new ResourceGroup("defaultdNz2qk", ResourceGroupArgs.builder()
 *             .displayName("testname04")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var default_ = new TrafficMirrorFilter("default", TrafficMirrorFilterArgs.builder()
 *             .trafficMirrorFilterDescription("test")
 *             .trafficMirrorFilterName(name)
 *             .resourceGroupId(default3iXhoa.id())
 *             .egressRules(TrafficMirrorFilterEgressRuleArgs.builder()
 *                 .priority(1)
 *                 .protocol("TCP")
 *                 .action("accept")
 *                 .destinationCidrBlock("32.0.0.0/4")
 *                 .destinationPortRange("80/80")
 *                 .sourceCidrBlock("16.0.0.0/4")
 *                 .sourcePortRange("80/80")
 *                 .build())
 *             .ingressRules(TrafficMirrorFilterIngressRuleArgs.builder()
 *                 .priority(1)
 *                 .protocol("TCP")
 *                 .action("accept")
 *                 .destinationCidrBlock("10.64.0.0/10")
 *                 .destinationPortRange("80/80")
 *                 .sourceCidrBlock("10.0.0.0/8")
 *                 .sourcePortRange("80/80")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default3iXhoa:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: testname03
 *       resourceGroupName: ${name}
 *   defaultdNz2qk:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: testname04
 *       resourceGroupName: ${name}1
 *   default:
 *     type: alicloud:vpc:TrafficMirrorFilter
 *     properties:
 *       trafficMirrorFilterDescription: test
 *       trafficMirrorFilterName: ${name}
 *       resourceGroupId: ${default3iXhoa.id}
 *       egressRules:
 *         - priority: 1
 *           protocol: TCP
 *           action: accept
 *           destinationCidrBlock: 32.0.0.0/4
 *           destinationPortRange: 80/80
 *           sourceCidrBlock: 16.0.0.0/4
 *           sourcePortRange: 80/80
 *       ingressRules:
 *         - priority: 1
 *           protocol: TCP
 *           action: accept
 *           destinationCidrBlock: 10.64.0.0/10
 *           destinationPortRange: 80/80
 *           sourceCidrBlock: 10.0.0.0/8
 *           sourcePortRange: 80/80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Traffic Mirror Filter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/trafficMirrorFilter:TrafficMirrorFilter example <id>
 * ```
 * @property dryRun Whether to PreCheck only this request. Value:
 * - **true**: The check request is sent without creating traffic Image filter conditions. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
 * - **false** (default): Sends a normal request, returns a 2xx HTTP status code after passing the check, and directly creates a filter condition.
 * @property egressRules Information about the outbound rule. See the following `Block EgressRules`.
 * @property ingressRules Inward direction rule information. See the following `Block IngressRules`.
 * @property resourceGroupId The ID of the resource group to which the VPC belongs.
 * @property tags The tags of this resource.
 * @property trafficMirrorFilterDescription The description of the TrafficMirrorFilter.
 * @property trafficMirrorFilterName The name of the TrafficMirrorFilter.
 */
public data class TrafficMirrorFilterArgs(
    public val dryRun: Output<Boolean>? = null,
    public val egressRules: Output<List<TrafficMirrorFilterEgressRuleArgs>>? = null,
    public val ingressRules: Output<List<TrafficMirrorFilterIngressRuleArgs>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficMirrorFilterDescription: Output<String>? = null,
    public val trafficMirrorFilterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs =
        com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .egressRules(
                egressRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingressRules(
                ingressRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficMirrorFilterDescription(trafficMirrorFilterDescription?.applyValue({ args0 -> args0 }))
            .trafficMirrorFilterName(trafficMirrorFilterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMirrorFilterArgs].
 */
@PulumiTagMarker
public class TrafficMirrorFilterArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var egressRules: Output<List<TrafficMirrorFilterEgressRuleArgs>>? = null

    private var ingressRules: Output<List<TrafficMirrorFilterIngressRuleArgs>>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficMirrorFilterDescription: Output<String>? = null

    private var trafficMirrorFilterName: Output<String>? = null

    /**
     * @param value Whether to PreCheck only this request. Value:
     * - **true**: The check request is sent without creating traffic Image filter conditions. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request, returns a 2xx HTTP status code after passing the check, and directly creates a filter condition.
     */
    @JvmName("emxufkqqcgeximty")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("gdraxbbqcleviqiy")
    public suspend fun egressRules(`value`: Output<List<TrafficMirrorFilterEgressRuleArgs>>) {
        this.egressRules = value
    }

    @JvmName("nrgdhqqajjrhuuhy")
    public suspend fun egressRules(vararg values: Output<TrafficMirrorFilterEgressRuleArgs>) {
        this.egressRules = Output.all(values.asList())
    }

    /**
     * @param values Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("ilimuwgkhvfmlbbm")
    public suspend fun egressRules(values: List<Output<TrafficMirrorFilterEgressRuleArgs>>) {
        this.egressRules = Output.all(values)
    }

    /**
     * @param value Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("fkmsgegdgqmxwofa")
    public suspend fun ingressRules(`value`: Output<List<TrafficMirrorFilterIngressRuleArgs>>) {
        this.ingressRules = value
    }

    @JvmName("rqoqesiarejkhagq")
    public suspend fun ingressRules(vararg values: Output<TrafficMirrorFilterIngressRuleArgs>) {
        this.ingressRules = Output.all(values.asList())
    }

    /**
     * @param values Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("ofeqexdedussvvqe")
    public suspend fun ingressRules(values: List<Output<TrafficMirrorFilterIngressRuleArgs>>) {
        this.ingressRules = Output.all(values)
    }

    /**
     * @param value The ID of the resource group to which the VPC belongs.
     */
    @JvmName("fjcxydfkrtbvqjos")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tags of this resource.
     */
    @JvmName("ahvulnwvqsixdweu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the TrafficMirrorFilter.
     */
    @JvmName("iudujctjctotmlbn")
    public suspend fun trafficMirrorFilterDescription(`value`: Output<String>) {
        this.trafficMirrorFilterDescription = value
    }

    /**
     * @param value The name of the TrafficMirrorFilter.
     */
    @JvmName("rdrayhrfmfrkjtdl")
    public suspend fun trafficMirrorFilterName(`value`: Output<String>) {
        this.trafficMirrorFilterName = value
    }

    /**
     * @param value Whether to PreCheck only this request. Value:
     * - **true**: The check request is sent without creating traffic Image filter conditions. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request, returns a 2xx HTTP status code after passing the check, and directly creates a filter condition.
     */
    @JvmName("vjocvmfdnwklnadr")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("velpnnqrysghvyxq")
    public suspend fun egressRules(`value`: List<TrafficMirrorFilterEgressRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressRules = mapped
    }

    /**
     * @param argument Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("snhanotvttwhoayp")
    public suspend fun egressRules(argument: List<suspend TrafficMirrorFilterEgressRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficMirrorFilterEgressRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.egressRules = mapped
    }

    /**
     * @param argument Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("eytlujcwhjydpvgo")
    public suspend fun egressRules(vararg argument: suspend TrafficMirrorFilterEgressRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrafficMirrorFilterEgressRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.egressRules = mapped
    }

    /**
     * @param argument Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("wjbgevksinjgpnbo")
    public suspend fun egressRules(argument: suspend TrafficMirrorFilterEgressRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TrafficMirrorFilterEgressRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.egressRules = mapped
    }

    /**
     * @param values Information about the outbound rule. See the following `Block EgressRules`.
     */
    @JvmName("kyhqaslstsvwuwcr")
    public suspend fun egressRules(vararg values: TrafficMirrorFilterEgressRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressRules = mapped
    }

    /**
     * @param value Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("wrafydafdnewnyne")
    public suspend fun ingressRules(`value`: List<TrafficMirrorFilterIngressRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressRules = mapped
    }

    /**
     * @param argument Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("tlwlwcurqurqaikg")
    public suspend fun ingressRules(argument: List<suspend TrafficMirrorFilterIngressRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficMirrorFilterIngressRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ingressRules = mapped
    }

    /**
     * @param argument Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("fqxyqwclbqgwnnec")
    public suspend fun ingressRules(vararg argument: suspend TrafficMirrorFilterIngressRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrafficMirrorFilterIngressRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ingressRules = mapped
    }

    /**
     * @param argument Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("vygoucsxuasubsnc")
    public suspend fun ingressRules(argument: suspend TrafficMirrorFilterIngressRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TrafficMirrorFilterIngressRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ingressRules = mapped
    }

    /**
     * @param values Inward direction rule information. See the following `Block IngressRules`.
     */
    @JvmName("ttdjvdtrgpjbayla")
    public suspend fun ingressRules(vararg values: TrafficMirrorFilterIngressRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingressRules = mapped
    }

    /**
     * @param value The ID of the resource group to which the VPC belongs.
     */
    @JvmName("rqkkgayrubryqaym")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tags of this resource.
     */
    @JvmName("hnbhcceljajkreyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of this resource.
     */
    @JvmName("gpsuetlophfybcdt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The description of the TrafficMirrorFilter.
     */
    @JvmName("rroammqraxgtyckx")
    public suspend fun trafficMirrorFilterDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterDescription = mapped
    }

    /**
     * @param value The name of the TrafficMirrorFilter.
     */
    @JvmName("bplbsvfjkpdvecdf")
    public suspend fun trafficMirrorFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterName = mapped
    }

    internal fun build(): TrafficMirrorFilterArgs = TrafficMirrorFilterArgs(
        dryRun = dryRun,
        egressRules = egressRules,
        ingressRules = ingressRules,
        resourceGroupId = resourceGroupId,
        tags = tags,
        trafficMirrorFilterDescription = trafficMirrorFilterDescription,
        trafficMirrorFilterName = trafficMirrorFilterName,
    )
}
