@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficMirrorFilterEgressRule].
 */
@PulumiTagMarker
public class TrafficMirrorFilterEgressRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMirrorFilterEgressRuleArgs = TrafficMirrorFilterEgressRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMirrorFilterEgressRuleArgsBuilder.() -> Unit) {
        val builder = TrafficMirrorFilterEgressRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficMirrorFilterEgressRule {
        val builtJavaResource =
            com.pulumi.alicloud.vpc.TrafficMirrorFilterEgressRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrafficMirrorFilterEgressRule(builtJavaResource)
    }
}

/**
 * Provides a VPC Traffic Mirror Filter Egress Rule resource.
 * For information about VPC Traffic Mirror Filter Egress Rule and how to use it, see [What is Traffic Mirror Filter Egress Rule](https://www.alibabacloud.com/help/doc-detail/261357.htm).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.vpc.TrafficMirrorFilter("example", {trafficMirrorFilterName: "example_value"});
 * const _default = new alicloud.vpc.TrafficMirrorFilterEgressRule("default", {
 *     action: "drop",
 *     priority: 2,
 *     sourceCidrBlock: "10.0.0.0/11",
 *     destinationCidrBlock: "10.0.0.0/12",
 *     trafficMirrorFilterId: example.id,
 *     protocol: "ALL",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.vpc.TrafficMirrorFilter("example", traffic_mirror_filter_name="example_value")
 * default = alicloud.vpc.TrafficMirrorFilterEgressRule("default",
 *     action="drop",
 *     priority=2,
 *     source_cidr_block="10.0.0.0/11",
 *     destination_cidr_block="10.0.0.0/12",
 *     traffic_mirror_filter_id=example.id,
 *     protocol="ALL")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Vpc.TrafficMirrorFilter("example", new()
 *     {
 *         TrafficMirrorFilterName = "example_value",
 *     });
 *     var @default = new AliCloud.Vpc.TrafficMirrorFilterEgressRule("default", new()
 *     {
 *         Action = "drop",
 *         Priority = 2,
 *         SourceCidrBlock = "10.0.0.0/11",
 *         DestinationCidrBlock = "10.0.0.0/12",
 *         TrafficMirrorFilterId = example.Id,
 *         Protocol = "ALL",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := vpc.NewTrafficMirrorFilter(ctx, "example", &vpc.TrafficMirrorFilterArgs{
 * 			TrafficMirrorFilterName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewTrafficMirrorFilterEgressRule(ctx, "default", &vpc.TrafficMirrorFilterEgressRuleArgs{
 * 			Action:                pulumi.String("drop"),
 * 			Priority:              pulumi.Int(2),
 * 			SourceCidrBlock:       pulumi.String("10.0.0.0/11"),
 * 			DestinationCidrBlock:  pulumi.String("10.0.0.0/12"),
 * 			TrafficMirrorFilterId: example.ID(),
 * 			Protocol:              pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilter;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterEgressRule;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterEgressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrafficMirrorFilter("example", TrafficMirrorFilterArgs.builder()
 *             .trafficMirrorFilterName("example_value")
 *             .build());
 *         var default_ = new TrafficMirrorFilterEgressRule("default", TrafficMirrorFilterEgressRuleArgs.builder()
 *             .action("drop")
 *             .priority("2")
 *             .sourceCidrBlock("10.0.0.0/11")
 *             .destinationCidrBlock("10.0.0.0/12")
 *             .trafficMirrorFilterId(example.id())
 *             .protocol("ALL")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:TrafficMirrorFilter
 *     properties:
 *       trafficMirrorFilterName: example_value
 *   default:
 *     type: alicloud:vpc:TrafficMirrorFilterEgressRule
 *     properties:
 *       action: drop
 *       priority: '2'
 *       sourceCidrBlock: 10.0.0.0/11
 *       destinationCidrBlock: 10.0.0.0/12
 *       trafficMirrorFilterId: ${example.id}
 *       protocol: ALL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Traffic Mirror Filter Egress Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/trafficMirrorFilterEgressRule:TrafficMirrorFilterEgressRule example <traffic_mirror_filter_id>:<traffic_mirror_filter_egress_rule_id>
 * ```
 */
public class TrafficMirrorFilterEgressRule internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.TrafficMirrorFilterEgressRule,
) : KotlinCustomResource(javaResource, TrafficMirrorFilterEgressRuleMapper) {
    /**
     * The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The destination CIDR block of the outbound traffic.
     */
    public val destinationCidrBlock: Output<String>
        get() = javaResource.destinationCidrBlock().applyValue({ args0 -> args0 })

    /**
     * The destination CIDR block of the outbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
     */
    public val destinationPortRange: Output<String>
        get() = javaResource.destinationPortRange().applyValue({ args0 -> args0 })

    /**
     * Whether to PreCheck this request only. Value:
     * - **true**: sends a check request and does not create inbound or outbound rules. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request and directly creates an inbound or outbound direction rule after checking.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The transport protocol used by outbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * . Field 'rule_action' has been deprecated from provider version 1.211.0. New field 'action' instead.
     */
    @Deprecated(
        message = """
  Field 'rule_action' has been deprecated since provider version 1.211.0. New field 'action'
      instead.
  """,
    )
    public val ruleAction: Output<String>
        get() = javaResource.ruleAction().applyValue({ args0 -> args0 })

    /**
     * The source CIDR block of the outbound traffic.
     */
    public val sourceCidrBlock: Output<String>
        get() = javaResource.sourceCidrBlock().applyValue({ args0 -> args0 })

    /**
     * The source port range of the outbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
     */
    public val sourcePortRange: Output<String>
        get() = javaResource.sourcePortRange().applyValue({ args0 -> args0 })

    /**
     * The state of the inbound rule. `Creating`, `Created`, `Modifying` and `Deleting`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the outbound rule.
     */
    public val trafficMirrorFilterEgressRuleId: Output<String>
        get() = javaResource.trafficMirrorFilterEgressRuleId().applyValue({ args0 -> args0 })

    /**
     * The ID of the filter.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val trafficMirrorFilterId: Output<String>
        get() = javaResource.trafficMirrorFilterId().applyValue({ args0 -> args0 })
}

public object TrafficMirrorFilterEgressRuleMapper : ResourceMapper<TrafficMirrorFilterEgressRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.TrafficMirrorFilterEgressRule::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMirrorFilterEgressRule =
        TrafficMirrorFilterEgressRule(
            javaResource as
                com.pulumi.alicloud.vpc.TrafficMirrorFilterEgressRule,
        )
}

/**
 * @see [TrafficMirrorFilterEgressRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMirrorFilterEgressRule].
 */
public suspend fun trafficMirrorFilterEgressRule(
    name: String,
    block: suspend TrafficMirrorFilterEgressRuleResourceBuilder.() -> Unit,
): TrafficMirrorFilterEgressRule {
    val builder = TrafficMirrorFilterEgressRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMirrorFilterEgressRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMirrorFilterEgressRule(name: String): TrafficMirrorFilterEgressRule {
    val builder = TrafficMirrorFilterEgressRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
