@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.TrafficMirrorFilterIngressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Traffic Mirror Filter Ingress Rule resource. Traffic mirror entry rule.
 * For information about VPC Traffic Mirror Filter Ingress Rule and how to use it, see [What is Traffic Mirror Filter Ingress Rule](https://www.alibabacloud.com/help/doc-detail/261357.htm).
 * > **NOTE:** Available since v1.141.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.vpc.TrafficMirrorFilter("example", {trafficMirrorFilterName: "example_value"});
 * const exampleTrafficMirrorFilterIngressRule = new alicloud.vpc.TrafficMirrorFilterIngressRule("example", {
 *     trafficMirrorFilterId: example.id,
 *     priority: 1,
 *     ruleAction: "accept",
 *     protocol: "UDP",
 *     destinationCidrBlock: "10.0.0.0/24",
 *     sourceCidrBlock: "10.0.0.0/24",
 *     destinationPortRange: "1/120",
 *     sourcePortRange: "1/120",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.vpc.TrafficMirrorFilter("example", traffic_mirror_filter_name="example_value")
 * example_traffic_mirror_filter_ingress_rule = alicloud.vpc.TrafficMirrorFilterIngressRule("example",
 *     traffic_mirror_filter_id=example.id,
 *     priority=1,
 *     rule_action="accept",
 *     protocol="UDP",
 *     destination_cidr_block="10.0.0.0/24",
 *     source_cidr_block="10.0.0.0/24",
 *     destination_port_range="1/120",
 *     source_port_range="1/120")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Vpc.TrafficMirrorFilter("example", new()
 *     {
 *         TrafficMirrorFilterName = "example_value",
 *     });
 *     var exampleTrafficMirrorFilterIngressRule = new AliCloud.Vpc.TrafficMirrorFilterIngressRule("example", new()
 *     {
 *         TrafficMirrorFilterId = example.Id,
 *         Priority = 1,
 *         RuleAction = "accept",
 *         Protocol = "UDP",
 *         DestinationCidrBlock = "10.0.0.0/24",
 *         SourceCidrBlock = "10.0.0.0/24",
 *         DestinationPortRange = "1/120",
 *         SourcePortRange = "1/120",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := vpc.NewTrafficMirrorFilter(ctx, "example", &vpc.TrafficMirrorFilterArgs{
 * 			TrafficMirrorFilterName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewTrafficMirrorFilterIngressRule(ctx, "example", &vpc.TrafficMirrorFilterIngressRuleArgs{
 * 			TrafficMirrorFilterId: example.ID(),
 * 			Priority:              pulumi.Int(1),
 * 			RuleAction:            pulumi.String("accept"),
 * 			Protocol:              pulumi.String("UDP"),
 * 			DestinationCidrBlock:  pulumi.String("10.0.0.0/24"),
 * 			SourceCidrBlock:       pulumi.String("10.0.0.0/24"),
 * 			DestinationPortRange:  pulumi.String("1/120"),
 * 			SourcePortRange:       pulumi.String("1/120"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilter;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterArgs;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterIngressRule;
 * import com.pulumi.alicloud.vpc.TrafficMirrorFilterIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrafficMirrorFilter("example", TrafficMirrorFilterArgs.builder()
 *             .trafficMirrorFilterName("example_value")
 *             .build());
 *         var exampleTrafficMirrorFilterIngressRule = new TrafficMirrorFilterIngressRule("exampleTrafficMirrorFilterIngressRule", TrafficMirrorFilterIngressRuleArgs.builder()
 *             .trafficMirrorFilterId(example.id())
 *             .priority("1")
 *             .ruleAction("accept")
 *             .protocol("UDP")
 *             .destinationCidrBlock("10.0.0.0/24")
 *             .sourceCidrBlock("10.0.0.0/24")
 *             .destinationPortRange("1/120")
 *             .sourcePortRange("1/120")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:TrafficMirrorFilter
 *     properties:
 *       trafficMirrorFilterName: example_value
 *   exampleTrafficMirrorFilterIngressRule:
 *     type: alicloud:vpc:TrafficMirrorFilterIngressRule
 *     name: example
 *     properties:
 *       trafficMirrorFilterId: ${example.id}
 *       priority: '1'
 *       ruleAction: accept
 *       protocol: UDP
 *       destinationCidrBlock: 10.0.0.0/24
 *       sourceCidrBlock: 10.0.0.0/24
 *       destinationPortRange: 1/120
 *       sourcePortRange: 1/120
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Traffic Mirror Filter Ingress Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/trafficMirrorFilterIngressRule:TrafficMirrorFilterIngressRule example <traffic_mirror_filter_id>:<traffic_mirror_filter_ingress_rule_id>
 * ```
 * @property action The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
 * @property destinationCidrBlock The destination CIDR block of the inbound traffic.
 * @property destinationPortRange The destination CIDR block of the inbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
 * @property dryRun Whether to PreCheck this request only. Value:
 * - **true**: sends a check request and does not create inbound or outbound rules. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
 * - **false** (default): Sends a normal request and directly creates an inbound or outbound direction rule after checking.
 * @property priority The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
 * @property protocol The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
 * @property ruleAction . Field 'rule_action' has been deprecated from provider version 1.211.0. New field 'action' instead.
 * @property sourceCidrBlock The source CIDR block of the inbound traffic.
 * @property sourcePortRange The source port range of the inbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
 * @property trafficMirrorFilterId The ID of the filter.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class TrafficMirrorFilterIngressRuleArgs(
    public val action: Output<String>? = null,
    public val destinationCidrBlock: Output<String>? = null,
    public val destinationPortRange: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'rule_action' has been deprecated since provider version 1.211.0. New field 'action'
      instead.
  """,
    )
    public val ruleAction: Output<String>? = null,
    public val sourceCidrBlock: Output<String>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val trafficMirrorFilterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.TrafficMirrorFilterIngressRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.TrafficMirrorFilterIngressRuleArgs =
        com.pulumi.alicloud.vpc.TrafficMirrorFilterIngressRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .ruleAction(ruleAction?.applyValue({ args0 -> args0 }))
            .sourceCidrBlock(sourceCidrBlock?.applyValue({ args0 -> args0 }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .trafficMirrorFilterId(trafficMirrorFilterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMirrorFilterIngressRuleArgs].
 */
@PulumiTagMarker
public class TrafficMirrorFilterIngressRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var destinationCidrBlock: Output<String>? = null

    private var destinationPortRange: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var ruleAction: Output<String>? = null

    private var sourceCidrBlock: Output<String>? = null

    private var sourcePortRange: Output<String>? = null

    private var trafficMirrorFilterId: Output<String>? = null

    /**
     * @param value The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
     */
    @JvmName("njlaxwkihsywdabk")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The destination CIDR block of the inbound traffic.
     */
    @JvmName("ioabaoyttdtxaiut")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value The destination CIDR block of the inbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
     */
    @JvmName("mckaaxptapjplers")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value Whether to PreCheck this request only. Value:
     * - **true**: sends a check request and does not create inbound or outbound rules. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request and directly creates an inbound or outbound direction rule after checking.
     */
    @JvmName("tebowwrgpxdoyxdh")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
     */
    @JvmName("wpxwhlggdigbwfxc")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
     */
    @JvmName("aggilgbefrrkwfvh")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value . Field 'rule_action' has been deprecated from provider version 1.211.0. New field 'action' instead.
     */
    @Deprecated(
        message = """
  Field 'rule_action' has been deprecated since provider version 1.211.0. New field 'action'
      instead.
  """,
    )
    @JvmName("lspwalmgusonhbtn")
    public suspend fun ruleAction(`value`: Output<String>) {
        this.ruleAction = value
    }

    /**
     * @param value The source CIDR block of the inbound traffic.
     */
    @JvmName("itcakxntakpmxegx")
    public suspend fun sourceCidrBlock(`value`: Output<String>) {
        this.sourceCidrBlock = value
    }

    /**
     * @param value The source port range of the inbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
     */
    @JvmName("nofdypwgrcfxyxdi")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The ID of the filter.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("snutlxprochhbcir")
    public suspend fun trafficMirrorFilterId(`value`: Output<String>) {
        this.trafficMirrorFilterId = value
    }

    /**
     * @param value The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
     */
    @JvmName("devocpdoljwcofok")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The destination CIDR block of the inbound traffic.
     */
    @JvmName("cpanmhmqfshkgitd")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value The destination CIDR block of the inbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
     */
    @JvmName("pwctueagunkhuskn")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value Whether to PreCheck this request only. Value:
     * - **true**: sends a check request and does not create inbound or outbound rules. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request and directly creates an inbound or outbound direction rule after checking.
     */
    @JvmName("wlsbiaohrsxgpueq")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
     */
    @JvmName("qpxjqhaxafyoqmcs")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
     */
    @JvmName("hielhwxexdynvkun")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value . Field 'rule_action' has been deprecated from provider version 1.211.0. New field 'action' instead.
     */
    @Deprecated(
        message = """
  Field 'rule_action' has been deprecated since provider version 1.211.0. New field 'action'
      instead.
  """,
    )
    @JvmName("ramyrxtbaulrqxsn")
    public suspend fun ruleAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleAction = mapped
    }

    /**
     * @param value The source CIDR block of the inbound traffic.
     */
    @JvmName("grnksmhhpuswkhjy")
    public suspend fun sourceCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidrBlock = mapped
    }

    /**
     * @param value The source port range of the inbound traffic. Valid values: `1` to `65535`. Separate the first port and last port with a forward slash (/), for example, `1/200` or `80/80`. A value of `-1/-1` indicates that all ports are available. Therefore, do not set the value to `-1/-1`. **NOTE:** When `protocol` is `ICMP`, this parameter is invalid.
     */
    @JvmName("lwhvvfgbfjtqvyce")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value The ID of the filter.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("ehxojupnjavcpdjo")
    public suspend fun trafficMirrorFilterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterId = mapped
    }

    internal fun build(): TrafficMirrorFilterIngressRuleArgs = TrafficMirrorFilterIngressRuleArgs(
        action = action,
        destinationCidrBlock = destinationCidrBlock,
        destinationPortRange = destinationPortRange,
        dryRun = dryRun,
        priority = priority,
        protocol = protocol,
        ruleAction = ruleAction,
        sourceCidrBlock = sourceCidrBlock,
        sourcePortRange = sourcePortRange,
        trafficMirrorFilterId = trafficMirrorFilterId,
    )
}
