@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VbrHa].
 */
@PulumiTagMarker
public class VbrHaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VbrHaArgs = VbrHaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VbrHaArgsBuilder.() -> Unit) {
        val builder = VbrHaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VbrHa {
        val builtJavaResource = com.pulumi.alicloud.vpc.VbrHa(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VbrHa(builtJavaResource)
    }
}

/**
 * Provides a VPC Vbr Ha resource.
 * For information about VPC Vbr Ha and how to use it, see [What is Vbr Ha](https://www.alibabacloud.com/help/doc-detail/212629.html).
 * > **NOTE:** Available since v1.151.0.
 * ## Import
 * VPC Vbr Ha can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/vbrHa:VbrHa example <id>
 * ```
 */
public class VbrHa internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.VbrHa,
) : KotlinCustomResource(javaResource, VbrHaMapper) {
    /**
     * The description of the VBR switching group. It must be `2` to `256` characters in length and must start with a letter or Chinese, but cannot start with `https://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the other VBR in the VBR failover group.
     */
    public val peerVbrId: Output<String>
        get() = javaResource.peerVbrId().applyValue({ args0 -> args0 })

    /**
     * The state of the VBR failover group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The name of the VBR failover group.
     */
    public val vbrHaName: Output<String>?
        get() = javaResource.vbrHaName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the VBR instance.
     */
    public val vbrId: Output<String>
        get() = javaResource.vbrId().applyValue({ args0 -> args0 })
}

public object VbrHaMapper : ResourceMapper<VbrHa> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.VbrHa::class == javaResource::class

    override fun map(javaResource: Resource): VbrHa = VbrHa(
        javaResource as
            com.pulumi.alicloud.vpc.VbrHa,
    )
}

/**
 * @see [VbrHa].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VbrHa].
 */
public suspend fun vbrHa(name: String, block: suspend VbrHaResourceBuilder.() -> Unit): VbrHa {
    val builder = VbrHaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VbrHa].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vbrHa(name: String): VbrHa {
    val builder = VbrHaResourceBuilder()
    builder.name(name)
    return builder.build()
}
