@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.VbrHaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Vbr Ha resource.
 * For information about VPC Vbr Ha and how to use it, see [What is Vbr Ha](https://www.alibabacloud.com/help/doc-detail/212629.html).
 * > **NOTE:** Available since v1.151.0.
 * ## Import
 * VPC Vbr Ha can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/vbrHa:VbrHa example <id>
 * ```
 * @property description The description of the VBR switching group. It must be `2` to `256` characters in length and must start with a letter or Chinese, but cannot start with `https://` or `https://`.
 * @property dryRun The dry run.
 * @property peerVbrId The ID of the other VBR in the VBR failover group.
 * @property vbrHaName The name of the VBR failover group.
 * @property vbrId The ID of the VBR instance.
 */
public data class VbrHaArgs(
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val peerVbrId: Output<String>? = null,
    public val vbrHaName: Output<String>? = null,
    public val vbrId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.VbrHaArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.VbrHaArgs =
        com.pulumi.alicloud.vpc.VbrHaArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .peerVbrId(peerVbrId?.applyValue({ args0 -> args0 }))
            .vbrHaName(vbrHaName?.applyValue({ args0 -> args0 }))
            .vbrId(vbrId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VbrHaArgs].
 */
@PulumiTagMarker
public class VbrHaArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var peerVbrId: Output<String>? = null

    private var vbrHaName: Output<String>? = null

    private var vbrId: Output<String>? = null

    /**
     * @param value The description of the VBR switching group. It must be `2` to `256` characters in length and must start with a letter or Chinese, but cannot start with `https://` or `https://`.
     */
    @JvmName("yeipvqtrbqcjaemu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("jqjxyhgwkjglbkou")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the other VBR in the VBR failover group.
     */
    @JvmName("ihdjoemlahntnliu")
    public suspend fun peerVbrId(`value`: Output<String>) {
        this.peerVbrId = value
    }

    /**
     * @param value The name of the VBR failover group.
     */
    @JvmName("ltmjhkltblhbvrfe")
    public suspend fun vbrHaName(`value`: Output<String>) {
        this.vbrHaName = value
    }

    /**
     * @param value The ID of the VBR instance.
     */
    @JvmName("hehegvcanwfoaqja")
    public suspend fun vbrId(`value`: Output<String>) {
        this.vbrId = value
    }

    /**
     * @param value The description of the VBR switching group. It must be `2` to `256` characters in length and must start with a letter or Chinese, but cannot start with `https://` or `https://`.
     */
    @JvmName("spqhwcagdrylyjfs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("jajsfgucwnbclcpk")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the other VBR in the VBR failover group.
     */
    @JvmName("imnwqonrdowldpkd")
    public suspend fun peerVbrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerVbrId = mapped
    }

    /**
     * @param value The name of the VBR failover group.
     */
    @JvmName("lencxjrsaerdajmq")
    public suspend fun vbrHaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vbrHaName = mapped
    }

    /**
     * @param value The ID of the VBR instance.
     */
    @JvmName("hkghjftcuteettiv")
    public suspend fun vbrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vbrId = mapped
    }

    internal fun build(): VbrHaArgs = VbrHaArgs(
        description = description,
        dryRun = dryRun,
        peerVbrId = peerVbrId,
        vbrHaName = vbrHaName,
        vbrId = vbrId,
    )
}
