@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.VpcFunctions.getBgpGroupsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getBgpNetworksPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getBgpPeersPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getCommonBandwidthPackagesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getDhcpOptionsSetsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getEnhancedNatAvailableZonesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getFlowLogServicePlain
import com.pulumi.alicloud.vpc.VpcFunctions.getForwardEntriesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getHavipsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getIpsecServersPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getIpv4GatewaysPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getIpv6AddressesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getIpv6EgressRulesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getIpv6GatewaysPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getIpv6InternetBandwidthsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getNatGatewaysPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getNatIpCidrsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getNatIpsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getNetworkAclsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getNetworksPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getPbrRouteEntriesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getPeerConnectionsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getPrefixListsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getPublicIpAddressPoolCidrBlocksPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getPublicIpAddressPoolsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getRouteEntriesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getRouteTablesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getRouterInterfacesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getSnatEntriesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getSslVpnClientCertsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getSslVpnServersPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getSwitchesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getTrafficMirrorFilterEgressRulesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getTrafficMirrorFilterIngressRulesPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getTrafficMirrorFiltersPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getTrafficMirrorServicePlain
import com.pulumi.alicloud.vpc.VpcFunctions.getTrafficMirrorSessionsPlain
import com.pulumi.alicloud.vpc.VpcFunctions.getVpcFlowLogsPlain
import com.pulumi.alicloud.vpc.kotlin.inputs.GetBgpGroupsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetBgpGroupsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetBgpNetworksPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetBgpNetworksPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetBgpPeersPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetBgpPeersPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetCommonBandwidthPackagesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetCommonBandwidthPackagesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetDhcpOptionsSetsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetDhcpOptionsSetsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetEnhancedNatAvailableZonesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetEnhancedNatAvailableZonesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetFlowLogServicePlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetFlowLogServicePlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetForwardEntriesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetForwardEntriesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetHavipsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetHavipsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpsecServersPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpsecServersPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv4GatewaysPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv4GatewaysPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6AddressesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6AddressesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6EgressRulesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6EgressRulesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6GatewaysPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6GatewaysPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6InternetBandwidthsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetIpv6InternetBandwidthsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNatGatewaysPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNatGatewaysPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNatIpCidrsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNatIpCidrsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNatIpsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNatIpsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNetworkAclsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNetworkAclsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNetworksPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetNetworksPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPbrRouteEntriesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPbrRouteEntriesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPeerConnectionsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPeerConnectionsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPrefixListsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPrefixListsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPublicIpAddressPoolCidrBlocksPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPublicIpAddressPoolCidrBlocksPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPublicIpAddressPoolsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetPublicIpAddressPoolsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetRouteEntriesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetRouteEntriesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetRouteTablesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetRouteTablesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetRouterInterfacesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetRouterInterfacesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSnatEntriesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSnatEntriesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSslVpnClientCertsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSslVpnClientCertsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSslVpnServersPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSslVpnServersPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSwitchesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetSwitchesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorFilterEgressRulesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorFilterEgressRulesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorFilterIngressRulesPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorFilterIngressRulesPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorFiltersPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorFiltersPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorServicePlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorServicePlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorSessionsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetTrafficMirrorSessionsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.inputs.GetVpcFlowLogsPlainArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.GetVpcFlowLogsPlainArgsBuilder
import com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpGroupsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpNetworksResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpPeersResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetCommonBandwidthPackagesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetDhcpOptionsSetsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetEnhancedNatAvailableZonesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetFlowLogServiceResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetForwardEntriesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetHavipsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpsecServersResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv4GatewaysResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6AddressesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6EgressRulesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6GatewaysResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6InternetBandwidthsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNatGatewaysResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNatIpCidrsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNatIpsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworkAclsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworksResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPbrRouteEntriesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPeerConnectionsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPrefixListsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPublicIpAddressPoolCidrBlocksResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPublicIpAddressPoolsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetRouteEntriesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetRouteTablesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetRouterInterfacesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSnatEntriesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSslVpnClientCertsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSslVpnServersResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSwitchesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFilterEgressRulesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFilterIngressRulesResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFiltersResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorServiceResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorSessionsResult
import com.pulumi.alicloud.vpc.kotlin.outputs.GetVpcFlowLogsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpGroupsResult.Companion.toKotlin as getBgpGroupsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpNetworksResult.Companion.toKotlin as getBgpNetworksResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpPeersResult.Companion.toKotlin as getBgpPeersResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetCommonBandwidthPackagesResult.Companion.toKotlin as getCommonBandwidthPackagesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetDhcpOptionsSetsResult.Companion.toKotlin as getDhcpOptionsSetsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetEnhancedNatAvailableZonesResult.Companion.toKotlin as getEnhancedNatAvailableZonesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetFlowLogServiceResult.Companion.toKotlin as getFlowLogServiceResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetForwardEntriesResult.Companion.toKotlin as getForwardEntriesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetHavipsResult.Companion.toKotlin as getHavipsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpsecServersResult.Companion.toKotlin as getIpsecServersResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv4GatewaysResult.Companion.toKotlin as getIpv4GatewaysResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6AddressesResult.Companion.toKotlin as getIpv6AddressesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6EgressRulesResult.Companion.toKotlin as getIpv6EgressRulesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6GatewaysResult.Companion.toKotlin as getIpv6GatewaysResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6InternetBandwidthsResult.Companion.toKotlin as getIpv6InternetBandwidthsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNatGatewaysResult.Companion.toKotlin as getNatGatewaysResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNatIpCidrsResult.Companion.toKotlin as getNatIpCidrsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNatIpsResult.Companion.toKotlin as getNatIpsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworkAclsResult.Companion.toKotlin as getNetworkAclsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworksResult.Companion.toKotlin as getNetworksResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPbrRouteEntriesResult.Companion.toKotlin as getPbrRouteEntriesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPeerConnectionsResult.Companion.toKotlin as getPeerConnectionsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPrefixListsResult.Companion.toKotlin as getPrefixListsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPublicIpAddressPoolCidrBlocksResult.Companion.toKotlin as getPublicIpAddressPoolCidrBlocksResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetPublicIpAddressPoolsResult.Companion.toKotlin as getPublicIpAddressPoolsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetRouteEntriesResult.Companion.toKotlin as getRouteEntriesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetRouteTablesResult.Companion.toKotlin as getRouteTablesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetRouterInterfacesResult.Companion.toKotlin as getRouterInterfacesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSnatEntriesResult.Companion.toKotlin as getSnatEntriesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSslVpnClientCertsResult.Companion.toKotlin as getSslVpnClientCertsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSslVpnServersResult.Companion.toKotlin as getSslVpnServersResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetSwitchesResult.Companion.toKotlin as getSwitchesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFilterEgressRulesResult.Companion.toKotlin as getTrafficMirrorFilterEgressRulesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFilterIngressRulesResult.Companion.toKotlin as getTrafficMirrorFilterIngressRulesResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFiltersResult.Companion.toKotlin as getTrafficMirrorFiltersResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorServiceResult.Companion.toKotlin as getTrafficMirrorServiceResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorSessionsResult.Companion.toKotlin as getTrafficMirrorSessionsResultToKotlin
import com.pulumi.alicloud.vpc.kotlin.outputs.GetVpcFlowLogsResult.Companion.toKotlin as getVpcFlowLogsResultToKotlin

public object VpcFunctions {
    /**
     * This data source provides the Vpc Bgp Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.152.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getBgpGroups({
     *     ids: ["example_value"],
     * });
     * export const vpcBgpGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.vpc.getBgpGroups({
     *     nameRegex: "^my-BgpGroup",
     * });
     * export const vpcBgpGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_bgp_groups(ids=["example_value"])
     * pulumi.export("vpcBgpGroupId1", ids.groups[0].id)
     * name_regex = alicloud.vpc.get_bgp_groups(name_regex="^my-BgpGroup")
     * pulumi.export("vpcBgpGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetBgpGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetBgpGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-BgpGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcBgpGroupId1"] = ids&#46;Apply(getBgpGroupsResult => getBgpGroupsResult&#46;Groups[0]?.Id),
     *         ["vpcBgpGroupId2"] = nameRegex&#46;Apply(getBgpGroupsResult => getBgpGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetBgpGroups(ctx, &vpc.GetBgpGroupsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := vpc.GetBgpGroups(ctx, &vpc.GetBgpGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-BgpGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetBgpGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getBgpGroups(GetBgpGroupsArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("vpcBgpGroupId1", ids.applyValue(getBgpGroupsResult -> getBgpGroupsResult.groups()[0].id()));
     *         final var nameRegex = VpcFunctions.getBgpGroups(GetBgpGroupsArgs.builder()
     *             .nameRegex("^my-BgpGroup")
     *             .build());
     *         ctx.export("vpcBgpGroupId2", nameRegex.applyValue(getBgpGroupsResult -> getBgpGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpGroups
     *       Arguments:
     *         ids:
     *           - example_value
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpGroups
     *       Arguments:
     *         nameRegex: ^my-BgpGroup
     * outputs:
     *   vpcBgpGroupId1: ${ids.groups[0].id}
     *   vpcBgpGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBgpGroups.
     * @return A collection of values returned by getBgpGroups.
     */
    public suspend fun getBgpGroups(argument: GetBgpGroupsPlainArgs): GetBgpGroupsResult =
        getBgpGroupsResultToKotlin(getBgpGroupsPlain(argument.toJava()).await())

    /**
     * @see [getBgpGroups].
     * @param ids A list of Bgp Group IDs.
     * @param nameRegex A regex string to filter results by Bgp Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param routerId The ID of the virtual border router (VBR) that is associated with the BGP group.
     * @param status The status of the resource. Valid values: `Available`, `Deleting` and `Pending`.
     * @return A collection of values returned by getBgpGroups.
     */
    public suspend fun getBgpGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        routerId: String? = null,
        status: String? = null,
    ): GetBgpGroupsResult {
        val argument = GetBgpGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            routerId = routerId,
            status = status,
        )
        return getBgpGroupsResultToKotlin(getBgpGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBgpGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetBgpGroupsPlainArgs].
     * @return A collection of values returned by getBgpGroups.
     */
    public suspend fun getBgpGroups(argument: suspend GetBgpGroupsPlainArgsBuilder.() -> Unit): GetBgpGroupsResult {
        val builder = GetBgpGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBgpGroupsResultToKotlin(getBgpGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Bgp Networks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.153.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getBgpNetworks({
     *     ids: ["example_value"],
     * });
     * export const vpcBgpNetworkId1 = ids.then(ids => ids.networks?.[0]?.id);
     * const routerId = alicloud.vpc.getBgpNetworks({
     *     routerId: "example_value",
     * });
     * export const vpcBgpNetworkId2 = routerId.then(routerId => routerId.networks?.[0]?.id);
     * const status = alicloud.vpc.getBgpNetworks({
     *     status: "Available",
     * });
     * export const vpcBgpNetworkId3 = status.then(status => status.networks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_bgp_networks(ids=["example_value"])
     * pulumi.export("vpcBgpNetworkId1", ids.networks[0].id)
     * router_id = alicloud.vpc.get_bgp_networks(router_id="example_value")
     * pulumi.export("vpcBgpNetworkId2", router_id.networks[0].id)
     * status = alicloud.vpc.get_bgp_networks(status="Available")
     * pulumi.export("vpcBgpNetworkId3", status.networks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetBgpNetworks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var routerId = AliCloud.Vpc.GetBgpNetworks.Invoke(new()
     *     {
     *         RouterId = "example_value",
     *     });
     *     var status = AliCloud.Vpc.GetBgpNetworks.Invoke(new()
     *     {
     *         Status = "Available",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcBgpNetworkId1"] = ids&#46;Apply(getBgpNetworksResult => getBgpNetworksResult&#46;Networks[0]?.Id),
     *         ["vpcBgpNetworkId2"] = routerId&#46;Apply(getBgpNetworksResult => getBgpNetworksResult&#46;Networks[0]?.Id),
     *         ["vpcBgpNetworkId3"] = status&#46;Apply(getBgpNetworksResult => getBgpNetworksResult&#46;Networks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetBgpNetworks(ctx, &vpc.GetBgpNetworksArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpNetworkId1", ids.Networks[0].Id)
     * 		routerId, err := vpc.GetBgpNetworks(ctx, &vpc.GetBgpNetworksArgs{
     * 			RouterId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpNetworkId2", routerId.Networks[0].Id)
     * 		status, err := vpc.GetBgpNetworks(ctx, &vpc.GetBgpNetworksArgs{
     * 			Status: pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpNetworkId3", status.Networks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetBgpNetworksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getBgpNetworks(GetBgpNetworksArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("vpcBgpNetworkId1", ids.applyValue(getBgpNetworksResult -> getBgpNetworksResult.networks()[0].id()));
     *         final var routerId = VpcFunctions.getBgpNetworks(GetBgpNetworksArgs.builder()
     *             .routerId("example_value")
     *             .build());
     *         ctx.export("vpcBgpNetworkId2", routerId.applyValue(getBgpNetworksResult -> getBgpNetworksResult.networks()[0].id()));
     *         final var status = VpcFunctions.getBgpNetworks(GetBgpNetworksArgs.builder()
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcBgpNetworkId3", status.applyValue(getBgpNetworksResult -> getBgpNetworksResult.networks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpNetworks
     *       Arguments:
     *         ids:
     *           - example_value
     *   routerId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpNetworks
     *       Arguments:
     *         routerId: example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpNetworks
     *       Arguments:
     *         status: Available
     * outputs:
     *   vpcBgpNetworkId1: ${ids.networks[0].id}
     *   vpcBgpNetworkId2: ${routerId.networks[0].id}
     *   vpcBgpNetworkId3: ${status.networks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBgpNetworks.
     * @return A collection of values returned by getBgpNetworks.
     */
    public suspend fun getBgpNetworks(argument: GetBgpNetworksPlainArgs): GetBgpNetworksResult =
        getBgpNetworksResultToKotlin(getBgpNetworksPlain(argument.toJava()).await())

    /**
     * @see [getBgpNetworks].
     * @param ids A list of Bgp Network IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param routerId The ID of the router to which the route table belongs.
     * @param status The state of the advertised BGP network. Valid values: `Available`, `Pending`, `Deleting`.
     * @return A collection of values returned by getBgpNetworks.
     */
    public suspend fun getBgpNetworks(
        ids: List<String>? = null,
        outputFile: String? = null,
        routerId: String? = null,
        status: String? = null,
    ): GetBgpNetworksResult {
        val argument = GetBgpNetworksPlainArgs(
            ids = ids,
            outputFile = outputFile,
            routerId = routerId,
            status = status,
        )
        return getBgpNetworksResultToKotlin(getBgpNetworksPlain(argument.toJava()).await())
    }

    /**
     * @see [getBgpNetworks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetBgpNetworksPlainArgs].
     * @return A collection of values returned by getBgpNetworks.
     */
    public suspend fun getBgpNetworks(argument: suspend GetBgpNetworksPlainArgsBuilder.() -> Unit): GetBgpNetworksResult {
        val builder = GetBgpNetworksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBgpNetworksResultToKotlin(getBgpNetworksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Bgp Peers of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.153.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getBgpPeers({
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const vpcBgpPeerId1 = ids.then(ids => ids.peers?.[0]?.id);
     * const bgpGroupId = alicloud.vpc.getBgpPeers({
     *     bgpGroupId: "example_value",
     * });
     * export const vpcBgpPeerId2 = bgpGroupId.then(bgpGroupId => bgpGroupId.peers?.[0]?.id);
     * const routerId = alicloud.vpc.getBgpPeers({
     *     routerId: "example_value",
     * });
     * export const vpcBgpPeerId3 = routerId.then(routerId => routerId.peers?.[0]?.id);
     * const status = alicloud.vpc.getBgpPeers({
     *     status: "Available",
     * });
     * export const vpcBgpPeerId4 = status.then(status => status.peers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_bgp_peers(ids=[
     *     "example_value-1",
     *     "example_value-2",
     * ])
     * pulumi.export("vpcBgpPeerId1", ids.peers[0].id)
     * bgp_group_id = alicloud.vpc.get_bgp_peers(bgp_group_id="example_value")
     * pulumi.export("vpcBgpPeerId2", bgp_group_id.peers[0].id)
     * router_id = alicloud.vpc.get_bgp_peers(router_id="example_value")
     * pulumi.export("vpcBgpPeerId3", router_id.peers[0].id)
     * status = alicloud.vpc.get_bgp_peers(status="Available")
     * pulumi.export("vpcBgpPeerId4", status.peers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetBgpPeers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var bgpGroupId = AliCloud.Vpc.GetBgpPeers.Invoke(new()
     *     {
     *         BgpGroupId = "example_value",
     *     });
     *     var routerId = AliCloud.Vpc.GetBgpPeers.Invoke(new()
     *     {
     *         RouterId = "example_value",
     *     });
     *     var status = AliCloud.Vpc.GetBgpPeers.Invoke(new()
     *     {
     *         Status = "Available",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcBgpPeerId1"] = ids&#46;Apply(getBgpPeersResult => getBgpPeersResult&#46;Peers[0]?.Id),
     *         ["vpcBgpPeerId2"] = bgpGroupId&#46;Apply(getBgpPeersResult => getBgpPeersResult&#46;Peers[0]?.Id),
     *         ["vpcBgpPeerId3"] = routerId&#46;Apply(getBgpPeersResult => getBgpPeersResult&#46;Peers[0]?.Id),
     *         ["vpcBgpPeerId4"] = status&#46;Apply(getBgpPeersResult => getBgpPeersResult&#46;Peers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetBgpPeers(ctx, &vpc.GetBgpPeersArgs{
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpPeerId1", ids.Peers[0].Id)
     * 		bgpGroupId, err := vpc.GetBgpPeers(ctx, &vpc.GetBgpPeersArgs{
     * 			BgpGroupId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpPeerId2", bgpGroupId.Peers[0].Id)
     * 		routerId, err := vpc.GetBgpPeers(ctx, &vpc.GetBgpPeersArgs{
     * 			RouterId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpPeerId3", routerId.Peers[0].Id)
     * 		status, err := vpc.GetBgpPeers(ctx, &vpc.GetBgpPeersArgs{
     * 			Status: pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcBgpPeerId4", status.Peers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetBgpPeersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getBgpPeers(GetBgpPeersArgs.builder()
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("vpcBgpPeerId1", ids.applyValue(getBgpPeersResult -> getBgpPeersResult.peers()[0].id()));
     *         final var bgpGroupId = VpcFunctions.getBgpPeers(GetBgpPeersArgs.builder()
     *             .bgpGroupId("example_value")
     *             .build());
     *         ctx.export("vpcBgpPeerId2", bgpGroupId.applyValue(getBgpPeersResult -> getBgpPeersResult.peers()[0].id()));
     *         final var routerId = VpcFunctions.getBgpPeers(GetBgpPeersArgs.builder()
     *             .routerId("example_value")
     *             .build());
     *         ctx.export("vpcBgpPeerId3", routerId.applyValue(getBgpPeersResult -> getBgpPeersResult.peers()[0].id()));
     *         final var status = VpcFunctions.getBgpPeers(GetBgpPeersArgs.builder()
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcBgpPeerId4", status.applyValue(getBgpPeersResult -> getBgpPeersResult.peers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpPeers
     *       Arguments:
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   bgpGroupId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpPeers
     *       Arguments:
     *         bgpGroupId: example_value
     *   routerId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpPeers
     *       Arguments:
     *         routerId: example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getBgpPeers
     *       Arguments:
     *         status: Available
     * outputs:
     *   vpcBgpPeerId1: ${ids.peers[0].id}
     *   vpcBgpPeerId2: ${bgpGroupId.peers[0].id}
     *   vpcBgpPeerId3: ${routerId.peers[0].id}
     *   vpcBgpPeerId4: ${status.peers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBgpPeers.
     * @return A collection of values returned by getBgpPeers.
     */
    public suspend fun getBgpPeers(argument: GetBgpPeersPlainArgs): GetBgpPeersResult =
        getBgpPeersResultToKotlin(getBgpPeersPlain(argument.toJava()).await())

    /**
     * @see [getBgpPeers].
     * @param bgpGroupId The ID of the BGP group to which the BGP peer that you want to query belongs.
     * @param ids A list of Bgp Peer IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param routerId The ID of the virtual border router (VBR) that is associated with the BGP peer that you want to query.
     * @param status The status of the BGP peer. Valid values: `Available`, `Deleted`, `Deleting`, `Modifying`, `Pending`.
     * @return A collection of values returned by getBgpPeers.
     */
    public suspend fun getBgpPeers(
        bgpGroupId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        routerId: String? = null,
        status: String? = null,
    ): GetBgpPeersResult {
        val argument = GetBgpPeersPlainArgs(
            bgpGroupId = bgpGroupId,
            ids = ids,
            outputFile = outputFile,
            routerId = routerId,
            status = status,
        )
        return getBgpPeersResultToKotlin(getBgpPeersPlain(argument.toJava()).await())
    }

    /**
     * @see [getBgpPeers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetBgpPeersPlainArgs].
     * @return A collection of values returned by getBgpPeers.
     */
    public suspend fun getBgpPeers(argument: suspend GetBgpPeersPlainArgsBuilder.() -> Unit): GetBgpPeersResult {
        val builder = GetBgpPeersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBgpPeersResultToKotlin(getBgpPeersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Common Bandwidth Packages owned by an Alibaba Cloud account.
     * > **NOTE:** Available in 1.36.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const fooCommonBandwithPackage = new alicloud.vpc.CommonBandwithPackage("foo", {
     *     bandwidth: "2",
     *     name: "tf-testAccCommonBandwidthPackage",
     *     description: "tf-testAcc-CommonBandwidthPackage",
     * });
     * const foo = alicloud.vpc.getCommonBandwidthPackagesOutput({
     *     nameRegex: "^tf-testAcc.*",
     *     ids: [fooCommonBandwithPackage&#46;id],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * foo_common_bandwith_package = alicloud.vpc.CommonBandwithPackage("foo",
     *     bandwidth="2",
     *     name="tf-testAccCommonBandwidthPackage",
     *     description="tf-testAcc-CommonBandwidthPackage")
     * foo = alicloud.vpc.get_common_bandwidth_packages_output(name_regex="^tf-testAcc.*",
     *     ids=[foo_common_bandwith_package&#46;id])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var fooCommonBandwithPackage = new AliCloud.Vpc.CommonBandwithPackage("foo", new()
     *     {
     *         Bandwidth = "2",
     *         Name = "tf-testAccCommonBandwidthPackage",
     *         Description = "tf-testAcc-CommonBandwidthPackage",
     *     });
     *     var foo = AliCloud.Vpc.GetCommonBandwidthPackages.Invoke(new()
     *     {
     *         NameRegex = "^tf-testAcc.*",
     *         Ids = new[]
     *         {
     *             fooCommonBandwithPackage.Id,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		fooCommonBandwithPackage, err := vpc.NewCommonBandwithPackage(ctx, "foo", &vpc.CommonBandwithPackageArgs{
     * 			Bandwidth:   pulumi.String("2"),
     * 			Name:        pulumi.String("tf-testAccCommonBandwidthPackage"),
     * 			Description: pulumi.String("tf-testAcc-CommonBandwidthPackage"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = vpc.GetCommonBandwidthPackagesOutput(ctx, vpc.GetCommonBandwidthPackagesOutputArgs{
     * 			NameRegex: pulumi.String("^tf-testAcc.*"),
     * 			Ids: pulumi.StringArray{
     * 				fooCommonBandwithPackage.ID(),
     * 			},
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.CommonBandwithPackage;
     * import com.pulumi.alicloud.vpc.CommonBandwithPackageArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetCommonBandwidthPackagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var fooCommonBandwithPackage = new CommonBandwithPackage("fooCommonBandwithPackage", CommonBandwithPackageArgs.builder()
     *             .bandwidth("2")
     *             .name("tf-testAccCommonBandwidthPackage")
     *             .description("tf-testAcc-CommonBandwidthPackage")
     *             .build());
     *         final var foo = VpcFunctions.getCommonBandwidthPackages(GetCommonBandwidthPackagesArgs.builder()
     *             .nameRegex("^tf-testAcc.*")
     *             .ids(fooCommonBandwithPackage.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   fooCommonBandwithPackage:
     *     type: alicloud:vpc:CommonBandwithPackage
     *     name: foo
     *     properties:
     *       bandwidth: '2'
     *       name: tf-testAccCommonBandwidthPackage
     *       description: tf-testAcc-CommonBandwidthPackage
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getCommonBandwidthPackages
     *       Arguments:
     *         nameRegex: ^tf-testAcc.*
     *         ids:
     *           - ${fooCommonBandwithPackage.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * ## Public ip addresses Block
     *   The public ip addresses mapping supports the following:
     *   * `ip_address`   - The address of the EIP.
     *   * `allocation_id` - The ID of the EIP instance.
     *   * `bandwidth_package_ip_relation_status` - The IP relation status of bandwidth package.
     * @param argument A collection of arguments for invoking getCommonBandwidthPackages.
     * @return A collection of values returned by getCommonBandwidthPackages.
     */
    public suspend fun getCommonBandwidthPackages(argument: GetCommonBandwidthPackagesPlainArgs): GetCommonBandwidthPackagesResult =
        getCommonBandwidthPackagesResultToKotlin(getCommonBandwidthPackagesPlain(argument.toJava()).await())

    /**
     * @see [getCommonBandwidthPackages].
     * @param bandwidthPackageName The name of bandwidth package.
     * @param dryRun Specifies whether to precheck only the request.
     * @param ids A list of Common Bandwidth Packages IDs.
     * @param includeReservationData Specifies whether to return data of orders that have not taken effect.
     * @param nameRegex A regex string to filter results by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which the common bandwidth package belongs.
     * @param status The status of bandwidth package. Valid values: `Available` and `Pending`.
     * @return A collection of values returned by getCommonBandwidthPackages.
     */
    public suspend fun getCommonBandwidthPackages(
        bandwidthPackageName: String? = null,
        dryRun: Boolean? = null,
        ids: List<String>? = null,
        includeReservationData: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
    ): GetCommonBandwidthPackagesResult {
        val argument = GetCommonBandwidthPackagesPlainArgs(
            bandwidthPackageName = bandwidthPackageName,
            dryRun = dryRun,
            ids = ids,
            includeReservationData = includeReservationData,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
        )
        return getCommonBandwidthPackagesResultToKotlin(getCommonBandwidthPackagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommonBandwidthPackages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetCommonBandwidthPackagesPlainArgs].
     * @return A collection of values returned by getCommonBandwidthPackages.
     */
    public suspend fun getCommonBandwidthPackages(argument: suspend GetCommonBandwidthPackagesPlainArgsBuilder.() -> Unit): GetCommonBandwidthPackagesResult {
        val builder = GetCommonBandwidthPackagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommonBandwidthPackagesResultToKotlin(getCommonBandwidthPackagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Dhcp Options Sets of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getDhcpOptionsSets({
     *     ids: ["example_value"],
     * });
     * export const vpcDhcpOptionsSetId1 = ids.then(ids => ids.sets?.[0]?.id);
     * const nameRegex = alicloud.vpc.getDhcpOptionsSets({
     *     nameRegex: "^my-DhcpOptionsSet",
     * });
     * export const vpcDhcpOptionsSetId2 = nameRegex.then(nameRegex => nameRegex.sets?.[0]?.id);
     * const dhcpOptionsSetName = alicloud.vpc.getDhcpOptionsSets({
     *     dhcpOptionsSetName: "my-DhcpOptionsSet",
     * });
     * export const vpcDhcpOptionsSetId3 = dhcpOptionsSetName.then(dhcpOptionsSetName => dhcpOptionsSetName.sets?.[0]?.id);
     * const domainName = alicloud.vpc.getDhcpOptionsSets({
     *     ids: ["example_value"],
     *     domainName: "example.com",
     * });
     * export const vpcDhcpOptionsSetId4 = domainName.then(domainName => domainName.sets?.[0]?.id);
     * const status = alicloud.vpc.getDhcpOptionsSets({
     *     ids: ["example_value"],
     *     status: "Available",
     * });
     * export const vpcDhcpOptionsSetId5 = status.then(status => status.sets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_dhcp_options_sets(ids=["example_value"])
     * pulumi.export("vpcDhcpOptionsSetId1", ids.sets[0].id)
     * name_regex = alicloud.vpc.get_dhcp_options_sets(name_regex="^my-DhcpOptionsSet")
     * pulumi.export("vpcDhcpOptionsSetId2", name_regex.sets[0].id)
     * dhcp_options_set_name = alicloud.vpc.get_dhcp_options_sets(dhcp_options_set_name="my-DhcpOptionsSet")
     * pulumi.export("vpcDhcpOptionsSetId3", dhcp_options_set_name.sets[0].id)
     * domain_name = alicloud.vpc.get_dhcp_options_sets(ids=["example_value"],
     *     domain_name="example.com")
     * pulumi.export("vpcDhcpOptionsSetId4", domain_name.sets[0].id)
     * status = alicloud.vpc.get_dhcp_options_sets(ids=["example_value"],
     *     status="Available")
     * pulumi.export("vpcDhcpOptionsSetId5", status.sets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetDhcpOptionsSets.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetDhcpOptionsSets.Invoke(new()
     *     {
     *         NameRegex = "^my-DhcpOptionsSet",
     *     });
     *     var dhcpOptionsSetName = AliCloud.Vpc.GetDhcpOptionsSets.Invoke(new()
     *     {
     *         DhcpOptionsSetName = "my-DhcpOptionsSet",
     *     });
     *     var domainName = AliCloud.Vpc.GetDhcpOptionsSets.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         DomainName = "example.com",
     *     });
     *     var status = AliCloud.Vpc.GetDhcpOptionsSets.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         Status = "Available",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcDhcpOptionsSetId1"] = ids&#46;Apply(getDhcpOptionsSetsResult => getDhcpOptionsSetsResult&#46;Sets[0]?.Id),
     *         ["vpcDhcpOptionsSetId2"] = nameRegex&#46;Apply(getDhcpOptionsSetsResult => getDhcpOptionsSetsResult&#46;Sets[0]?.Id),
     *         ["vpcDhcpOptionsSetId3"] = dhcpOptionsSetName&#46;Apply(getDhcpOptionsSetsResult => getDhcpOptionsSetsResult&#46;Sets[0]?.Id),
     *         ["vpcDhcpOptionsSetId4"] = domainName&#46;Apply(getDhcpOptionsSetsResult => getDhcpOptionsSetsResult&#46;Sets[0]?.Id),
     *         ["vpcDhcpOptionsSetId5"] = status&#46;Apply(getDhcpOptionsSetsResult => getDhcpOptionsSetsResult&#46;Sets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetDhcpOptionsSets(ctx, &vpc.GetDhcpOptionsSetsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcDhcpOptionsSetId1", ids.Sets[0].Id)
     * 		nameRegex, err := vpc.GetDhcpOptionsSets(ctx, &vpc.GetDhcpOptionsSetsArgs{
     * 			NameRegex: pulumi.StringRef("^my-DhcpOptionsSet"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcDhcpOptionsSetId2", nameRegex.Sets[0].Id)
     * 		dhcpOptionsSetName, err := vpc.GetDhcpOptionsSets(ctx, &vpc.GetDhcpOptionsSetsArgs{
     * 			DhcpOptionsSetName: pulumi.StringRef("my-DhcpOptionsSet"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcDhcpOptionsSetId3", dhcpOptionsSetName.Sets[0].Id)
     * 		domainName, err := vpc.GetDhcpOptionsSets(ctx, &vpc.GetDhcpOptionsSetsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			DomainName: pulumi.StringRef("example.com"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcDhcpOptionsSetId4", domainName.Sets[0].Id)
     * 		status, err := vpc.GetDhcpOptionsSets(ctx, &vpc.GetDhcpOptionsSetsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			Status: pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcDhcpOptionsSetId5", status.Sets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetDhcpOptionsSetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getDhcpOptionsSets(GetDhcpOptionsSetsArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("vpcDhcpOptionsSetId1", ids.applyValue(getDhcpOptionsSetsResult -> getDhcpOptionsSetsResult.sets()[0].id()));
     *         final var nameRegex = VpcFunctions.getDhcpOptionsSets(GetDhcpOptionsSetsArgs.builder()
     *             .nameRegex("^my-DhcpOptionsSet")
     *             .build());
     *         ctx.export("vpcDhcpOptionsSetId2", nameRegex.applyValue(getDhcpOptionsSetsResult -> getDhcpOptionsSetsResult.sets()[0].id()));
     *         final var dhcpOptionsSetName = VpcFunctions.getDhcpOptionsSets(GetDhcpOptionsSetsArgs.builder()
     *             .dhcpOptionsSetName("my-DhcpOptionsSet")
     *             .build());
     *         ctx.export("vpcDhcpOptionsSetId3", dhcpOptionsSetName.applyValue(getDhcpOptionsSetsResult -> getDhcpOptionsSetsResult.sets()[0].id()));
     *         final var domainName = VpcFunctions.getDhcpOptionsSets(GetDhcpOptionsSetsArgs.builder()
     *             .ids("example_value")
     *             .domainName("example.com")
     *             .build());
     *         ctx.export("vpcDhcpOptionsSetId4", domainName.applyValue(getDhcpOptionsSetsResult -> getDhcpOptionsSetsResult.sets()[0].id()));
     *         final var status = VpcFunctions.getDhcpOptionsSets(GetDhcpOptionsSetsArgs.builder()
     *             .ids("example_value")
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcDhcpOptionsSetId5", status.applyValue(getDhcpOptionsSetsResult -> getDhcpOptionsSetsResult.sets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getDhcpOptionsSets
     *       Arguments:
     *         ids:
     *           - example_value
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getDhcpOptionsSets
     *       Arguments:
     *         nameRegex: ^my-DhcpOptionsSet
     *   dhcpOptionsSetName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getDhcpOptionsSets
     *       Arguments:
     *         dhcpOptionsSetName: my-DhcpOptionsSet
     *   domainName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getDhcpOptionsSets
     *       Arguments:
     *         ids:
     *           - example_value
     *         domainName: example.com
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getDhcpOptionsSets
     *       Arguments:
     *         ids:
     *           - example_value
     *         status: Available
     * outputs:
     *   vpcDhcpOptionsSetId1: ${ids.sets[0].id}
     *   vpcDhcpOptionsSetId2: ${nameRegex.sets[0].id}
     *   vpcDhcpOptionsSetId3: ${dhcpOptionsSetName.sets[0].id}
     *   vpcDhcpOptionsSetId4: ${domainName.sets[0].id}
     *   vpcDhcpOptionsSetId5: ${status.sets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDhcpOptionsSets.
     * @return A collection of values returned by getDhcpOptionsSets.
     */
    public suspend fun getDhcpOptionsSets(argument: GetDhcpOptionsSetsPlainArgs): GetDhcpOptionsSetsResult =
        getDhcpOptionsSetsResultToKotlin(getDhcpOptionsSetsPlain(argument.toJava()).await())

    /**
     * @see [getDhcpOptionsSets].
     * @param dhcpOptionsSetName The name of the DHCP options set.The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
     * @param domainName The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
     * @param ids A list of Dhcp Options Set IDs.
     * @param nameRegex A regex string to filter results by Dhcp Options Set name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
     * @return A collection of values returned by getDhcpOptionsSets.
     */
    public suspend fun getDhcpOptionsSets(
        dhcpOptionsSetName: String? = null,
        domainName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetDhcpOptionsSetsResult {
        val argument = GetDhcpOptionsSetsPlainArgs(
            dhcpOptionsSetName = dhcpOptionsSetName,
            domainName = domainName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getDhcpOptionsSetsResultToKotlin(getDhcpOptionsSetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDhcpOptionsSets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetDhcpOptionsSetsPlainArgs].
     * @return A collection of values returned by getDhcpOptionsSets.
     */
    public suspend fun getDhcpOptionsSets(argument: suspend GetDhcpOptionsSetsPlainArgsBuilder.() -> Unit): GetDhcpOptionsSetsResult {
        val builder = GetDhcpOptionsSetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDhcpOptionsSetsResultToKotlin(getDhcpOptionsSetsPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getEnhancedNatAvailableZones.
     * @return A collection of values returned by getEnhancedNatAvailableZones.
     */
    public suspend fun getEnhancedNatAvailableZones(argument: GetEnhancedNatAvailableZonesPlainArgs): GetEnhancedNatAvailableZonesResult =
        getEnhancedNatAvailableZonesResultToKotlin(getEnhancedNatAvailableZonesPlain(argument.toJava()).await())

    /**
     * @see [getEnhancedNatAvailableZones].
     * @param outputFile
     * @return A collection of values returned by getEnhancedNatAvailableZones.
     */
    public suspend fun getEnhancedNatAvailableZones(outputFile: String? = null): GetEnhancedNatAvailableZonesResult {
        val argument = GetEnhancedNatAvailableZonesPlainArgs(
            outputFile = outputFile,
        )
        return getEnhancedNatAvailableZonesResultToKotlin(getEnhancedNatAvailableZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnhancedNatAvailableZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetEnhancedNatAvailableZonesPlainArgs].
     * @return A collection of values returned by getEnhancedNatAvailableZones.
     */
    public suspend fun getEnhancedNatAvailableZones(argument: suspend GetEnhancedNatAvailableZonesPlainArgsBuilder.() -> Unit): GetEnhancedNatAvailableZonesResult {
        val builder = GetEnhancedNatAvailableZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnhancedNatAvailableZonesResultToKotlin(getEnhancedNatAvailableZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Vpc Flow Log service automatically. If the service has been opened, it will return opened.
     * For information about Vpc Flow Log and how to use it, see [What is Vpc Flow Log](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-openflowlog).
     * > **NOTE:** Available since v1.209.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.vpc.getFlowLogService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.vpc.get_flow_log_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Vpc.GetFlowLogService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpc.GetFlowLogService(ctx, &vpc.GetFlowLogServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetFlowLogServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = VpcFunctions.getFlowLogService(GetFlowLogServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:vpc:getFlowLogService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFlowLogService.
     * @return A collection of values returned by getFlowLogService.
     */
    public suspend fun getFlowLogService(argument: GetFlowLogServicePlainArgs): GetFlowLogServiceResult =
        getFlowLogServiceResultToKotlin(getFlowLogServicePlain(argument.toJava()).await())

    /**
     * @see [getFlowLogService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Default value: `Off`. Valid values: `On` and `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Vpc Flow Log service that means you have read and agreed the [Vpc Flow Log Terms of Service](https://help.aliyun.com/zh/vpc/support/vpc-terms-of-service). The service can not closed once it is opened.
     * @return A collection of values returned by getFlowLogService.
     */
    public suspend fun getFlowLogService(enable: String? = null): GetFlowLogServiceResult {
        val argument = GetFlowLogServicePlainArgs(
            enable = enable,
        )
        return getFlowLogServiceResultToKotlin(getFlowLogServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getFlowLogService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetFlowLogServicePlainArgs].
     * @return A collection of values returned by getFlowLogService.
     */
    public suspend fun getFlowLogService(argument: suspend GetFlowLogServicePlainArgsBuilder.() -> Unit): GetFlowLogServiceResult {
        val builder = GetFlowLogServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFlowLogServiceResultToKotlin(getFlowLogServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Forward Entries owned by an Alibaba Cloud account.
     * > **NOTE:** Available in 1.37.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "forward-entry-config-example-name";
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {
     *     vpcName: name,
     *     cidrBlock: "172.16.0.0/12",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "172.16.0.0/21",
     *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
     *     vswitchName: name,
     * });
     * const defaultNatGateway = new alicloud.vpc.NatGateway("default", {
     *     vpcId: defaultNetwork.id,
     *     internetChargeType: "PayByLcu",
     *     natGatewayName: name,
     *     natType: "Enhanced",
     *     vswitchId: defaultSwitch.id,
     * });
     * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {addressName: name});
     * const defaultEipAssociation = new alicloud.ecs.EipAssociation("default", {
     *     allocationId: defaultEipAddress.id,
     *     instanceId: defaultNatGateway.id,
     * });
     * const defaultForwardEntry = new alicloud.vpc.ForwardEntry("default", {
     *     forwardTableId: defaultNatGateway.forwardTableIds,
     *     externalIp: defaultEipAddress.ipAddress,
     *     externalPort: "80",
     *     ipProtocol: "tcp",
     *     internalIp: "172.16.0.3",
     *     internalPort: "8080",
     * });
     * const defaultGetForwardEntries = alicloud.vpc.getForwardEntriesOutput({
     *     forwardTableId: defaultForwardEntry.forwardTableId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "forward-entry-config-example-name"
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * default_network = alicloud.vpc.Network("default",
     *     vpc_name=name,
     *     cidr_block="172.16.0.0/12")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/21",
     *     zone_id=default.zones[0].id,
     *     vswitch_name=name)
     * default_nat_gateway = alicloud.vpc.NatGateway("default",
     *     vpc_id=default_network.id,
     *     internet_charge_type="PayByLcu",
     *     nat_gateway_name=name,
     *     nat_type="Enhanced",
     *     vswitch_id=default_switch.id)
     * default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
     * default_eip_association = alicloud.ecs.EipAssociation("default",
     *     allocation_id=default_eip_address.id,
     *     instance_id=default_nat_gateway.id)
     * default_forward_entry = alicloud.vpc.ForwardEntry("default",
     *     forward_table_id=default_nat_gateway.forward_table_ids,
     *     external_ip=default_eip_address.ip_address,
     *     external_port="80",
     *     ip_protocol="tcp",
     *     internal_ip="172.16.0.3",
     *     internal_port="8080")
     * default_get_forward_entries = alicloud.vpc.get_forward_entries_output(forward_table_id=default_forward_entry.forward_table_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "forward-entry-config-example-name";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = name,
     *         CidrBlock = "172.16.0.0/12",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/21",
     *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VswitchName = name,
     *     });
     *     var defaultNatGateway = new AliCloud.Vpc.NatGateway("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         InternetChargeType = "PayByLcu",
     *         NatGatewayName = name,
     *         NatType = "Enhanced",
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
     *     {
     *         AddressName = name,
     *     });
     *     var defaultEipAssociation = new AliCloud.Ecs.EipAssociation("default", new()
     *     {
     *         AllocationId = defaultEipAddress.Id,
     *         InstanceId = defaultNatGateway.Id,
     *     });
     *     var defaultForwardEntry = new AliCloud.Vpc.ForwardEntry("default", new()
     *     {
     *         ForwardTableId = defaultNatGateway.ForwardTableIds,
     *         ExternalIp = defaultEipAddress.IpAddress,
     *         ExternalPort = "80",
     *         IpProtocol = "tcp",
     *         InternalIp = "172.16.0.3",
     *         InternalPort = "8080",
     *     });
     *     var defaultGetForwardEntries = AliCloud.Vpc.GetForwardEntries.Invoke(new()
     *     {
     *         ForwardTableId = defaultForwardEntry.ForwardTableId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "forward-entry-config-example-name"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * 			VpcName:   pulumi.String(name),
     * 			CidrBlock: pulumi.String("172.16.0.0/12"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * 			VpcId:       defaultNetwork.ID(),
     * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
     * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
     * 			VswitchName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNatGateway, err := vpc.NewNatGateway(ctx, "default", &vpc.NatGatewayArgs{
     * 			VpcId:              defaultNetwork.ID(),
     * 			InternetChargeType: pulumi.String("PayByLcu"),
     * 			NatGatewayName:     pulumi.String(name),
     * 			NatType:            pulumi.String("Enhanced"),
     * 			VswitchId:          defaultSwitch.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
     * 			AddressName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecs.NewEipAssociation(ctx, "default", &ecs.EipAssociationArgs{
     * 			AllocationId: defaultEipAddress.ID(),
     * 			InstanceId:   defaultNatGateway.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultForwardEntry, err := vpc.NewForwardEntry(ctx, "default", &vpc.ForwardEntryArgs{
     * 			ForwardTableId: defaultNatGateway.ForwardTableIds,
     * 			ExternalIp:     defaultEipAddress.IpAddress,
     * 			ExternalPort:   pulumi.String("80"),
     * 			IpProtocol:     pulumi.String("tcp"),
     * 			InternalIp:     pulumi.String("172.16.0.3"),
     * 			InternalPort:   pulumi.String("8080"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = vpc.GetForwardEntriesOutput(ctx, vpc.GetForwardEntriesOutputArgs{
     * 			ForwardTableId: defaultForwardEntry.ForwardTableId,
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.vpc.NatGateway;
     * import com.pulumi.alicloud.vpc.NatGatewayArgs;
     * import com.pulumi.alicloud.ecs.EipAddress;
     * import com.pulumi.alicloud.ecs.EipAddressArgs;
     * import com.pulumi.alicloud.ecs.EipAssociation;
     * import com.pulumi.alicloud.ecs.EipAssociationArgs;
     * import com.pulumi.alicloud.vpc.ForwardEntry;
     * import com.pulumi.alicloud.vpc.ForwardEntryArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetForwardEntriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("forward-entry-config-example-name");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .vpcName(name)
     *             .cidrBlock("172.16.0.0/12")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/21")
     *             .zoneId(default_.zones()[0].id())
     *             .vswitchName(name)
     *             .build());
     *         var defaultNatGateway = new NatGateway("defaultNatGateway", NatGatewayArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .internetChargeType("PayByLcu")
     *             .natGatewayName(name)
     *             .natType("Enhanced")
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
     *             .addressName(name)
     *             .build());
     *         var defaultEipAssociation = new EipAssociation("defaultEipAssociation", EipAssociationArgs.builder()
     *             .allocationId(defaultEipAddress.id())
     *             .instanceId(defaultNatGateway.id())
     *             .build());
     *         var defaultForwardEntry = new ForwardEntry("defaultForwardEntry", ForwardEntryArgs.builder()
     *             .forwardTableId(defaultNatGateway.forwardTableIds())
     *             .externalIp(defaultEipAddress.ipAddress())
     *             .externalPort("80")
     *             .ipProtocol("tcp")
     *             .internalIp("172.16.0.3")
     *             .internalPort("8080")
     *             .build());
     *         final var defaultGetForwardEntries = VpcFunctions.getForwardEntries(GetForwardEntriesArgs.builder()
     *             .forwardTableId(defaultForwardEntry.forwardTableId())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: forward-entry-config-example-name
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       vpcName: ${name}
     *       cidrBlock: 172.16.0.0/12
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/21
     *       zoneId: ${default.zones[0].id}
     *       vswitchName: ${name}
     *   defaultNatGateway:
     *     type: alicloud:vpc:NatGateway
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       internetChargeType: PayByLcu
     *       natGatewayName: ${name}
     *       natType: Enhanced
     *       vswitchId: ${defaultSwitch.id}
     *   defaultEipAddress:
     *     type: alicloud:ecs:EipAddress
     *     name: default
     *     properties:
     *       addressName: ${name}
     *   defaultEipAssociation:
     *     type: alicloud:ecs:EipAssociation
     *     name: default
     *     properties:
     *       allocationId: ${defaultEipAddress.id}
     *       instanceId: ${defaultNatGateway.id}
     *   defaultForwardEntry:
     *     type: alicloud:vpc:ForwardEntry
     *     name: default
     *     properties:
     *       forwardTableId: ${defaultNatGateway.forwardTableIds}
     *       externalIp: ${defaultEipAddress.ipAddress}
     *       externalPort: '80'
     *       ipProtocol: tcp
     *       internalIp: 172.16.0.3
     *       internalPort: '8080'
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   defaultGetForwardEntries:
     *     fn::invoke:
     *       Function: alicloud:vpc:getForwardEntries
     *       Arguments:
     *         forwardTableId: ${defaultForwardEntry.forwardTableId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getForwardEntries.
     * @return A collection of values returned by getForwardEntries.
     */
    public suspend fun getForwardEntries(argument: GetForwardEntriesPlainArgs): GetForwardEntriesResult =
        getForwardEntriesResultToKotlin(getForwardEntriesPlain(argument.toJava()).await())

    /**
     * @see [getForwardEntries].
     * @param externalIp The public IP address.
     * @param externalPort The public port.
     * @param forwardEntryName The name of forward entry.
     * @param forwardTableId The ID of the Forward table.
     * @param ids A list of Forward Entries IDs.
     * @param internalIp The private IP address.
     * @param internalPort The internal port.
     * @param ipProtocol The ip protocol. Valid values: `any`,`tcp` and `udp`.
     * @param nameRegex A regex string to filter results by forward entry name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
     * @return A collection of values returned by getForwardEntries.
     */
    public suspend fun getForwardEntries(
        externalIp: String? = null,
        externalPort: String? = null,
        forwardEntryName: String? = null,
        forwardTableId: String,
        ids: List<String>? = null,
        internalIp: String? = null,
        internalPort: String? = null,
        ipProtocol: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetForwardEntriesResult {
        val argument = GetForwardEntriesPlainArgs(
            externalIp = externalIp,
            externalPort = externalPort,
            forwardEntryName = forwardEntryName,
            forwardTableId = forwardTableId,
            ids = ids,
            internalIp = internalIp,
            internalPort = internalPort,
            ipProtocol = ipProtocol,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getForwardEntriesResultToKotlin(getForwardEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getForwardEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetForwardEntriesPlainArgs].
     * @return A collection of values returned by getForwardEntries.
     */
    public suspend fun getForwardEntries(argument: suspend GetForwardEntriesPlainArgsBuilder.() -> Unit): GetForwardEntriesResult {
        val builder = GetForwardEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getForwardEntriesResultToKotlin(getForwardEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Havips of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.vpc.getHavips({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstHavipId = example.then(example => example.havips?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.vpc.get_havips(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstHavipId", example.havips[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Vpc.GetHavips.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstHavipId"] = example&#46;Apply(getHavipsResult => getHavipsResult&#46;Havips[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := vpc.GetHavips(ctx, &vpc.GetHavipsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstHavipId", example.Havips[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetHavipsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpcFunctions.getHavips(GetHavipsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstHavipId", example.applyValue(getHavipsResult -> getHavipsResult.havips()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:vpc:getHavips
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstHavipId: ${example.havips[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHavips.
     * @return A collection of values returned by getHavips.
     */
    public suspend fun getHavips(argument: GetHavipsPlainArgs): GetHavipsResult =
        getHavipsResultToKotlin(getHavipsPlain(argument.toJava()).await())

    /**
     * @see [getHavips].
     * @param ids A list of Ha Vip IDs.
     * @param nameRegex A regex string to filter results by Ha Vip name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of HaVip instance. Valid value: `Available`, `InUse` and `Pending`.
     * @return A collection of values returned by getHavips.
     */
    public suspend fun getHavips(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetHavipsResult {
        val argument = GetHavipsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getHavipsResultToKotlin(getHavipsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHavips].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetHavipsPlainArgs].
     * @return A collection of values returned by getHavips.
     */
    public suspend fun getHavips(argument: suspend GetHavipsPlainArgsBuilder.() -> Unit): GetHavipsResult {
        val builder = GetHavipsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHavipsResultToKotlin(getHavipsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpn Ipsec Servers of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.161.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getIpsecServers({
     *     ids: ["example_id"],
     * });
     * export const vpnIpsecServerId1 = ids.then(ids => ids.servers?.[0]?.id);
     * const nameRegex = alicloud.vpc.getIpsecServers({
     *     nameRegex: "^my-IpsecServer",
     * });
     * export const vpnIpsecServerId2 = nameRegex.then(nameRegex => nameRegex.servers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_ipsec_servers(ids=["example_id"])
     * pulumi.export("vpnIpsecServerId1", ids.servers[0].id)
     * name_regex = alicloud.vpc.get_ipsec_servers(name_regex="^my-IpsecServer")
     * pulumi.export("vpnIpsecServerId2", name_regex.servers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetIpsecServers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetIpsecServers.Invoke(new()
     *     {
     *         NameRegex = "^my-IpsecServer",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpnIpsecServerId1"] = ids&#46;Apply(getIpsecServersResult => getIpsecServersResult&#46;Servers[0]?.Id),
     *         ["vpnIpsecServerId2"] = nameRegex&#46;Apply(getIpsecServersResult => getIpsecServersResult&#46;Servers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetIpsecServers(ctx, &vpc.GetIpsecServersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpnIpsecServerId1", ids.Servers[0].Id)
     * 		nameRegex, err := vpc.GetIpsecServers(ctx, &vpc.GetIpsecServersArgs{
     * 			NameRegex: pulumi.StringRef("^my-IpsecServer"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpnIpsecServerId2", nameRegex.Servers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetIpsecServersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getIpsecServers(GetIpsecServersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpnIpsecServerId1", ids.applyValue(getIpsecServersResult -> getIpsecServersResult.servers()[0].id()));
     *         final var nameRegex = VpcFunctions.getIpsecServers(GetIpsecServersArgs.builder()
     *             .nameRegex("^my-IpsecServer")
     *             .build());
     *         ctx.export("vpnIpsecServerId2", nameRegex.applyValue(getIpsecServersResult -> getIpsecServersResult.servers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpsecServers
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpsecServers
     *       Arguments:
     *         nameRegex: ^my-IpsecServer
     * outputs:
     *   vpnIpsecServerId1: ${ids.servers[0].id}
     *   vpnIpsecServerId2: ${nameRegex.servers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpsecServers.
     * @return A collection of values returned by getIpsecServers.
     */
    public suspend fun getIpsecServers(argument: GetIpsecServersPlainArgs): GetIpsecServersResult =
        getIpsecServersResultToKotlin(getIpsecServersPlain(argument.toJava()).await())

    /**
     * @see [getIpsecServers].
     * @param ids A list of Ipsec Server IDs.
     * @param ipsecServerName The name of the IPsec server.
     * @param nameRegex A regex string to filter results by Ipsec Server name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param vpnGatewayId The ID of the VPN gateway.
     * @return A collection of values returned by getIpsecServers.
     */
    public suspend fun getIpsecServers(
        ids: List<String>? = null,
        ipsecServerName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        vpnGatewayId: String? = null,
    ): GetIpsecServersResult {
        val argument = GetIpsecServersPlainArgs(
            ids = ids,
            ipsecServerName = ipsecServerName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            vpnGatewayId = vpnGatewayId,
        )
        return getIpsecServersResultToKotlin(getIpsecServersPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpsecServers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetIpsecServersPlainArgs].
     * @return A collection of values returned by getIpsecServers.
     */
    public suspend fun getIpsecServers(argument: suspend GetIpsecServersPlainArgsBuilder.() -> Unit): GetIpsecServersResult {
        val builder = GetIpsecServersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpsecServersResultToKotlin(getIpsecServersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Ipv4 Gateways of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.181.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getIpv4Gateways({});
     * export const vpcIpv4GatewayId1 = ids.then(ids => ids.gateways?.[0]?.id);
     * const nameRegex = alicloud.vpc.getIpv4Gateways({
     *     nameRegex: "^my-Ipv4Gateway",
     * });
     * export const vpcIpv4GatewayId2 = nameRegex.then(nameRegex => nameRegex.gateways?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_ipv4_gateways()
     * pulumi.export("vpcIpv4GatewayId1", ids.gateways[0].id)
     * name_regex = alicloud.vpc.get_ipv4_gateways(name_regex="^my-Ipv4Gateway")
     * pulumi.export("vpcIpv4GatewayId2", name_regex.gateways[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetIpv4Gateways.Invoke();
     *     var nameRegex = AliCloud.Vpc.GetIpv4Gateways.Invoke(new()
     *     {
     *         NameRegex = "^my-Ipv4Gateway",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcIpv4GatewayId1"] = ids&#46;Apply(getIpv4GatewaysResult => getIpv4GatewaysResult&#46;Gateways[0]?.Id),
     *         ["vpcIpv4GatewayId2"] = nameRegex&#46;Apply(getIpv4GatewaysResult => getIpv4GatewaysResult&#46;Gateways[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetIpv4Gateways(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv4GatewayId1", ids.Gateways[0].Id)
     * 		nameRegex, err := vpc.GetIpv4Gateways(ctx, &vpc.GetIpv4GatewaysArgs{
     * 			NameRegex: pulumi.StringRef("^my-Ipv4Gateway"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv4GatewayId2", nameRegex.Gateways[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetIpv4GatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getIpv4Gateways();
     *         ctx.export("vpcIpv4GatewayId1", ids.applyValue(getIpv4GatewaysResult -> getIpv4GatewaysResult.gateways()[0].id()));
     *         final var nameRegex = VpcFunctions.getIpv4Gateways(GetIpv4GatewaysArgs.builder()
     *             .nameRegex("^my-Ipv4Gateway")
     *             .build());
     *         ctx.export("vpcIpv4GatewayId2", nameRegex.applyValue(getIpv4GatewaysResult -> getIpv4GatewaysResult.gateways()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv4Gateways
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv4Gateways
     *       Arguments:
     *         nameRegex: ^my-Ipv4Gateway
     * outputs:
     *   vpcIpv4GatewayId1: ${ids.gateways[0].id}
     *   vpcIpv4GatewayId2: ${nameRegex.gateways[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpv4Gateways.
     * @return A collection of values returned by getIpv4Gateways.
     */
    public suspend fun getIpv4Gateways(argument: GetIpv4GatewaysPlainArgs): GetIpv4GatewaysResult =
        getIpv4GatewaysResultToKotlin(getIpv4GatewaysPlain(argument.toJava()).await())

    /**
     * @see [getIpv4Gateways].
     * @param ids A list of Ipv4 Gateway IDs.
     * @param ipv4GatewayName The name of the IPv4 gateway.
     * @param nameRegex A regex string to filter results by Ipv4 Gateway name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Creating`, `Created`, `Deleting`, `Pending`, `Deleted`.
     * @param vpcId The ID of the VPC associated with the IPv4 Gateway.
     * @return A collection of values returned by getIpv4Gateways.
     */
    public suspend fun getIpv4Gateways(
        ids: List<String>? = null,
        ipv4GatewayName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        vpcId: String? = null,
    ): GetIpv4GatewaysResult {
        val argument = GetIpv4GatewaysPlainArgs(
            ids = ids,
            ipv4GatewayName = ipv4GatewayName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            vpcId = vpcId,
        )
        return getIpv4GatewaysResultToKotlin(getIpv4GatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpv4Gateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetIpv4GatewaysPlainArgs].
     * @return A collection of values returned by getIpv4Gateways.
     */
    public suspend fun getIpv4Gateways(argument: suspend GetIpv4GatewaysPlainArgsBuilder.() -> Unit): GetIpv4GatewaysResult {
        val builder = GetIpv4GatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpv4GatewaysResultToKotlin(getIpv4GatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Ipv6 Addresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const associatedInstanceId = alicloud.vpc.getIpv6Addresses({
     *     associatedInstanceId: "example_value",
     * });
     * export const vpcIpv6AddressId1 = associatedInstanceId.then(associatedInstanceId => associatedInstanceId.addresses?.[0]?.id);
     * const vswitchId = alicloud.vpc.getIpv6Addresses({
     *     vswitchId: "example_value",
     * });
     * export const vpcIpv6AddressId2 = vswitchId.then(vswitchId => vswitchId.addresses?.[0]?.id);
     * const vpcId = alicloud.vpc.getIpv6Addresses({
     *     vpcId: "example_value",
     * });
     * export const vpcIpv6AddressId3 = vpcId.then(vpcId => vpcId.addresses?.[0]?.id);
     * const status = alicloud.vpc.getIpv6Addresses({
     *     status: "Available",
     * });
     * export const vpcIpv6AddressId4 = status.then(status => status.addresses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * associated_instance_id = alicloud.vpc.get_ipv6_addresses(associated_instance_id="example_value")
     * pulumi.export("vpcIpv6AddressId1", associated_instance_id.addresses[0].id)
     * vswitch_id = alicloud.vpc.get_ipv6_addresses(vswitch_id="example_value")
     * pulumi.export("vpcIpv6AddressId2", vswitch_id.addresses[0].id)
     * vpc_id = alicloud.vpc.get_ipv6_addresses(vpc_id="example_value")
     * pulumi.export("vpcIpv6AddressId3", vpc_id.addresses[0].id)
     * status = alicloud.vpc.get_ipv6_addresses(status="Available")
     * pulumi.export("vpcIpv6AddressId4", status.addresses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var associatedInstanceId = AliCloud.Vpc.GetIpv6Addresses.Invoke(new()
     *     {
     *         AssociatedInstanceId = "example_value",
     *     });
     *     var vswitchId = AliCloud.Vpc.GetIpv6Addresses.Invoke(new()
     *     {
     *         VswitchId = "example_value",
     *     });
     *     var vpcId = AliCloud.Vpc.GetIpv6Addresses.Invoke(new()
     *     {
     *         VpcId = "example_value",
     *     });
     *     var status = AliCloud.Vpc.GetIpv6Addresses.Invoke(new()
     *     {
     *         Status = "Available",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcIpv6AddressId1"] = associatedInstanceId&#46;Apply(getIpv6AddressesResult => getIpv6AddressesResult&#46;Addresses[0]?.Id),
     *         ["vpcIpv6AddressId2"] = vswitchId&#46;Apply(getIpv6AddressesResult => getIpv6AddressesResult&#46;Addresses[0]?.Id),
     *         ["vpcIpv6AddressId3"] = vpcId&#46;Apply(getIpv6AddressesResult => getIpv6AddressesResult&#46;Addresses[0]?.Id),
     *         ["vpcIpv6AddressId4"] = status&#46;Apply(getIpv6AddressesResult => getIpv6AddressesResult&#46;Addresses[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		associatedInstanceId, err := vpc.GetIpv6Addresses(ctx, &vpc.GetIpv6AddressesArgs{
     * 			AssociatedInstanceId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6AddressId1", associatedInstanceId.Addresses[0].Id)
     * 		vswitchId, err := vpc.GetIpv6Addresses(ctx, &vpc.GetIpv6AddressesArgs{
     * 			VswitchId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6AddressId2", vswitchId.Addresses[0].Id)
     * 		vpcId, err := vpc.GetIpv6Addresses(ctx, &vpc.GetIpv6AddressesArgs{
     * 			VpcId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6AddressId3", vpcId.Addresses[0].Id)
     * 		status, err := vpc.GetIpv6Addresses(ctx, &vpc.GetIpv6AddressesArgs{
     * 			Status: pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6AddressId4", status.Addresses[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetIpv6AddressesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var associatedInstanceId = VpcFunctions.getIpv6Addresses(GetIpv6AddressesArgs.builder()
     *             .associatedInstanceId("example_value")
     *             .build());
     *         ctx.export("vpcIpv6AddressId1", associatedInstanceId.applyValue(getIpv6AddressesResult -> getIpv6AddressesResult.addresses()[0].id()));
     *         final var vswitchId = VpcFunctions.getIpv6Addresses(GetIpv6AddressesArgs.builder()
     *             .vswitchId("example_value")
     *             .build());
     *         ctx.export("vpcIpv6AddressId2", vswitchId.applyValue(getIpv6AddressesResult -> getIpv6AddressesResult.addresses()[0].id()));
     *         final var vpcId = VpcFunctions.getIpv6Addresses(GetIpv6AddressesArgs.builder()
     *             .vpcId("example_value")
     *             .build());
     *         ctx.export("vpcIpv6AddressId3", vpcId.applyValue(getIpv6AddressesResult -> getIpv6AddressesResult.addresses()[0].id()));
     *         final var status = VpcFunctions.getIpv6Addresses(GetIpv6AddressesArgs.builder()
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcIpv6AddressId4", status.applyValue(getIpv6AddressesResult -> getIpv6AddressesResult.addresses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   associatedInstanceId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Addresses
     *       Arguments:
     *         associatedInstanceId: example_value
     *   vswitchId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Addresses
     *       Arguments:
     *         vswitchId: example_value
     *   vpcId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Addresses
     *       Arguments:
     *         vpcId: example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Addresses
     *       Arguments:
     *         status: Available
     * outputs:
     *   vpcIpv6AddressId1: ${associatedInstanceId.addresses[0].id}
     *   vpcIpv6AddressId2: ${vswitchId.addresses[0].id}
     *   vpcIpv6AddressId3: ${vpcId.addresses[0].id}
     *   vpcIpv6AddressId4: ${status.addresses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpv6Addresses.
     * @return A collection of values returned by getIpv6Addresses.
     */
    public suspend fun getIpv6Addresses(argument: GetIpv6AddressesPlainArgs): GetIpv6AddressesResult =
        getIpv6AddressesResultToKotlin(getIpv6AddressesPlain(argument.toJava()).await())

    /**
     * @see [getIpv6Addresses].
     * @param associatedInstanceId The ID of the instance that is assigned the IPv6 address.
     * @param ids
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the IPv6 address. Valid values:`Pending` or `Available`.
     * - `Pending`: The IPv6 address is being configured.
     * - `Available`: The IPv6 address is available.
     * @param vpcId The ID of the VPC to which the IPv6 address belongs.
     * @param vswitchId The ID of the vSwitch to which the IPv6 address belongs.
     * @return A collection of values returned by getIpv6Addresses.
     */
    public suspend fun getIpv6Addresses(
        associatedInstanceId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetIpv6AddressesResult {
        val argument = GetIpv6AddressesPlainArgs(
            associatedInstanceId = associatedInstanceId,
            ids = ids,
            outputFile = outputFile,
            status = status,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getIpv6AddressesResultToKotlin(getIpv6AddressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpv6Addresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetIpv6AddressesPlainArgs].
     * @return A collection of values returned by getIpv6Addresses.
     */
    public suspend fun getIpv6Addresses(argument: suspend GetIpv6AddressesPlainArgsBuilder.() -> Unit): GetIpv6AddressesResult {
        val builder = GetIpv6AddressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpv6AddressesResultToKotlin(getIpv6AddressesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Ipv6 Egress Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getIpv6EgressRules({
     *     ipv6GatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const vpcIpv6EgressRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const nameRegex = alicloud.vpc.getIpv6EgressRules({
     *     ipv6GatewayId: "example_value",
     *     nameRegex: "^my-Ipv6EgressRule",
     * });
     * export const vpcIpv6EgressRuleId2 = nameRegex.then(nameRegex => nameRegex.rules?.[0]?.id);
     * const status = alicloud.vpc.getIpv6EgressRules({
     *     ipv6GatewayId: "example_value",
     *     status: "Available",
     * });
     * export const vpcIpv6EgressRuleId3 = status.then(status => status.rules?.[0]?.id);
     * const ipv6EgressRuleName = alicloud.vpc.getIpv6EgressRules({
     *     ipv6GatewayId: "example_value",
     *     ipv6EgressRuleName: "example_value",
     * });
     * export const vpcIpv6EgressRuleId4 = ipv6EgressRuleName.then(ipv6EgressRuleName => ipv6EgressRuleName.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_ipv6_egress_rules(ipv6_gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("vpcIpv6EgressRuleId1", ids.rules[0].id)
     * name_regex = alicloud.vpc.get_ipv6_egress_rules(ipv6_gateway_id="example_value",
     *     name_regex="^my-Ipv6EgressRule")
     * pulumi.export("vpcIpv6EgressRuleId2", name_regex.rules[0].id)
     * status = alicloud.vpc.get_ipv6_egress_rules(ipv6_gateway_id="example_value",
     *     status="Available")
     * pulumi.export("vpcIpv6EgressRuleId3", status.rules[0].id)
     * ipv6_egress_rule_name = alicloud.vpc.get_ipv6_egress_rules(ipv6_gateway_id="example_value",
     *     ipv6_egress_rule_name="example_value")
     * pulumi.export("vpcIpv6EgressRuleId4", ipv6_egress_rule_name.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetIpv6EgressRules.Invoke(new()
     *     {
     *         Ipv6GatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetIpv6EgressRules.Invoke(new()
     *     {
     *         Ipv6GatewayId = "example_value",
     *         NameRegex = "^my-Ipv6EgressRule",
     *     });
     *     var status = AliCloud.Vpc.GetIpv6EgressRules.Invoke(new()
     *     {
     *         Ipv6GatewayId = "example_value",
     *         Status = "Available",
     *     });
     *     var ipv6EgressRuleName = AliCloud.Vpc.GetIpv6EgressRules.Invoke(new()
     *     {
     *         Ipv6GatewayId = "example_value",
     *         Ipv6EgressRuleName = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcIpv6EgressRuleId1"] = ids&#46;Apply(getIpv6EgressRulesResult => getIpv6EgressRulesResult&#46;Rules[0]?.Id),
     *         ["vpcIpv6EgressRuleId2"] = nameRegex&#46;Apply(getIpv6EgressRulesResult => getIpv6EgressRulesResult&#46;Rules[0]?.Id),
     *         ["vpcIpv6EgressRuleId3"] = status&#46;Apply(getIpv6EgressRulesResult => getIpv6EgressRulesResult&#46;Rules[0]?.Id),
     *         ["vpcIpv6EgressRuleId4"] = ipv6EgressRuleName&#46;Apply(getIpv6EgressRulesResult => getIpv6EgressRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetIpv6EgressRules(ctx, &vpc.GetIpv6EgressRulesArgs{
     * 			Ipv6GatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6EgressRuleId1", ids.Rules[0].Id)
     * 		nameRegex, err := vpc.GetIpv6EgressRules(ctx, &vpc.GetIpv6EgressRulesArgs{
     * 			Ipv6GatewayId: "example_value",
     * 			NameRegex:     pulumi.StringRef("^my-Ipv6EgressRule"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6EgressRuleId2", nameRegex.Rules[0].Id)
     * 		status, err := vpc.GetIpv6EgressRules(ctx, &vpc.GetIpv6EgressRulesArgs{
     * 			Ipv6GatewayId: "example_value",
     * 			Status:        pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6EgressRuleId3", status.Rules[0].Id)
     * 		ipv6EgressRuleName, err := vpc.GetIpv6EgressRules(ctx, &vpc.GetIpv6EgressRulesArgs{
     * 			Ipv6GatewayId:      "example_value",
     * 			Ipv6EgressRuleName: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6EgressRuleId4", ipv6EgressRuleName.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetIpv6EgressRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getIpv6EgressRules(GetIpv6EgressRulesArgs.builder()
     *             .ipv6GatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("vpcIpv6EgressRuleId1", ids.applyValue(getIpv6EgressRulesResult -> getIpv6EgressRulesResult.rules()[0].id()));
     *         final var nameRegex = VpcFunctions.getIpv6EgressRules(GetIpv6EgressRulesArgs.builder()
     *             .ipv6GatewayId("example_value")
     *             .nameRegex("^my-Ipv6EgressRule")
     *             .build());
     *         ctx.export("vpcIpv6EgressRuleId2", nameRegex.applyValue(getIpv6EgressRulesResult -> getIpv6EgressRulesResult.rules()[0].id()));
     *         final var status = VpcFunctions.getIpv6EgressRules(GetIpv6EgressRulesArgs.builder()
     *             .ipv6GatewayId("example_value")
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcIpv6EgressRuleId3", status.applyValue(getIpv6EgressRulesResult -> getIpv6EgressRulesResult.rules()[0].id()));
     *         final var ipv6EgressRuleName = VpcFunctions.getIpv6EgressRules(GetIpv6EgressRulesArgs.builder()
     *             .ipv6GatewayId("example_value")
     *             .ipv6EgressRuleName("example_value")
     *             .build());
     *         ctx.export("vpcIpv6EgressRuleId4", ipv6EgressRuleName.applyValue(getIpv6EgressRulesResult -> getIpv6EgressRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6EgressRules
     *       Arguments:
     *         ipv6GatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6EgressRules
     *       Arguments:
     *         ipv6GatewayId: example_value
     *         nameRegex: ^my-Ipv6EgressRule
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6EgressRules
     *       Arguments:
     *         ipv6GatewayId: example_value
     *         status: Available
     *   ipv6EgressRuleName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6EgressRules
     *       Arguments:
     *         ipv6GatewayId: example_value
     *         ipv6EgressRuleName: example_value
     * outputs:
     *   vpcIpv6EgressRuleId1: ${ids.rules[0].id}
     *   vpcIpv6EgressRuleId2: ${nameRegex.rules[0].id}
     *   vpcIpv6EgressRuleId3: ${status.rules[0].id}
     *   vpcIpv6EgressRuleId4: ${ipv6EgressRuleName.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpv6EgressRules.
     * @return A collection of values returned by getIpv6EgressRules.
     */
    public suspend fun getIpv6EgressRules(argument: GetIpv6EgressRulesPlainArgs): GetIpv6EgressRulesResult =
        getIpv6EgressRulesResultToKotlin(getIpv6EgressRulesPlain(argument.toJava()).await())

    /**
     * @see [getIpv6EgressRules].
     * @param ids A list of Ipv6 Egress Rule IDs.
     * @param instanceId The ID of the instance that is associated with the IPv6 address to which the egress-only rule is applied.
     * @param ipv6EgressRuleName The name of the resource.
     * @param ipv6GatewayId The ID of the IPv6 gateway.
     * @param nameRegex A regex string to filter results by Ipv6 Egress Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Available`, `Deleting`, `Pending`.
     * @return A collection of values returned by getIpv6EgressRules.
     */
    public suspend fun getIpv6EgressRules(
        ids: List<String>? = null,
        instanceId: String? = null,
        ipv6EgressRuleName: String? = null,
        ipv6GatewayId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetIpv6EgressRulesResult {
        val argument = GetIpv6EgressRulesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            ipv6EgressRuleName = ipv6EgressRuleName,
            ipv6GatewayId = ipv6GatewayId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getIpv6EgressRulesResultToKotlin(getIpv6EgressRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpv6EgressRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetIpv6EgressRulesPlainArgs].
     * @return A collection of values returned by getIpv6EgressRules.
     */
    public suspend fun getIpv6EgressRules(argument: suspend GetIpv6EgressRulesPlainArgsBuilder.() -> Unit): GetIpv6EgressRulesResult {
        val builder = GetIpv6EgressRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpv6EgressRulesResultToKotlin(getIpv6EgressRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Ipv6 Gateways of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getIpv6Gateways({
     *     ids: ["example_id"],
     * });
     * export const vpcIpv6GatewayId1 = ids.then(ids => ids.gateways?.[0]?.id);
     * const nameRegex = alicloud.vpc.getIpv6Gateways({
     *     nameRegex: "^my-Ipv6Gateway",
     * });
     * export const vpcIpv6GatewayId2 = nameRegex.then(nameRegex => nameRegex.gateways?.[0]?.id);
     * const vpcId = alicloud.vpc.getIpv6Gateways({
     *     ids: ["example_id"],
     *     vpcId: "example_value",
     * });
     * export const vpcIpv6GatewayId3 = vpcId.then(vpcId => vpcId.gateways?.[0]?.id);
     * const status = alicloud.vpc.getIpv6Gateways({
     *     ids: ["example_id"],
     *     status: "Available",
     * });
     * export const vpcIpv6GatewayId4 = status.then(status => status.gateways?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_ipv6_gateways(ids=["example_id"])
     * pulumi.export("vpcIpv6GatewayId1", ids.gateways[0].id)
     * name_regex = alicloud.vpc.get_ipv6_gateways(name_regex="^my-Ipv6Gateway")
     * pulumi.export("vpcIpv6GatewayId2", name_regex.gateways[0].id)
     * vpc_id = alicloud.vpc.get_ipv6_gateways(ids=["example_id"],
     *     vpc_id="example_value")
     * pulumi.export("vpcIpv6GatewayId3", vpc_id.gateways[0].id)
     * status = alicloud.vpc.get_ipv6_gateways(ids=["example_id"],
     *     status="Available")
     * pulumi.export("vpcIpv6GatewayId4", status.gateways[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetIpv6Gateways.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetIpv6Gateways.Invoke(new()
     *     {
     *         NameRegex = "^my-Ipv6Gateway",
     *     });
     *     var vpcId = AliCloud.Vpc.GetIpv6Gateways.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         VpcId = "example_value",
     *     });
     *     var status = AliCloud.Vpc.GetIpv6Gateways.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Status = "Available",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcIpv6GatewayId1"] = ids&#46;Apply(getIpv6GatewaysResult => getIpv6GatewaysResult&#46;Gateways[0]?.Id),
     *         ["vpcIpv6GatewayId2"] = nameRegex&#46;Apply(getIpv6GatewaysResult => getIpv6GatewaysResult&#46;Gateways[0]?.Id),
     *         ["vpcIpv6GatewayId3"] = vpcId&#46;Apply(getIpv6GatewaysResult => getIpv6GatewaysResult&#46;Gateways[0]?.Id),
     *         ["vpcIpv6GatewayId4"] = status&#46;Apply(getIpv6GatewaysResult => getIpv6GatewaysResult&#46;Gateways[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetIpv6Gateways(ctx, &vpc.GetIpv6GatewaysArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6GatewayId1", ids.Gateways[0].Id)
     * 		nameRegex, err := vpc.GetIpv6Gateways(ctx, &vpc.GetIpv6GatewaysArgs{
     * 			NameRegex: pulumi.StringRef("^my-Ipv6Gateway"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6GatewayId2", nameRegex.Gateways[0].Id)
     * 		vpcId, err := vpc.GetIpv6Gateways(ctx, &vpc.GetIpv6GatewaysArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			VpcId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6GatewayId3", vpcId.Gateways[0].Id)
     * 		status, err := vpc.GetIpv6Gateways(ctx, &vpc.GetIpv6GatewaysArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Status: pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6GatewayId4", status.Gateways[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetIpv6GatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getIpv6Gateways(GetIpv6GatewaysArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcIpv6GatewayId1", ids.applyValue(getIpv6GatewaysResult -> getIpv6GatewaysResult.gateways()[0].id()));
     *         final var nameRegex = VpcFunctions.getIpv6Gateways(GetIpv6GatewaysArgs.builder()
     *             .nameRegex("^my-Ipv6Gateway")
     *             .build());
     *         ctx.export("vpcIpv6GatewayId2", nameRegex.applyValue(getIpv6GatewaysResult -> getIpv6GatewaysResult.gateways()[0].id()));
     *         final var vpcId = VpcFunctions.getIpv6Gateways(GetIpv6GatewaysArgs.builder()
     *             .ids("example_id")
     *             .vpcId("example_value")
     *             .build());
     *         ctx.export("vpcIpv6GatewayId3", vpcId.applyValue(getIpv6GatewaysResult -> getIpv6GatewaysResult.gateways()[0].id()));
     *         final var status = VpcFunctions.getIpv6Gateways(GetIpv6GatewaysArgs.builder()
     *             .ids("example_id")
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcIpv6GatewayId4", status.applyValue(getIpv6GatewaysResult -> getIpv6GatewaysResult.gateways()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Gateways
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Gateways
     *       Arguments:
     *         nameRegex: ^my-Ipv6Gateway
     *   vpcId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Gateways
     *       Arguments:
     *         ids:
     *           - example_id
     *         vpcId: example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6Gateways
     *       Arguments:
     *         ids:
     *           - example_id
     *         status: Available
     * outputs:
     *   vpcIpv6GatewayId1: ${ids.gateways[0].id}
     *   vpcIpv6GatewayId2: ${nameRegex.gateways[0].id}
     *   vpcIpv6GatewayId3: ${vpcId.gateways[0].id}
     *   vpcIpv6GatewayId4: ${status.gateways[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpv6Gateways.
     * @return A collection of values returned by getIpv6Gateways.
     */
    public suspend fun getIpv6Gateways(argument: GetIpv6GatewaysPlainArgs): GetIpv6GatewaysResult =
        getIpv6GatewaysResultToKotlin(getIpv6GatewaysPlain(argument.toJava()).await())

    /**
     * @see [getIpv6Gateways].
     * @param ids A list of Ipv6 Gateway IDs.
     * @param ipv6GatewayName The name of the IPv6 gateway.
     * @param nameRegex A regex string to filter results by Ipv6 Gateway name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Available`, `Deleting`, `Pending`.
     * @param vpcId The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
     * @return A collection of values returned by getIpv6Gateways.
     */
    public suspend fun getIpv6Gateways(
        ids: List<String>? = null,
        ipv6GatewayName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        vpcId: String? = null,
    ): GetIpv6GatewaysResult {
        val argument = GetIpv6GatewaysPlainArgs(
            ids = ids,
            ipv6GatewayName = ipv6GatewayName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            vpcId = vpcId,
        )
        return getIpv6GatewaysResultToKotlin(getIpv6GatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpv6Gateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetIpv6GatewaysPlainArgs].
     * @return A collection of values returned by getIpv6Gateways.
     */
    public suspend fun getIpv6Gateways(argument: suspend GetIpv6GatewaysPlainArgsBuilder.() -> Unit): GetIpv6GatewaysResult {
        val builder = GetIpv6GatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpv6GatewaysResultToKotlin(getIpv6GatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Ipv6 Internet Bandwidths of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getIpv6InternetBandwidths({
     *     ids: ["example_id"],
     * });
     * export const vpcIpv6InternetBandwidthId1 = ids.then(ids => ids.bandwidths?.[0]?.id);
     * const ipv6InternetBandwidthId = alicloud.vpc.getIpv6InternetBandwidths({
     *     ipv6InternetBandwidthId: "example_value",
     * });
     * export const vpcIpv6InternetBandwidthId2 = ipv6InternetBandwidthId.then(ipv6InternetBandwidthId => ipv6InternetBandwidthId.bandwidths?.[0]?.id);
     * const ipv6AddressId = alicloud.vpc.getIpv6InternetBandwidths({
     *     ipv6AddressId: "example_value",
     * });
     * export const vpcIpv6InternetBandwidthId3 = ipv6AddressId.then(ipv6AddressId => ipv6AddressId.bandwidths?.[0]?.id);
     * const status = alicloud.vpc.getIpv6InternetBandwidths({
     *     status: "Normal",
     * });
     * export const vpcIpv6InternetBandwidthId4 = status.then(status => status.bandwidths?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_ipv6_internet_bandwidths(ids=["example_id"])
     * pulumi.export("vpcIpv6InternetBandwidthId1", ids.bandwidths[0].id)
     * ipv6_internet_bandwidth_id = alicloud.vpc.get_ipv6_internet_bandwidths(ipv6_internet_bandwidth_id="example_value")
     * pulumi.export("vpcIpv6InternetBandwidthId2", ipv6_internet_bandwidth_id.bandwidths[0].id)
     * ipv6_address_id = alicloud.vpc.get_ipv6_internet_bandwidths(ipv6_address_id="example_value")
     * pulumi.export("vpcIpv6InternetBandwidthId3", ipv6_address_id.bandwidths[0].id)
     * status = alicloud.vpc.get_ipv6_internet_bandwidths(status="Normal")
     * pulumi.export("vpcIpv6InternetBandwidthId4", status.bandwidths[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetIpv6InternetBandwidths.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var ipv6InternetBandwidthId = AliCloud.Vpc.GetIpv6InternetBandwidths.Invoke(new()
     *     {
     *         Ipv6InternetBandwidthId = "example_value",
     *     });
     *     var ipv6AddressId = AliCloud.Vpc.GetIpv6InternetBandwidths.Invoke(new()
     *     {
     *         Ipv6AddressId = "example_value",
     *     });
     *     var status = AliCloud.Vpc.GetIpv6InternetBandwidths.Invoke(new()
     *     {
     *         Status = "Normal",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcIpv6InternetBandwidthId1"] = ids&#46;Apply(getIpv6InternetBandwidthsResult => getIpv6InternetBandwidthsResult&#46;Bandwidths[0]?.Id),
     *         ["vpcIpv6InternetBandwidthId2"] = ipv6InternetBandwidthId&#46;Apply(getIpv6InternetBandwidthsResult => getIpv6InternetBandwidthsResult&#46;Bandwidths[0]?.Id),
     *         ["vpcIpv6InternetBandwidthId3"] = ipv6AddressId&#46;Apply(getIpv6InternetBandwidthsResult => getIpv6InternetBandwidthsResult&#46;Bandwidths[0]?.Id),
     *         ["vpcIpv6InternetBandwidthId4"] = status&#46;Apply(getIpv6InternetBandwidthsResult => getIpv6InternetBandwidthsResult&#46;Bandwidths[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetIpv6InternetBandwidths(ctx, &vpc.GetIpv6InternetBandwidthsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6InternetBandwidthId1", ids.Bandwidths[0].Id)
     * 		ipv6InternetBandwidthId, err := vpc.GetIpv6InternetBandwidths(ctx, &vpc.GetIpv6InternetBandwidthsArgs{
     * 			Ipv6InternetBandwidthId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6InternetBandwidthId2", ipv6InternetBandwidthId.Bandwidths[0].Id)
     * 		ipv6AddressId, err := vpc.GetIpv6InternetBandwidths(ctx, &vpc.GetIpv6InternetBandwidthsArgs{
     * 			Ipv6AddressId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6InternetBandwidthId3", ipv6AddressId.Bandwidths[0].Id)
     * 		status, err := vpc.GetIpv6InternetBandwidths(ctx, &vpc.GetIpv6InternetBandwidthsArgs{
     * 			Status: pulumi.StringRef("Normal"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcIpv6InternetBandwidthId4", status.Bandwidths[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetIpv6InternetBandwidthsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getIpv6InternetBandwidths(GetIpv6InternetBandwidthsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcIpv6InternetBandwidthId1", ids.applyValue(getIpv6InternetBandwidthsResult -> getIpv6InternetBandwidthsResult.bandwidths()[0].id()));
     *         final var ipv6InternetBandwidthId = VpcFunctions.getIpv6InternetBandwidths(GetIpv6InternetBandwidthsArgs.builder()
     *             .ipv6InternetBandwidthId("example_value")
     *             .build());
     *         ctx.export("vpcIpv6InternetBandwidthId2", ipv6InternetBandwidthId.applyValue(getIpv6InternetBandwidthsResult -> getIpv6InternetBandwidthsResult.bandwidths()[0].id()));
     *         final var ipv6AddressId = VpcFunctions.getIpv6InternetBandwidths(GetIpv6InternetBandwidthsArgs.builder()
     *             .ipv6AddressId("example_value")
     *             .build());
     *         ctx.export("vpcIpv6InternetBandwidthId3", ipv6AddressId.applyValue(getIpv6InternetBandwidthsResult -> getIpv6InternetBandwidthsResult.bandwidths()[0].id()));
     *         final var status = VpcFunctions.getIpv6InternetBandwidths(GetIpv6InternetBandwidthsArgs.builder()
     *             .status("Normal")
     *             .build());
     *         ctx.export("vpcIpv6InternetBandwidthId4", status.applyValue(getIpv6InternetBandwidthsResult -> getIpv6InternetBandwidthsResult.bandwidths()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6InternetBandwidths
     *       Arguments:
     *         ids:
     *           - example_id
     *   ipv6InternetBandwidthId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6InternetBandwidths
     *       Arguments:
     *         ipv6InternetBandwidthId: example_value
     *   ipv6AddressId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6InternetBandwidths
     *       Arguments:
     *         ipv6AddressId: example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getIpv6InternetBandwidths
     *       Arguments:
     *         status: Normal
     * outputs:
     *   vpcIpv6InternetBandwidthId1: ${ids.bandwidths[0].id}
     *   vpcIpv6InternetBandwidthId2: ${ipv6InternetBandwidthId.bandwidths[0].id}
     *   vpcIpv6InternetBandwidthId3: ${ipv6AddressId.bandwidths[0].id}
     *   vpcIpv6InternetBandwidthId4: ${status.bandwidths[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpv6InternetBandwidths.
     * @return A collection of values returned by getIpv6InternetBandwidths.
     */
    public suspend fun getIpv6InternetBandwidths(argument: GetIpv6InternetBandwidthsPlainArgs): GetIpv6InternetBandwidthsResult =
        getIpv6InternetBandwidthsResultToKotlin(getIpv6InternetBandwidthsPlain(argument.toJava()).await())

    /**
     * @see [getIpv6InternetBandwidths].
     * @param ids A list of Ipv6 Internet Bandwidth IDs.
     * @param ipv6AddressId The ID of the IPv6 address.
     * @param ipv6InternetBandwidthId The ID of the Ipv6 Internet Bandwidth.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
     * @return A collection of values returned by getIpv6InternetBandwidths.
     */
    public suspend fun getIpv6InternetBandwidths(
        ids: List<String>? = null,
        ipv6AddressId: String? = null,
        ipv6InternetBandwidthId: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetIpv6InternetBandwidthsResult {
        val argument = GetIpv6InternetBandwidthsPlainArgs(
            ids = ids,
            ipv6AddressId = ipv6AddressId,
            ipv6InternetBandwidthId = ipv6InternetBandwidthId,
            outputFile = outputFile,
            status = status,
        )
        return getIpv6InternetBandwidthsResultToKotlin(getIpv6InternetBandwidthsPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpv6InternetBandwidths].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetIpv6InternetBandwidthsPlainArgs].
     * @return A collection of values returned by getIpv6InternetBandwidths.
     */
    public suspend fun getIpv6InternetBandwidths(argument: suspend GetIpv6InternetBandwidthsPlainArgsBuilder.() -> Unit): GetIpv6InternetBandwidthsResult {
        val builder = GetIpv6InternetBandwidthsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpv6InternetBandwidthsResultToKotlin(getIpv6InternetBandwidthsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Nat Gateways owned by an Alibaba Cloud account.
     * > **NOTE:** Available in 1.37.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: natGatewaysDatasource
     * resources:
     *   fooNetwork:
     *     type: alicloud:vpc:Network
     *     name: foo
     *     properties:
     *       vpcName: ${name}
     *       cidrBlock: 172.16.0.0/12
     *   fooNatGateway:
     *     type: alicloud:vpc:NatGateway
     *     name: foo
     *     properties:
     *       vpcId: ${fooNetwork.id}
     *       specification: Small
     *       natGateName: ${name}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatGateways
     *       Arguments:
     *         vpcId: ${fooNetwork.id}
     *         nameRegex: ${fooNatGateway.name}
     *         ids:
     *           - ${fooNatGateway.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNatGateways.
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(argument: GetNatGatewaysPlainArgs): GetNatGatewaysResult =
        getNatGatewaysResultToKotlin(getNatGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getNatGateways].
     * @param dryRun Specifies whether to only precheck the request.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of NAT gateways IDs.
     * @param nameRegex A regex string to filter nat gateways by name.
     * @param natGatewayName The name of NAT gateway.
     * @param natType The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param paymentType The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
     * @param resourceGroupId The resource group id of NAT gateway.
     * @param specification The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
     * @param status The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
     * @param tags The tags of NAT gateway.
     * @param vpcId The ID of the VPC.
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(
        dryRun: Boolean? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        natGatewayName: String? = null,
        natType: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        paymentType: String? = null,
        resourceGroupId: String? = null,
        specification: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNatGatewaysResult {
        val argument = GetNatGatewaysPlainArgs(
            dryRun = dryRun,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            natGatewayName = natGatewayName,
            natType = natType,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            paymentType = paymentType,
            resourceGroupId = resourceGroupId,
            specification = specification,
            status = status,
            tags = tags,
            vpcId = vpcId,
        )
        return getNatGatewaysResultToKotlin(getNatGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatGateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetNatGatewaysPlainArgs].
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(argument: suspend GetNatGatewaysPlainArgsBuilder.() -> Unit): GetNatGatewaysResult {
        val builder = GetNatGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatGatewaysResultToKotlin(getNatGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Nat Ip Cidrs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getNatIpCidrs({
     *     natGatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const vpcNatIpCidrId1 = ids.then(ids => ids.cidrs?.[0]?.id);
     * const nameRegex = alicloud.vpc.getNatIpCidrs({
     *     natGatewayId: "example_value",
     *     nameRegex: "^my-NatIpCidr",
     * });
     * export const vpcNatIpCidrId2 = nameRegex.then(nameRegex => nameRegex.cidrs?.[0]?.id);
     * const status = alicloud.vpc.getNatIpCidrs({
     *     natGatewayId: "example_value",
     *     ids: ["example_value-1"],
     *     status: "Available",
     * });
     * export const vpcNatIpCidrId3 = status.then(status => status.cidrs?.[0]?.id);
     * const natIpCidr = alicloud.vpc.getNatIpCidrs({
     *     natGatewayId: "example_value",
     *     natIpCidrs: ["example_value-1"],
     * });
     * export const vpcNatIpCidrId4 = natIpCidr.then(natIpCidr => natIpCidr.cidrs?.[0]?.id);
     * const atIpCidrName = alicloud.vpc.getNatIpCidrs({
     *     natGatewayId: "example_value",
     *     natIpCidrNames: ["example_value-1"],
     * });
     * export const vpcNatIpCidrId5 = atIpCidrName.then(atIpCidrName => atIpCidrName.cidrs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_nat_ip_cidrs(nat_gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("vpcNatIpCidrId1", ids.cidrs[0].id)
     * name_regex = alicloud.vpc.get_nat_ip_cidrs(nat_gateway_id="example_value",
     *     name_regex="^my-NatIpCidr")
     * pulumi.export("vpcNatIpCidrId2", name_regex.cidrs[0].id)
     * status = alicloud.vpc.get_nat_ip_cidrs(nat_gateway_id="example_value",
     *     ids=["example_value-1"],
     *     status="Available")
     * pulumi.export("vpcNatIpCidrId3", status.cidrs[0].id)
     * nat_ip_cidr = alicloud.vpc.get_nat_ip_cidrs(nat_gateway_id="example_value",
     *     nat_ip_cidrs=["example_value-1"])
     * pulumi.export("vpcNatIpCidrId4", nat_ip_cidr.cidrs[0].id)
     * at_ip_cidr_name = alicloud.vpc.get_nat_ip_cidrs(nat_gateway_id="example_value",
     *     nat_ip_cidr_names=["example_value-1"])
     * pulumi.export("vpcNatIpCidrId5", at_ip_cidr_name.cidrs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetNatIpCidrs.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetNatIpCidrs.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         NameRegex = "^my-NatIpCidr",
     *     });
     *     var status = AliCloud.Vpc.GetNatIpCidrs.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *         },
     *         Status = "Available",
     *     });
     *     var natIpCidr = AliCloud.Vpc.GetNatIpCidrs.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         NatIpCidrs = new[]
     *         {
     *             "example_value-1",
     *         },
     *     });
     *     var atIpCidrName = AliCloud.Vpc.GetNatIpCidrs.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         NatIpCidrNames = new[]
     *         {
     *             "example_value-1",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcNatIpCidrId1"] = ids&#46;Apply(getNatIpCidrsResult => getNatIpCidrsResult&#46;Cidrs[0]?.Id),
     *         ["vpcNatIpCidrId2"] = nameRegex&#46;Apply(getNatIpCidrsResult => getNatIpCidrsResult&#46;Cidrs[0]?.Id),
     *         ["vpcNatIpCidrId3"] = status&#46;Apply(getNatIpCidrsResult => getNatIpCidrsResult&#46;Cidrs[0]?.Id),
     *         ["vpcNatIpCidrId4"] = natIpCidr&#46;Apply(getNatIpCidrsResult => getNatIpCidrsResult&#46;Cidrs[0]?.Id),
     *         ["vpcNatIpCidrId5"] = atIpCidrName&#46;Apply(getNatIpCidrsResult => getNatIpCidrsResult&#46;Cidrs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetNatIpCidrs(ctx, &vpc.GetNatIpCidrsArgs{
     * 			NatGatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpCidrId1", ids.Cidrs[0].Id)
     * 		nameRegex, err := vpc.GetNatIpCidrs(ctx, &vpc.GetNatIpCidrsArgs{
     * 			NatGatewayId: "example_value",
     * 			NameRegex:    pulumi.StringRef("^my-NatIpCidr"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpCidrId2", nameRegex.Cidrs[0].Id)
     * 		status, err := vpc.GetNatIpCidrs(ctx, &vpc.GetNatIpCidrsArgs{
     * 			NatGatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 			},
     * 			Status: pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpCidrId3", status.Cidrs[0].Id)
     * 		natIpCidr, err := vpc.GetNatIpCidrs(ctx, &vpc.GetNatIpCidrsArgs{
     * 			NatGatewayId: "example_value",
     * 			NatIpCidrs: []string{
     * 				"example_value-1",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpCidrId4", natIpCidr.Cidrs[0].Id)
     * 		atIpCidrName, err := vpc.GetNatIpCidrs(ctx, &vpc.GetNatIpCidrsArgs{
     * 			NatGatewayId: "example_value",
     * 			NatIpCidrNames: []string{
     * 				"example_value-1",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpCidrId5", atIpCidrName.Cidrs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNatIpCidrsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getNatIpCidrs(GetNatIpCidrsArgs.builder()
     *             .natGatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("vpcNatIpCidrId1", ids.applyValue(getNatIpCidrsResult -> getNatIpCidrsResult.cidrs()[0].id()));
     *         final var nameRegex = VpcFunctions.getNatIpCidrs(GetNatIpCidrsArgs.builder()
     *             .natGatewayId("example_value")
     *             .nameRegex("^my-NatIpCidr")
     *             .build());
     *         ctx.export("vpcNatIpCidrId2", nameRegex.applyValue(getNatIpCidrsResult -> getNatIpCidrsResult.cidrs()[0].id()));
     *         final var status = VpcFunctions.getNatIpCidrs(GetNatIpCidrsArgs.builder()
     *             .natGatewayId("example_value")
     *             .ids("example_value-1")
     *             .status("Available")
     *             .build());
     *         ctx.export("vpcNatIpCidrId3", status.applyValue(getNatIpCidrsResult -> getNatIpCidrsResult.cidrs()[0].id()));
     *         final var natIpCidr = VpcFunctions.getNatIpCidrs(GetNatIpCidrsArgs.builder()
     *             .natGatewayId("example_value")
     *             .natIpCidrs("example_value-1")
     *             .build());
     *         ctx.export("vpcNatIpCidrId4", natIpCidr.applyValue(getNatIpCidrsResult -> getNatIpCidrsResult.cidrs()[0].id()));
     *         final var atIpCidrName = VpcFunctions.getNatIpCidrs(GetNatIpCidrsArgs.builder()
     *             .natGatewayId("example_value")
     *             .natIpCidrNames("example_value-1")
     *             .build());
     *         ctx.export("vpcNatIpCidrId5", atIpCidrName.applyValue(getNatIpCidrsResult -> getNatIpCidrsResult.cidrs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIpCidrs
     *       Arguments:
     *         natGatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIpCidrs
     *       Arguments:
     *         natGatewayId: example_value
     *         nameRegex: ^my-NatIpCidr
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIpCidrs
     *       Arguments:
     *         natGatewayId: example_value
     *         ids:
     *           - example_value-1
     *         status: Available
     *   natIpCidr:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIpCidrs
     *       Arguments:
     *         natGatewayId: example_value
     *         natIpCidrs:
     *           - example_value-1
     *   atIpCidrName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIpCidrs
     *       Arguments:
     *         natGatewayId: example_value
     *         natIpCidrNames:
     *           - example_value-1
     * outputs:
     *   vpcNatIpCidrId1: ${ids.cidrs[0].id}
     *   vpcNatIpCidrId2: ${nameRegex.cidrs[0].id}
     *   vpcNatIpCidrId3: ${status.cidrs[0].id}
     *   vpcNatIpCidrId4: ${natIpCidr.cidrs[0].id}
     *   vpcNatIpCidrId5: ${atIpCidrName.cidrs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNatIpCidrs.
     * @return A collection of values returned by getNatIpCidrs.
     */
    public suspend fun getNatIpCidrs(argument: GetNatIpCidrsPlainArgs): GetNatIpCidrsResult =
        getNatIpCidrsResultToKotlin(getNatIpCidrsPlain(argument.toJava()).await())

    /**
     * @see [getNatIpCidrs].
     * @param ids A list of Nat Ip Cidr IDs.
     * @param nameRegex A regex string to filter results by Nat Ip Cidr name.
     * @param natGatewayId NAT IP ADDRESS range to the security group of the Kafka VPC NAT gateway instance ID.
     * @param natIpCidrNames The name of the CIDR block that you want to query. Support up to `20`.
     * @param natIpCidrs The NAT CIDR block to be created. Support up to `20`. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the NAT IP address. Valid values:`Available`.
     * @return A collection of values returned by getNatIpCidrs.
     */
    public suspend fun getNatIpCidrs(
        ids: List<String>? = null,
        nameRegex: String? = null,
        natGatewayId: String,
        natIpCidrNames: List<String>? = null,
        natIpCidrs: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetNatIpCidrsResult {
        val argument = GetNatIpCidrsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            natGatewayId = natGatewayId,
            natIpCidrNames = natIpCidrNames,
            natIpCidrs = natIpCidrs,
            outputFile = outputFile,
            status = status,
        )
        return getNatIpCidrsResultToKotlin(getNatIpCidrsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatIpCidrs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetNatIpCidrsPlainArgs].
     * @return A collection of values returned by getNatIpCidrs.
     */
    public suspend fun getNatIpCidrs(argument: suspend GetNatIpCidrsPlainArgsBuilder.() -> Unit): GetNatIpCidrsResult {
        val builder = GetNatIpCidrsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatIpCidrsResultToKotlin(getNatIpCidrsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Nat Ips of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getNatIps({
     *     natGatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const vpcNatIpId1 = ids.then(ids => ids.ips?.[0]?.id);
     * const nameRegex = alicloud.vpc.getNatIps({
     *     natGatewayId: "example_value",
     *     nameRegex: "^my-NatIp",
     * });
     * export const vpcNatIpId2 = nameRegex.then(nameRegex => nameRegex.ips?.[0]?.id);
     * const natIpCidr = alicloud.vpc.getNatIps({
     *     natGatewayId: "example_value",
     *     natIpCidr: "example_value",
     *     nameRegex: "^my-NatIp",
     * });
     * export const vpcNatIpId3 = natIpCidr.then(natIpCidr => natIpCidr.ips?.[0]?.id);
     * const natIpName = alicloud.vpc.getNatIps({
     *     natGatewayId: "example_value",
     *     ids: ["example_value"],
     *     natIpNames: ["example_value"],
     * });
     * export const vpcNatIpId4 = natIpName.then(natIpName => natIpName.ips?.[0]?.id);
     * const natIpIds = alicloud.vpc.getNatIps({
     *     natGatewayId: "example_value",
     *     ids: ["example_value"],
     *     natIpIds: ["example_value"],
     * });
     * export const vpcNatIpId5 = natIpIds.then(natIpIds => natIpIds.ips?.[0]?.id);
     * const status = alicloud.vpc.getNatIps({
     *     natGatewayId: "example_value",
     *     ids: ["example_value"],
     *     status: "example_value",
     * });
     * export const vpcNatIpId6 = status.then(status => status.ips?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("vpcNatIpId1", ids.ips[0].id)
     * name_regex = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
     *     name_regex="^my-NatIp")
     * pulumi.export("vpcNatIpId2", name_regex.ips[0].id)
     * nat_ip_cidr = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
     *     nat_ip_cidr="example_value",
     *     name_regex="^my-NatIp")
     * pulumi.export("vpcNatIpId3", nat_ip_cidr.ips[0].id)
     * nat_ip_name = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
     *     ids=["example_value"],
     *     nat_ip_names=["example_value"])
     * pulumi.export("vpcNatIpId4", nat_ip_name.ips[0].id)
     * nat_ip_ids = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
     *     ids=["example_value"],
     *     nat_ip_ids=["example_value"])
     * pulumi.export("vpcNatIpId5", nat_ip_ids.ips[0].id)
     * status = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
     *     ids=["example_value"],
     *     status="example_value")
     * pulumi.export("vpcNatIpId6", status.ips[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetNatIps.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetNatIps.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         NameRegex = "^my-NatIp",
     *     });
     *     var natIpCidr = AliCloud.Vpc.GetNatIps.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         NatIpCidr = "example_value",
     *         NameRegex = "^my-NatIp",
     *     });
     *     var natIpName = AliCloud.Vpc.GetNatIps.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NatIpNames = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var natIpIds = AliCloud.Vpc.GetNatIps.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NatIpIds = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var status = AliCloud.Vpc.GetNatIps.Invoke(new()
     *     {
     *         NatGatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         Status = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcNatIpId1"] = ids&#46;Apply(getNatIpsResult => getNatIpsResult&#46;Ips[0]?.Id),
     *         ["vpcNatIpId2"] = nameRegex&#46;Apply(getNatIpsResult => getNatIpsResult&#46;Ips[0]?.Id),
     *         ["vpcNatIpId3"] = natIpCidr&#46;Apply(getNatIpsResult => getNatIpsResult&#46;Ips[0]?.Id),
     *         ["vpcNatIpId4"] = natIpName&#46;Apply(getNatIpsResult => getNatIpsResult&#46;Ips[0]?.Id),
     *         ["vpcNatIpId5"] = natIpIds&#46;Apply(getNatIpsResult => getNatIpsResult&#46;Ips[0]?.Id),
     *         ["vpcNatIpId6"] = status&#46;Apply(getNatIpsResult => getNatIpsResult&#46;Ips[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetNatIps(ctx, &vpc.GetNatIpsArgs{
     * 			NatGatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpId1", ids.Ips[0].Id)
     * 		nameRegex, err := vpc.GetNatIps(ctx, &vpc.GetNatIpsArgs{
     * 			NatGatewayId: "example_value",
     * 			NameRegex:    pulumi.StringRef("^my-NatIp"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpId2", nameRegex.Ips[0].Id)
     * 		natIpCidr, err := vpc.GetNatIps(ctx, &vpc.GetNatIpsArgs{
     * 			NatGatewayId: "example_value",
     * 			NatIpCidr:    pulumi.StringRef("example_value"),
     * 			NameRegex:    pulumi.StringRef("^my-NatIp"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpId3", natIpCidr.Ips[0].Id)
     * 		natIpName, err := vpc.GetNatIps(ctx, &vpc.GetNatIpsArgs{
     * 			NatGatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NatIpNames: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpId4", natIpName.Ips[0].Id)
     * 		natIpIds, err := vpc.GetNatIps(ctx, &vpc.GetNatIpsArgs{
     * 			NatGatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NatIpIds: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpId5", natIpIds.Ips[0].Id)
     * 		status, err := vpc.GetNatIps(ctx, &vpc.GetNatIpsArgs{
     * 			NatGatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			Status: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcNatIpId6", status.Ips[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNatIpsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getNatIps(GetNatIpsArgs.builder()
     *             .natGatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("vpcNatIpId1", ids.applyValue(getNatIpsResult -> getNatIpsResult.ips()[0].id()));
     *         final var nameRegex = VpcFunctions.getNatIps(GetNatIpsArgs.builder()
     *             .natGatewayId("example_value")
     *             .nameRegex("^my-NatIp")
     *             .build());
     *         ctx.export("vpcNatIpId2", nameRegex.applyValue(getNatIpsResult -> getNatIpsResult.ips()[0].id()));
     *         final var natIpCidr = VpcFunctions.getNatIps(GetNatIpsArgs.builder()
     *             .natGatewayId("example_value")
     *             .natIpCidr("example_value")
     *             .nameRegex("^my-NatIp")
     *             .build());
     *         ctx.export("vpcNatIpId3", natIpCidr.applyValue(getNatIpsResult -> getNatIpsResult.ips()[0].id()));
     *         final var natIpName = VpcFunctions.getNatIps(GetNatIpsArgs.builder()
     *             .natGatewayId("example_value")
     *             .ids("example_value")
     *             .natIpNames("example_value")
     *             .build());
     *         ctx.export("vpcNatIpId4", natIpName.applyValue(getNatIpsResult -> getNatIpsResult.ips()[0].id()));
     *         final var natIpIds = VpcFunctions.getNatIps(GetNatIpsArgs.builder()
     *             .natGatewayId("example_value")
     *             .ids("example_value")
     *             .natIpIds("example_value")
     *             .build());
     *         ctx.export("vpcNatIpId5", natIpIds.applyValue(getNatIpsResult -> getNatIpsResult.ips()[0].id()));
     *         final var status = VpcFunctions.getNatIps(GetNatIpsArgs.builder()
     *             .natGatewayId("example_value")
     *             .ids("example_value")
     *             .status("example_value")
     *             .build());
     *         ctx.export("vpcNatIpId6", status.applyValue(getNatIpsResult -> getNatIpsResult.ips()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIps
     *       Arguments:
     *         natGatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIps
     *       Arguments:
     *         natGatewayId: example_value
     *         nameRegex: ^my-NatIp
     *   natIpCidr:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIps
     *       Arguments:
     *         natGatewayId: example_value
     *         natIpCidr: example_value
     *         nameRegex: ^my-NatIp
     *   natIpName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIps
     *       Arguments:
     *         natGatewayId: example_value
     *         ids:
     *           - example_value
     *         natIpNames:
     *           - example_value
     *   natIpIds:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIps
     *       Arguments:
     *         natGatewayId: example_value
     *         ids:
     *           - example_value
     *         natIpIds:
     *           - example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNatIps
     *       Arguments:
     *         natGatewayId: example_value
     *         ids:
     *           - example_value
     *         status: example_value
     * outputs:
     *   vpcNatIpId1: ${ids.ips[0].id}
     *   vpcNatIpId2: ${nameRegex.ips[0].id}
     *   vpcNatIpId3: ${natIpCidr.ips[0].id}
     *   vpcNatIpId4: ${natIpName.ips[0].id}
     *   vpcNatIpId5: ${natIpIds.ips[0].id}
     *   vpcNatIpId6: ${status.ips[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNatIps.
     * @return A collection of values returned by getNatIps.
     */
    public suspend fun getNatIps(argument: GetNatIpsPlainArgs): GetNatIpsResult =
        getNatIpsResultToKotlin(getNatIpsPlain(argument.toJava()).await())

    /**
     * @see [getNatIps].
     * @param ids A list of Nat Ip IDs.
     * @param nameRegex A regex string to filter results by Nat Ip name.
     * @param natGatewayId The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
     * @param natIpCidr NAT IP ADDRESS of the address segment.
     * @param natIpIds
     * @param natIpNames NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
     * @return A collection of values returned by getNatIps.
     */
    public suspend fun getNatIps(
        ids: List<String>? = null,
        nameRegex: String? = null,
        natGatewayId: String,
        natIpCidr: String? = null,
        natIpIds: List<String>? = null,
        natIpNames: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetNatIpsResult {
        val argument = GetNatIpsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            natGatewayId = natGatewayId,
            natIpCidr = natIpCidr,
            natIpIds = natIpIds,
            natIpNames = natIpNames,
            outputFile = outputFile,
            status = status,
        )
        return getNatIpsResultToKotlin(getNatIpsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatIps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetNatIpsPlainArgs].
     * @return A collection of values returned by getNatIps.
     */
    public suspend fun getNatIps(argument: suspend GetNatIpsPlainArgsBuilder.() -> Unit): GetNatIpsResult {
        val builder = GetNatIpsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatIpsResultToKotlin(getNatIpsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Network Acls of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.122.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.vpc.getNetworkAcls({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstNetworkAclId = example.then(example => example.acls?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.vpc.get_network_acls(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstNetworkAclId", example.acls[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Vpc.GetNetworkAcls.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstNetworkAclId"] = example&#46;Apply(getNetworkAclsResult => getNetworkAclsResult&#46;Acls[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := vpc.GetNetworkAcls(ctx, &vpc.GetNetworkAclsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstNetworkAclId", example.Acls[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworkAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpcFunctions.getNetworkAcls(GetNetworkAclsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstNetworkAclId", example.applyValue(getNetworkAclsResult -> getNetworkAclsResult.acls()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNetworkAcls
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstNetworkAclId: ${example.acls[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkAcls.
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(argument: GetNetworkAclsPlainArgs): GetNetworkAclsResult =
        getNetworkAclsResultToKotlin(getNetworkAclsPlain(argument.toJava()).await())

    /**
     * @see [getNetworkAcls].
     * @param ids A list of Network Acl ID.
     * @param nameRegex A regex string to filter results by Network Acl name.
     * @param networkAclName The name of the network ACL.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceId The ID of the associated resource.
     * @param resourceType The type of the associated resource. Valid values `VSwitch`. `resource_type` and `resource_id` need to be specified at the same time to take effect.
     * @param status The state of the network ACL. Valid values: `Available` and `Modifying`.
     * @param vpcId The ID of the associated VPC.
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(
        ids: List<String>? = null,
        nameRegex: String? = null,
        networkAclName: String? = null,
        outputFile: String? = null,
        resourceId: String? = null,
        resourceType: String? = null,
        status: String? = null,
        vpcId: String? = null,
    ): GetNetworkAclsResult {
        val argument = GetNetworkAclsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            networkAclName = networkAclName,
            outputFile = outputFile,
            resourceId = resourceId,
            resourceType = resourceType,
            status = status,
            vpcId = vpcId,
        )
        return getNetworkAclsResultToKotlin(getNetworkAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkAcls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetNetworkAclsPlainArgs].
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(argument: suspend GetNetworkAclsPlainArgsBuilder.() -> Unit): GetNetworkAclsResult {
        val builder = GetNetworkAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkAclsResultToKotlin(getNetworkAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides VPCs available to the user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const vpcsDs = alicloud.vpc.getNetworks({
     *     cidrBlock: "172.16.0.0/12",
     *     status: "Available",
     *     nameRegex: "^foo",
     * });
     * export const firstVpcId = vpcsDs.then(vpcsDs => vpcsDs.vpcs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * vpcs_ds = alicloud.vpc.get_networks(cidr_block="172.16.0.0/12",
     *     status="Available",
     *     name_regex="^foo")
     * pulumi.export("firstVpcId", vpcs_ds.vpcs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var vpcsDs = AliCloud.Vpc.GetNetworks.Invoke(new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         Status = "Available",
     *         NameRegex = "^foo",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstVpcId"] = vpcsDs&#46;Apply(getNetworksResult => getNetworksResult&#46;Vpcs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		vpcsDs, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
     * 			CidrBlock: pulumi.StringRef("172.16.0.0/12"),
     * 			Status:    pulumi.StringRef("Available"),
     * 			NameRegex: pulumi.StringRef("^foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstVpcId", vpcsDs.Vpcs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var vpcsDs = VpcFunctions.getNetworks(GetNetworksArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .status("Available")
     *             .nameRegex("^foo")
     *             .build());
     *         ctx.export("firstVpcId", vpcsDs.applyValue(getNetworksResult -> getNetworksResult.vpcs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   vpcsDs:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNetworks
     *       Arguments:
     *         cidrBlock: 172.16.0.0/12
     *         status: Available
     *         nameRegex: ^foo
     * outputs:
     *   firstVpcId: ${vpcsDs.vpcs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworks.
     * @return A collection of values returned by getNetworks.
     */
    public suspend fun getNetworks(argument: GetNetworksPlainArgs): GetNetworksResult =
        getNetworksResultToKotlin(getNetworksPlain(argument.toJava()).await())

    /**
     * @see [getNetworks].
     * @param cidrBlock Filter results by a specific CIDR block. For example: "172.16.0.0/12".
     * @param dhcpOptionsSetId The ID of dhcp options set.
     * @param dryRun Indicates whether to check this request only. Valid values: `true` and `false`.
     * @param enableDetails Default to `true`. Set it to true can output the `route_table_id`.
     * @param ids A list of VPC IDs.
     * @param isDefault Indicate whether the VPC is the default one in the specified region.
     * @param nameRegex A regex string to filter VPCs by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The Id of resource group which VPC belongs.
     * @param status Filter results by a specific status. Valid value are `Pending` and `Available`.
     * @param tags A mapping of tags to assign to the resource.
     * @param vpcName The name of the VPC.
     * @param vpcOwnerId The owner ID of VPC.
     * @param vswitchId Filter results by the specified vSwitch.
     * @return A collection of values returned by getNetworks.
     */
    public suspend fun getNetworks(
        cidrBlock: String? = null,
        dhcpOptionsSetId: String? = null,
        dryRun: Boolean? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        isDefault: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcName: String? = null,
        vpcOwnerId: Int? = null,
        vswitchId: String? = null,
    ): GetNetworksResult {
        val argument = GetNetworksPlainArgs(
            cidrBlock = cidrBlock,
            dhcpOptionsSetId = dhcpOptionsSetId,
            dryRun = dryRun,
            enableDetails = enableDetails,
            ids = ids,
            isDefault = isDefault,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vpcName = vpcName,
            vpcOwnerId = vpcOwnerId,
            vswitchId = vswitchId,
        )
        return getNetworksResultToKotlin(getNetworksPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetNetworksPlainArgs].
     * @return A collection of values returned by getNetworks.
     */
    public suspend fun getNetworks(argument: suspend GetNetworksPlainArgsBuilder.() -> Unit): GetNetworksResult {
        val builder = GetNetworksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworksResultToKotlin(getNetworksPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** Available in v1.162.0+.
     * The data source lists a number of VPN Pbr Route Entries resource information owned by an Alicloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getPbrRouteEntries({
     *     vpnGatewayId: "example_vpn_gateway_id",
     *     ids: ["example_id"],
     * });
     * export const vpnIpsecServerId1 = ids.then(ids => ids.entries?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_pbr_route_entries(vpn_gateway_id="example_vpn_gateway_id",
     *     ids=["example_id"])
     * pulumi.export("vpnIpsecServerId1", ids.entries[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetPbrRouteEntries.Invoke(new()
     *     {
     *         VpnGatewayId = "example_vpn_gateway_id",
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpnIpsecServerId1"] = ids&#46;Apply(getPbrRouteEntriesResult => getPbrRouteEntriesResult&#46;Entries[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetPbrRouteEntries(ctx, &vpc.GetPbrRouteEntriesArgs{
     * 			VpnGatewayId: "example_vpn_gateway_id",
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpnIpsecServerId1", ids.Entries[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetPbrRouteEntriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getPbrRouteEntries(GetPbrRouteEntriesArgs.builder()
     *             .vpnGatewayId("example_vpn_gateway_id")
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpnIpsecServerId1", ids.applyValue(getPbrRouteEntriesResult -> getPbrRouteEntriesResult.entries()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPbrRouteEntries
     *       Arguments:
     *         vpnGatewayId: example_vpn_gateway_id
     *         ids:
     *           - example_id
     * outputs:
     *   vpnIpsecServerId1: ${ids.entries[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPbrRouteEntries.
     * @return A collection of values returned by getPbrRouteEntries.
     */
    public suspend fun getPbrRouteEntries(argument: GetPbrRouteEntriesPlainArgs): GetPbrRouteEntriesResult =
        getPbrRouteEntriesResultToKotlin(getPbrRouteEntriesPlain(argument.toJava()).await())

    /**
     * @see [getPbrRouteEntries].
     * @param ids A list of VPN Pbr Route Entries IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param vpnGatewayId The ID of the VPN gateway.
     * @return A collection of values returned by getPbrRouteEntries.
     */
    public suspend fun getPbrRouteEntries(
        ids: List<String>? = null,
        outputFile: String? = null,
        vpnGatewayId: String,
    ): GetPbrRouteEntriesResult {
        val argument = GetPbrRouteEntriesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            vpnGatewayId = vpnGatewayId,
        )
        return getPbrRouteEntriesResultToKotlin(getPbrRouteEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPbrRouteEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetPbrRouteEntriesPlainArgs].
     * @return A collection of values returned by getPbrRouteEntries.
     */
    public suspend fun getPbrRouteEntries(argument: suspend GetPbrRouteEntriesPlainArgsBuilder.() -> Unit): GetPbrRouteEntriesResult {
        val builder = GetPbrRouteEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPbrRouteEntriesResultToKotlin(getPbrRouteEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Peer Connections of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.186.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getPeerConnections({});
     * export const vpcPeerConnectionId1 = ids.then(ids => ids.connections?.[0]?.id);
     * const nameRegex = alicloud.vpc.getPeerConnections({
     *     nameRegex: "^my-PeerConnection",
     * });
     * export const vpcPeerConnectionId2 = nameRegex.then(nameRegex => nameRegex.connections?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_peer_connections()
     * pulumi.export("vpcPeerConnectionId1", ids.connections[0].id)
     * name_regex = alicloud.vpc.get_peer_connections(name_regex="^my-PeerConnection")
     * pulumi.export("vpcPeerConnectionId2", name_regex.connections[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetPeerConnections.Invoke();
     *     var nameRegex = AliCloud.Vpc.GetPeerConnections.Invoke(new()
     *     {
     *         NameRegex = "^my-PeerConnection",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcPeerConnectionId1"] = ids&#46;Apply(getPeerConnectionsResult => getPeerConnectionsResult&#46;Connections[0]?.Id),
     *         ["vpcPeerConnectionId2"] = nameRegex&#46;Apply(getPeerConnectionsResult => getPeerConnectionsResult&#46;Connections[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetPeerConnections(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPeerConnectionId1", ids.Connections[0].Id)
     * 		nameRegex, err := vpc.GetPeerConnections(ctx, &vpc.GetPeerConnectionsArgs{
     * 			NameRegex: pulumi.StringRef("^my-PeerConnection"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPeerConnectionId2", nameRegex.Connections[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetPeerConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getPeerConnections();
     *         ctx.export("vpcPeerConnectionId1", ids.applyValue(getPeerConnectionsResult -> getPeerConnectionsResult.connections()[0].id()));
     *         final var nameRegex = VpcFunctions.getPeerConnections(GetPeerConnectionsArgs.builder()
     *             .nameRegex("^my-PeerConnection")
     *             .build());
     *         ctx.export("vpcPeerConnectionId2", nameRegex.applyValue(getPeerConnectionsResult -> getPeerConnectionsResult.connections()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPeerConnections
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPeerConnections
     *       Arguments:
     *         nameRegex: ^my-PeerConnection
     * outputs:
     *   vpcPeerConnectionId1: ${ids.connections[0].id}
     *   vpcPeerConnectionId2: ${nameRegex.connections[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPeerConnections.
     * @return A collection of values returned by getPeerConnections.
     */
    public suspend fun getPeerConnections(argument: GetPeerConnectionsPlainArgs): GetPeerConnectionsResult =
        getPeerConnectionsResultToKotlin(getPeerConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getPeerConnections].
     * @param ids A list of PeerConnection IDs.
     * @param nameRegex A regex string to filter results by PeerConnection name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param peerConnectionName The name of the resource.
     * @param status The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
     * @param vpcId The ID of the requester VPC.
     * @return A collection of values returned by getPeerConnections.
     */
    public suspend fun getPeerConnections(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        peerConnectionName: String? = null,
        status: String? = null,
        vpcId: String? = null,
    ): GetPeerConnectionsResult {
        val argument = GetPeerConnectionsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            peerConnectionName = peerConnectionName,
            status = status,
            vpcId = vpcId,
        )
        return getPeerConnectionsResultToKotlin(getPeerConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeerConnections].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetPeerConnectionsPlainArgs].
     * @return A collection of values returned by getPeerConnections.
     */
    public suspend fun getPeerConnections(argument: suspend GetPeerConnectionsPlainArgsBuilder.() -> Unit): GetPeerConnectionsResult {
        val builder = GetPeerConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeerConnectionsResultToKotlin(getPeerConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Prefix Lists of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.182.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getPrefixLists({});
     * export const vpcPrefixListId1 = ids.then(ids => ids.lists?.[0]?.id);
     * const nameRegex = alicloud.vpc.getPrefixLists({
     *     nameRegex: "^my-PrefixList",
     * });
     * export const vpcPrefixListId2 = nameRegex.then(nameRegex => nameRegex.lists?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_prefix_lists()
     * pulumi.export("vpcPrefixListId1", ids.lists[0].id)
     * name_regex = alicloud.vpc.get_prefix_lists(name_regex="^my-PrefixList")
     * pulumi.export("vpcPrefixListId2", name_regex.lists[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetPrefixLists.Invoke();
     *     var nameRegex = AliCloud.Vpc.GetPrefixLists.Invoke(new()
     *     {
     *         NameRegex = "^my-PrefixList",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcPrefixListId1"] = ids&#46;Apply(getPrefixListsResult => getPrefixListsResult&#46;Lists[0]?.Id),
     *         ["vpcPrefixListId2"] = nameRegex&#46;Apply(getPrefixListsResult => getPrefixListsResult&#46;Lists[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetPrefixLists(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPrefixListId1", ids.Lists[0].Id)
     * 		nameRegex, err := vpc.GetPrefixLists(ctx, &vpc.GetPrefixListsArgs{
     * 			NameRegex: pulumi.StringRef("^my-PrefixList"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPrefixListId2", nameRegex.Lists[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetPrefixListsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getPrefixLists();
     *         ctx.export("vpcPrefixListId1", ids.applyValue(getPrefixListsResult -> getPrefixListsResult.lists()[0].id()));
     *         final var nameRegex = VpcFunctions.getPrefixLists(GetPrefixListsArgs.builder()
     *             .nameRegex("^my-PrefixList")
     *             .build());
     *         ctx.export("vpcPrefixListId2", nameRegex.applyValue(getPrefixListsResult -> getPrefixListsResult.lists()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPrefixLists
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPrefixLists
     *       Arguments:
     *         nameRegex: ^my-PrefixList
     * outputs:
     *   vpcPrefixListId1: ${ids.lists[0].id}
     *   vpcPrefixListId2: ${nameRegex.lists[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrefixLists.
     * @return A collection of values returned by getPrefixLists.
     */
    public suspend fun getPrefixLists(argument: GetPrefixListsPlainArgs): GetPrefixListsResult =
        getPrefixListsResultToKotlin(getPrefixListsPlain(argument.toJava()).await())

    /**
     * @see [getPrefixLists].
     * @param enableDetails Default to `true`. Set it to `false` can hide the `entrys` to output.
     * @param ids A list of Prefix List IDs.
     * @param nameRegex A regex string to filter results by Prefix List name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param prefixListName The name of the prefix list.
     * @return A collection of values returned by getPrefixLists.
     */
    public suspend fun getPrefixLists(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        prefixListName: String? = null,
    ): GetPrefixListsResult {
        val argument = GetPrefixListsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            prefixListName = prefixListName,
        )
        return getPrefixListsResultToKotlin(getPrefixListsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrefixLists].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetPrefixListsPlainArgs].
     * @return A collection of values returned by getPrefixLists.
     */
    public suspend fun getPrefixLists(argument: suspend GetPrefixListsPlainArgsBuilder.() -> Unit): GetPrefixListsResult {
        val builder = GetPrefixListsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrefixListsResultToKotlin(getPrefixListsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Public Ip Address Pool Cidr Blocks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.189.0+.
     * > **NOTE:** Only users who have the required permissions can use the IP address pool feature of Elastic IP Address (EIP). To apply for the required permissions, [submit a ticket](https://smartservice.console.aliyun.com/service/create-ticket).
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getPublicIpAddressPoolCidrBlocks({
     *     ids: ["example_id"],
     *     publicIpAddressPoolId: "example_value",
     * });
     * export const vpcPublicIpAddressPoolCidrBlockId1 = ids.then(ids => ids.blocks?.[0]?.id);
     * const cidrBlock = alicloud.vpc.getPublicIpAddressPoolCidrBlocks({
     *     publicIpAddressPoolId: "example_value",
     *     cidrBlock: "example_value",
     * });
     * export const vpcPublicIpAddressPoolCidrBlockId2 = cidrBlock.then(cidrBlock => cidrBlock.blocks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_public_ip_address_pool_cidr_blocks(ids=["example_id"],
     *     public_ip_address_pool_id="example_value")
     * pulumi.export("vpcPublicIpAddressPoolCidrBlockId1", ids.blocks[0].id)
     * cidr_block = alicloud.vpc.get_public_ip_address_pool_cidr_blocks(public_ip_address_pool_id="example_value",
     *     cidr_block="example_value")
     * pulumi.export("vpcPublicIpAddressPoolCidrBlockId2", cidr_block.blocks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetPublicIpAddressPoolCidrBlocks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         PublicIpAddressPoolId = "example_value",
     *     });
     *     var cidrBlock = AliCloud.Vpc.GetPublicIpAddressPoolCidrBlocks.Invoke(new()
     *     {
     *         PublicIpAddressPoolId = "example_value",
     *         CidrBlock = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcPublicIpAddressPoolCidrBlockId1"] = ids&#46;Apply(getPublicIpAddressPoolCidrBlocksResult => getPublicIpAddressPoolCidrBlocksResult&#46;Blocks[0]?.Id),
     *         ["vpcPublicIpAddressPoolCidrBlockId2"] = cidrBlock&#46;Apply(getPublicIpAddressPoolCidrBlocksResult => getPublicIpAddressPoolCidrBlocksResult&#46;Blocks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetPublicIpAddressPoolCidrBlocks(ctx, &vpc.GetPublicIpAddressPoolCidrBlocksArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			PublicIpAddressPoolId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPublicIpAddressPoolCidrBlockId1", ids.Blocks[0].Id)
     * 		cidrBlock, err := vpc.GetPublicIpAddressPoolCidrBlocks(ctx, &vpc.GetPublicIpAddressPoolCidrBlocksArgs{
     * 			PublicIpAddressPoolId: "example_value",
     * 			CidrBlock:             pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPublicIpAddressPoolCidrBlockId2", cidrBlock.Blocks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolCidrBlocksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getPublicIpAddressPoolCidrBlocks(GetPublicIpAddressPoolCidrBlocksArgs.builder()
     *             .ids("example_id")
     *             .publicIpAddressPoolId("example_value")
     *             .build());
     *         ctx.export("vpcPublicIpAddressPoolCidrBlockId1", ids.applyValue(getPublicIpAddressPoolCidrBlocksResult -> getPublicIpAddressPoolCidrBlocksResult.blocks()[0].id()));
     *         final var cidrBlock = VpcFunctions.getPublicIpAddressPoolCidrBlocks(GetPublicIpAddressPoolCidrBlocksArgs.builder()
     *             .publicIpAddressPoolId("example_value")
     *             .cidrBlock("example_value")
     *             .build());
     *         ctx.export("vpcPublicIpAddressPoolCidrBlockId2", cidrBlock.applyValue(getPublicIpAddressPoolCidrBlocksResult -> getPublicIpAddressPoolCidrBlocksResult.blocks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPublicIpAddressPoolCidrBlocks
     *       Arguments:
     *         ids:
     *           - example_id
     *         publicIpAddressPoolId: example_value
     *   cidrBlock:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPublicIpAddressPoolCidrBlocks
     *       Arguments:
     *         publicIpAddressPoolId: example_value
     *         cidrBlock: example_value
     * outputs:
     *   vpcPublicIpAddressPoolCidrBlockId1: ${ids.blocks[0].id}
     *   vpcPublicIpAddressPoolCidrBlockId2: ${cidrBlock.blocks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPublicIpAddressPoolCidrBlocks.
     * @return A collection of values returned by getPublicIpAddressPoolCidrBlocks.
     */
    public suspend fun getPublicIpAddressPoolCidrBlocks(argument: GetPublicIpAddressPoolCidrBlocksPlainArgs): GetPublicIpAddressPoolCidrBlocksResult =
        getPublicIpAddressPoolCidrBlocksResultToKotlin(getPublicIpAddressPoolCidrBlocksPlain(argument.toJava()).await())

    /**
     * @see [getPublicIpAddressPoolCidrBlocks].
     * @param cidrBlock The CIDR block.
     * @param ids A list of Vpc Public Ip Address Pool Cidr Block IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param publicIpAddressPoolId The ID of the Vpc Public IP address pool.
     * @param status The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
     * @return A collection of values returned by getPublicIpAddressPoolCidrBlocks.
     */
    public suspend fun getPublicIpAddressPoolCidrBlocks(
        cidrBlock: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        publicIpAddressPoolId: String,
        status: String? = null,
    ): GetPublicIpAddressPoolCidrBlocksResult {
        val argument = GetPublicIpAddressPoolCidrBlocksPlainArgs(
            cidrBlock = cidrBlock,
            ids = ids,
            outputFile = outputFile,
            publicIpAddressPoolId = publicIpAddressPoolId,
            status = status,
        )
        return getPublicIpAddressPoolCidrBlocksResultToKotlin(getPublicIpAddressPoolCidrBlocksPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicIpAddressPoolCidrBlocks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetPublicIpAddressPoolCidrBlocksPlainArgs].
     * @return A collection of values returned by getPublicIpAddressPoolCidrBlocks.
     */
    public suspend fun getPublicIpAddressPoolCidrBlocks(argument: suspend GetPublicIpAddressPoolCidrBlocksPlainArgsBuilder.() -> Unit): GetPublicIpAddressPoolCidrBlocksResult {
        val builder = GetPublicIpAddressPoolCidrBlocksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicIpAddressPoolCidrBlocksResultToKotlin(getPublicIpAddressPoolCidrBlocksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Public Ip Address Pools of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.186.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getPublicIpAddressPools({
     *     ids: ["example_id"],
     * });
     * export const vpcPublicIpAddressPoolId1 = ids.then(ids => ids.pools?.[0]?.id);
     * const nameRegex = alicloud.vpc.getPublicIpAddressPools({
     *     nameRegex: "example_name",
     * });
     * export const vpcPublicIpAddressPoolId2 = nameRegex.then(nameRegex => nameRegex.pools?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_public_ip_address_pools(ids=["example_id"])
     * pulumi.export("vpcPublicIpAddressPoolId1", ids.pools[0].id)
     * name_regex = alicloud.vpc.get_public_ip_address_pools(name_regex="example_name")
     * pulumi.export("vpcPublicIpAddressPoolId2", name_regex.pools[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetPublicIpAddressPools.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetPublicIpAddressPools.Invoke(new()
     *     {
     *         NameRegex = "example_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcPublicIpAddressPoolId1"] = ids&#46;Apply(getPublicIpAddressPoolsResult => getPublicIpAddressPoolsResult&#46;Pools[0]?.Id),
     *         ["vpcPublicIpAddressPoolId2"] = nameRegex&#46;Apply(getPublicIpAddressPoolsResult => getPublicIpAddressPoolsResult&#46;Pools[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetPublicIpAddressPools(ctx, &vpc.GetPublicIpAddressPoolsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPublicIpAddressPoolId1", ids.Pools[0].Id)
     * 		nameRegex, err := vpc.GetPublicIpAddressPools(ctx, &vpc.GetPublicIpAddressPoolsArgs{
     * 			NameRegex: pulumi.StringRef("example_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcPublicIpAddressPoolId2", nameRegex.Pools[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getPublicIpAddressPools(GetPublicIpAddressPoolsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcPublicIpAddressPoolId1", ids.applyValue(getPublicIpAddressPoolsResult -> getPublicIpAddressPoolsResult.pools()[0].id()));
     *         final var nameRegex = VpcFunctions.getPublicIpAddressPools(GetPublicIpAddressPoolsArgs.builder()
     *             .nameRegex("example_name")
     *             .build());
     *         ctx.export("vpcPublicIpAddressPoolId2", nameRegex.applyValue(getPublicIpAddressPoolsResult -> getPublicIpAddressPoolsResult.pools()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPublicIpAddressPools
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getPublicIpAddressPools
     *       Arguments:
     *         nameRegex: example_name
     * outputs:
     *   vpcPublicIpAddressPoolId1: ${ids.pools[0].id}
     *   vpcPublicIpAddressPoolId2: ${nameRegex.pools[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPublicIpAddressPools.
     * @return A collection of values returned by getPublicIpAddressPools.
     */
    public suspend fun getPublicIpAddressPools(argument: GetPublicIpAddressPoolsPlainArgs): GetPublicIpAddressPoolsResult =
        getPublicIpAddressPoolsResultToKotlin(getPublicIpAddressPoolsPlain(argument.toJava()).await())

    /**
     * @see [getPublicIpAddressPools].
     * @param ids A list of Vpc Public Ip Address Pool IDs.
     * @param isp The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`.
     * @param nameRegex A regex string to filter results by Vpc Public Ip Address Pool name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param publicIpAddressPoolIds The IDs of the Vpc Public IP address pools.
     * @param publicIpAddressPoolName The name of the VPC Public IP address pool.
     * @param status The status of the Vpc Public Ip Address Pool. Valid values: `Created`, `Deleting`, `Modifying`.
     * @return A collection of values returned by getPublicIpAddressPools.
     */
    public suspend fun getPublicIpAddressPools(
        ids: List<String>? = null,
        isp: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        publicIpAddressPoolIds: List<String>? = null,
        publicIpAddressPoolName: String? = null,
        status: String? = null,
    ): GetPublicIpAddressPoolsResult {
        val argument = GetPublicIpAddressPoolsPlainArgs(
            ids = ids,
            isp = isp,
            nameRegex = nameRegex,
            outputFile = outputFile,
            publicIpAddressPoolIds = publicIpAddressPoolIds,
            publicIpAddressPoolName = publicIpAddressPoolName,
            status = status,
        )
        return getPublicIpAddressPoolsResultToKotlin(getPublicIpAddressPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicIpAddressPools].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetPublicIpAddressPoolsPlainArgs].
     * @return A collection of values returned by getPublicIpAddressPools.
     */
    public suspend fun getPublicIpAddressPools(argument: suspend GetPublicIpAddressPoolsPlainArgsBuilder.() -> Unit): GetPublicIpAddressPoolsResult {
        val builder = GetPublicIpAddressPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicIpAddressPoolsResultToKotlin(getPublicIpAddressPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Route Entries owned by an Alibaba Cloud account.
     * > **NOTE:** Available in 1.37.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
     *     availabilityZone: _default.zones?.[0]?.id,
     *     cpuCoreCount: 1,
     *     memorySize: 2,
     * }));
     * const defaultGetImages = alicloud.ecs.getImages({
     *     nameRegex: "^ubuntu_18.*64",
     *     mostRecent: true,
     *     owners: "system",
     * });
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-testAccRouteEntryConfig";
     * const fooNetwork = new alicloud.vpc.Network("foo", {
     *     name: name,
     *     cidrBlock: "10.1.0.0/21",
     * });
     * const fooSwitch = new alicloud.vpc.Switch("foo", {
     *     vpcId: fooNetwork.id,
     *     cidrBlock: "10.1.1.0/24",
     *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
     *     vswitchName: name,
     * });
     * const tfTestFoo = new alicloud.ecs.SecurityGroup("tf_test_foo", {
     *     name: name,
     *     description: "foo",
     *     vpcId: fooNetwork.id,
     * });
     * const fooInstance = new alicloud.ecs.Instance("foo", {
     *     securityGroups: [tfTestFoo&#46;id],
     *     vswitchId: fooSwitch.id,
     *     allocatePublicIp: true,
     *     instanceChargeType: "PostPaid",
     *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
     *     internetChargeType: "PayByTraffic",
     *     internetMaxBandwidthOut: 5,
     *     systemDiskCategory: "cloud_efficiency",
     *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
     *     instanceName: name,
     * });
     * const fooRouteEntry = new alicloud.vpc.RouteEntry("foo", {
     *     routeTableId: fooNetwork.routeTableId,
     *     destinationCidrblock: "172.11.1.1/32",
     *     nexthopType: "Instance",
     *     nexthopId: fooInstance.id,
     * });
     * const ingress = new alicloud.ecs.SecurityGroupRule("ingress", {
     *     type: "ingress",
     *     ipProtocol: "tcp",
     *     nicType: "intranet",
     *     policy: "accept",
     *     portRange: "22/22",
     *     priority: 1,
     *     securityGroupId: tfTestFoo.id,
     *     cidrIp: "0.0.0.0/0",
     * });
     * const foo = alicloud.vpc.getRouteEntriesOutput({
     *     routeTableId: fooRouteEntry.routeTableId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
     *     cpu_core_count=1,
     *     memory_size=2)
     * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
     *     most_recent=True,
     *     owners="system")
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-testAccRouteEntryConfig"
     * foo_network = alicloud.vpc.Network("foo",
     *     name=name,
     *     cidr_block="10.1.0.0/21")
     * foo_switch = alicloud.vpc.Switch("foo",
     *     vpc_id=foo_network.id,
     *     cidr_block="10.1.1.0/24",
     *     availability_zone=default.zones[0].id,
     *     vswitch_name=name)
     * tf_test_foo = alicloud.ecs.SecurityGroup("tf_test_foo",
     *     name=name,
     *     description="foo",
     *     vpc_id=foo_network.id)
     * foo_instance = alicloud.ecs.Instance("foo",
     *     security_groups=[tf_test_foo&#46;id],
     *     vswitch_id=foo_switch.id,
     *     allocate_public_ip=True,
     *     instance_charge_type="PostPaid",
     *     instance_type=default_get_instance_types.instance_types[0].id,
     *     internet_charge_type="PayByTraffic",
     *     internet_max_bandwidth_out=5,
     *     system_disk_category="cloud_efficiency",
     *     image_id=default_get_images.images[0].id,
     *     instance_name=name)
     * foo_route_entry = alicloud.vpc.RouteEntry("foo",
     *     route_table_id=foo_network.route_table_id,
     *     destination_cidrblock="172.11.1.1/32",
     *     nexthop_type="Instance",
     *     nexthop_id=foo_instance.id)
     * ingress = alicloud.ecs.SecurityGroupRule("ingress",
     *     type="ingress",
     *     ip_protocol="tcp",
     *     nic_type="intranet",
     *     policy="accept",
     *     port_range="22/22",
     *     priority=1,
     *     security_group_id=tf_test_foo.id,
     *     cidr_ip="0.0.0.0/0")
     * foo = alicloud.vpc.get_route_entries_output(route_table_id=foo_route_entry.route_table_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
     *     {
     *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *         CpuCoreCount = 1,
     *         MemorySize = 2,
     *     });
     *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
     *     {
     *         NameRegex = "^ubuntu_18.*64",
     *         MostRecent = true,
     *         Owners = "system",
     *     });
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-testAccRouteEntryConfig";
     *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
     *     {
     *         Name = name,
     *         CidrBlock = "10.1.0.0/21",
     *     });
     *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
     *     {
     *         VpcId = fooNetwork.Id,
     *         CidrBlock = "10.1.1.0/24",
     *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VswitchName = name,
     *     });
     *     var tfTestFoo = new AliCloud.Ecs.SecurityGroup("tf_test_foo", new()
     *     {
     *         Name = name,
     *         Description = "foo",
     *         VpcId = fooNetwork.Id,
     *     });
     *     var fooInstance = new AliCloud.Ecs.Instance("foo", new()
     *     {
     *         SecurityGroups = new[]
     *         {
     *             tfTestFoo.Id,
     *         },
     *         VswitchId = fooSwitch.Id,
     *         AllocatePublicIp = true,
     *         InstanceChargeType = "PostPaid",
     *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
     *         InternetChargeType = "PayByTraffic",
     *         InternetMaxBandwidthOut = 5,
     *         SystemDiskCategory = "cloud_efficiency",
     *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
     *         InstanceName = name,
     *     });
     *     var fooRouteEntry = new AliCloud.Vpc.RouteEntry("foo", new()
     *     {
     *         RouteTableId = fooNetwork.RouteTableId,
     *         DestinationCidrblock = "172.11.1.1/32",
     *         NexthopType = "Instance",
     *         NexthopId = fooInstance.Id,
     *     });
     *     var ingress = new AliCloud.Ecs.SecurityGroupRule("ingress", new()
     *     {
     *         Type = "ingress",
     *         IpProtocol = "tcp",
     *         NicType = "intranet",
     *         Policy = "accept",
     *         PortRange = "22/22",
     *         Priority = 1,
     *         SecurityGroupId = tfTestFoo.Id,
     *         CidrIp = "0.0.0.0/0",
     *     });
     *     var foo = AliCloud.Vpc.GetRouteEntries.Invoke(new()
     *     {
     *         RouteTableId = fooRouteEntry.RouteTableId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
     * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
     * 			CpuCoreCount:     pulumi.IntRef(1),
     * 			MemorySize:       pulumi.Float64Ref(2),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
     * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
     * 			MostRecent: pulumi.BoolRef(true),
     * 			Owners:     pulumi.StringRef("system"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-testAccRouteEntryConfig"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
     * 			Name:      pulumi.String(name),
     * 			CidrBlock: pulumi.String("10.1.0.0/21"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooSwitch, err := vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
     * 			VpcId:            fooNetwork.ID(),
     * 			CidrBlock:        pulumi.String("10.1.1.0/24"),
     * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
     * 			VswitchName:      pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		tfTestFoo, err := ecs.NewSecurityGroup(ctx, "tf_test_foo", &ecs.SecurityGroupArgs{
     * 			Name:        pulumi.String(name),
     * 			Description: pulumi.String("foo"),
     * 			VpcId:       fooNetwork.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooInstance, err := ecs.NewInstance(ctx, "foo", &ecs.InstanceArgs{
     * 			SecurityGroups: pulumi.StringArray{
     * 				tfTestFoo.ID(),
     * 			},
     * 			VswitchId:               fooSwitch.ID(),
     * 			AllocatePublicIp:        pulumi.Bool(true),
     * 			InstanceChargeType:      pulumi.String("PostPaid"),
     * 			InstanceType:            pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
     * 			InternetChargeType:      pulumi.String("PayByTraffic"),
     * 			InternetMaxBandwidthOut: pulumi.Int(5),
     * 			SystemDiskCategory:      pulumi.String("cloud_efficiency"),
     * 			ImageId:                 pulumi.String(defaultGetImages.Images[0].Id),
     * 			InstanceName:            pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooRouteEntry, err := vpc.NewRouteEntry(ctx, "foo", &vpc.RouteEntryArgs{
     * 			RouteTableId:         fooNetwork.RouteTableId,
     * 			DestinationCidrblock: pulumi.String("172.11.1.1/32"),
     * 			NexthopType:          pulumi.String("Instance"),
     * 			NexthopId:            fooInstance.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecs.NewSecurityGroupRule(ctx, "ingress", &ecs.SecurityGroupRuleArgs{
     * 			Type:            pulumi.String("ingress"),
     * 			IpProtocol:      pulumi.String("tcp"),
     * 			NicType:         pulumi.String("intranet"),
     * 			Policy:          pulumi.String("accept"),
     * 			PortRange:       pulumi.String("22/22"),
     * 			Priority:        pulumi.Int(1),
     * 			SecurityGroupId: tfTestFoo.ID(),
     * 			CidrIp:          pulumi.String("0.0.0.0/0"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = vpc.GetRouteEntriesOutput(ctx, vpc.GetRouteEntriesOutputArgs{
     * 			RouteTableId: fooRouteEntry.RouteTableId,
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
     * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroup;
     * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
     * import com.pulumi.alicloud.ecs.Instance;
     * import com.pulumi.alicloud.ecs.InstanceArgs;
     * import com.pulumi.alicloud.vpc.RouteEntry;
     * import com.pulumi.alicloud.vpc.RouteEntryArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroupRule;
     * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetRouteEntriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
     *             .availabilityZone(default_.zones()[0].id())
     *             .cpuCoreCount(1)
     *             .memorySize(2)
     *             .build());
     *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
     *             .nameRegex("^ubuntu_18.*64")
     *             .mostRecent(true)
     *             .owners("system")
     *             .build());
     *         final var name = config.get("name").orElse("tf-testAccRouteEntryConfig");
     *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
     *             .name(name)
     *             .cidrBlock("10.1.0.0/21")
     *             .build());
     *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
     *             .vpcId(fooNetwork.id())
     *             .cidrBlock("10.1.1.0/24")
     *             .availabilityZone(default_.zones()[0].id())
     *             .vswitchName(name)
     *             .build());
     *         var tfTestFoo = new SecurityGroup("tfTestFoo", SecurityGroupArgs.builder()
     *             .name(name)
     *             .description("foo")
     *             .vpcId(fooNetwork.id())
     *             .build());
     *         var fooInstance = new Instance("fooInstance", InstanceArgs.builder()
     *             .securityGroups(tfTestFoo.id())
     *             .vswitchId(fooSwitch.id())
     *             .allocatePublicIp(true)
     *             .instanceChargeType("PostPaid")
     *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
     *             .internetChargeType("PayByTraffic")
     *             .internetMaxBandwidthOut(5)
     *             .systemDiskCategory("cloud_efficiency")
     *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
     *             .instanceName(name)
     *             .build());
     *         var fooRouteEntry = new RouteEntry("fooRouteEntry", RouteEntryArgs.builder()
     *             .routeTableId(fooNetwork.routeTableId())
     *             .destinationCidrblock("172.11.1.1/32")
     *             .nexthopType("Instance")
     *             .nexthopId(fooInstance.id())
     *             .build());
     *         var ingress = new SecurityGroupRule("ingress", SecurityGroupRuleArgs.builder()
     *             .type("ingress")
     *             .ipProtocol("tcp")
     *             .nicType("intranet")
     *             .policy("accept")
     *             .portRange("22/22")
     *             .priority(1)
     *             .securityGroupId(tfTestFoo.id())
     *             .cidrIp("0.0.0.0/0")
     *             .build());
     *         final var foo = VpcFunctions.getRouteEntries(GetRouteEntriesArgs.builder()
     *             .routeTableId(fooRouteEntry.routeTableId())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-testAccRouteEntryConfig
     * resources:
     *   fooNetwork:
     *     type: alicloud:vpc:Network
     *     name: foo
     *     properties:
     *       name: ${name}
     *       cidrBlock: 10.1.0.0/21
     *   fooSwitch:
     *     type: alicloud:vpc:Switch
     *     name: foo
     *     properties:
     *       vpcId: ${fooNetwork.id}
     *       cidrBlock: 10.1.1.0/24
     *       availabilityZone: ${default.zones[0].id}
     *       vswitchName: ${name}
     *   fooRouteEntry:
     *     type: alicloud:vpc:RouteEntry
     *     name: foo
     *     properties:
     *       routeTableId: ${fooNetwork.routeTableId}
     *       destinationCidrblock: 172.11.1.1/32
     *       nexthopType: Instance
     *       nexthopId: ${fooInstance.id}
     *   tfTestFoo:
     *     type: alicloud:ecs:SecurityGroup
     *     name: tf_test_foo
     *     properties:
     *       name: ${name}
     *       description: foo
     *       vpcId: ${fooNetwork.id}
     *   ingress:
     *     type: alicloud:ecs:SecurityGroupRule
     *     properties:
     *       type: ingress
     *       ipProtocol: tcp
     *       nicType: intranet
     *       policy: accept
     *       portRange: 22/22
     *       priority: 1
     *       securityGroupId: ${tfTestFoo.id}
     *       cidrIp: 0.0.0.0/0
     *   fooInstance:
     *     type: alicloud:ecs:Instance
     *     name: foo
     *     properties:
     *       securityGroups:
     *         - ${tfTestFoo.id}
     *       vswitchId: ${fooSwitch.id}
     *       allocatePublicIp: true # series III
     *       instanceChargeType: PostPaid
     *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
     *       internetChargeType: PayByTraffic
     *       internetMaxBandwidthOut: 5
     *       systemDiskCategory: cloud_efficiency
     *       imageId: ${defaultGetImages.images[0].id}
     *       instanceName: ${name}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   defaultGetInstanceTypes:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstanceTypes
     *       Arguments:
     *         availabilityZone: ${default.zones[0].id}
     *         cpuCoreCount: 1
     *         memorySize: 2
     *   defaultGetImages:
     *     fn::invoke:
     *       Function: alicloud:ecs:getImages
     *       Arguments:
     *         nameRegex: ^ubuntu_18.*64
     *         mostRecent: true
     *         owners: system
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getRouteEntries
     *       Arguments:
     *         routeTableId: ${fooRouteEntry.routeTableId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteEntries.
     * @return A collection of values returned by getRouteEntries.
     */
    public suspend fun getRouteEntries(argument: GetRouteEntriesPlainArgs): GetRouteEntriesResult =
        getRouteEntriesResultToKotlin(getRouteEntriesPlain(argument.toJava()).await())

    /**
     * @see [getRouteEntries].
     * @param cidrBlock The destination CIDR block of the route entry.
     * @param instanceId The instance ID of the next hop.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param routeTableId The ID of the router table to which the route entry belongs.
     * @param type The type of the route entry.
     * @return A collection of values returned by getRouteEntries.
     */
    public suspend fun getRouteEntries(
        cidrBlock: String? = null,
        instanceId: String? = null,
        outputFile: String? = null,
        routeTableId: String,
        type: String? = null,
    ): GetRouteEntriesResult {
        val argument = GetRouteEntriesPlainArgs(
            cidrBlock = cidrBlock,
            instanceId = instanceId,
            outputFile = outputFile,
            routeTableId = routeTableId,
            type = type,
        )
        return getRouteEntriesResultToKotlin(getRouteEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetRouteEntriesPlainArgs].
     * @return A collection of values returned by getRouteEntries.
     */
    public suspend fun getRouteEntries(argument: suspend GetRouteEntriesPlainArgsBuilder.() -> Unit): GetRouteEntriesResult {
        val builder = GetRouteEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteEntriesResultToKotlin(getRouteEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Route Tables owned by an Alibaba Cloud account.
     * > **NOTE:** Available in 1.36.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "route-tables-datasource-example-name";
     * const fooNetwork = new alicloud.vpc.Network("foo", {
     *     cidrBlock: "172.16.0.0/12",
     *     vpcName: name,
     * });
     * const fooRouteTable = new alicloud.vpc.RouteTable("foo", {
     *     vpcId: fooNetwork.id,
     *     routeTableName: name,
     *     description: name,
     * });
     * const foo = alicloud.vpc.getRouteTablesOutput({
     *     ids: [fooRouteTable&#46;id],
     * });
     * export const routeTableIds = foo.apply(foo => foo.ids);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "route-tables-datasource-example-name"
     * foo_network = alicloud.vpc.Network("foo",
     *     cidr_block="172.16.0.0/12",
     *     vpc_name=name)
     * foo_route_table = alicloud.vpc.RouteTable("foo",
     *     vpc_id=foo_network.id,
     *     route_table_name=name,
     *     description=name)
     * foo = alicloud.vpc.get_route_tables_output(ids=[foo_route_table&#46;id])
     * pulumi.export("routeTableIds", foo.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "route-tables-datasource-example-name";
     *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         VpcName = name,
     *     });
     *     var fooRouteTable = new AliCloud.Vpc.RouteTable("foo", new()
     *     {
     *         VpcId = fooNetwork.Id,
     *         RouteTableName = name,
     *         Description = name,
     *     });
     *     var foo = AliCloud.Vpc.GetRouteTables.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             fooRouteTable.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["routeTableIds"] = foo.Apply(getRouteTablesResult => getRouteTablesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "route-tables-datasource-example-name";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
     * CidrBlock: pulumi.String("172.16.0.0/12"),
     * VpcName: pulumi.String(name),
     * })
     * if err != nil {
     * return err
     * }
     * fooRouteTable, err := vpc.NewRouteTable(ctx, "foo", &vpc.RouteTableArgs{
     * VpcId: fooNetwork.ID(),
     * RouteTableName: pulumi.String(name),
     * Description: pulumi.String(name),
     * })
     * if err != nil {
     * return err
     * }
     * foo := vpc.GetRouteTablesOutput(ctx, vpc.GetRouteTablesOutputArgs{
     * Ids: pulumi.StringArray{
     * fooRouteTable.ID(),
     * },
     * }, nil);
     * ctx.Export("routeTableIds", foo.ApplyT(func(foo vpc.GetRouteTablesResult) (interface{}, error) {
     * return foo.Ids, nil
     * }).(pulumi.Interface{}Output))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.RouteTable;
     * import com.pulumi.alicloud.vpc.RouteTableArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetRouteTablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("route-tables-datasource-example-name");
     *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .vpcName(name)
     *             .build());
     *         var fooRouteTable = new RouteTable("fooRouteTable", RouteTableArgs.builder()
     *             .vpcId(fooNetwork.id())
     *             .routeTableName(name)
     *             .description(name)
     *             .build());
     *         final var foo = VpcFunctions.getRouteTables(GetRouteTablesArgs.builder()
     *             .ids(fooRouteTable.id())
     *             .build());
     *         ctx.export("routeTableIds", foo.applyValue(getRouteTablesResult -> getRouteTablesResult).applyValue(foo -> foo.applyValue(getRouteTablesResult -> getRouteTablesResult.ids())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: route-tables-datasource-example-name
     * resources:
     *   fooNetwork:
     *     type: alicloud:vpc:Network
     *     name: foo
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *       vpcName: ${name}
     *   fooRouteTable:
     *     type: alicloud:vpc:RouteTable
     *     name: foo
     *     properties:
     *       vpcId: ${fooNetwork.id}
     *       routeTableName: ${name}
     *       description: ${name}
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getRouteTables
     *       Arguments:
     *         ids:
     *           - ${fooRouteTable.id}
     * outputs:
     *   routeTableIds: ${foo.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTables.
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(argument: GetRouteTablesPlainArgs): GetRouteTablesResult =
        getRouteTablesResultToKotlin(getRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getRouteTables].
     * @param ids A list of Route Tables IDs.
     * @param nameRegex A regex string to filter route tables by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The Id of resource group which route tables belongs.
     * @param routeTableName The route table name.
     * @param routerId The router ID.
     * @param routerType The route type of route table. Valid values: `VRouter` and `VBR`.
     * @param status The status of resource. Valid values: `Available` and `Pending`.
     * @param tags A mapping of tags to assign to the resource.
     * @param vpcId Vpc id of the route table.
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        routeTableName: String? = null,
        routerId: String? = null,
        routerType: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetRouteTablesResult {
        val argument = GetRouteTablesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            routeTableName = routeTableName,
            routerId = routerId,
            routerType = routerType,
            status = status,
            tags = tags,
            vpcId = vpcId,
        )
        return getRouteTablesResultToKotlin(getRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetRouteTablesPlainArgs].
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(argument: suspend GetRouteTablesPlainArgsBuilder.() -> Unit): GetRouteTablesResult {
        val builder = GetRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTablesResultToKotlin(getRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides information about [router interfaces](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-vpc-2016-04-28-describerouterinterfaces-efficiency-channels)
     * that connect VPCs together.
     * > **DEPRECATED:**  This datasource has been deprecated from version `1.199.0`. Please use new data source alicloud_express_connect_router_interfaces.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const routerInterfacesDs = alicloud.vpc.getRouterInterfaces({
     *     nameRegex: "^testenv",
     *     status: "Active",
     * });
     * export const firstRouterInterfaceId = routerInterfacesDs.then(routerInterfacesDs => routerInterfacesDs.interfaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * router_interfaces_ds = alicloud.vpc.get_router_interfaces(name_regex="^testenv",
     *     status="Active")
     * pulumi.export("firstRouterInterfaceId", router_interfaces_ds.interfaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var routerInterfacesDs = AliCloud.Vpc.GetRouterInterfaces.Invoke(new()
     *     {
     *         NameRegex = "^testenv",
     *         Status = "Active",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRouterInterfaceId"] = routerInterfacesDs&#46;Apply(getRouterInterfacesResult => getRouterInterfacesResult&#46;Interfaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		routerInterfacesDs, err := vpc.GetRouterInterfaces(ctx, &vpc.GetRouterInterfacesArgs{
     * 			NameRegex: pulumi.StringRef("^testenv"),
     * 			Status:    pulumi.StringRef("Active"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRouterInterfaceId", routerInterfacesDs.Interfaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetRouterInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var routerInterfacesDs = VpcFunctions.getRouterInterfaces(GetRouterInterfacesArgs.builder()
     *             .nameRegex("^testenv")
     *             .status("Active")
     *             .build());
     *         ctx.export("firstRouterInterfaceId", routerInterfacesDs.applyValue(getRouterInterfacesResult -> getRouterInterfacesResult.interfaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   routerInterfacesDs:
     *     fn::invoke:
     *       Function: alicloud:vpc:getRouterInterfaces
     *       Arguments:
     *         nameRegex: ^testenv
     *         status: Active
     * outputs:
     *   firstRouterInterfaceId: ${routerInterfacesDs.interfaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouterInterfaces.
     * @return A collection of values returned by getRouterInterfaces.
     */
    public suspend fun getRouterInterfaces(argument: GetRouterInterfacesPlainArgs): GetRouterInterfacesResult =
        getRouterInterfacesResultToKotlin(getRouterInterfacesPlain(argument.toJava()).await())

    /**
     * @see [getRouterInterfaces].
     * @param ids A list of router interface IDs.
     * @param nameRegex A regex string used to filter by router interface name.
     * @param oppositeInterfaceId ID of the peer router interface.
     * @param oppositeInterfaceOwnerId Account ID of the owner of the peer router interface.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param role Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and
     * `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
     * @param routerId ID of the VRouter located in the local region.
     * @param routerType Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
     * @param specification Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
     * @param status Expected status. Valid values are `Active`, `Inactive` and `Idle`.
     * @return A collection of values returned by getRouterInterfaces.
     */
    public suspend fun getRouterInterfaces(
        ids: List<String>? = null,
        nameRegex: String? = null,
        oppositeInterfaceId: String? = null,
        oppositeInterfaceOwnerId: String? = null,
        outputFile: String? = null,
        role: String? = null,
        routerId: String? = null,
        routerType: String? = null,
        specification: String? = null,
        status: String? = null,
    ): GetRouterInterfacesResult {
        val argument = GetRouterInterfacesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            oppositeInterfaceId = oppositeInterfaceId,
            oppositeInterfaceOwnerId = oppositeInterfaceOwnerId,
            outputFile = outputFile,
            role = role,
            routerId = routerId,
            routerType = routerType,
            specification = specification,
            status = status,
        )
        return getRouterInterfacesResultToKotlin(getRouterInterfacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouterInterfaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetRouterInterfacesPlainArgs].
     * @return A collection of values returned by getRouterInterfaces.
     */
    public suspend fun getRouterInterfaces(argument: suspend GetRouterInterfacesPlainArgsBuilder.() -> Unit): GetRouterInterfacesResult {
        val builder = GetRouterInterfacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouterInterfacesResultToKotlin(getRouterInterfacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Snat Entries owned by an Alibaba Cloud account.
     * > **NOTE:** Available in 1.37.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "snat-entry-example-name";
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * const fooNetwork = new alicloud.vpc.Network("foo", {
     *     name: name,
     *     cidrBlock: "172.16.0.0/12",
     * });
     * const fooSwitch = new alicloud.vpc.Switch("foo", {
     *     vpcId: fooNetwork.id,
     *     cidrBlock: "172.16.0.0/21",
     *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
     *     vswitchName: name,
     * });
     * const fooNatGateway = new alicloud.vpc.NatGateway("foo", {
     *     vpcId: fooNetwork.id,
     *     specification: "Small",
     *     name: name,
     * });
     * const fooEipAddress = new alicloud.ecs.EipAddress("foo", {addressName: name});
     * const fooEipAssociation = new alicloud.ecs.EipAssociation("foo", {
     *     allocationId: fooEipAddress.id,
     *     instanceId: fooNatGateway.id,
     * });
     * const fooSnatEntry = new alicloud.vpc.SnatEntry("foo", {
     *     snatTableId: fooNatGateway.snatTableIds,
     *     sourceVswitchId: fooSwitch.id,
     *     snatIp: fooEipAddress.ipAddress,
     * });
     * const foo = alicloud.vpc.getSnatEntriesOutput({
     *     snatTableId: fooSnatEntry.snatTableId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "snat-entry-example-name"
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * foo_network = alicloud.vpc.Network("foo",
     *     name=name,
     *     cidr_block="172.16.0.0/12")
     * foo_switch = alicloud.vpc.Switch("foo",
     *     vpc_id=foo_network.id,
     *     cidr_block="172.16.0.0/21",
     *     availability_zone=default.zones[0].id,
     *     vswitch_name=name)
     * foo_nat_gateway = alicloud.vpc.NatGateway("foo",
     *     vpc_id=foo_network.id,
     *     specification="Small",
     *     name=name)
     * foo_eip_address = alicloud.ecs.EipAddress("foo", address_name=name)
     * foo_eip_association = alicloud.ecs.EipAssociation("foo",
     *     allocation_id=foo_eip_address.id,
     *     instance_id=foo_nat_gateway.id)
     * foo_snat_entry = alicloud.vpc.SnatEntry("foo",
     *     snat_table_id=foo_nat_gateway.snat_table_ids,
     *     source_vswitch_id=foo_switch.id,
     *     snat_ip=foo_eip_address.ip_address)
     * foo = alicloud.vpc.get_snat_entries_output(snat_table_id=foo_snat_entry.snat_table_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "snat-entry-example-name";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var fooNetwork = new AliCloud.Vpc.Network("foo", new()
     *     {
     *         Name = name,
     *         CidrBlock = "172.16.0.0/12",
     *     });
     *     var fooSwitch = new AliCloud.Vpc.Switch("foo", new()
     *     {
     *         VpcId = fooNetwork.Id,
     *         CidrBlock = "172.16.0.0/21",
     *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VswitchName = name,
     *     });
     *     var fooNatGateway = new AliCloud.Vpc.NatGateway("foo", new()
     *     {
     *         VpcId = fooNetwork.Id,
     *         Specification = "Small",
     *         Name = name,
     *     });
     *     var fooEipAddress = new AliCloud.Ecs.EipAddress("foo", new()
     *     {
     *         AddressName = name,
     *     });
     *     var fooEipAssociation = new AliCloud.Ecs.EipAssociation("foo", new()
     *     {
     *         AllocationId = fooEipAddress.Id,
     *         InstanceId = fooNatGateway.Id,
     *     });
     *     var fooSnatEntry = new AliCloud.Vpc.SnatEntry("foo", new()
     *     {
     *         SnatTableId = fooNatGateway.SnatTableIds,
     *         SourceVswitchId = fooSwitch.Id,
     *         SnatIp = fooEipAddress.IpAddress,
     *     });
     *     var foo = AliCloud.Vpc.GetSnatEntries.Invoke(new()
     *     {
     *         SnatTableId = fooSnatEntry.SnatTableId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "snat-entry-example-name"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooNetwork, err := vpc.NewNetwork(ctx, "foo", &vpc.NetworkArgs{
     * 			Name:      pulumi.String(name),
     * 			CidrBlock: pulumi.String("172.16.0.0/12"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooSwitch, err := vpc.NewSwitch(ctx, "foo", &vpc.SwitchArgs{
     * 			VpcId:            fooNetwork.ID(),
     * 			CidrBlock:        pulumi.String("172.16.0.0/21"),
     * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
     * 			VswitchName:      pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooNatGateway, err := vpc.NewNatGateway(ctx, "foo", &vpc.NatGatewayArgs{
     * 			VpcId:         fooNetwork.ID(),
     * 			Specification: pulumi.String("Small"),
     * 			Name:          pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooEipAddress, err := ecs.NewEipAddress(ctx, "foo", &ecs.EipAddressArgs{
     * 			AddressName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecs.NewEipAssociation(ctx, "foo", &ecs.EipAssociationArgs{
     * 			AllocationId: fooEipAddress.ID(),
     * 			InstanceId:   fooNatGateway.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		fooSnatEntry, err := vpc.NewSnatEntry(ctx, "foo", &vpc.SnatEntryArgs{
     * 			SnatTableId:     fooNatGateway.SnatTableIds,
     * 			SourceVswitchId: fooSwitch.ID(),
     * 			SnatIp:          fooEipAddress.IpAddress,
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = vpc.GetSnatEntriesOutput(ctx, vpc.GetSnatEntriesOutputArgs{
     * 			SnatTableId: fooSnatEntry.SnatTableId,
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.vpc.NatGateway;
     * import com.pulumi.alicloud.vpc.NatGatewayArgs;
     * import com.pulumi.alicloud.ecs.EipAddress;
     * import com.pulumi.alicloud.ecs.EipAddressArgs;
     * import com.pulumi.alicloud.ecs.EipAssociation;
     * import com.pulumi.alicloud.ecs.EipAssociationArgs;
     * import com.pulumi.alicloud.vpc.SnatEntry;
     * import com.pulumi.alicloud.vpc.SnatEntryArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetSnatEntriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("snat-entry-example-name");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var fooNetwork = new Network("fooNetwork", NetworkArgs.builder()
     *             .name(name)
     *             .cidrBlock("172.16.0.0/12")
     *             .build());
     *         var fooSwitch = new Switch("fooSwitch", SwitchArgs.builder()
     *             .vpcId(fooNetwork.id())
     *             .cidrBlock("172.16.0.0/21")
     *             .availabilityZone(default_.zones()[0].id())
     *             .vswitchName(name)
     *             .build());
     *         var fooNatGateway = new NatGateway("fooNatGateway", NatGatewayArgs.builder()
     *             .vpcId(fooNetwork.id())
     *             .specification("Small")
     *             .name(name)
     *             .build());
     *         var fooEipAddress = new EipAddress("fooEipAddress", EipAddressArgs.builder()
     *             .addressName(name)
     *             .build());
     *         var fooEipAssociation = new EipAssociation("fooEipAssociation", EipAssociationArgs.builder()
     *             .allocationId(fooEipAddress.id())
     *             .instanceId(fooNatGateway.id())
     *             .build());
     *         var fooSnatEntry = new SnatEntry("fooSnatEntry", SnatEntryArgs.builder()
     *             .snatTableId(fooNatGateway.snatTableIds())
     *             .sourceVswitchId(fooSwitch.id())
     *             .snatIp(fooEipAddress.ipAddress())
     *             .build());
     *         final var foo = VpcFunctions.getSnatEntries(GetSnatEntriesArgs.builder()
     *             .snatTableId(fooSnatEntry.snatTableId())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: snat-entry-example-name
     * resources:
     *   fooNetwork:
     *     type: alicloud:vpc:Network
     *     name: foo
     *     properties:
     *       name: ${name}
     *       cidrBlock: 172.16.0.0/12
     *   fooSwitch:
     *     type: alicloud:vpc:Switch
     *     name: foo
     *     properties:
     *       vpcId: ${fooNetwork.id}
     *       cidrBlock: 172.16.0.0/21
     *       availabilityZone: ${default.zones[0].id}
     *       vswitchName: ${name}
     *   fooNatGateway:
     *     type: alicloud:vpc:NatGateway
     *     name: foo
     *     properties:
     *       vpcId: ${fooNetwork.id}
     *       specification: Small
     *       name: ${name}
     *   fooEipAddress:
     *     type: alicloud:ecs:EipAddress
     *     name: foo
     *     properties:
     *       addressName: ${name}
     *   fooEipAssociation:
     *     type: alicloud:ecs:EipAssociation
     *     name: foo
     *     properties:
     *       allocationId: ${fooEipAddress.id}
     *       instanceId: ${fooNatGateway.id}
     *   fooSnatEntry:
     *     type: alicloud:vpc:SnatEntry
     *     name: foo
     *     properties:
     *       snatTableId: ${fooNatGateway.snatTableIds}
     *       sourceVswitchId: ${fooSwitch.id}
     *       snatIp: ${fooEipAddress.ipAddress}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSnatEntries
     *       Arguments:
     *         snatTableId: ${fooSnatEntry.snatTableId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnatEntries.
     * @return A collection of values returned by getSnatEntries.
     */
    public suspend fun getSnatEntries(argument: GetSnatEntriesPlainArgs): GetSnatEntriesResult =
        getSnatEntriesResultToKotlin(getSnatEntriesPlain(argument.toJava()).await())

    /**
     * @see [getSnatEntries].
     * @param ids A list of Snat Entries IDs.
     * @param nameRegex A regex string to filter results by the resource name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param snatEntryName The name of snat entry.
     * @param snatIp The public IP of the Snat Entry.
     * @param snatTableId The ID of the Snat table.
     * @param sourceCidr The source CIDR block of the Snat Entry.
     * @param sourceVswitchId The source vswitch ID.
     * @param status The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
     * @return A collection of values returned by getSnatEntries.
     */
    public suspend fun getSnatEntries(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        snatEntryName: String? = null,
        snatIp: String? = null,
        snatTableId: String,
        sourceCidr: String? = null,
        sourceVswitchId: String? = null,
        status: String? = null,
    ): GetSnatEntriesResult {
        val argument = GetSnatEntriesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            snatEntryName = snatEntryName,
            snatIp = snatIp,
            snatTableId = snatTableId,
            sourceCidr = sourceCidr,
            sourceVswitchId = sourceVswitchId,
            status = status,
        )
        return getSnatEntriesResultToKotlin(getSnatEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnatEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetSnatEntriesPlainArgs].
     * @return A collection of values returned by getSnatEntries.
     */
    public suspend fun getSnatEntries(argument: suspend GetSnatEntriesPlainArgsBuilder.() -> Unit): GetSnatEntriesResult {
        val builder = GetSnatEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnatEntriesResultToKotlin(getSnatEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * The SSL-VPN client certificates data source lists lots of SSL-VPN client certificates resource information owned by an Alicloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const foo = alicloud.vpc.getSslVpnClientCerts({
     *     ids: ["fake-cert-id"],
     *     sslVpnServerId: "fake-server-id",
     *     outputFile: "/tmp/clientcert",
     *     nameRegex: "^foo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * foo = alicloud.vpc.get_ssl_vpn_client_certs(ids=["fake-cert-id"],
     *     ssl_vpn_server_id="fake-server-id",
     *     output_file="/tmp/clientcert",
     *     name_regex="^foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = AliCloud.Vpc.GetSslVpnClientCerts.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "fake-cert-id",
     *         },
     *         SslVpnServerId = "fake-server-id",
     *         OutputFile = "/tmp/clientcert",
     *         NameRegex = "^foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpc.GetSslVpnClientCerts(ctx, &vpc.GetSslVpnClientCertsArgs{
     * 			Ids: []string{
     * 				"fake-cert-id",
     * 			},
     * 			SslVpnServerId: pulumi.StringRef("fake-server-id"),
     * 			OutputFile:     pulumi.StringRef("/tmp/clientcert"),
     * 			NameRegex:      pulumi.StringRef("^foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetSslVpnClientCertsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = VpcFunctions.getSslVpnClientCerts(GetSslVpnClientCertsArgs.builder()
     *             .ids("fake-cert-id")
     *             .sslVpnServerId("fake-server-id")
     *             .outputFile("/tmp/clientcert")
     *             .nameRegex("^foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSslVpnClientCerts
     *       Arguments:
     *         ids:
     *           - fake-cert-id
     *         sslVpnServerId: fake-server-id
     *         outputFile: /tmp/clientcert
     *         nameRegex: ^foo
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSslVpnClientCerts.
     * @return A collection of values returned by getSslVpnClientCerts.
     */
    public suspend fun getSslVpnClientCerts(argument: GetSslVpnClientCertsPlainArgs): GetSslVpnClientCertsResult =
        getSslVpnClientCertsResultToKotlin(getSslVpnClientCertsPlain(argument.toJava()).await())

    /**
     * @see [getSslVpnClientCerts].
     * @param ids IDs of the SSL-VPN client certificates.
     * @param nameRegex A regex string of SSL-VPN client certificate name.
     * @param outputFile Save the result to the file.
     * @param sslVpnServerId Use the SSL-VPN server ID as the search key.
     * @return A collection of values returned by getSslVpnClientCerts.
     */
    public suspend fun getSslVpnClientCerts(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        sslVpnServerId: String? = null,
    ): GetSslVpnClientCertsResult {
        val argument = GetSslVpnClientCertsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            sslVpnServerId = sslVpnServerId,
        )
        return getSslVpnClientCertsResultToKotlin(getSslVpnClientCertsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSslVpnClientCerts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetSslVpnClientCertsPlainArgs].
     * @return A collection of values returned by getSslVpnClientCerts.
     */
    public suspend fun getSslVpnClientCerts(argument: suspend GetSslVpnClientCertsPlainArgsBuilder.() -> Unit): GetSslVpnClientCertsResult {
        val builder = GetSslVpnClientCertsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSslVpnClientCertsResultToKotlin(getSslVpnClientCertsPlain(builtArgument.toJava()).await())
    }

    /**
     * The SSL-VPN servers data source lists lots of SSL-VPN servers resource information owned by an Alicloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const foo = alicloud.vpc.getSslVpnServers({
     *     ids: ["fake-server-id"],
     *     vpnGatewayId: "fake-vpn-id",
     *     outputFile: "/tmp/sslserver",
     *     nameRegex: "^foo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * foo = alicloud.vpc.get_ssl_vpn_servers(ids=["fake-server-id"],
     *     vpn_gateway_id="fake-vpn-id",
     *     output_file="/tmp/sslserver",
     *     name_regex="^foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = AliCloud.Vpc.GetSslVpnServers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "fake-server-id",
     *         },
     *         VpnGatewayId = "fake-vpn-id",
     *         OutputFile = "/tmp/sslserver",
     *         NameRegex = "^foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpc.GetSslVpnServers(ctx, &vpc.GetSslVpnServersArgs{
     * 			Ids: []string{
     * 				"fake-server-id",
     * 			},
     * 			VpnGatewayId: pulumi.StringRef("fake-vpn-id"),
     * 			OutputFile:   pulumi.StringRef("/tmp/sslserver"),
     * 			NameRegex:    pulumi.StringRef("^foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetSslVpnServersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = VpcFunctions.getSslVpnServers(GetSslVpnServersArgs.builder()
     *             .ids("fake-server-id")
     *             .vpnGatewayId("fake-vpn-id")
     *             .outputFile("/tmp/sslserver")
     *             .nameRegex("^foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSslVpnServers
     *       Arguments:
     *         ids:
     *           - fake-server-id
     *         vpnGatewayId: fake-vpn-id
     *         outputFile: /tmp/sslserver
     *         nameRegex: ^foo
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSslVpnServers.
     * @return A collection of values returned by getSslVpnServers.
     */
    public suspend fun getSslVpnServers(argument: GetSslVpnServersPlainArgs): GetSslVpnServersResult =
        getSslVpnServersResultToKotlin(getSslVpnServersPlain(argument.toJava()).await())

    /**
     * @see [getSslVpnServers].
     * @param ids IDs of the SSL-VPN servers.
     * @param nameRegex A regex string of SSL-VPN server name.
     * @param outputFile Save the result to the file.
     * @param vpnGatewayId Use the VPN gateway ID as the search key.
     * @return A collection of values returned by getSslVpnServers.
     */
    public suspend fun getSslVpnServers(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        vpnGatewayId: String? = null,
    ): GetSslVpnServersResult {
        val argument = GetSslVpnServersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            vpnGatewayId = vpnGatewayId,
        )
        return getSslVpnServersResultToKotlin(getSslVpnServersPlain(argument.toJava()).await())
    }

    /**
     * @see [getSslVpnServers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetSslVpnServersPlainArgs].
     * @return A collection of values returned by getSslVpnServers.
     */
    public suspend fun getSslVpnServers(argument: suspend GetSslVpnServersPlainArgsBuilder.() -> Unit): GetSslVpnServersResult {
        val builder = GetSslVpnServersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSslVpnServersResultToKotlin(getSslVpnServersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of VSwitches owned by an Alibaba Cloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "vswitchDatasourceName";
     * const default = alicloud.getZones({});
     * const vpc = new alicloud.vpc.Network("vpc", {
     *     cidrBlock: "172.16.0.0/16",
     *     vpcName: name,
     * });
     * const vswitch = new alicloud.vpc.Switch("vswitch", {
     *     vswitchName: name,
     *     cidrBlock: "172.16.0.0/24",
     *     vpcId: vpc.id,
     *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
     * });
     * const defaultGetSwitches = alicloud.vpc.getSwitchesOutput({
     *     nameRegex: vswitch.vswitchName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "vswitchDatasourceName"
     * default = alicloud.get_zones()
     * vpc = alicloud.vpc.Network("vpc",
     *     cidr_block="172.16.0.0/16",
     *     vpc_name=name)
     * vswitch = alicloud.vpc.Switch("vswitch",
     *     vswitch_name=name,
     *     cidr_block="172.16.0.0/24",
     *     vpc_id=vpc.id,
     *     availability_zone=default.zones[0].id)
     * default_get_switches = alicloud.vpc.get_switches_output(name_regex=vswitch.vswitch_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "vswitchDatasourceName";
     *     var @default = AliCloud.GetZones.Invoke();
     *     var vpc = new AliCloud.Vpc.Network("vpc", new()
     *     {
     *         CidrBlock = "172.16.0.0/16",
     *         VpcName = name,
     *     });
     *     var vswitch = new AliCloud.Vpc.Switch("vswitch", new()
     *     {
     *         VswitchName = name,
     *         CidrBlock = "172.16.0.0/24",
     *         VpcId = vpc.Id,
     *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *     });
     *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         NameRegex = vswitch.VswitchName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "vswitchDatasourceName"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
     * 			CidrBlock: pulumi.String("172.16.0.0/16"),
     * 			VpcName:   pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		vswitch, err := vpc.NewSwitch(ctx, "vswitch", &vpc.SwitchArgs{
     * 			VswitchName:      pulumi.String(name),
     * 			CidrBlock:        pulumi.String("172.16.0.0/24"),
     * 			VpcId:            vpc.ID(),
     * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = vpc.GetSwitchesOutput(ctx, vpc.GetSwitchesOutputArgs{
     * 			NameRegex: vswitch.VswitchName,
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("vswitchDatasourceName");
     *         final var default = AlicloudFunctions.getZones();
     *         var vpc = new Network("vpc", NetworkArgs.builder()
     *             .cidrBlock("172.16.0.0/16")
     *             .vpcName(name)
     *             .build());
     *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
     *             .vswitchName(name)
     *             .cidrBlock("172.16.0.0/24")
     *             .vpcId(vpc.id())
     *             .availabilityZone(default_.zones()[0].id())
     *             .build());
     *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .nameRegex(vswitch.vswitchName())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: vswitchDatasourceName
     * resources:
     *   vpc:
     *     type: alicloud:vpc:Network
     *     properties:
     *       cidrBlock: 172.16.0.0/16
     *       vpcName: ${name}
     *   vswitch:
     *     type: alicloud:vpc:Switch
     *     properties:
     *       vswitchName: ${name}
     *       cidrBlock: 172.16.0.0/24
     *       vpcId: ${vpc.id}
     *       availabilityZone: ${default.zones[0].id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments: {}
     *   defaultGetSwitches:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSwitches
     *       Arguments:
     *         nameRegex: ${vswitch.vswitchName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSwitches.
     * @return A collection of values returned by getSwitches.
     */
    public suspend fun getSwitches(argument: GetSwitchesPlainArgs): GetSwitchesResult =
        getSwitchesResultToKotlin(getSwitchesPlain(argument.toJava()).await())

    /**
     * @see [getSwitches].
     * @param cidrBlock Filter results by a specific CIDR block. For example: "172.16.0.0/12".
     * @param dryRun Specifies whether to precheck this request only. Valid values: `true` and `false`.
     * @param ids A list of vSwitch IDs.
     * @param isDefault Indicate whether the vSwitch is created by the system.
     * @param nameRegex A regex string to filter results by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which VSWitch belongs.
     * @param routeTableId The route table ID of the vSwitch.
     * @param status The status of the vSwitch. Valid values: `Available` and `Pending`.
     * @param tags A mapping of tags to assign to the resource.
     * @param vpcId ID of the VPC that owns the vSwitch.
     * @param vswitchName The name of the vSwitch.
     * @param vswitchOwnerId The vSwitch owner id.
     * @param zoneId The availability zone of the vSwitch.
     * @return A collection of values returned by getSwitches.
     */
    public suspend fun getSwitches(
        cidrBlock: String? = null,
        dryRun: Boolean? = null,
        ids: List<String>? = null,
        isDefault: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        routeTableId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchName: String? = null,
        vswitchOwnerId: Int? = null,
        zoneId: String? = null,
    ): GetSwitchesResult {
        val argument = GetSwitchesPlainArgs(
            cidrBlock = cidrBlock,
            dryRun = dryRun,
            ids = ids,
            isDefault = isDefault,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            routeTableId = routeTableId,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchName = vswitchName,
            vswitchOwnerId = vswitchOwnerId,
            zoneId = zoneId,
        )
        return getSwitchesResultToKotlin(getSwitchesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSwitches].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetSwitchesPlainArgs].
     * @return A collection of values returned by getSwitches.
     */
    public suspend fun getSwitches(argument: suspend GetSwitchesPlainArgsBuilder.() -> Unit): GetSwitchesResult {
        val builder = GetSwitchesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSwitchesResultToKotlin(getSwitchesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Traffic Mirror Filter Egress Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getTrafficMirrorFilterEgressRules({
     *     trafficMirrorFilterId: "example_traffic_mirror_filter_id",
     *     ids: ["example_id"],
     * });
     * export const vpcTrafficMirrorFilterEgressRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const status = alicloud.vpc.getTrafficMirrorFilterEgressRules({
     *     trafficMirrorFilterId: "example_traffic_mirror_filter_id",
     *     ids: ["example_id"],
     *     status: "Created",
     * });
     * export const vpcTrafficMirrorFilterEgressRuleId2 = status.then(status => status.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_traffic_mirror_filter_egress_rules(traffic_mirror_filter_id="example_traffic_mirror_filter_id",
     *     ids=["example_id"])
     * pulumi.export("vpcTrafficMirrorFilterEgressRuleId1", ids.rules[0].id)
     * status = alicloud.vpc.get_traffic_mirror_filter_egress_rules(traffic_mirror_filter_id="example_traffic_mirror_filter_id",
     *     ids=["example_id"],
     *     status="Created")
     * pulumi.export("vpcTrafficMirrorFilterEgressRuleId2", status.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetTrafficMirrorFilterEgressRules.Invoke(new()
     *     {
     *         TrafficMirrorFilterId = "example_traffic_mirror_filter_id",
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var status = AliCloud.Vpc.GetTrafficMirrorFilterEgressRules.Invoke(new()
     *     {
     *         TrafficMirrorFilterId = "example_traffic_mirror_filter_id",
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Status = "Created",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcTrafficMirrorFilterEgressRuleId1"] = ids&#46;Apply(getTrafficMirrorFilterEgressRulesResult => getTrafficMirrorFilterEgressRulesResult&#46;Rules[0]?.Id),
     *         ["vpcTrafficMirrorFilterEgressRuleId2"] = status&#46;Apply(getTrafficMirrorFilterEgressRulesResult => getTrafficMirrorFilterEgressRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetTrafficMirrorFilterEgressRules(ctx, &vpc.GetTrafficMirrorFilterEgressRulesArgs{
     * 			TrafficMirrorFilterId: "example_traffic_mirror_filter_id",
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterEgressRuleId1", ids.Rules[0].Id)
     * 		status, err := vpc.GetTrafficMirrorFilterEgressRules(ctx, &vpc.GetTrafficMirrorFilterEgressRulesArgs{
     * 			TrafficMirrorFilterId: "example_traffic_mirror_filter_id",
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Status: pulumi.StringRef("Created"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterEgressRuleId2", status.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFilterEgressRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getTrafficMirrorFilterEgressRules(GetTrafficMirrorFilterEgressRulesArgs.builder()
     *             .trafficMirrorFilterId("example_traffic_mirror_filter_id")
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterEgressRuleId1", ids.applyValue(getTrafficMirrorFilterEgressRulesResult -> getTrafficMirrorFilterEgressRulesResult.rules()[0].id()));
     *         final var status = VpcFunctions.getTrafficMirrorFilterEgressRules(GetTrafficMirrorFilterEgressRulesArgs.builder()
     *             .trafficMirrorFilterId("example_traffic_mirror_filter_id")
     *             .ids("example_id")
     *             .status("Created")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterEgressRuleId2", status.applyValue(getTrafficMirrorFilterEgressRulesResult -> getTrafficMirrorFilterEgressRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilterEgressRules
     *       Arguments:
     *         trafficMirrorFilterId: example_traffic_mirror_filter_id
     *         ids:
     *           - example_id
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilterEgressRules
     *       Arguments:
     *         trafficMirrorFilterId: example_traffic_mirror_filter_id
     *         ids:
     *           - example_id
     *         status: Created
     * outputs:
     *   vpcTrafficMirrorFilterEgressRuleId1: ${ids.rules[0].id}
     *   vpcTrafficMirrorFilterEgressRuleId2: ${status.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrafficMirrorFilterEgressRules.
     * @return A collection of values returned by getTrafficMirrorFilterEgressRules.
     */
    public suspend fun getTrafficMirrorFilterEgressRules(argument: GetTrafficMirrorFilterEgressRulesPlainArgs): GetTrafficMirrorFilterEgressRulesResult =
        getTrafficMirrorFilterEgressRulesResultToKotlin(getTrafficMirrorFilterEgressRulesPlain(argument.toJava()).await())

    /**
     * @see [getTrafficMirrorFilterEgressRules].
     * @param ids A list of Traffic Mirror Filter Egress Rule IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
     * @param trafficMirrorFilterId The ID of the Traffic Mirror Filter.
     * @return A collection of values returned by getTrafficMirrorFilterEgressRules.
     */
    public suspend fun getTrafficMirrorFilterEgressRules(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        trafficMirrorFilterId: String,
    ): GetTrafficMirrorFilterEgressRulesResult {
        val argument = GetTrafficMirrorFilterEgressRulesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            trafficMirrorFilterId = trafficMirrorFilterId,
        )
        return getTrafficMirrorFilterEgressRulesResultToKotlin(getTrafficMirrorFilterEgressRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficMirrorFilterEgressRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetTrafficMirrorFilterEgressRulesPlainArgs].
     * @return A collection of values returned by getTrafficMirrorFilterEgressRules.
     */
    public suspend fun getTrafficMirrorFilterEgressRules(argument: suspend GetTrafficMirrorFilterEgressRulesPlainArgsBuilder.() -> Unit): GetTrafficMirrorFilterEgressRulesResult {
        val builder = GetTrafficMirrorFilterEgressRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficMirrorFilterEgressRulesResultToKotlin(getTrafficMirrorFilterEgressRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Traffic Mirror Filter Ingress Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.141.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getTrafficMirrorFilterIngressRules({
     *     trafficMirrorFilterId: "example_traffic_mirror_filter_id",
     *     ids: ["example_id"],
     * });
     * export const vpcTrafficMirrorFilterIngressRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const status = alicloud.vpc.getTrafficMirrorFilterIngressRules({
     *     trafficMirrorFilterId: "example_traffic_mirror_filter_id",
     *     ids: ["example_id"],
     *     status: "Created",
     * });
     * export const vpcTrafficMirrorFilterIngressRuleId2 = status.then(status => status.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_traffic_mirror_filter_ingress_rules(traffic_mirror_filter_id="example_traffic_mirror_filter_id",
     *     ids=["example_id"])
     * pulumi.export("vpcTrafficMirrorFilterIngressRuleId1", ids.rules[0].id)
     * status = alicloud.vpc.get_traffic_mirror_filter_ingress_rules(traffic_mirror_filter_id="example_traffic_mirror_filter_id",
     *     ids=["example_id"],
     *     status="Created")
     * pulumi.export("vpcTrafficMirrorFilterIngressRuleId2", status.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetTrafficMirrorFilterIngressRules.Invoke(new()
     *     {
     *         TrafficMirrorFilterId = "example_traffic_mirror_filter_id",
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var status = AliCloud.Vpc.GetTrafficMirrorFilterIngressRules.Invoke(new()
     *     {
     *         TrafficMirrorFilterId = "example_traffic_mirror_filter_id",
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Status = "Created",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcTrafficMirrorFilterIngressRuleId1"] = ids&#46;Apply(getTrafficMirrorFilterIngressRulesResult => getTrafficMirrorFilterIngressRulesResult&#46;Rules[0]?.Id),
     *         ["vpcTrafficMirrorFilterIngressRuleId2"] = status&#46;Apply(getTrafficMirrorFilterIngressRulesResult => getTrafficMirrorFilterIngressRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetTrafficMirrorFilterIngressRules(ctx, &vpc.GetTrafficMirrorFilterIngressRulesArgs{
     * 			TrafficMirrorFilterId: "example_traffic_mirror_filter_id",
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterIngressRuleId1", ids.Rules[0].Id)
     * 		status, err := vpc.GetTrafficMirrorFilterIngressRules(ctx, &vpc.GetTrafficMirrorFilterIngressRulesArgs{
     * 			TrafficMirrorFilterId: "example_traffic_mirror_filter_id",
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Status: pulumi.StringRef("Created"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterIngressRuleId2", status.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFilterIngressRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getTrafficMirrorFilterIngressRules(GetTrafficMirrorFilterIngressRulesArgs.builder()
     *             .trafficMirrorFilterId("example_traffic_mirror_filter_id")
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterIngressRuleId1", ids.applyValue(getTrafficMirrorFilterIngressRulesResult -> getTrafficMirrorFilterIngressRulesResult.rules()[0].id()));
     *         final var status = VpcFunctions.getTrafficMirrorFilterIngressRules(GetTrafficMirrorFilterIngressRulesArgs.builder()
     *             .trafficMirrorFilterId("example_traffic_mirror_filter_id")
     *             .ids("example_id")
     *             .status("Created")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterIngressRuleId2", status.applyValue(getTrafficMirrorFilterIngressRulesResult -> getTrafficMirrorFilterIngressRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilterIngressRules
     *       Arguments:
     *         trafficMirrorFilterId: example_traffic_mirror_filter_id
     *         ids:
     *           - example_id
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilterIngressRules
     *       Arguments:
     *         trafficMirrorFilterId: example_traffic_mirror_filter_id
     *         ids:
     *           - example_id
     *         status: Created
     * outputs:
     *   vpcTrafficMirrorFilterIngressRuleId1: ${ids.rules[0].id}
     *   vpcTrafficMirrorFilterIngressRuleId2: ${status.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrafficMirrorFilterIngressRules.
     * @return A collection of values returned by getTrafficMirrorFilterIngressRules.
     */
    public suspend fun getTrafficMirrorFilterIngressRules(argument: GetTrafficMirrorFilterIngressRulesPlainArgs): GetTrafficMirrorFilterIngressRulesResult =
        getTrafficMirrorFilterIngressRulesResultToKotlin(getTrafficMirrorFilterIngressRulesPlain(argument.toJava()).await())

    /**
     * @see [getTrafficMirrorFilterIngressRules].
     * @param ids A list of Traffic Mirror Filter Ingress Rule IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
     * @param trafficMirrorFilterId The ID of the Traffic Mirror Filter.
     * @return A collection of values returned by getTrafficMirrorFilterIngressRules.
     */
    public suspend fun getTrafficMirrorFilterIngressRules(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        trafficMirrorFilterId: String,
    ): GetTrafficMirrorFilterIngressRulesResult {
        val argument = GetTrafficMirrorFilterIngressRulesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            trafficMirrorFilterId = trafficMirrorFilterId,
        )
        return getTrafficMirrorFilterIngressRulesResultToKotlin(getTrafficMirrorFilterIngressRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficMirrorFilterIngressRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetTrafficMirrorFilterIngressRulesPlainArgs].
     * @return A collection of values returned by getTrafficMirrorFilterIngressRules.
     */
    public suspend fun getTrafficMirrorFilterIngressRules(argument: suspend GetTrafficMirrorFilterIngressRulesPlainArgsBuilder.() -> Unit): GetTrafficMirrorFilterIngressRulesResult {
        val builder = GetTrafficMirrorFilterIngressRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficMirrorFilterIngressRulesResultToKotlin(getTrafficMirrorFilterIngressRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Traffic Mirror Filters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getTrafficMirrorFilters({
     *     ids: ["example_id"],
     * });
     * export const vpcTrafficMirrorFilterId1 = ids.then(ids => ids.filters?.[0]?.id);
     * const nameRegex = alicloud.vpc.getTrafficMirrorFilters({
     *     nameRegex: "^my-TrafficMirrorFilter",
     * });
     * export const vpcTrafficMirrorFilterId2 = nameRegex.then(nameRegex => nameRegex.filters?.[0]?.id);
     * const filterName = alicloud.vpc.getTrafficMirrorFilters({
     *     trafficMirrorFilterName: "example_traffic_mirror_filter_name",
     * });
     * export const vpcTrafficMirrorFilterId3 = filterName.then(filterName => filterName.filters?.[0]?.id);
     * const status = alicloud.vpc.getTrafficMirrorFilters({
     *     status: "^my-TrafficMirrorFilter",
     * });
     * export const vpcTrafficMirrorFilterId4 = status.then(status => status.filters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_traffic_mirror_filters(ids=["example_id"])
     * pulumi.export("vpcTrafficMirrorFilterId1", ids.filters[0].id)
     * name_regex = alicloud.vpc.get_traffic_mirror_filters(name_regex="^my-TrafficMirrorFilter")
     * pulumi.export("vpcTrafficMirrorFilterId2", name_regex.filters[0].id)
     * filter_name = alicloud.vpc.get_traffic_mirror_filters(traffic_mirror_filter_name="example_traffic_mirror_filter_name")
     * pulumi.export("vpcTrafficMirrorFilterId3", filter_name.filters[0].id)
     * status = alicloud.vpc.get_traffic_mirror_filters(status="^my-TrafficMirrorFilter")
     * pulumi.export("vpcTrafficMirrorFilterId4", status.filters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetTrafficMirrorFilters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetTrafficMirrorFilters.Invoke(new()
     *     {
     *         NameRegex = "^my-TrafficMirrorFilter",
     *     });
     *     var filterName = AliCloud.Vpc.GetTrafficMirrorFilters.Invoke(new()
     *     {
     *         TrafficMirrorFilterName = "example_traffic_mirror_filter_name",
     *     });
     *     var status = AliCloud.Vpc.GetTrafficMirrorFilters.Invoke(new()
     *     {
     *         Status = "^my-TrafficMirrorFilter",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcTrafficMirrorFilterId1"] = ids&#46;Apply(getTrafficMirrorFiltersResult => getTrafficMirrorFiltersResult&#46;Filters[0]?.Id),
     *         ["vpcTrafficMirrorFilterId2"] = nameRegex&#46;Apply(getTrafficMirrorFiltersResult => getTrafficMirrorFiltersResult&#46;Filters[0]?.Id),
     *         ["vpcTrafficMirrorFilterId3"] = filterName&#46;Apply(getTrafficMirrorFiltersResult => getTrafficMirrorFiltersResult&#46;Filters[0]?.Id),
     *         ["vpcTrafficMirrorFilterId4"] = status&#46;Apply(getTrafficMirrorFiltersResult => getTrafficMirrorFiltersResult&#46;Filters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetTrafficMirrorFilters(ctx, &vpc.GetTrafficMirrorFiltersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterId1", ids.Filters[0].Id)
     * 		nameRegex, err := vpc.GetTrafficMirrorFilters(ctx, &vpc.GetTrafficMirrorFiltersArgs{
     * 			NameRegex: pulumi.StringRef("^my-TrafficMirrorFilter"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterId2", nameRegex.Filters[0].Id)
     * 		filterName, err := vpc.GetTrafficMirrorFilters(ctx, &vpc.GetTrafficMirrorFiltersArgs{
     * 			TrafficMirrorFilterName: pulumi.StringRef("example_traffic_mirror_filter_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterId3", filterName.Filters[0].Id)
     * 		status, err := vpc.GetTrafficMirrorFilters(ctx, &vpc.GetTrafficMirrorFiltersArgs{
     * 			Status: pulumi.StringRef("^my-TrafficMirrorFilter"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorFilterId4", status.Filters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFiltersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getTrafficMirrorFilters(GetTrafficMirrorFiltersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterId1", ids.applyValue(getTrafficMirrorFiltersResult -> getTrafficMirrorFiltersResult.filters()[0].id()));
     *         final var nameRegex = VpcFunctions.getTrafficMirrorFilters(GetTrafficMirrorFiltersArgs.builder()
     *             .nameRegex("^my-TrafficMirrorFilter")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterId2", nameRegex.applyValue(getTrafficMirrorFiltersResult -> getTrafficMirrorFiltersResult.filters()[0].id()));
     *         final var filterName = VpcFunctions.getTrafficMirrorFilters(GetTrafficMirrorFiltersArgs.builder()
     *             .trafficMirrorFilterName("example_traffic_mirror_filter_name")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterId3", filterName.applyValue(getTrafficMirrorFiltersResult -> getTrafficMirrorFiltersResult.filters()[0].id()));
     *         final var status = VpcFunctions.getTrafficMirrorFilters(GetTrafficMirrorFiltersArgs.builder()
     *             .status("^my-TrafficMirrorFilter")
     *             .build());
     *         ctx.export("vpcTrafficMirrorFilterId4", status.applyValue(getTrafficMirrorFiltersResult -> getTrafficMirrorFiltersResult.filters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilters
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilters
     *       Arguments:
     *         nameRegex: ^my-TrafficMirrorFilter
     *   filterName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilters
     *       Arguments:
     *         trafficMirrorFilterName: example_traffic_mirror_filter_name
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorFilters
     *       Arguments:
     *         status: ^my-TrafficMirrorFilter
     * outputs:
     *   vpcTrafficMirrorFilterId1: ${ids.filters[0].id}
     *   vpcTrafficMirrorFilterId2: ${nameRegex.filters[0].id}
     *   vpcTrafficMirrorFilterId3: ${filterName.filters[0].id}
     *   vpcTrafficMirrorFilterId4: ${status.filters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrafficMirrorFilters.
     * @return A collection of values returned by getTrafficMirrorFilters.
     */
    public suspend fun getTrafficMirrorFilters(argument: GetTrafficMirrorFiltersPlainArgs): GetTrafficMirrorFiltersResult =
        getTrafficMirrorFiltersResultToKotlin(getTrafficMirrorFiltersPlain(argument.toJava()).await())

    /**
     * @see [getTrafficMirrorFilters].
     * @param ids A list of Traffic Mirror Filter IDs.
     * @param nameRegex A regex string to filter results by Traffic Mirror Filter name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
     * @param trafficMirrorFilterName The name of the filter. The name must be `2` to `128` characters in length, and can contain digits, periods (.), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
     * @return A collection of values returned by getTrafficMirrorFilters.
     */
    public suspend fun getTrafficMirrorFilters(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        trafficMirrorFilterName: String? = null,
    ): GetTrafficMirrorFiltersResult {
        val argument = GetTrafficMirrorFiltersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            trafficMirrorFilterName = trafficMirrorFilterName,
        )
        return getTrafficMirrorFiltersResultToKotlin(getTrafficMirrorFiltersPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficMirrorFilters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetTrafficMirrorFiltersPlainArgs].
     * @return A collection of values returned by getTrafficMirrorFilters.
     */
    public suspend fun getTrafficMirrorFilters(argument: suspend GetTrafficMirrorFiltersPlainArgsBuilder.() -> Unit): GetTrafficMirrorFiltersResult {
        val builder = GetTrafficMirrorFiltersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficMirrorFiltersResultToKotlin(getTrafficMirrorFiltersPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open VPC Traffic Mirror service automatically. If the service has been opened, it will return opened.
     * For information about VPC Traffic Mirror and how to use it, see [What is VPC Traffic Mirror](https://www.alibabacloud.com/help/en/vpc/user-guide/traffic-mirroring-overview).
     * > **NOTE:** Available since v1.141.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.vpc.getTrafficMirrorService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.vpc.get_traffic_mirror_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Vpc.GetTrafficMirrorService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpc.GetTrafficMirrorService(ctx, &vpc.GetTrafficMirrorServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = VpcFunctions.getTrafficMirrorService(GetTrafficMirrorServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrafficMirrorService.
     * @return A collection of values returned by getTrafficMirrorService.
     */
    public suspend fun getTrafficMirrorService(argument: GetTrafficMirrorServicePlainArgs): GetTrafficMirrorServiceResult =
        getTrafficMirrorServiceResultToKotlin(getTrafficMirrorServicePlain(argument.toJava()).await())

    /**
     * @see [getTrafficMirrorService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Default value: `Off`. Valid values: `On` and `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the VPC Traffic Mirror service that means you have read and agreed the [VPC Traffic Mirror Terms of Service](https://help.aliyun.com/zh/vpc/support/vpc-terms-of-service). The service can not closed once it is opened.
     * @return A collection of values returned by getTrafficMirrorService.
     */
    public suspend fun getTrafficMirrorService(enable: String? = null): GetTrafficMirrorServiceResult {
        val argument = GetTrafficMirrorServicePlainArgs(
            enable = enable,
        )
        return getTrafficMirrorServiceResultToKotlin(getTrafficMirrorServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficMirrorService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetTrafficMirrorServicePlainArgs].
     * @return A collection of values returned by getTrafficMirrorService.
     */
    public suspend fun getTrafficMirrorService(argument: suspend GetTrafficMirrorServicePlainArgsBuilder.() -> Unit): GetTrafficMirrorServiceResult {
        val builder = GetTrafficMirrorServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficMirrorServiceResultToKotlin(getTrafficMirrorServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Traffic Mirror Sessions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     * });
     * export const vpcTrafficMirrorSessionId1 = ids.then(ids => ids.sessions?.[0]?.id);
     * const nameRegex = alicloud.vpc.getTrafficMirrorSessions({
     *     nameRegex: "^my-TrafficMirrorSession",
     * });
     * export const vpcTrafficMirrorSessionId2 = nameRegex.then(nameRegex => nameRegex.sessions?.[0]?.id);
     * const enabled = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     enabled: false,
     * });
     * export const vpcTrafficMirrorSessionId3 = enabled.then(enabled => enabled.sessions?.[0]?.id);
     * const priority = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     priority: 1,
     * });
     * export const vpcTrafficMirrorSessionId4 = priority.then(priority => priority.sessions?.[0]?.id);
     * const filterId = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     trafficMirrorFilterId: "example_value",
     * });
     * export const vpcTrafficMirrorSessionId5 = filterId.then(filterId => filterId.sessions?.[0]?.id);
     * const sessionName = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     trafficMirrorSessionName: "example_value",
     * });
     * export const vpcTrafficMirrorSessionId6 = sessionName.then(sessionName => sessionName.sessions?.[0]?.id);
     * const sourceId = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     trafficMirrorSourceId: "example_value",
     * });
     * export const vpcTrafficMirrorSessionId7 = sourceId.then(sourceId => sourceId.sessions?.[0]?.id);
     * const targetId = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     trafficMirrorTargetId: "example_value",
     * });
     * export const vpcTrafficMirrorSessionId8 = targetId.then(targetId => targetId.sessions?.[0]?.id);
     * const status = alicloud.vpc.getTrafficMirrorSessions({
     *     ids: ["example_id"],
     *     status: "Created",
     * });
     * export const vpcTrafficMirrorSessionId9 = status.then(status => status.sessions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"])
     * pulumi.export("vpcTrafficMirrorSessionId1", ids.sessions[0].id)
     * name_regex = alicloud.vpc.get_traffic_mirror_sessions(name_regex="^my-TrafficMirrorSession")
     * pulumi.export("vpcTrafficMirrorSessionId2", name_regex.sessions[0].id)
     * enabled = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     enabled=False)
     * pulumi.export("vpcTrafficMirrorSessionId3", enabled.sessions[0].id)
     * priority = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     priority=1)
     * pulumi.export("vpcTrafficMirrorSessionId4", priority.sessions[0].id)
     * filter_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     traffic_mirror_filter_id="example_value")
     * pulumi.export("vpcTrafficMirrorSessionId5", filter_id.sessions[0].id)
     * session_name = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     traffic_mirror_session_name="example_value")
     * pulumi.export("vpcTrafficMirrorSessionId6", session_name.sessions[0].id)
     * source_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     traffic_mirror_source_id="example_value")
     * pulumi.export("vpcTrafficMirrorSessionId7", source_id.sessions[0].id)
     * target_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     traffic_mirror_target_id="example_value")
     * pulumi.export("vpcTrafficMirrorSessionId8", target_id.sessions[0].id)
     * status = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
     *     status="Created")
     * pulumi.export("vpcTrafficMirrorSessionId9", status.sessions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         NameRegex = "^my-TrafficMirrorSession",
     *     });
     *     var enabled = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Enabled = false,
     *     });
     *     var priority = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Priority = 1,
     *     });
     *     var filterId = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TrafficMirrorFilterId = "example_value",
     *     });
     *     var sessionName = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TrafficMirrorSessionName = "example_value",
     *     });
     *     var sourceId = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TrafficMirrorSourceId = "example_value",
     *     });
     *     var targetId = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TrafficMirrorTargetId = "example_value",
     *     });
     *     var status = AliCloud.Vpc.GetTrafficMirrorSessions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Status = "Created",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpcTrafficMirrorSessionId1"] = ids&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId2"] = nameRegex&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId3"] = enabled&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId4"] = priority&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId5"] = filterId&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId6"] = sessionName&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId7"] = sourceId&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId8"] = targetId&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *         ["vpcTrafficMirrorSessionId9"] = status&#46;Apply(getTrafficMirrorSessionsResult => getTrafficMirrorSessionsResult&#46;Sessions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId1", ids.Sessions[0].Id)
     * 		nameRegex, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			NameRegex: pulumi.StringRef("^my-TrafficMirrorSession"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId2", nameRegex.Sessions[0].Id)
     * 		enabled, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Enabled: pulumi.BoolRef(false),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId3", enabled.Sessions[0].Id)
     * 		priority, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Priority: pulumi.IntRef(1),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId4", priority.Sessions[0].Id)
     * 		filterId, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TrafficMirrorFilterId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId5", filterId.Sessions[0].Id)
     * 		sessionName, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TrafficMirrorSessionName: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId6", sessionName.Sessions[0].Id)
     * 		sourceId, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TrafficMirrorSourceId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId7", sourceId.Sessions[0].Id)
     * 		targetId, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TrafficMirrorTargetId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId8", targetId.Sessions[0].Id)
     * 		status, err := vpc.GetTrafficMirrorSessions(ctx, &vpc.GetTrafficMirrorSessionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Status: pulumi.StringRef("Created"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpcTrafficMirrorSessionId9", status.Sessions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorSessionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId1", ids.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var nameRegex = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .nameRegex("^my-TrafficMirrorSession")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId2", nameRegex.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var enabled = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .enabled("false")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId3", enabled.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var priority = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .priority("1")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId4", priority.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var filterId = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .trafficMirrorFilterId("example_value")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId5", filterId.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var sessionName = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .trafficMirrorSessionName("example_value")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId6", sessionName.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var sourceId = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .trafficMirrorSourceId("example_value")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId7", sourceId.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var targetId = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .trafficMirrorTargetId("example_value")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId8", targetId.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *         final var status = VpcFunctions.getTrafficMirrorSessions(GetTrafficMirrorSessionsArgs.builder()
     *             .ids("example_id")
     *             .status("Created")
     *             .build());
     *         ctx.export("vpcTrafficMirrorSessionId9", status.applyValue(getTrafficMirrorSessionsResult -> getTrafficMirrorSessionsResult.sessions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         nameRegex: ^my-TrafficMirrorSession
     *   enabled:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         enabled: 'false'
     *   priority:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         priority: '1'
     *   filterId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         trafficMirrorFilterId: example_value
     *   sessionName:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         trafficMirrorSessionName: example_value
     *   sourceId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         trafficMirrorSourceId: example_value
     *   targetId:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         trafficMirrorTargetId: example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:vpc:getTrafficMirrorSessions
     *       Arguments:
     *         ids:
     *           - example_id
     *         status: Created
     * outputs:
     *   vpcTrafficMirrorSessionId1: ${ids.sessions[0].id}
     *   vpcTrafficMirrorSessionId2: ${nameRegex.sessions[0].id}
     *   vpcTrafficMirrorSessionId3: ${enabled.sessions[0].id}
     *   vpcTrafficMirrorSessionId4: ${priority.sessions[0].id}
     *   vpcTrafficMirrorSessionId5: ${filterId.sessions[0].id}
     *   vpcTrafficMirrorSessionId6: ${sessionName.sessions[0].id}
     *   vpcTrafficMirrorSessionId7: ${sourceId.sessions[0].id}
     *   vpcTrafficMirrorSessionId8: ${targetId.sessions[0].id}
     *   vpcTrafficMirrorSessionId9: ${status.sessions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrafficMirrorSessions.
     * @return A collection of values returned by getTrafficMirrorSessions.
     */
    public suspend fun getTrafficMirrorSessions(argument: GetTrafficMirrorSessionsPlainArgs): GetTrafficMirrorSessionsResult =
        getTrafficMirrorSessionsResultToKotlin(getTrafficMirrorSessionsPlain(argument.toJava()).await())

    /**
     * @see [getTrafficMirrorSessions].
     * @param enabled Specifies whether to enable traffic mirror sessions. default to `false`.
     * @param ids A list of Traffic Mirror Session IDs.
     * @param nameRegex A regex string to filter results by Traffic Mirror Session name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param priority The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
     * @param status The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
     * @param trafficMirrorFilterId The ID of the filter.
     * @param trafficMirrorSessionName The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
     * @param trafficMirrorSourceId The ID of the mirror source. You can specify only an elastic network interface (ENI) as the mirror source.
     * @param trafficMirrorTargetId The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
     * @return A collection of values returned by getTrafficMirrorSessions.
     */
    public suspend fun getTrafficMirrorSessions(
        enabled: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        priority: Int? = null,
        status: String? = null,
        trafficMirrorFilterId: String? = null,
        trafficMirrorSessionName: String? = null,
        trafficMirrorSourceId: String? = null,
        trafficMirrorTargetId: String? = null,
    ): GetTrafficMirrorSessionsResult {
        val argument = GetTrafficMirrorSessionsPlainArgs(
            enabled = enabled,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            priority = priority,
            status = status,
            trafficMirrorFilterId = trafficMirrorFilterId,
            trafficMirrorSessionName = trafficMirrorSessionName,
            trafficMirrorSourceId = trafficMirrorSourceId,
            trafficMirrorTargetId = trafficMirrorTargetId,
        )
        return getTrafficMirrorSessionsResultToKotlin(getTrafficMirrorSessionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficMirrorSessions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetTrafficMirrorSessionsPlainArgs].
     * @return A collection of values returned by getTrafficMirrorSessions.
     */
    public suspend fun getTrafficMirrorSessions(argument: suspend GetTrafficMirrorSessionsPlainArgsBuilder.() -> Unit): GetTrafficMirrorSessionsResult {
        val builder = GetTrafficMirrorSessionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficMirrorSessionsResultToKotlin(getTrafficMirrorSessionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Vpc Flow Logs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.122.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.vpc.getVpcFlowLogs({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstVpcFlowLogId = example.then(example => example.logs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.vpc.get_vpc_flow_logs(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstVpcFlowLogId", example.logs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Vpc.GetVpcFlowLogs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstVpcFlowLogId"] = example&#46;Apply(getVpcFlowLogsResult => getVpcFlowLogsResult&#46;Logs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := vpc.GetVpcFlowLogs(ctx, &vpc.GetVpcFlowLogsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstVpcFlowLogId", example.Logs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetVpcFlowLogsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpcFunctions.getVpcFlowLogs(GetVpcFlowLogsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstVpcFlowLogId", example.applyValue(getVpcFlowLogsResult -> getVpcFlowLogsResult.logs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:vpc:getVpcFlowLogs
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstVpcFlowLogId: ${example.logs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcFlowLogs.
     * @return A collection of values returned by getVpcFlowLogs.
     */
    public suspend fun getVpcFlowLogs(argument: GetVpcFlowLogsPlainArgs): GetVpcFlowLogsResult =
        getVpcFlowLogsResultToKotlin(getVpcFlowLogsPlain(argument.toJava()).await())

    /**
     * @see [getVpcFlowLogs].
     * @param description The Description of flow log.
     * @param flowLogName The flow log name.
     * @param ids A list of Flow Log IDs.
     * @param logStoreName The log store name.
     * @param nameRegex A regex string to filter results by Flow Log name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param projectName The project name.
     * @param resourceId The resource id.
     * @param resourceType The resource type. Valid values: `NetworkInterface`, `VPC`, `VSwitch`.
     * @param status The status of  flow log. Valid values: `Active`, `Inactive`.
     * @param trafficType The traffic type. Valid values: `All`, `Allow`, `Drop`.
     * @return A collection of values returned by getVpcFlowLogs.
     */
    public suspend fun getVpcFlowLogs(
        description: String? = null,
        flowLogName: String? = null,
        ids: List<String>? = null,
        logStoreName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        projectName: String? = null,
        resourceId: String? = null,
        resourceType: String? = null,
        status: String? = null,
        trafficType: String? = null,
    ): GetVpcFlowLogsResult {
        val argument = GetVpcFlowLogsPlainArgs(
            description = description,
            flowLogName = flowLogName,
            ids = ids,
            logStoreName = logStoreName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            projectName = projectName,
            resourceId = resourceId,
            resourceType = resourceType,
            status = status,
            trafficType = trafficType,
        )
        return getVpcFlowLogsResultToKotlin(getVpcFlowLogsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcFlowLogs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vpc&#46;kotlin&#46;inputs&#46;GetVpcFlowLogsPlainArgs].
     * @return A collection of values returned by getVpcFlowLogs.
     */
    public suspend fun getVpcFlowLogs(argument: suspend GetVpcFlowLogsPlainArgsBuilder.() -> Unit): GetVpcFlowLogsResult {
        val builder = GetVpcFlowLogsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcFlowLogsResultToKotlin(getVpcFlowLogsPlain(builtArgument.toJava()).await())
    }
}
