@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcNetworkAclAttachment].
 */
@PulumiTagMarker
public class VpcNetworkAclAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcNetworkAclAttachmentArgs = VpcNetworkAclAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcNetworkAclAttachmentArgsBuilder.() -> Unit) {
        val builder = VpcNetworkAclAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcNetworkAclAttachment {
        val builtJavaResource = com.pulumi.alicloud.vpc.VpcNetworkAclAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcNetworkAclAttachment(builtJavaResource)
    }
}

/**
 * Provides a VPC Network Acl Attachment resource. Resources associated with network Acl.
 * For information about VPC Network Acl Attachment and how to use it, see [What is Network Acl Attachment](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/associatenetworkacl).
 * > **NOTE:** Available since v1.193.0.
 * ## Import
 * VPC Network Acl Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/vpcNetworkAclAttachment:VpcNetworkAclAttachment example <network_acl_id>:<resource_id>
 * ```
 */
public class VpcNetworkAclAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.VpcNetworkAclAttachment,
) : KotlinCustomResource(javaResource, VpcNetworkAclAttachmentMapper) {
    /**
     * The ID of the network ACL.
     */
    public val networkAclId: Output<String>
        get() = javaResource.networkAclId().applyValue({ args0 -> args0 })

    /**
     * The ID of the associated resource.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * The type of the associated resource. Valid values: `VSwitch`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The status of the Network Acl Attachment.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object VpcNetworkAclAttachmentMapper : ResourceMapper<VpcNetworkAclAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.VpcNetworkAclAttachment::class == javaResource::class

    override fun map(javaResource: Resource): VpcNetworkAclAttachment =
        VpcNetworkAclAttachment(javaResource as com.pulumi.alicloud.vpc.VpcNetworkAclAttachment)
}

/**
 * @see [VpcNetworkAclAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcNetworkAclAttachment].
 */
public suspend fun vpcNetworkAclAttachment(
    name: String,
    block: suspend VpcNetworkAclAttachmentResourceBuilder.() -> Unit,
): VpcNetworkAclAttachment {
    val builder = VpcNetworkAclAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcNetworkAclAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcNetworkAclAttachment(name: String): VpcNetworkAclAttachment {
    val builder = VpcNetworkAclAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
