@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.VpcNetworkAclAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Network Acl Attachment resource. Resources associated with network Acl.
 * For information about VPC Network Acl Attachment and how to use it, see [What is Network Acl Attachment](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/associatenetworkacl).
 * > **NOTE:** Available since v1.193.0.
 * ## Import
 * VPC Network Acl Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/vpcNetworkAclAttachment:VpcNetworkAclAttachment example <network_acl_id>:<resource_id>
 * ```
 * @property networkAclId The ID of the network ACL.
 * @property resourceId The ID of the associated resource.
 * @property resourceType The type of the associated resource. Valid values: `VSwitch`.
 */
public data class VpcNetworkAclAttachmentArgs(
    public val networkAclId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.VpcNetworkAclAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.VpcNetworkAclAttachmentArgs =
        com.pulumi.alicloud.vpc.VpcNetworkAclAttachmentArgs.builder()
            .networkAclId(networkAclId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcNetworkAclAttachmentArgs].
 */
@PulumiTagMarker
public class VpcNetworkAclAttachmentArgsBuilder internal constructor() {
    private var networkAclId: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("jmfhnnecksvnasbq")
    public suspend fun networkAclId(`value`: Output<String>) {
        this.networkAclId = value
    }

    /**
     * @param value The ID of the associated resource.
     */
    @JvmName("fgkvubcdairleiha")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The type of the associated resource. Valid values: `VSwitch`.
     */
    @JvmName("kruxvgumjotprfxc")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("hshbdnvybjjsceqb")
    public suspend fun networkAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclId = mapped
    }

    /**
     * @param value The ID of the associated resource.
     */
    @JvmName("qdkmapdajlmnwwrv")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The type of the associated resource. Valid values: `VSwitch`.
     */
    @JvmName("widaqxqawhftliqc")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): VpcNetworkAclAttachmentArgs = VpcNetworkAclAttachmentArgs(
        networkAclId = networkAclId,
        resourceId = resourceId,
        resourceType = resourceType,
    )
}
