@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VswitchCidrReservation].
 */
@PulumiTagMarker
public class VswitchCidrReservationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VswitchCidrReservationArgs = VswitchCidrReservationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VswitchCidrReservationArgsBuilder.() -> Unit) {
        val builder = VswitchCidrReservationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VswitchCidrReservation {
        val builtJavaResource = com.pulumi.alicloud.vpc.VswitchCidrReservation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VswitchCidrReservation(builtJavaResource)
    }
}

/**
 * Provides a Vpc Vswitch Cidr Reservation resource. The reserved network segment of the vswitch. This resource type can be used only in ap-southeast region.
 * For information about Vpc Vswitch Cidr Reservation and how to use it, see [What is Vswitch Cidr Reservation](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/610154).
 * > **NOTE:** Available since v1.205.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultVSwitch = new alicloud.vpc.Switch("defaultVSwitch", {
 *     vpcId: defaultVpc.id,
 *     cidrBlock: "10.0.0.0/20",
 *     vswitchName: `${name}1`,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultVswitchCidrReservation = new alicloud.vpc.VswitchCidrReservation("default", {
 *     ipVersion: "IPv4",
 *     vswitchId: defaultVSwitch.id,
 *     cidrReservationDescription: name,
 *     cidrReservationCidr: "10.0.10.0/24",
 *     vswitchCidrReservationName: name,
 *     cidrReservationType: "Prefix",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_vpc = alicloud.vpc.Network("defaultVpc",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_v_switch = alicloud.vpc.Switch("defaultVSwitch",
 *     vpc_id=default_vpc.id,
 *     cidr_block="10.0.0.0/20",
 *     vswitch_name=f"{name}1",
 *     zone_id=default.zones[0].id)
 * default_vswitch_cidr_reservation = alicloud.vpc.VswitchCidrReservation("default",
 *     ip_version="IPv4",
 *     vswitch_id=default_v_switch.id,
 *     cidr_reservation_description=name,
 *     cidr_reservation_cidr="10.0.10.0/24",
 *     vswitch_cidr_reservation_name=name,
 *     cidr_reservation_type="Prefix")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultVSwitch = new AliCloud.Vpc.Switch("defaultVSwitch", new()
 *     {
 *         VpcId = defaultVpc.Id,
 *         CidrBlock = "10.0.0.0/20",
 *         VswitchName = $"{name}1",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultVswitchCidrReservation = new AliCloud.Vpc.VswitchCidrReservation("default", new()
 *     {
 *         IpVersion = "IPv4",
 *         VswitchId = defaultVSwitch.Id,
 *         CidrReservationDescription = name,
 *         CidrReservationCidr = "10.0.10.0/24",
 *         VswitchCidrReservationName = name,
 *         CidrReservationType = "Prefix",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVSwitch, err := vpc.NewSwitch(ctx, "defaultVSwitch", &vpc.SwitchArgs{
 * 			VpcId:       defaultVpc.ID(),
 * 			CidrBlock:   pulumi.String("10.0.0.0/20"),
 * 			VswitchName: pulumi.Sprintf("%v1", name),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewVswitchCidrReservation(ctx, "default", &vpc.VswitchCidrReservationArgs{
 * 			IpVersion:                  pulumi.String("IPv4"),
 * 			VswitchId:                  defaultVSwitch.ID(),
 * 			CidrReservationDescription: pulumi.String(name),
 * 			CidrReservationCidr:        pulumi.String("10.0.10.0/24"),
 * 			VswitchCidrReservationName: pulumi.String(name),
 * 			CidrReservationType:        pulumi.String("Prefix"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.VswitchCidrReservation;
 * import com.pulumi.alicloud.vpc.VswitchCidrReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultVSwitch = new Switch("defaultVSwitch", SwitchArgs.builder()
 *             .vpcId(defaultVpc.id())
 *             .cidrBlock("10.0.0.0/20")
 *             .vswitchName(String.format("%s1", name))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultVswitchCidrReservation = new VswitchCidrReservation("defaultVswitchCidrReservation", VswitchCidrReservationArgs.builder()
 *             .ipVersion("IPv4")
 *             .vswitchId(defaultVSwitch.id())
 *             .cidrReservationDescription(name)
 *             .cidrReservationCidr("10.0.10.0/24")
 *             .vswitchCidrReservationName(name)
 *             .cidrReservationType("Prefix")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultVSwitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultVpc.id}
 *       cidrBlock: 10.0.0.0/20
 *       vswitchName: ${name}1
 *       zoneId: ${default.zones[0].id}
 *   defaultVswitchCidrReservation:
 *     type: alicloud:vpc:VswitchCidrReservation
 *     name: default
 *     properties:
 *       ipVersion: IPv4
 *       vswitchId: ${defaultVSwitch.id}
 *       cidrReservationDescription: ${name}
 *       cidrReservationCidr: 10.0.10.0/24
 *       vswitchCidrReservationName: ${name}
 *       cidrReservationType: Prefix
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Vswitch Cidr Reservation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/vswitchCidrReservation:VswitchCidrReservation example <vswitch_id>:<vswitch_cidr_reservation_id>
 * ```
 */
public class VswitchCidrReservation internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.VswitchCidrReservation,
) : KotlinCustomResource(javaResource, VswitchCidrReservationMapper) {
    /**
     * Reserved network segment CIdrBlock.
     */
    public val cidrReservationCidr: Output<String>
        get() = javaResource.cidrReservationCidr().applyValue({ args0 -> args0 })

    /**
     * The description of the reserved CIDR block.
     */
    public val cidrReservationDescription: Output<String>?
        get() = javaResource.cidrReservationDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Reserved segment mask.
     */
    public val cidrReservationMask: Output<String>?
        get() = javaResource.cidrReservationMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
     */
    public val cidrReservationType: Output<String>
        get() = javaResource.cidrReservationType().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
     */
    public val ipVersion: Output<String>
        get() = javaResource.ipVersion().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The id of the vpc instance to which the reserved CIDR block belongs.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The resource attribute field of the resource ID.
     */
    public val vswitchCidrReservationId: Output<String>
        get() = javaResource.vswitchCidrReservationId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val vswitchCidrReservationName: Output<String>?
        get() = javaResource.vswitchCidrReservationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of the switch instance.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object VswitchCidrReservationMapper : ResourceMapper<VswitchCidrReservation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.VswitchCidrReservation::class == javaResource::class

    override fun map(javaResource: Resource): VswitchCidrReservation =
        VswitchCidrReservation(javaResource as com.pulumi.alicloud.vpc.VswitchCidrReservation)
}

/**
 * @see [VswitchCidrReservation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VswitchCidrReservation].
 */
public suspend fun vswitchCidrReservation(
    name: String,
    block: suspend VswitchCidrReservationResourceBuilder.() -> Unit,
): VswitchCidrReservation {
    val builder = VswitchCidrReservationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VswitchCidrReservation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vswitchCidrReservation(name: String): VswitchCidrReservation {
    val builder = VswitchCidrReservationResourceBuilder()
    builder.name(name)
    return builder.build()
}
