@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.VswitchCidrReservationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Vpc Vswitch Cidr Reservation resource. The reserved network segment of the vswitch. This resource type can be used only in ap-southeast region.
 * For information about Vpc Vswitch Cidr Reservation and how to use it, see [What is Vswitch Cidr Reservation](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/610154).
 * > **NOTE:** Available since v1.205.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultVSwitch = new alicloud.vpc.Switch("defaultVSwitch", {
 *     vpcId: defaultVpc.id,
 *     cidrBlock: "10.0.0.0/20",
 *     vswitchName: `${name}1`,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultVswitchCidrReservation = new alicloud.vpc.VswitchCidrReservation("default", {
 *     ipVersion: "IPv4",
 *     vswitchId: defaultVSwitch.id,
 *     cidrReservationDescription: name,
 *     cidrReservationCidr: "10.0.10.0/24",
 *     vswitchCidrReservationName: name,
 *     cidrReservationType: "Prefix",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_vpc = alicloud.vpc.Network("defaultVpc",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_v_switch = alicloud.vpc.Switch("defaultVSwitch",
 *     vpc_id=default_vpc.id,
 *     cidr_block="10.0.0.0/20",
 *     vswitch_name=f"{name}1",
 *     zone_id=default.zones[0].id)
 * default_vswitch_cidr_reservation = alicloud.vpc.VswitchCidrReservation("default",
 *     ip_version="IPv4",
 *     vswitch_id=default_v_switch.id,
 *     cidr_reservation_description=name,
 *     cidr_reservation_cidr="10.0.10.0/24",
 *     vswitch_cidr_reservation_name=name,
 *     cidr_reservation_type="Prefix")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultVSwitch = new AliCloud.Vpc.Switch("defaultVSwitch", new()
 *     {
 *         VpcId = defaultVpc.Id,
 *         CidrBlock = "10.0.0.0/20",
 *         VswitchName = $"{name}1",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultVswitchCidrReservation = new AliCloud.Vpc.VswitchCidrReservation("default", new()
 *     {
 *         IpVersion = "IPv4",
 *         VswitchId = defaultVSwitch.Id,
 *         CidrReservationDescription = name,
 *         CidrReservationCidr = "10.0.10.0/24",
 *         VswitchCidrReservationName = name,
 *         CidrReservationType = "Prefix",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVSwitch, err := vpc.NewSwitch(ctx, "defaultVSwitch", &vpc.SwitchArgs{
 * 			VpcId:       defaultVpc.ID(),
 * 			CidrBlock:   pulumi.String("10.0.0.0/20"),
 * 			VswitchName: pulumi.Sprintf("%v1", name),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewVswitchCidrReservation(ctx, "default", &vpc.VswitchCidrReservationArgs{
 * 			IpVersion:                  pulumi.String("IPv4"),
 * 			VswitchId:                  defaultVSwitch.ID(),
 * 			CidrReservationDescription: pulumi.String(name),
 * 			CidrReservationCidr:        pulumi.String("10.0.10.0/24"),
 * 			VswitchCidrReservationName: pulumi.String(name),
 * 			CidrReservationType:        pulumi.String("Prefix"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.VswitchCidrReservation;
 * import com.pulumi.alicloud.vpc.VswitchCidrReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultVSwitch = new Switch("defaultVSwitch", SwitchArgs.builder()
 *             .vpcId(defaultVpc.id())
 *             .cidrBlock("10.0.0.0/20")
 *             .vswitchName(String.format("%s1", name))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultVswitchCidrReservation = new VswitchCidrReservation("defaultVswitchCidrReservation", VswitchCidrReservationArgs.builder()
 *             .ipVersion("IPv4")
 *             .vswitchId(defaultVSwitch.id())
 *             .cidrReservationDescription(name)
 *             .cidrReservationCidr("10.0.10.0/24")
 *             .vswitchCidrReservationName(name)
 *             .cidrReservationType("Prefix")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultVSwitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultVpc.id}
 *       cidrBlock: 10.0.0.0/20
 *       vswitchName: ${name}1
 *       zoneId: ${default.zones[0].id}
 *   defaultVswitchCidrReservation:
 *     type: alicloud:vpc:VswitchCidrReservation
 *     name: default
 *     properties:
 *       ipVersion: IPv4
 *       vswitchId: ${defaultVSwitch.id}
 *       cidrReservationDescription: ${name}
 *       cidrReservationCidr: 10.0.10.0/24
 *       vswitchCidrReservationName: ${name}
 *       cidrReservationType: Prefix
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Vswitch Cidr Reservation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/vswitchCidrReservation:VswitchCidrReservation example <vswitch_id>:<vswitch_cidr_reservation_id>
 * ```
 * @property cidrReservationCidr Reserved network segment CIdrBlock.
 * @property cidrReservationDescription The description of the reserved CIDR block.
 * @property cidrReservationMask Reserved segment mask.
 * @property cidrReservationType Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
 * @property ipVersion Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
 * @property vswitchCidrReservationName The name of the resource.
 * @property vswitchId The Id of the switch instance.
 */
public data class VswitchCidrReservationArgs(
    public val cidrReservationCidr: Output<String>? = null,
    public val cidrReservationDescription: Output<String>? = null,
    public val cidrReservationMask: Output<String>? = null,
    public val cidrReservationType: Output<String>? = null,
    public val ipVersion: Output<String>? = null,
    public val vswitchCidrReservationName: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.VswitchCidrReservationArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.VswitchCidrReservationArgs =
        com.pulumi.alicloud.vpc.VswitchCidrReservationArgs.builder()
            .cidrReservationCidr(cidrReservationCidr?.applyValue({ args0 -> args0 }))
            .cidrReservationDescription(cidrReservationDescription?.applyValue({ args0 -> args0 }))
            .cidrReservationMask(cidrReservationMask?.applyValue({ args0 -> args0 }))
            .cidrReservationType(cidrReservationType?.applyValue({ args0 -> args0 }))
            .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
            .vswitchCidrReservationName(vswitchCidrReservationName?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VswitchCidrReservationArgs].
 */
@PulumiTagMarker
public class VswitchCidrReservationArgsBuilder internal constructor() {
    private var cidrReservationCidr: Output<String>? = null

    private var cidrReservationDescription: Output<String>? = null

    private var cidrReservationMask: Output<String>? = null

    private var cidrReservationType: Output<String>? = null

    private var ipVersion: Output<String>? = null

    private var vswitchCidrReservationName: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Reserved network segment CIdrBlock.
     */
    @JvmName("mgeiflusenujnkmn")
    public suspend fun cidrReservationCidr(`value`: Output<String>) {
        this.cidrReservationCidr = value
    }

    /**
     * @param value The description of the reserved CIDR block.
     */
    @JvmName("rstgjaxerdphroei")
    public suspend fun cidrReservationDescription(`value`: Output<String>) {
        this.cidrReservationDescription = value
    }

    /**
     * @param value Reserved segment mask.
     */
    @JvmName("mfplsydmwpugpnqi")
    public suspend fun cidrReservationMask(`value`: Output<String>) {
        this.cidrReservationMask = value
    }

    /**
     * @param value Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
     */
    @JvmName("yocjiqrrhtljssqa")
    public suspend fun cidrReservationType(`value`: Output<String>) {
        this.cidrReservationType = value
    }

    /**
     * @param value Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
     */
    @JvmName("cllabnryxjjmhqnb")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("tvmtlgpijwjqprud")
    public suspend fun vswitchCidrReservationName(`value`: Output<String>) {
        this.vswitchCidrReservationName = value
    }

    /**
     * @param value The Id of the switch instance.
     */
    @JvmName("onorofrfuafdtxgt")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Reserved network segment CIdrBlock.
     */
    @JvmName("kulvicrmbwaxpdrf")
    public suspend fun cidrReservationCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrReservationCidr = mapped
    }

    /**
     * @param value The description of the reserved CIDR block.
     */
    @JvmName("wulykeceqyygwwsr")
    public suspend fun cidrReservationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrReservationDescription = mapped
    }

    /**
     * @param value Reserved segment mask.
     */
    @JvmName("mexbtavovgamwfsd")
    public suspend fun cidrReservationMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrReservationMask = mapped
    }

    /**
     * @param value Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
     */
    @JvmName("usajbfnvtsbrpmcy")
    public suspend fun cidrReservationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrReservationType = mapped
    }

    /**
     * @param value Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
     */
    @JvmName("ltxushluvewsgvta")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ccvjcqsfwabowqku")
    public suspend fun vswitchCidrReservationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchCidrReservationName = mapped
    }

    /**
     * @param value The Id of the switch instance.
     */
    @JvmName("ghglthtkqixcudxc")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): VswitchCidrReservationArgs = VswitchCidrReservationArgs(
        cidrReservationCidr = cidrReservationCidr,
        cidrReservationDescription = cidrReservationDescription,
        cidrReservationMask = cidrReservationMask,
        cidrReservationType = cidrReservationType,
        ipVersion = ipVersion,
        vswitchCidrReservationName = vswitchCidrReservationName,
        vswitchId = vswitchId,
    )
}
