@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.DhcpOptionsSetAssociateVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property associateStatus The status of the VPC associated with the DHCP option set.
 * @property vpcId The ID of the VPC network that is associated with the DHCP options set.
 */
public data class DhcpOptionsSetAssociateVpcArgs(
    public val associateStatus: Output<String>? = null,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.DhcpOptionsSetAssociateVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.DhcpOptionsSetAssociateVpcArgs =
        com.pulumi.alicloud.vpc.inputs.DhcpOptionsSetAssociateVpcArgs.builder()
            .associateStatus(associateStatus?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DhcpOptionsSetAssociateVpcArgs].
 */
@PulumiTagMarker
public class DhcpOptionsSetAssociateVpcArgsBuilder internal constructor() {
    private var associateStatus: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The status of the VPC associated with the DHCP option set.
     */
    @JvmName("oewfnlgnxjjudeus")
    public suspend fun associateStatus(`value`: Output<String>) {
        this.associateStatus = value
    }

    /**
     * @param value The ID of the VPC network that is associated with the DHCP options set.
     */
    @JvmName("ossyjxytmtruwhyf")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The status of the VPC associated with the DHCP option set.
     */
    @JvmName("bmffyqyghlckpham")
    public suspend fun associateStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associateStatus = mapped
    }

    /**
     * @param value The ID of the VPC network that is associated with the DHCP options set.
     */
    @JvmName("tqawsiyrhgyyriml")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DhcpOptionsSetAssociateVpcArgs = DhcpOptionsSetAssociateVpcArgs(
        associateStatus = associateStatus,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
