@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetBgpGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBgpGroups.
 * @property ids A list of Bgp Group IDs.
 * @property nameRegex A regex string to filter results by Bgp Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property routerId The ID of the virtual border router (VBR) that is associated with the BGP group.
 * @property status The status of the resource. Valid values: `Available`, `Deleting` and `Pending`.
 */
public data class GetBgpGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val routerId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetBgpGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetBgpGroupsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetBgpGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .routerId(routerId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBgpGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetBgpGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var routerId: String? = null

    private var status: String? = null

    /**
     * @param value A list of Bgp Group IDs.
     */
    @JvmName("hircspaofjowuimw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Bgp Group IDs.
     */
    @JvmName("uevgpxjdtcukalja")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Bgp Group name.
     */
    @JvmName("kymeolojindxkjky")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("oyuepigredprugsc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the virtual border router (VBR) that is associated with the BGP group.
     */
    @JvmName("qcganhdavcagirqh")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerId = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Available`, `Deleting` and `Pending`.
     */
    @JvmName("jkedvtkknjppcabj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBgpGroupsPlainArgs = GetBgpGroupsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        routerId = routerId,
        status = status,
    )
}
