@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetBgpNetworksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBgpNetworks.
 * @property ids A list of Bgp Network IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property routerId The ID of the router to which the route table belongs.
 * @property status The state of the advertised BGP network. Valid values: `Available`, `Pending`, `Deleting`.
 */
public data class GetBgpNetworksPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val routerId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetBgpNetworksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetBgpNetworksPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetBgpNetworksPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .routerId(routerId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBgpNetworksPlainArgs].
 */
@PulumiTagMarker
public class GetBgpNetworksPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var routerId: String? = null

    private var status: String? = null

    /**
     * @param value A list of Bgp Network IDs.
     */
    @JvmName("siucksgcrsrlaqtf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Bgp Network IDs.
     */
    @JvmName("sittycyukawvtqbv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jdnhriavifjbhiix")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the router to which the route table belongs.
     */
    @JvmName("edunuhfjuholtkao")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerId = mapped
    }

    /**
     * @param value The state of the advertised BGP network. Valid values: `Available`, `Pending`, `Deleting`.
     */
    @JvmName("yvnfryktcenbmscf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBgpNetworksPlainArgs = GetBgpNetworksPlainArgs(
        ids = ids,
        outputFile = outputFile,
        routerId = routerId,
        status = status,
    )
}
