@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetBgpPeersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBgpPeers.
 * @property bgpGroupId The ID of the BGP group to which the BGP peer that you want to query belongs.
 * @property ids A list of Bgp Peer IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property routerId The ID of the virtual border router (VBR) that is associated with the BGP peer that you want to query.
 * @property status The status of the BGP peer. Valid values: `Available`, `Deleted`, `Deleting`, `Modifying`, `Pending`.
 */
public data class GetBgpPeersPlainArgs(
    public val bgpGroupId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val routerId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetBgpPeersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetBgpPeersPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetBgpPeersPlainArgs.builder()
            .bgpGroupId(bgpGroupId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .routerId(routerId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBgpPeersPlainArgs].
 */
@PulumiTagMarker
public class GetBgpPeersPlainArgsBuilder internal constructor() {
    private var bgpGroupId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var routerId: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the BGP group to which the BGP peer that you want to query belongs.
     */
    @JvmName("nhdeqrvtkjlurohg")
    public suspend fun bgpGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bgpGroupId = mapped
    }

    /**
     * @param value A list of Bgp Peer IDs.
     */
    @JvmName("lsjywdcdaaahocju")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Bgp Peer IDs.
     */
    @JvmName("adllkgjtoebexiwq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nuhjgeofoctpltfp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the virtual border router (VBR) that is associated with the BGP peer that you want to query.
     */
    @JvmName("bvursamybpmyfatg")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerId = mapped
    }

    /**
     * @param value The status of the BGP peer. Valid values: `Available`, `Deleted`, `Deleting`, `Modifying`, `Pending`.
     */
    @JvmName("erjjjjnudpmovjir")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBgpPeersPlainArgs = GetBgpPeersPlainArgs(
        bgpGroupId = bgpGroupId,
        ids = ids,
        outputFile = outputFile,
        routerId = routerId,
        status = status,
    )
}
