@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetCommonBandwidthPackagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCommonBandwidthPackages.
 * @property bandwidthPackageName The name of bandwidth package.
 * @property dryRun Specifies whether to precheck only the request.
 * @property ids A list of Common Bandwidth Packages IDs.
 * @property includeReservationData Specifies whether to return data of orders that have not taken effect.
 * @property nameRegex A regex string to filter results by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The Id of resource group which the common bandwidth package belongs.
 * @property status The status of bandwidth package. Valid values: `Available` and `Pending`.
 */
public data class GetCommonBandwidthPackagesPlainArgs(
    public val bandwidthPackageName: String? = null,
    public val dryRun: Boolean? = null,
    public val ids: List<String>? = null,
    public val includeReservationData: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetCommonBandwidthPackagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetCommonBandwidthPackagesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetCommonBandwidthPackagesPlainArgs.builder()
            .bandwidthPackageName(bandwidthPackageName?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeReservationData(includeReservationData?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommonBandwidthPackagesPlainArgs].
 */
@PulumiTagMarker
public class GetCommonBandwidthPackagesPlainArgsBuilder internal constructor() {
    private var bandwidthPackageName: String? = null

    private var dryRun: Boolean? = null

    private var ids: List<String>? = null

    private var includeReservationData: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    /**
     * @param value The name of bandwidth package.
     */
    @JvmName("elcrwkjnmnembred")
    public suspend fun bandwidthPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bandwidthPackageName = mapped
    }

    /**
     * @param value Specifies whether to precheck only the request.
     */
    @JvmName("bspttjtcualloxhj")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value A list of Common Bandwidth Packages IDs.
     */
    @JvmName("gkddypmlhqebbsau")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Common Bandwidth Packages IDs.
     */
    @JvmName("pdehtrabgrostqva")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Specifies whether to return data of orders that have not taken effect.
     */
    @JvmName("xqkktcgvxtiqdwkp")
    public suspend fun includeReservationData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeReservationData = mapped
    }

    /**
     * @param value A regex string to filter results by name.
     */
    @JvmName("pjjteatawqlepwnf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ksqgjqgsqsoekyeg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Id of resource group which the common bandwidth package belongs.
     */
    @JvmName("lpwijuhocwnpdoht")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of bandwidth package. Valid values: `Available` and `Pending`.
     */
    @JvmName("vlkjktvaogvmftyk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetCommonBandwidthPackagesPlainArgs = GetCommonBandwidthPackagesPlainArgs(
        bandwidthPackageName = bandwidthPackageName,
        dryRun = dryRun,
        ids = ids,
        includeReservationData = includeReservationData,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
    )
}
