@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetDhcpOptionsSetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDhcpOptionsSets.
 * @property dhcpOptionsSetName The name of the DHCP options set.The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
 * @property domainName The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
 * @property ids A list of Dhcp Options Set IDs.
 * @property nameRegex A regex string to filter results by Dhcp Options Set name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
 */
public data class GetDhcpOptionsSetsPlainArgs(
    public val dhcpOptionsSetName: String? = null,
    public val domainName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetDhcpOptionsSetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetDhcpOptionsSetsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetDhcpOptionsSetsPlainArgs.builder()
            .dhcpOptionsSetName(dhcpOptionsSetName?.let({ args0 -> args0 }))
            .domainName(domainName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDhcpOptionsSetsPlainArgs].
 */
@PulumiTagMarker
public class GetDhcpOptionsSetsPlainArgsBuilder internal constructor() {
    private var dhcpOptionsSetName: String? = null

    private var domainName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The name of the DHCP options set.The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
     */
    @JvmName("hkrtgwcxbpbgmhog")
    public suspend fun dhcpOptionsSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dhcpOptionsSetName = mapped
    }

    /**
     * @param value The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
     */
    @JvmName("lhmvaidrujeooxpa")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value A list of Dhcp Options Set IDs.
     */
    @JvmName("drproawqqitcgrbw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Dhcp Options Set IDs.
     */
    @JvmName("ctpouhtkmgevyfyo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Dhcp Options Set name.
     */
    @JvmName("olcmiieiiunsqqpr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wlmtffsotdothvon")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
     */
    @JvmName("asjbjefmlmchshfm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDhcpOptionsSetsPlainArgs = GetDhcpOptionsSetsPlainArgs(
        dhcpOptionsSetName = dhcpOptionsSetName,
        domainName = domainName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
