@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetForwardEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getForwardEntries.
 * @property externalIp The public IP address.
 * @property externalPort The public port.
 * @property forwardEntryName The name of forward entry.
 * @property forwardTableId The ID of the Forward table.
 * @property ids A list of Forward Entries IDs.
 * @property internalIp The private IP address.
 * @property internalPort The internal port.
 * @property ipProtocol The ip protocol. Valid values: `any`,`tcp` and `udp`.
 * @property nameRegex A regex string to filter results by forward entry name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
 */
public data class GetForwardEntriesPlainArgs(
    public val externalIp: String? = null,
    public val externalPort: String? = null,
    public val forwardEntryName: String? = null,
    public val forwardTableId: String,
    public val ids: List<String>? = null,
    public val internalIp: String? = null,
    public val internalPort: String? = null,
    public val ipProtocol: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetForwardEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetForwardEntriesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetForwardEntriesPlainArgs.builder()
            .externalIp(externalIp?.let({ args0 -> args0 }))
            .externalPort(externalPort?.let({ args0 -> args0 }))
            .forwardEntryName(forwardEntryName?.let({ args0 -> args0 }))
            .forwardTableId(forwardTableId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .internalIp(internalIp?.let({ args0 -> args0 }))
            .internalPort(internalPort?.let({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetForwardEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetForwardEntriesPlainArgsBuilder internal constructor() {
    private var externalIp: String? = null

    private var externalPort: String? = null

    private var forwardEntryName: String? = null

    private var forwardTableId: String? = null

    private var ids: List<String>? = null

    private var internalIp: String? = null

    private var internalPort: String? = null

    private var ipProtocol: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The public IP address.
     */
    @JvmName("ojelsufpdybgbvqp")
    public suspend fun externalIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.externalIp = mapped
    }

    /**
     * @param value The public port.
     */
    @JvmName("owkdwruiaxbiefjc")
    public suspend fun externalPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.externalPort = mapped
    }

    /**
     * @param value The name of forward entry.
     */
    @JvmName("kmpvtesfxbgxdtwv")
    public suspend fun forwardEntryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.forwardEntryName = mapped
    }

    /**
     * @param value The ID of the Forward table.
     */
    @JvmName("tbnwyxrffvpafkvx")
    public suspend fun forwardTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.forwardTableId = mapped
    }

    /**
     * @param value A list of Forward Entries IDs.
     */
    @JvmName("wxkwoiofxmuskjml")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Forward Entries IDs.
     */
    @JvmName("jqihcjdlhtwvehfk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The private IP address.
     */
    @JvmName("hfsnfagwlbunxkwq")
    public suspend fun internalIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.internalIp = mapped
    }

    /**
     * @param value The internal port.
     */
    @JvmName("ulrigjxhqgdmiyyr")
    public suspend fun internalPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.internalPort = mapped
    }

    /**
     * @param value The ip protocol. Valid values: `any`,`tcp` and `udp`.
     */
    @JvmName("rbewdperjcelhkan")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipProtocol = mapped
    }

    /**
     * @param value A regex string to filter results by forward entry name.
     */
    @JvmName("kpujtgfpwmnfxuej")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dlbwowpplmtgxqvw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
     */
    @JvmName("ydgqiftwttsiqfrc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetForwardEntriesPlainArgs = GetForwardEntriesPlainArgs(
        externalIp = externalIp,
        externalPort = externalPort,
        forwardEntryName = forwardEntryName,
        forwardTableId = forwardTableId ?: throw PulumiNullFieldException("forwardTableId"),
        ids = ids,
        internalIp = internalIp,
        internalPort = internalPort,
        ipProtocol = ipProtocol,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
